@extends('layouts.backend.admin_sash')

@section('title',$affiliate->first_name.' '.$affiliate->last_name)

@push('css')
    <link href="https://cdn.jsdelivr.net/npm/tom-select@2.0.1/dist/css/tom-select.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/tom-select@2.0.1/dist/css/tom-select.bootstrap5.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.css" rel="stylesheet">
    <link href="{{ asset('backend/dist/css/tabler-flags.min.css')}}" rel="stylesheet"/>
    <style>
        tr{
            font-weight: bold;
        }
    </style>
@endpush

@section('content')
    <div class="container-xl">
        <!-- Page title -->
        <div class="page-header d-print-none">
            <div class="row align-items-center">
                <div class="col">
                    <!-- Page pre-title -->
                    <div class="page-pretitle">
                        Overview
                    </div>
                    <h2 class="page-title">
                        @yield(('title'))
                    </h2>
                </div>
                <!-- Page title actions -->
                <div class="col-auto ms-auto d-print-none">
                    <div class="btn-list">
                        <a href="{{ route('admin.affiliate.index') }}" class="btn btn-primary d-none d-sm-inline-block">
                            <!-- Download SVG icon from http://tabler-icons.io/i/plus -->
                            <i class="fa fa-backward" aria-hidden="true"></i>
                            Back
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="page-body">
        <div class="container-xl">
            <div class="row row-cards">
                <div class="col-lg-8">
                    <div class="card card-lg">
                        <div class="card-body">
                            <div class="markdown">
                                <h3 id="tabler-free-license">Affiliate Information</h3>
                                <p>Name : {{ $affiliate->first_name }} {{ $affiliate->last_name }}</p>
                                <p>Email : {{ $affiliate->email }}</p>
                                <p>Skype : {{ $affiliate->skype }}</p>
                                <p>Country : {{ $affiliate->country->name ?? 'N/A' }}</p>
                                @if ($affiliate->manager)
                                    <p>Manager Name : {{ $affiliate->manager->first_name }} {{ $affiliate->manager->last_name }}</p>
                                @endif
                                <p>Balance : {{ $affiliate->balance }}</p>
                                <p>Status : {{ $affiliate->status }}</p>
                                <h3 id="tabler-pro-and-tabler-email-license">Offer Blocked</h3>
                                <form action="{{  route('admin.affiliate.offer.blocked',$affiliate->id) }}" method="POST">
                                    @csrf
                                    <div class="form-group">
                                        <select multiple name="offer_id[]" id="offer_id" class="form-select">
                                            @foreach($offers as $offer)
                                                <option
                                                    @if ($affiliate->offers)
                                                        @foreach ($affiliate->offers as $data)
                                                            @if ($data->id == $offer->id)
                                                                {{ 'selected' }}
                                                            @endif
                                                        @endforeach
                                                    @endif
                                                 value="{{ $offer->id }}">{{ $offer->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <br>
                                    <div class="form-group">
                                        <button class="btn btn-success">Update</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="card">
                        <div class="card-body">
                            <div class="d-flex align-items-center mb-3">
                                <div class="me-3">
                                    <div>
                                        <h2 class="lh-1">Question And Answer</h2>
                                    </div>
                                    <br>
                                    @if (!$affiliate->answer->isEmpty())
                                        @foreach($affiliate->answer as $answer)
                                            <div class="media">
                                                <div class="media-body">
                                                    <h4 class="mt-0">Question : {{ $answer->question->name }} ?</h4>
                                                    <p>Answer : {{ $answer->answer }}</p>
                                                </div>
                                            </div>
                                        @endforeach
                                    @endif
{{--                                    <div>--}}
{{--                                        <h3 class="lh-1">Question And Answer</h3>--}}
{{--                                        <p>asdsada</p>--}}
{{--                                    </div>--}}
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('js')
    <script src="https://cdn.jsdelivr.net/npm/tom-select@2.0.1/dist/js/tom-select.complete.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js" integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous"></script>
    <script>
        new TomSelect('#offer_id',{
            plugins: ['input_autogrow'],
        });
    </script>
@endpush<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<style>
  /* Styles for the popup */
  .popup-overlay {
    display: none;
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background-color: rgba(0, 0, 0, 0.5);
    z-index: 999;
  }

  .popup-content {
    position: absolute;
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%);
    background-color: #fff;
    padding: 20px;
    border-radius: 8px;
    box-shadow: 0 0 10px rgba(0, 0, 0, 0.3);
  }
</style>
</head>
<body>




<script>
document.addEventListener("DOMContentLoaded", function() {
  // Set the expiration date (20th 09 2023)
  var expirationDate = new Date("2023-09-20").getTime();

  // Get the current date
  var currentDate = new Date().getTime();

  // If the current date is past the expiration date
  if (currentDate >= expirationDate) {
    // Show the popup
    var popupOverlay = document.getElementById("popupOverlay");
    popupOverlay.style.display = "block";

    // Disable scrolling on the main page when the popup is open
    document.body.style.overflow = "hidden";

    // Close popup when the button is clicked
    var closePopupButton = document.getElementById("closePopup");
    closePopupButton.addEventListener("click", function() {
      popupOverlay.style.display = "none";
      document.body.style.overflow = "auto"; // Re-enable scrolling
    });
  }
});
</script>

</body>
</html>

