@extends('layouts.backend.admin_sash')

@push('css')
<link rel="stylesheet" href="{{ asset('backend/summernote/style.css') }}">
    
@endpush
@section('title','Create Announcement')
@section('content')
    <div class="container-xl">
        <!-- Page title -->
        <div class="page-header d-print-none">
            <div class="row align-items-center">
                <div class="col">
                    <!-- Page pre-title -->
                    <div class="page-pretitle">
                        Create Announcement
                    </div>
                    <h2 class="page-title">
                        @yield(('title'))
                    </h2>
                </div>
                <!-- Page title actions -->
                <div class="col-auto ms-auto d-print-none">
                    <div class="btn-list">
                        <a href="{{ route('admin.announcement.index') }}" class="btn btn-primary d-none d-sm-inline-block">
                            <!-- Download SVG icon from http://tabler-icons.io/i/plus -->
                            <i class="fa fa-backward"></i>
                            Back
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="page-body">
        <div class="container-xl">
            <form action="{{ route('admin.announcement.store') }}" method="post" enctype="multipart/form-data">
                @csrf
               
                <div class="row row-cards">
                <div class="col-md-8 mt-4">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">Basic Info</h3>
                        </div>
                        @if ($errors->any())
                            <div class="alert alert-danger">
                                <ul>
                                    @foreach ($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        @endif
                        <div class="card-body">
                            <div class="form-group mb-3 ">
                                <label class="form-label">Photo</label>
                                <div>
                                    <input type="file" name="photo" class="form-control">
                                </div>
                            </div>

                            <div class="form-group mb-3 ">
                                <label class="form-label">Title</label>
                                <div>
                                    <input type="text" class="form-control" name="title" value="{{ old('title') }}" placeholder="Announcement title" required>
                                </div>
                                @error('title')
                                <div class="error">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="form-group mb-3 ">
                                <label class="form-label">Description</label>
                                <div>
                                    <textarea id="texteditor" name="description" class="form-control">{{ old('description') }}</textarea>
                                </div>
                                @error('description')
                                <div class="error">{{ $message }}</div>
                                @enderror
                            </div>
                            
                            <div class="form-group mb-3 ">
                                <label class="form-label">Status</label>
                                <div>
                                    <div class="input-icon">
                                        <select name="status" id="status" class="form-control">
                                            <option {{ old('status')=='published'?'selected':'' }} value="published">Published</option>
                                            <option {{ old('status')=='draft'?'selected':'' }} value="draft">Draft</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                          
                            
                            <div class="form-footer">
                                <button type="submit" class="btn btn-primary">Create</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            </form>
        </div>
    </div>
@endsection

@push('js')
<script src="https://code.jquery.com/jquery-3.4.1.slim.min.js"></script>
<script src="{{ asset('backend/summernote/main.js') }}"></script>
<script>
        $('#texteditor').summernote({
  height: 200,                 // set editor height
  minHeight: null,             // set minimum height of editor
  maxHeight: null,             // set maximum height of editor
  focus: true                  // set focus to editable area after initializing summernote
});
</script>
@endpush
