@extends('layouts.backend.admin_sash')

@section('title','Manage Announcements')
@section('content')
  
    <div class="container-xl">
        <!-- Page title -->
        <div class="page-header d-print-none">
            <div class="row align-items-center">
                <div class="col">
                    <!-- Page pre-title -->
                    <div class="page-pretitle">
                        Announcements
                    </div>
                    <h2 class="page-title">
                        @yield(('title'))
                    </h2>
                </div>
                <!-- Page title actions -->
                <div class="col-auto ms-auto d-print-none">
                    <div class="btn-list">
                        <a href="{{ route('admin.announcement.create') }}" class="btn btn-primary d-none d-sm-inline-block">
                            <!-- Download SVG icon from http://tabler-icons.io/i/plus -->
                            <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"></path><line x1="12" y1="5" x2="12" y2="19"></line><line x1="5" y1="12" x2="19" y2="12"></line></svg>
                            Create Announcements
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="page-body">
        <div class="container-xl">
            
            <div class="col-12">
                <div class="card">
                    <div class="table-responsive">
                        <table class="table table-vcenter table-mobile-md card-table">
                            <thead>
                            <tr>
                                <th>Photo</th>
                                <th>Titile</th>
                                <th>Status</th>
                               
                                <th>Action</th>
                            </tr>
                            </thead>
                            <tbody>
                                @foreach($announcements as $a)
                                    <tr>
                                        <td data-label="Photo">
                                            <img src="{{ asset(Storage::url($a->photo)) }}" width="80" alt="">
                                        </td>
                                        <td data-label="Title">
                                            <div>{{ $a->title }}</div>
                                        </td>
                                        <td data-label="Status">
                                            <div> <span class="badge bg-{{ $a->status=='published'?'success':'warning' }}">{{ $a->status }}</span></div>
                                        </td>
                                        <td>
                                            <a href="{{ route('admin.announcement.edit',$a->id) }}" class="btn btn-success btn-sm">
                                                <i class="fa fa-pencil"></i>
                                            </a>
                                            
                                            <form action="{{ route('admin.announcement.delete', $a->id) }}" method="POST" onclick="return confirm('are u sure to delete?')">
                                                @method('DELETE')
                                                @csrf
                                                <button class="btn btn-danger btn-sm">
                                                    <i class="fa fa-trash"></i>
                                                </button>
                                            </form>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                       
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

