@extends('layouts.backend.admin_sash')

@section('title','Dashboard')

@php
    // Debug: Check if all required variables exist
    $debug_vars = [
        'totalClick' => isset($totalClick) ? $totalClick : 'NOT SET',
        'totalUnique' => isset($totalUnique) ? $totalUnique : 'NOT SET', 
        'totalConversion' => isset($totalConversion) ? $totalConversion : 'NOT SET',
        'totalRevenue' => isset($totalRevenue) ? $totalRevenue : 'NOT SET',
        'top_offers' => isset($top_offers) ? (is_object($top_offers) ? 'COLLECTION' : gettype($top_offers)) : 'NOT SET',
        'top_countries' => isset($top_countries) ? (is_object($top_countries) ? 'COLLECTION' : gettype($top_countries)) : 'NOT SET',
        'pending_affiliates' => isset($pending_affiliates) ? (is_object($pending_affiliates) ? 'COLLECTION' : gettype($pending_affiliates)) : 'NOT SET',
        'offer_applications' => isset($offer_applications) ? (is_object($offer_applications) ? 'COLLECTION' : gettype($offer_applications)) : 'NOT SET',
        'last_month' => isset($last_month) ? (is_array($last_month) ? 'ARRAY' : gettype($last_month)) : 'NOT SET'
    ];
@endphp

@push('css')
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js" integrity="sha512-894YE6QWD5I59HgZOGReFYm4dnWc1Qt5NtvYSaNcOP+u1T9qYdvdihz0PPSiiqn/+/3e7Jo4EaG7TubfWGUrMQ==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
    <link rel="stylesheet" href="{{ asset('backend/date/bootstrap3-wysihtml5.min.css') }}">
    <link rel="stylesheet" href="{{ asset('backend/date/bootstrap-datepicker.min.css') }}">
    <link rel="stylesheet" href="{{ asset('backend/date/daterangepicker.css') }}">
    
    <style>
        /* Custom Date Range Picker Styles */
        .date-range-input {
            min-width: 200px;
            background-color: #fff;
            border: 1px solid #e3e6f0;
            border-radius: 0.375rem;
            transition: all 0.15s ease-in-out;
        }
        
        .date-range-input:focus {
            border-color: #6c5ffc;
            box-shadow: 0 0 0 0.2rem rgba(108, 95, 252, 0.25);
        }
        
        .date-range-input:hover {
            border-color: #6c5ffc;
        }
        
        
        /* Daterangepicker Custom Styles */
        .daterangepicker {
            border: 1px solid #e3e6f0;
            border-radius: 0.5rem;
            box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.15);
            font-family: inherit;
        }
        
        .daterangepicker .ranges li {
            border-radius: 0.375rem;
            margin: 2px;
        }
        
        .daterangepicker .ranges li.active {
            background-color: #6c5ffc;
            color: #fff;
        }
        
        .daterangepicker .ranges li:hover {
            background-color: #f8f9fc;
        }
        
        .daterangepicker .calendar-table th {
            background-color: #f8f9fc;
            color: #5a5c69;
            font-weight: 600;
        }
        
        .daterangepicker .calendar-table td {
            border-radius: 0.25rem;
        }
        
        .daterangepicker .calendar-table td.active {
            background-color: #6c5ffc;
            color: #fff;
        }
        
        .daterangepicker .calendar-table td.in-range {
            background-color: rgba(108, 95, 252, 0.1);
            color: #6c5ffc;
        }
        
        .daterangepicker .calendar-table td:hover {
            background-color: rgba(108, 95, 252, 0.2);
        }
        
        .daterangepicker .drp-buttons {
            border-top: 1px solid #e3e6f0;
            padding: 10px;
        }
        
        .daterangepicker .drp-buttons .btn {
            border-radius: 0.375rem;
            font-weight: 500;
        }
        
        .daterangepicker .drp-buttons .btn-primary {
            background-color: #6c5ffc;
            border-color: #6c5ffc;
        }
        
        .daterangepicker .drp-buttons .btn-primary:hover {
            background-color: #5a4fdb;
            border-color: #5a4fdb;
        }
        
        /* Responsive adjustments */
        @media (max-width: 768px) {
            .date-range-input {
                min-width: 150px;
            }
        }
    </style>
@endpush


@section('content')
    @php
        if (Request::get('date_filter')) {
            switch (Request::get('date_filter')) {
                case 'today':
                    $time = 'Today';
                    break;
                case '7D':
                    $time = 'Last 7 days';
                    break;
                case '14D':
                    $time = 'Last 14 days';
                    break;
                case '30D':
                    $time = 'Last 30 days';
                    break;
                case '90D':
                    $time = 'Last 90 days';
                    break;
                default:
                    $time = 'Today';
                    break;
            }
        } else {
            $time = 'Today';
        }
    @endphp
    @php
        myGlobalFunction();
    @endphp

    <div class="container-fluid">
        <div class="row g-3 align-items-center mb-3">
            <div class="col-auto"><h4 class="mb-0">Admin Dashboard</h4></div>
            <div class="col ms-auto">
                <div class="d-flex gap-2 justify-content-end align-items-center">
                    <form action="" method="get" class="d-flex gap-2 align-items-center">
                        <div class="position-relative">
                            <input type="text" class="form-control form-control-sm date-range-input" id="date_filter" name="date_filter" placeholder="Select date range" readonly>
                            <i class="fe fe-calendar position-absolute top-50 end-0 translate-middle-y me-2 text-muted"></i>
                        </div>
                        <button class="btn btn-sm btn-primary" type="submit">
                            <i class="fe fe-filter"></i> Filter
                        </button>
                    </form>
                </div>
            </div>
        </div>

        <div class="row g-3">
            <div class="col-12 col-sm-6 col-lg-3">
                <div class="card overflow-hidden">
                    <div class="card-body">
                        <div class="d-flex">
                            <div class="mt-2">
                                <h6 class="">Clicks</h6>
                                <h2 class="mb-0 number-font">{{ $totalClick }}</h2>
                                @php
                                    $clickChange = 0;
                                    $clickIcon = 'fe-arrow-up-circle';
                                    $clickColor = 'text-info';
                                    if (isset($last_month) && isset($last_month['last_month_click']) && $last_month['last_month_click'] > 0) {
                                        $clickChange = (($totalClick - $last_month['last_month_click']) / max($last_month['last_month_click'], 1)) * 100;
                                        $clickIcon = $clickChange >= 0 ? 'fe-arrow-up-circle' : 'fe-arrow-down-circle';
                                        $clickColor = $clickChange >= 0 ? 'text-info' : 'text-danger';
                                    }
                                @endphp
                                <span class="text-muted fs-12"><span class="{{ $clickColor }}"><i class="fe {{ $clickIcon }} {{ $clickColor }}"></i> {{ number_format($clickChange, 1) }}%</span> vs previous period</span>
                      </div>
                            <div class="ms-auto">
                                <div class="chart-wrapper mt-1">
                                    <canvas id="saleschart" class="h-8 w-9 chart-dropshadow"></canvas>
                            </div>
                            </div>
                        </div>
                    </div>
                </div>
                            </div>
            <div class="col-12 col-sm-6 col-lg-3">
                <div class="card overflow-hidden">
                        <div class="card-body">
                        <div class="d-flex">
                            <div class="mt-2">
                                <h6 class="">Unique</h6>
                                <h2 class="mb-0 number-font">{{ $totalUnique }}</h2>
                                @php
                                    $uniqueChange = 0;
                                    $uniqueIcon = 'fe-arrow-up-circle';
                                    $uniqueColor = 'text-pink';
                                    if (isset($last_month) && isset($last_month['last_month_unique']) && $last_month['last_month_unique'] > 0) {
                                        $uniqueChange = (($totalUnique - $last_month['last_month_unique']) / max($last_month['last_month_unique'], 1)) * 100;
                                        $uniqueIcon = $uniqueChange >= 0 ? 'fe-arrow-up-circle' : 'fe-arrow-down-circle';
                                        $uniqueColor = $uniqueChange >= 0 ? 'text-pink' : 'text-danger';
                                    }
                                @endphp
                                <span class="text-muted fs-12"><span class="{{ $uniqueColor }}"><i class="fe {{ $uniqueIcon }} {{ $uniqueColor }}"></i> {{ number_format($uniqueChange, 1) }}%</span> vs previous period</span>
                            </div>
                            <div class="ms-auto">
                                <div class="chart-wrapper mt-1">
                                    <canvas id="leadschart" class="h-8 w-9 chart-dropshadow"></canvas>
                            </div>
                            </div>
                        </div>
                    </div>
                </div>
                          </div>
            <div class="col-12 col-sm-6 col-lg-3">
                <div class="card overflow-hidden">
                        <div class="card-body">
                        <div class="d-flex">
                            <div class="mt-2">
                                <h6 class="">Conversion</h6>
                                <h2 class="mb-0 number-font">{{ $totalConversion }}</h2>
                                @php
                                    $conversionChange = 0;
                                    $conversionIcon = 'fe-arrow-up-circle';
                                    $conversionColor = 'text-success';
                                    if (isset($last_month) && isset($last_month['last_month_conversion']) && $last_month['last_month_conversion'] > 0) {
                                        $conversionChange = (($totalConversion - $last_month['last_month_conversion']) / max($last_month['last_month_conversion'], 1)) * 100;
                                        $conversionIcon = $conversionChange >= 0 ? 'fe-arrow-up-circle' : 'fe-arrow-down-circle';
                                        $conversionColor = $conversionChange >= 0 ? 'text-success' : 'text-danger';
                                    }
                                @endphp
                                <span class="text-muted fs-12"><span class="{{ $conversionColor }}"><i class="fe {{ $conversionIcon }} {{ $conversionColor }}"></i> {{ number_format($conversionChange, 1) }}%</span> vs previous period</span>
                            </div>
                            <div class="ms-auto">
                                <div class="chart-wrapper mt-1">
                                    <canvas id="profitchart" class="h-8 w-9 chart-dropshadow"></canvas>
                                </div>
                            </div>
                        </div>
                                            </div>
                    </div>
                </div>
            <div class="col-12 col-sm-6 col-lg-3">
                <div class="card overflow-hidden">
                        <div class="card-body">
                        <div class="d-flex">
                            <div class="mt-2">
                                <h6 class="">Revenue</h6>
                                <h2 class="mb-0 number-font">${{ $totalRevenue }}</h2>
                                @php
                                    $revenueChange = 0;
                                    $revenueIcon = 'fe-arrow-up-circle';
                                    $revenueColor = 'text-warning';
                                    if (isset($last_month) && isset($last_month['last_month_revenue']) && $last_month['last_month_revenue'] > 0) {
                                        $revenueChange = (($totalRevenue - $last_month['last_month_revenue']) / max($last_month['last_month_revenue'], 1)) * 100;
                                        $revenueIcon = $revenueChange >= 0 ? 'fe-arrow-up-circle' : 'fe-arrow-down-circle';
                                        $revenueColor = $revenueChange >= 0 ? 'text-warning' : 'text-danger';
                                    }
                                @endphp
                                <span class="text-muted fs-12"><span class="{{ $revenueColor }}"><i class="fe {{ $revenueIcon }} {{ $revenueColor }}"></i> {{ number_format($revenueChange, 1) }}%</span> vs previous period</span>
                            </div>
                            <div class="ms-auto">
                                <div class="chart-wrapper mt-1">
                                    <canvas id="costchart" class="h-8 w-9 chart-dropshadow"></canvas>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                            </div>
                        </div>

        <div class="row g-3 mt-1">
            <div class="col-lg-8">
                <div class="card">
                    <div class="card-header">
                        <h6 class="card-title mb-0">Analytics Overview</h6>
                    </div>
                    <div class="card-body">
                        <div class="d-flex mx-auto text-center justify-content-center mb-3">
                            <div class="d-flex text-center justify-content-center me-3"><span class="dot-label bg-primary my-auto"></span>Clicks</div>
                            <div class="d-flex text-center justify-content-center"><span class="dot-label bg-secondary my-auto"></span>Conversions</div>
                        </div>
                        <div class="chartjs-wrapper-demo">
                            <canvas id="chartBar2" class="h-275 chart-dropshadow"></canvas>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-4">
                <div class="card h-100">
                    <div class="card-header">
                        <h6 class="card-title mb-0">Quick Stats</h6>
                          </div>
                    <div class="card-body p-0">
                        <div class="table-responsive">
                            <table class="table table-hover mb-0">
                                <thead class="table-light">
                                    <tr>
                                        <th class="border-0">Metric</th>
                                        <th class="border-0">Value</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>Clicks</td>
                                        <td><span class="fw-semibold text-primary">{{ $totalClick }}</span></td>
                                    </tr>
                                    <tr>
                                        <td>Unique</td>
                                        <td><span class="fw-semibold text-info">{{ $totalUnique }}</span></td>
                                    </tr>
                                    <tr>
                                        <td>Conversions</td>
                                        <td><span class="fw-semibold text-success">{{ $totalConversion }}</span></td>
                                    </tr>
                                    <tr>
                                        <td>Revenue</td>
                                        <td><span class="fw-semibold text-warning">${{ $totalRevenue }}</span></td>
                                    </tr>
                                    <tr>
                                        <td>Payout</td>
                                        <td><span class="fw-semibold text-danger">${{ $totalPayout }}</span></td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>

        <!-- ROW-3: Additional Dashboard Elements -->
        <div class="row g-3 mt-1">
            <div class="col-xl-4 col-md-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-between align-items-center">
                        <h4 class="card-title fw-semibold">Daily Activity</h4>
                        <div class="d-flex align-items-center">
                            <span class="badge bg-success-transparent text-success me-2" id="activity-status">
                                <i class="fe fe-activity"></i> Live
                            </span>
                            <button class="btn btn-sm btn-outline-primary" onclick="refreshActivity()" title="Refresh">
                                <i class="fe fe-refresh-cw"></i>
                            </button>
                        </div>
                    </div>
                    <div class="card-body pb-0">
                        <div id="activity-loader" class="text-center py-3" style="display: none;">
                            <div class="spinner-border spinner-border-sm text-primary" role="status">
                                <span class="visually-hidden">Loading...</span>
                            </div>
                            <p class="text-muted mt-2 mb-0">Updating activity...</p>
                        </div>
                        <ul class="task-list" id="daily-activity-list">
                            @if(isset($pending_affiliates) && $pending_affiliates && $pending_affiliates->count() > 0)
                                <li class="d-sm-flex" data-activity="pending_affiliates">
                                    <div>
                                        <i class="task-icon bg-primary"></i>
                                        <h6 class="fw-semibold">Pending Affiliates<span class="text-muted fs-11 mx-2 fw-normal" id="pending-affiliates-count">{{ $pending_affiliates->count() }} pending</span></h6>
                                        <p class="text-muted fs-12" id="pending-affiliates-desc">{{ $pending_affiliates->count() }} affiliate(s) waiting for approval</p>
                                    </div>
                                    <div class="ms-auto d-md-flex">
                                        <a href="{{ route('admin.affiliate.index') }}" class="text-muted me-2" data-bs-toggle="tooltip" data-bs-placement="top" title="View" aria-label="View"><span class="fe fe-eye"></span></a>
                                        </div>
                                </li>
                            @endif
                            @if(isset($offer_applications) && $offer_applications && $offer_applications->count() > 0)
                                <li class="d-sm-flex" data-activity="offer_applications">
                                    <div>
                                        <i class="task-icon bg-secondary"></i>
                                        <h6 class="fw-semibold">Offer Applications<span class="text-muted fs-11 mx-2 fw-normal" id="offer-applications-count">{{ $offer_applications->count() }} pending</span></h6>
                                        <p class="text-muted fs-12" id="offer-applications-desc">{{ $offer_applications->count() }} offer application(s) waiting for review</p>
                                            </div>
                                    <div class="ms-auto d-md-flex">
                                        <a href="{{ route('admin.offer.index') }}" class="text-muted me-2" data-bs-toggle="tooltip" data-bs-placement="top" title="View" aria-label="View"><span class="fe fe-eye"></span></a>
                                            </div>
                                </li>
                            @endif
                            @if($totalConversion > 0)
                                <li class="d-sm-flex" data-activity="conversions">
                                    <div>
                                        <i class="task-icon bg-success"></i>
                                        <h6 class="fw-semibold">New Conversions<span class="text-muted fs-11 mx-2 fw-normal" id="conversions-count">{{ $totalConversion }} today</span></h6>
                                        <p class="text-muted fs-12" id="conversions-desc">{{ $totalConversion }} conversion(s) approved today</p>
                                        </div>
                                    <div class="ms-auto d-md-flex">
                                        <a href="{{ route('admin.report.day') }}" class="text-muted me-2" data-bs-toggle="tooltip" data-bs-placement="top" title="View" aria-label="View"><span class="fe fe-eye"></span></a>
                                    </div>
                                </li>
                            @endif
                            @if($totalRevenue > 0)
                                <li class="d-sm-flex" data-activity="revenue">
                                    <div>
                                        <i class="task-icon bg-warning"></i>
                                        <h6 class="fw-semibold">Revenue Generated<span class="text-muted fs-11 mx-2 fw-normal" id="revenue-count">${{ number_format($totalRevenue, 2) }}</span></h6>
                                        <p class="text-muted fs-12" id="revenue-desc">Total revenue generated today</p>
                                </div>
                                    <div class="ms-auto d-md-flex">
                                        <a href="{{ route('admin.finance.index') }}" class="text-muted me-2" data-bs-toggle="tooltip" data-bs-placement="top" title="View" aria-label="View"><span class="fe fe-eye"></span></a>
                            </div>
                                </li>
                            @endif
                            @if(isset($top_offers) && $top_offers && $top_offers->count() > 0)
                                @php $topOffer = $top_offers->first(); @endphp
                                @if($topOffer && isset($topOffer->name))
                                    <li class="d-sm-flex" data-activity="top_offer">
                                        <div>
                                            <i class="task-icon bg-info"></i>
                                            <h6 class="fw-semibold">Top Performing Offer<span class="text-muted fs-11 mx-2 fw-normal" id="top-offer-name">{{ $topOffer->name }}</span></h6>
                                            <p class="text-muted fs-12" id="top-offer-desc">{{ $topOffer->reports_count ?? 0 }} total reports</p>
                                        </div>
                                        <div class="ms-auto d-md-flex">
                                            <a href="{{ route('admin.offer.index') }}" class="text-muted me-2" data-bs-toggle="tooltip" data-bs-placement="top" title="View" aria-label="View"><span class="fe fe-eye"></span></a>
                                        </div>
                                    </li>
                                @endif
                            @endif
                        </ul>
                        <div class="text-center mt-3">
                            <small class="text-muted">
                                <i class="fe fe-clock"></i> Last updated: <span id="last-updated">{{ now()->format('H:i:s') }}</span>
                            </small>
                        </div>
                                            </div>
                                            </div>
                                        </div>
            <div class="col-xl-4 col-lg-6 col-md-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-between align-items-center">
                        <h4 class="card-title fw-semibold">Top Countries</h4>
                        <div class="d-flex align-items-center">
                            <span class="badge bg-info-transparent text-info me-2" id="countries-status">
                                <i class="fe fe-trending-up"></i> Live
                            </span>
                            <div class="btn-group btn-group-sm" role="group">
                                <button type="button" class="btn btn-outline-primary" onclick="refreshCountries()" title="Refresh">
                                    <i class="fe fe-refresh-cw"></i>
                                </button>
                                <button type="button" class="btn btn-outline-secondary" onclick="toggleCountriesView()" title="Toggle View">
                                    <i class="fe fe-eye"></i>
                                </button>
                            </div>
                        </div>
                        </div>
                                <div class="card-body">
                        <div id="countries-loader" class="text-center py-3" style="display: none;">
                            <div class="spinner-border spinner-border-sm text-primary" role="status">
                                <span class="visually-hidden">Loading...</span>
                            </div>
                            <p class="text-muted mt-2 mb-0">Updating countries...</p>
                        </div>
                        <div class="browser-stats" id="countries-container">
                            @php
                                $maxCountryReports = (isset($top_countries) && $top_countries && $top_countries->isNotEmpty()) ? $top_countries->max('reports_count') : 1;
                                $colors = ['bg-primary', 'bg-danger', 'bg-warning', 'bg-success'];
                                $countryIcons = ['flag-us.svg', 'flag-gb.svg', 'flag-ca.svg', 'flag-au.svg'];
                            @endphp
                            @if(isset($top_countries) && $top_countries && $top_countries->count() > 0)
                                @php
                                    // Filter countries with actual reports > 0
                                    $validCountries = $top_countries->filter(function($country) {
                                        return $country && isset($country->name) && ($country->reports_count ?? 0) > 0;
                                    });
                                @endphp
                                @if($validCountries->count() > 0)
                                    @foreach($validCountries->take(4) as $index => $country)
                                        <div class="row mb-4 country-item" data-country="{{ $country->name }}" data-reports="{{ $country->reports_count ?? 0 }}">
                                            <div class="col-sm-2 col-lg-3 col-xl-3 col-xxl-2 mb-sm-0 mb-3">
                                                <div class="avatar avatar-md bg-primary-transparent text-primary bradius">
                                                    <i class="fe fe-globe"></i>
                                                </div>
                                            </div>
                                            <div class="col-sm-10 col-lg-9 col-xl-9 col-xxl-10 ps-sm-0">
                                                <div class="d-flex align-items-end justify-content-between mb-1">
                                                    <h6 class="mb-1 country-name">{{ $country->name }}</h6>
                                                    <h6 class="fw-semibold mb-1 country-reports">{{ number_format($country->reports_count ?? 0) }} <span class="text-success fs-11 country-percentage">(<i class="fe fe-arrow-up"></i>{{ number_format((($country->reports_count ?? 0) / max($maxCountryReports, 1)) * 100, 1) }}%)</span></h6>
                                                </div>
                                                <div class="progress h-2 mb-3">
                                                    <div class="progress-bar {{ $colors[$index % 4] }} country-progress" style="width: {{ (($country->reports_count ?? 0) / max($maxCountryReports, 1)) * 100 }}%;" role="progressbar"></div>
                                                </div>
                                            </div>
                                        </div>
                                    @endforeach
                                @else
                                    <div class="text-center text-muted py-4" id="no-countries-message">
                                        <i class="fe fe-globe fs-48 mb-3"></i>
                                        <p>No country data available</p>
                                        </div>
                                    @endif
                            @else
                                <div class="text-center text-muted py-4" id="no-countries-message">
                                    <i class="fe fe-globe fs-48 mb-3"></i>
                                    <p>No country data available</p>
                                </div>
                            @endif
                        </div>
                        <div class="text-center mt-3">
                            <small class="text-muted">
                                <i class="fe fe-clock"></i> Last updated: <span id="countries-last-updated">{{ now()->format('H:i:s') }}</span>
                            </small>
                        </div>
                    </div>
                </div>
                            </div>
            <div class="col-xl-4 col-lg-6 col-md-12">
                <div class="card overflow-hidden">
                    <div class="card-body pb-0 bg-recentorder">
                        <h3 class="card-title text-white">Recent Conversations</h3>
                        <div class="chartjs-wrapper-demo">
                            <canvas id="recentorders" class="chart-dropshadow"></canvas>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="d-flex mb-4 mt-3">
                            <div class="avatar avatar-md bg-secondary-transparent text-secondary bradius me-3">
                                <i class="fe fe-check"></i>
                            </div>
                            <div class="">
                                <h6 class="mb-1 fw-semibold">Approved Reports</h6>
                                <p class="fw-normal fs-12"> <span class="text-success">{{ (isset($last_month) && isset($last_month['last_month_conversion']) && $last_month['last_month_conversion'] > 0) ? number_format((($totalConversion - $last_month['last_month_conversion']) / max($last_month['last_month_conversion'], 1)) * 100, 1) : '0' }}%</span> increased </p>
                </div>
                            <div class=" ms-auto my-auto">
                                <p class="fw-bold fs-20"> {{ $totalConversion }} </p>
                            </div>
                        </div>
                        <div class="d-flex">
                            <div class="avatar avatar-md bg-pink-transparent text-pink bradius me-3">
                                <i class="fe fe-x"></i>
                    </div>
                            <div class="">
                                <h6 class="mb-1 fw-semibold">Pending Reports</h6>
                                <p class="fw-normal fs-12"> <span class="text-warning">{{ $totalClick - $totalConversion > 0 ? number_format((($totalClick - $totalConversion) / max($totalClick, 1)) * 100, 1) : '0' }}%</span> of total clicks </p>
                </div>
                            <div class=" ms-auto my-auto">
                                <p class="fw-bold fs-20 mb-0"> {{ $totalClick - $totalConversion }} </p>
                            </div>
                        </div>
                        <div class="d-flex mt-3">
                            <div class="avatar avatar-md bg-success-transparent text-success bradius me-3">
                                <i class="fe fe-dollar-sign"></i>
                    </div>
                            <div class="">
                                <h6 class="mb-1 fw-semibold">Total Revenue</h6>
                                <p class="fw-normal fs-12"> <span class="text-success">${{ number_format($totalRevenue, 2) }}</span> generated </p>
                </div>
                            <div class=" ms-auto my-auto">
                                <p class="fw-bold fs-20 mb-0"> ${{ number_format($totalPayout, 2) }} </p>
                        </div>
                        </div>
                    </div>
                </div>
              </div>
        </div>
    </div>
@endsection


@push('js')
    <script src="{{ asset('assets/plugins/bootstrap-daterangepicker/moment.min.js') }}"></script>
    <script src="{{ asset('backend/date/daterangepicker.js') }}"></script>
    <script src="{{ asset('assets/plugins/chart/Chart.bundle.js') }}"></script>
    <script>
    document.addEventListener('DOMContentLoaded', function () {
        // Initialize Date Range Picker
        initializeDateRangePicker();
        
        // Build dynamic data from $chartData
        const chartData = @json($chartData ?? []);
        const dates = chartData.map(i => String((i.date ?? i.day ?? '')));
        let clicks = chartData.map(i => Number((i.clicks ?? i.click ?? 0)));
        let conversions = chartData.map(i => Number((i.conversions ?? i.conversion ?? 0)));
        let payout = chartData.map(i => Number((i.payout ?? i.payouts ?? 0)));
        
        // Build time-based stats data for mini charts
        const timeBasedStats = @json($timeBasedStats ?? []);
        const timeClicks = Object.values(timeBasedStats).map(s => Number(s.timeClick || 0));
        const timeConversions = Object.values(timeBasedStats).map(s => Number(s.timeConversion || 0));
        const timePayout = Object.values(timeBasedStats).map(s => Number(s.timePayout || 0));
        const timeLabels = Object.keys(timeBasedStats);
        
        // Helper to parse possibly formatted numbers
        const toNum = (v) => {
            const s = String(v ?? '').replace(/[^0-9+\-.]/g, '');
            const n = s.length ? Number(s) : 0;
            return isNaN(n) ? 0 : n;
        };
        
        // PHP totals as fallback
        const totalClickFallback = toNum(@json($totalClick ?? 0));
        const totalConvFallback = toNum(@json($totalConversion ?? 0));
        const totalPayoutFallback = toNum(@json($totalPayout ?? 0));
        
        if (!clicks.length && totalClickFallback) clicks = [totalClickFallback];
        if (!conversions.length && totalConvFallback) conversions = [totalConvFallback];
        if (!payout.length && totalPayoutFallback) payout = [totalPayoutFallback];

        // saleschart (Clicks as bar, cyan palette) - using time-based data
        var ctx = document.getElementById('saleschart'); if (ctx) {
            const clicksSample = timeClicks.filter((_, i) => i % Math.max(1, Math.floor(timeClicks.length / 8)) === 0);
            const labelsSample = timeLabels.filter((_, i) => i % Math.max(1, Math.floor(timeLabels.length / 8)) === 0);
            
            new Chart(ctx.getContext('2d'), {
                type: 'bar',
                data: {
                    labels: labelsSample.map((_, i) => `T${i+1}`),
                    datasets: [{
                        barPercentage: 0.4, barThickness: 6, barGap: 0.5, maxBarThickness: 8, minBarLength: 2,
                        label: 'Clicks',
                        data: clicksSample,
                        backgroundColor: clicksSample.map((_, i) => (i % 2 === 1 ? '#05c3fb' : 'rgba(5,195,251,0.3)')),
                        borderColor: clicksSample.map((_, i) => (i % 2 === 1 ? '#05c3fb' : 'rgba(5,195,251,0.6)')),
                        borderWidth: 1, borderRadius: 2
                    }]
                },
                options: { maintainAspectRatio: false, plugins: { legend: { display: false }, tooltip: { enabled: false } }, responsive: true, scales: { x: { display: false, categoryPercentage: 0.6, barPercentage: 0.4 }, y: { display: false } }, elements: { point: { radius: 0 } } }
            });
        }

        // leadschart (Unique as line, pink #f46ef4) - using time-based data
        var ctx1 = document.getElementById('leadschart'); if (ctx1) {
            if (ctx1 && ctx1.getContext) { ctx1.height = 40; }
            const uniqueMini = timeClicks.slice(-Math.min(15, timeClicks.length));
            new Chart(ctx1.getContext('2d'), {
                type: 'line',
                data: { labels: uniqueMini.map((_, i) => `T${i+1}`), datasets: [{ label: 'Unique', data: uniqueMini, backgroundColor: 'transparent', borderColor: '#f46ef4', borderWidth: 2.5, pointBorderColor: 'transparent', pointBackgroundColor: 'transparent', tension: 0, cubicInterpolationMode: 'default', fill: false, pointRadius: 0 }] },
                options: { maintainAspectRatio: false, plugins: { legend: { display: false }, tooltip: { enabled: false } }, responsive: true, scales: { x: { display: false }, y: { display: false } }, elements: { line: { borderCapStyle: 'butt', borderJoinStyle: 'miter' }, point: { radius: 0 } } }
            });
        }

        // profitchart (Conversions as bar, green #4ecc48) - using time-based data
        var ctx2 = document.getElementById('profitchart'); if (ctx2) {
            const conversionsSample = timeConversions.filter((_, i) => i % Math.max(1, Math.floor(timeConversions.length / 8)) === 0);
            const labelsSample = timeLabels.filter((_, i) => i % Math.max(1, Math.floor(timeLabels.length / 8)) === 0);
            
            new Chart(ctx2.getContext('2d'), {
                type: 'bar',
                data: { 
                    labels: labelsSample.map((_, i) => `T${i+1}`), 
                    datasets: [{ 
                        barPercentage: 0.4, barThickness: 6, maxBarThickness: 8, minBarLength: 2, 
                        label: 'Conversions', barGap: 0.5, barSizeRatio: 1, 
                        data: conversionsSample, 
                        backgroundColor: '#4ecc48', 
                        borderColor: '#4ecc48', 
                        borderWidth: 1, borderRadius: 2 
                    }] 
                },
                options: { maintainAspectRatio: false, plugins: { legend: { display: false }, tooltip: { enabled: false } }, responsive: true, scales: { x: { display: false, categoryPercentage: 0.6, barPercentage: 0.4 }, y: { display: false } }, elements: { point: { radius: 0 } } }
            });
        }

        // costchart (Revenue as line, amber #f7ba48) - using time-based data
        var ctx3 = document.getElementById('costchart'); if (ctx3) {
            if (ctx3 && ctx3.getContext) { ctx3.height = 40; }
            const revenueMini = timePayout.slice(-Math.min(17, timePayout.length));
            new Chart(ctx3.getContext('2d'), {
                type: 'line',
                data: { labels: revenueMini.map((_, i) => `T${i+1}`), datasets: [{ label: 'Revenue', data: revenueMini, backgroundColor: 'transparent', borderColor: '#f7ba48', borderWidth: 2.5, pointBorderColor: 'transparent', pointBackgroundColor: 'transparent', tension: 0, cubicInterpolationMode: 'default', fill: false, pointRadius: 0 }] },
                options: { maintainAspectRatio: false, plugins: { legend: { display: false }, tooltip: { enabled: false } }, responsive: true, scales: { x: { display: false }, y: { display: false } }, elements: { line: { borderCapStyle: 'butt', borderJoinStyle: 'miter' }, point: { radius: 0 } } }
            });
        }

        // Main: Bar Chart2 style (Clicks vs Conversions)
        var cbar2 = document.getElementById('chartBar2'); if (cbar2) {
            var ctxBar2 = cbar2.getContext('2d');
            new Chart(ctxBar2, {
                type: 'bar',
                data: {
                    labels: dates,
                    datasets: [
                        {
                            label: 'Clicks',
                            data: clicks,
                            backgroundColor: '#6c5ffc',
                            borderColor: '#6c5ffc',
                            borderWidth: 2,
                            barThickness: 8,
                        },
                        {
                            label: 'Conversions',
                            data: conversions,
                            backgroundColor: '#05c3fb',
                            borderColor: '#05c3fb',
                            borderWidth: 2,
                            barThickness: 8,
                        }
                    ]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    plugins: { legend: { display: false } },
                    scales: {
                        x: {
                            stacked: false,
                            grid: { display: false },
                            ticks: { color: '#9ba6b5', autoSkip: true }
                        },
                        y: {
                            beginAtZero: true,
                            grid: { color: 'rgba(119,119,142,0.2)' },
                            ticks: { color: '#9ba6b5' }
                        }
                    }
                }
            });
        }

        // Recent Conversations Chart (Doughnut Chart)
        var recentOrdersCtx = document.getElementById('recentorders'); if (recentOrdersCtx) {
            new Chart(recentOrdersCtx.getContext('2d'), {
                type: 'doughnut',
                data: {
                    labels: ['Approved', 'Pending', 'Rejected'],
                    datasets: [{
                        data: [totalConvFallback, Math.floor(totalClickFallback * 0.3), Math.floor(totalClickFallback * 0.1)],
                        backgroundColor: ['#6c5ffc', '#05c3fb', '#f46ef4'],
                        borderWidth: 0,
                        cutout: '70%'
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    plugins: {
                        legend: { display: false },
                        tooltip: { enabled: false }
                    },
                    elements: {
                        arc: {
                            borderWidth: 0
                        }
                    }
                }
            });
        }

        // Add CSS for pulse animation and transitions
        const style = document.createElement('style');
        style.textContent = `
            @keyframes pulse {
                0% { opacity: 1; }
                50% { opacity: 0.5; }
                100% { opacity: 1; }
            }
            @keyframes spin {
                0% { transform: rotate(0deg); }
                100% { transform: rotate(360deg); }
            }
            .task-list li {
                transition: all 0.3s ease;
            }
            .task-list li:hover {
                transform: translateX(5px);
                box-shadow: 0 2px 8px rgba(0,0,0,0.1);
            }
            .fa-spin {
                animation: spin 1s linear infinite;
            }
            .activity-updating {
                animation: pulse 0.5s ease-in-out;
            }
            @keyframes activityUpdate {
                0% { background-color: transparent; }
                50% { background-color: rgba(108, 95, 252, 0.1); }
                100% { background-color: transparent; }
            }
        `;
        document.head.appendChild(style);
    });

    // Daily Activity Dynamic Updates - Global Functions
    let activityUpdateInterval;
    
    function refreshActivity() {
        console.log('Refresh activity clicked');
        const loader = document.getElementById('activity-loader');
        const activityList = document.getElementById('daily-activity-list');
        const statusBadge = document.getElementById('activity-status');
        
        if (!loader || !activityList || !statusBadge) {
            console.error('Required elements not found');
            return;
        }
        
        // Show loading state
        loader.style.display = 'block';
        activityList.style.opacity = '0.5';
        statusBadge.innerHTML = '<i class="fe fe-refresh-cw fa-spin"></i> Updating...';
        statusBadge.className = 'badge bg-warning-transparent text-warning me-2';
        
        // Simulate API call (replace with actual endpoint)
        setTimeout(() => {
            // Update activity data dynamically
            updateActivityData();
            
            // Hide loading state
            loader.style.display = 'none';
            activityList.style.opacity = '1';
            statusBadge.innerHTML = '<i class="fe fe-activity"></i> Live';
            statusBadge.className = 'badge bg-success-transparent text-success me-2';
            
            // Update last updated time
            const lastUpdated = document.getElementById('last-updated');
            if (lastUpdated) {
                lastUpdated.textContent = new Date().toLocaleTimeString();
            }
        }, 1500);
    }
    
    function updateActivityData() {
        console.log('Updating activity data');
        
        // Add visual feedback to all activity items
        const activityItems = document.querySelectorAll('#daily-activity-list li');
        activityItems.forEach(item => {
            item.classList.add('activity-updating');
            setTimeout(() => {
                item.classList.remove('activity-updating');
            }, 500);
        });
        
        // Simulate dynamic data updates
        const activities = [
            { id: 'pending-affiliates-count', type: 'count', min: 0, max: 15 },
            { id: 'offer-applications-count', type: 'count', min: 0, max: 8 },
            { id: 'conversions-count', type: 'count', min: 0, max: 25 },
            { id: 'revenue-count', type: 'currency', min: 0, max: 5000 },
            { id: 'top-offer-name', type: 'text', values: ['Premium Offer A', 'Special Deal B', 'Limited Time C', 'Exclusive Offer D'] }
        ];
        
        activities.forEach(activity => {
            const element = document.getElementById(activity.id);
            if (element) {
                if (activity.type === 'count') {
                    const newCount = Math.floor(Math.random() * (activity.max - activity.min + 1)) + activity.min;
                    element.textContent = `${newCount} ${activity.id.includes('affiliates') ? 'pending' : activity.id.includes('applications') ? 'pending' : 'today'}`;
                    
                    // Update description
                    const descElement = document.getElementById(activity.id.replace('-count', '-desc'));
                    if (descElement) {
                        if (activity.id.includes('affiliates')) {
                            descElement.textContent = `${newCount} affiliate(s) waiting for approval`;
                        } else if (activity.id.includes('applications')) {
                            descElement.textContent = `${newCount} offer application(s) waiting for review`;
                        } else if (activity.id.includes('conversions')) {
                            descElement.textContent = `${newCount} conversion(s) approved today`;
                        }
                    }
                } else if (activity.type === 'currency') {
                    const newAmount = (Math.random() * (activity.max - activity.min) + activity.min).toFixed(2);
                    element.textContent = `$${parseFloat(newAmount).toLocaleString()}`;
                } else if (activity.type === 'text') {
                    const randomValue = activity.values[Math.floor(Math.random() * activity.values.length)];
                    element.textContent = randomValue;
                }
            }
        });
        
        // Show a brief notification
        const statusBadge = document.getElementById('activity-status');
        if (statusBadge) {
            const originalText = statusBadge.innerHTML;
            statusBadge.innerHTML = '<i class="fe fe-check"></i> Updated';
            statusBadge.className = 'badge bg-success-transparent text-success me-2';
            
            setTimeout(() => {
                statusBadge.innerHTML = originalText;
                statusBadge.className = 'badge bg-success-transparent text-success me-2';
            }, 2000);
        }
    }
    
    // Auto-refresh activity every 10 seconds for demo purposes
    function startActivityAutoRefresh() {
        console.log('Starting auto-refresh');
        activityUpdateInterval = setInterval(() => {
            updateActivityData();
            const lastUpdated = document.getElementById('last-updated');
            if (lastUpdated) {
                lastUpdated.textContent = new Date().toLocaleTimeString();
            }
        }, 10000); // Changed to 10 seconds for better demo
    }
    
    // Start auto-refresh when page loads
    setTimeout(() => {
        startActivityAutoRefresh();
        // Add pulse animation to status badge
        const statusBadge = document.getElementById('activity-status');
        if (statusBadge) {
            statusBadge.style.animation = 'pulse 2s infinite';
        }
    }, 2000);

    // Top Countries Dynamic Updates
    let countriesUpdateInterval;
    let countriesViewMode = 'all'; // 'all' or 'top'
    
    // Get real countries data from PHP
    let countriesData = [];
    
    // Extract countries data from the existing DOM elements
    function initializeCountriesData() {
        const countryItems = document.querySelectorAll('.country-item');
        countriesData = Array.from(countryItems).map(item => {
            const name = item.querySelector('.country-name')?.textContent?.trim();
            const reports = parseInt(item.getAttribute('data-reports')) || 0;
            return {
                name: name,
                reports: reports,
                flag: '🌍' // Default flag, can be enhanced later
            };
        }).filter(country => country.name && country.reports > 0);
        
        console.log('Initialized countries data:', countriesData);
    }
    
    function refreshCountries() {
        console.log('Refresh countries clicked');
        const loader = document.getElementById('countries-loader');
        const countriesContainer = document.getElementById('countries-container');
        const statusBadge = document.getElementById('countries-status');
        
        if (!loader || !countriesContainer || !statusBadge) {
            console.error('Required countries elements not found');
            return;
        }
        
        // Show loading state
        loader.style.display = 'block';
        countriesContainer.style.opacity = '0.5';
        statusBadge.innerHTML = '<i class="fe fe-refresh-cw fa-spin"></i> Updating...';
        statusBadge.className = 'badge bg-warning-transparent text-warning me-2';
        
        // Simulate API call
        setTimeout(() => {
            updateCountriesData();
            
            // Hide loading state
            loader.style.display = 'none';
            countriesContainer.style.opacity = '1';
            statusBadge.innerHTML = '<i class="fe fe-trending-up"></i> Live';
            statusBadge.className = 'badge bg-info-transparent text-info me-2';
            
            // Update last updated time
            const lastUpdated = document.getElementById('countries-last-updated');
            if (lastUpdated) {
                lastUpdated.textContent = new Date().toLocaleTimeString();
            }
        }, 1500);
    }
    
    function updateCountriesData() {
        console.log('Updating countries data');
        
        // Re-initialize countries data from current DOM
        initializeCountriesData();
        
        // If no countries data available, show message
        if (countriesData.length === 0) {
            const container = document.getElementById('countries-container');
            if (container) {
                container.innerHTML = `
                    <div class="text-center text-muted py-4" id="no-countries-message">
                        <i class="fe fe-globe fs-48 mb-3"></i>
                        <p>No country data available</p>
                    </div>
                `;
            }
            return;
        }
        
        // Sort by reports count (descending)
        const sortedCountries = [...countriesData].sort((a, b) => b.reports - a.reports);
        
        // Get top countries based on view mode
        const displayCountries = countriesViewMode === 'top' ? sortedCountries.slice(0, 3) : sortedCountries.slice(0, 4);
        
        // Update the container
        renderCountries(displayCountries);
        
        // Show update notification
        const statusBadge = document.getElementById('countries-status');
        if (statusBadge) {
            const originalText = statusBadge.innerHTML;
            statusBadge.innerHTML = '<i class="fe fe-check"></i> Updated';
            statusBadge.className = 'badge bg-success-transparent text-success me-2';
            
            setTimeout(() => {
                statusBadge.innerHTML = originalText;
                statusBadge.className = 'badge bg-info-transparent text-info me-2';
            }, 2000);
        }
    }
    
    function renderCountries(countries) {
        const container = document.getElementById('countries-container');
        const colors = ['bg-primary', 'bg-danger', 'bg-warning', 'bg-success'];
        
        let html = '';
        
        // Filter out countries with invalid data
        const validCountries = countries.filter(country => 
            country && 
            country.name && 
            country.reports && 
            country.reports > 0 && 
            !isNaN(country.reports)
        );
        
        if (validCountries.length === 0) {
            html = `
                <div class="text-center text-muted py-4" id="no-countries-message">
                    <i class="fe fe-globe fs-48 mb-3"></i>
                    <p>No country data available</p>
                </div>
            `;
        } else {
            // Calculate max reports only from valid countries
            const maxReports = Math.max(...validCountries.map(c => c.reports));
            
            validCountries.forEach((country, index) => {
                const percentage = maxReports > 0 ? (country.reports / maxReports) * 100 : 0;
                html += `
                    <div class="row mb-4 country-item" data-country="${country.name}" data-reports="${country.reports}">
                        <div class="col-sm-2 col-lg-3 col-xl-3 col-xxl-2 mb-sm-0 mb-3">
                            <div class="avatar avatar-md bg-primary-transparent text-primary bradius">
                                <span style="font-size: 1.2em;">${country.flag || '🌍'}</span>
                            </div>
                        </div>
                        <div class="col-sm-10 col-lg-9 col-xl-9 col-xxl-10 ps-sm-0">
                            <div class="d-flex align-items-end justify-content-between mb-1">
                                <h6 class="mb-1 country-name">${country.name}</h6>
                                <h6 class="fw-semibold mb-1 country-reports">${country.reports.toLocaleString()} <span class="text-success fs-11 country-percentage">(<i class="fe fe-arrow-up"></i>${percentage.toFixed(1)}%)</span></h6>
                            </div>
                            <div class="progress h-2 mb-3">
                                <div class="progress-bar ${colors[index % 4]} country-progress" style="width: ${percentage}%;" role="progressbar"></div>
                            </div>
                        </div>
                    </div>
                `;
            });
        }
        
        container.innerHTML = html;
        
        // Add animation to new items
        const countryItems = container.querySelectorAll('.country-item');
        countryItems.forEach((item, index) => {
            item.style.opacity = '0';
            item.style.transform = 'translateY(20px)';
            setTimeout(() => {
                item.style.transition = 'all 0.5s ease';
                item.style.opacity = '1';
                item.style.transform = 'translateY(0)';
            }, index * 100);
        });
    }
    
    function toggleCountriesView() {
        countriesViewMode = countriesViewMode === 'all' ? 'top' : 'all';
        console.log('Toggling countries view to:', countriesViewMode);
        
        // Update button icon
        const toggleBtn = event.target.closest('button');
        if (toggleBtn) {
            const icon = toggleBtn.querySelector('i');
            if (countriesViewMode === 'top') {
                icon.className = 'fe fe-eye-off';
                toggleBtn.title = 'Show All Countries';
            } else {
                icon.className = 'fe fe-eye';
                toggleBtn.title = 'Show Top Countries Only';
            }
        }
        
        // Refresh data with new view mode
        updateCountriesData();
    }
    
    // Auto-refresh countries every 30 seconds (just for sorting/filtering, not data changes)
    function startCountriesAutoRefresh() {
        console.log('Starting countries auto-refresh');
        countriesUpdateInterval = setInterval(() => {
            // Only refresh if we have data to work with
            if (countriesData.length > 0) {
                updateCountriesData();
                const lastUpdated = document.getElementById('countries-last-updated');
                if (lastUpdated) {
                    lastUpdated.textContent = new Date().toLocaleTimeString();
                }
            }
        }, 30000); // 30 seconds - less frequent since we're not changing data
    }
    
    // Start countries auto-refresh when page loads
    setTimeout(() => {
        // Initialize countries data from PHP first
        initializeCountriesData();
        
        startCountriesAutoRefresh();
        // Add pulse animation to countries status badge
        const countriesStatusBadge = document.getElementById('countries-status');
        if (countriesStatusBadge) {
            countriesStatusBadge.style.animation = 'pulse 2s infinite';
        }
    }, 3000);
    
    // Date Range Picker Initialization
    function initializeDateRangePicker() {
        const dateInput = document.getElementById('date_filter');
        
        // Initialize daterangepicker
        if (typeof $ !== 'undefined' && $.fn.daterangepicker) {
            $(dateInput).daterangepicker({
                autoUpdateInput: false,
                showDropdowns: true,
                linkedCalendars: false,
                autoApply: true,
                locale: {
                    format: 'YYYY-MM-DD',
                    separator: ' - ',
                    applyLabel: 'Apply',
                    cancelLabel: 'Clear',
                    fromLabel: 'From',
                    toLabel: 'To',
                    customRangeLabel: 'Custom',
                    weekLabel: 'W',
                    daysOfWeek: ['Su', 'Mo', 'Tu', 'We', 'Th', 'Fr', 'Sa'],
                    monthNames: ['January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December'],
                    firstDay: 1
                },
                ranges: {
                    'Today': [moment(), moment()],
                    'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                    'Last 7 Days': [moment().subtract(6, 'days'), moment()],
                    'Last 30 Days': [moment().subtract(29, 'days'), moment()],
                    'This Month': [moment().startOf('month'), moment().endOf('month')],
                    'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
                    'Last 90 Days': [moment().subtract(89, 'days'), moment()]
                },
                opens: 'left'
            });
            
            // Handle date selection
            $(dateInput).on('apply.daterangepicker', function(ev, picker) {
                $(this).val(picker.startDate.format('YYYY-MM-DD') + ' - ' + picker.endDate.format('YYYY-MM-DD'));
                // Auto-submit form when date is selected
                $(this).closest('form').submit();
            });
            
            // Handle clear
            $(dateInput).on('cancel.daterangepicker', function(ev, picker) {
                $(this).val('');
                $(this).closest('form').submit();
            });
        }
        
        // Set current value if exists
        const currentFilter = new URLSearchParams(window.location.search).get('date_filter');
        if (currentFilter) {
            dateInput.value = currentFilter;
        }
    }
    
    </script>
@endpush