@extends('layouts.backend.admin_sash')


@isset($finance)
@section('title', 'Edit Finance')
@else
@section('title','Create Finance')
@endisset


@push('css')
@endpush

@section('content')
    <div class="container-xl">
        <!-- Page title -->
        <div class="page-header d-print-none">
            <div class="row align-items-center">
                <div class="col">
                    <!-- Page pre-title -->
                    <div class="page-pretitle">
                        Overview
                    </div>
                    <h2 class="page-title">
                        @yield(('title'))
                    </h2>
                </div>
                <!-- Page title actions -->
                <div class="col-auto ms-auto d-print-none">
                    <div class="btn-list">
                        <a href="{{ route('admin.finance.index') }}" class="btn btn-primary d-none d-sm-inline-block">
                            <!-- Download SVG icon from http://tabler-icons.io/i/plus -->
                            <i class="fa fa-backward"></i>
                            Back
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="page-body">
        <div class="container-xl">
            <form action="{{ isset($finance) ? route('admin.finance.update',$finance->id) : route('admin.finance.store')   }}" method="post" enctype="multipart/form-data">
                @csrf
                @isset($finance)
                    @method('PUT')
                @endisset
                <div class="row row-cards">
                <div class="col-md-6">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">Finance Info</h3>
                        </div>
                        @if ($errors->any())
                            <div class="alert alert-danger">
                                <ul>
                                    @foreach ($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        @endif
                        <div class="card-body">
                            <div class="form-group mb-3 ">
                                <label class="form-label">Name</label>
                                <div>
                                    <input type="text" class="form-control" name="name" value="{{ $finance->name ?? old('name') }}" placeholder="Finance Name" required>
                                </div>
                                @error('name')
                                <div class="error">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="form-group mb-3 ">
                                <label class="form-label">Description</label>
                                <div>
                                    <textarea name="description" id="description"  rows="6" class="form-control">{{ $finance->description ?? old('description') }}</textarea>
                                </div>
                                @error('description')
                                <div class="error">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="form-group mb-3 ">
                                <label class="form-label">Description</label>
                                <div>
                                    <input type="file" name="avater" class="form-control" data-height="300" />
                                </div>
                                @error('first_name')
                                <div class="error">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="form-group mb-3 ">
                                <label class="form-label">Status</label>
                                <div>
                                    <select name="status" id="status" class="form-control">
                                        <option value="1" {{ isset($finance) && $finance->status == 1 ? 'selected' : '' }}>Active</option>
                                        <option value="0" {{ isset($finance) && $finance->status == 0 ? 'selected' : '' }}>Inactive</option>
                                    </select>
                                </div>
                            </div>
                            <div class="form-footer">
                                <button type="submit" class="btn btn-primary">@isset($finance) Update @else Create @endisset</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            </form>
        </div>
    </div>
@endsection

@push('js')
@endpush
