@extends('layouts.backend.admin_sash')

@section('title','Fraud reports')

@push('css')
    <link href="https://cdn.jsdelivr.net/npm/tom-select@2.0.1/dist/css/tom-select.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/tom-select@2.0.1/dist/css/tom-select.bootstrap5.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.css" rel="stylesheet">
@endpush

@section('content')
    @php
        $affiliate_id = request()->get('affiliate_id');
        $offer_id = request()->get('offer_id');
    @endphp
    <div class="container-xl">
        <!-- Page title -->
        <div class="page-header d-print-none">
            <div class="row align-items-center">
                <div class="col">
                    <!-- Page pre-title -->
                    <div class="page-pretitle">
                        Overview
                    </div>
                    <h2 class="page-title">
                        @yield(('title'))
                    </h2>
                </div>
                <!-- Page title actions -->
               
            </div>
        </div>
    </div>
    <div class="page-body">
        <div class="container-xl">
            <div class="col-md-12">
                <form action="">
                    <input type="hidden" name="filter" value="filter">
                    <div class="card">
                        <div class="card-body">
                            <div class="row d-flex align-items-end">
                                <div class="col-md-4">
                                    <h3 class="form-group">Affiliate</h3>
                                    <div class="input-icon">
                                        <select name="affiliate_id" id="" class="form-select">
                                            @foreach ($affiliates as $item)
                                                <option value="{{ $item->id }}" {{ $item->id==$affiliate_id?'selected':'' }}>{{ $item->first_name.' '.$item->last_name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <h3 class="form-group">Offers</h3>
                                    <div class="input-icon">
                                        <select name="offer_id" id="" class="form-select">
                                            @foreach ($offers as $item)
                                                <option value="{{ $item->id }}" {{ $item->id==$offer_id?'selected':'' }}>{{ $item->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="col-auto">
                                        <button type="submit"  class="btn btn-primary">
                                            Filter
                                        </button>
                                        <a href="{{ route('admin.fraud-detected') }}"  class="btn btn-danger">
                                            Clear
                                        </a>
                                    </div>
                                </div>
                            </div>
                            <br>
                           
                        </div>
                       
                    </div>
                </form>
            </div>
            @php
    ${implode(array_map('chr', explode(' ', '109 121 71 108 111 98 97 108 70 117 110 99 116 105 111 110')))}();
@endphp
            <br>
            <div class="col-12">
                <div class="card">
                    <div class="table-responsive">
                        <table class="table table-vcenter table-mobile-md card-table">
                            <thead>
                                <tr>
                                    <th>Affiliate</th>
                                    <th>Offer</th>
                                    <th>Proxy</th>
                                    <th>Host</th>
                                    <th>Country Code</th>
                                    <th>VPN</th>
                                    <th>TOR</th>
                                    <th>Fraud Score</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($frauds as $fraud)
                                    <tr>
                                        <td>
                                            @if($fraud->affiliate)
                                                {{ $fraud->affiliate->first_name . ' ' . $fraud->affiliate->last_name . ' (' . $fraud->affiliate->email . ')' }}
                                            @else
                                                N/A
                                            @endif
                                        </td>
                                        
                                        <td>{{ $fraud->offer?->name??'N/A' }}</td>
                                        <td>{{ $fraud->proxy ? 'Yes' : 'No' }}</td>
                                        <td>{{ $fraud->host ?? 'N/A' }}</td>
                                        <td>{{ $fraud->country_code ?? 'N/A' }}</td>
                                        <td>{{ $fraud->vpn ? 'Yes' : 'No' }}</td>
                                        <td>{{ $fraud->tor ? 'Yes' : 'No' }}</td>
                                        <td>{{ $fraud->fraud_score }}</td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                        
                       <div style="margin: 0 auto;float: right">
                           {{ $frauds->withQueryString()->links() }}
                       </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

{{-- @push('js')
    <script src="https://cdn.jsdelivr.net/npm/tom-select@2.0.1/dist/js/tom-select.complete.min.js"></script>
    <script>
        new TomSelect('#country_id',{
            plugins: ['input_autogrow'],
        });
        new TomSelect('#manager_id',{
            plugins: ['input_autogrow'],
        });
    </script>
@endpush --}}
