@extends('layouts.backend.admin_sash')


@isset($manager)
@section('title', 'Edit Manager')
@else
@section('title','Create Manager')
@endisset


@push('css')
    <link href="https://cdn.jsdelivr.net/npm/tom-select@2.0.1/dist/css/tom-select.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/tom-select@2.0.1/dist/css/tom-select.bootstrap5.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.css" rel="stylesheet">
@endpush

@section('content')
    <div class="container-xl">
        <!-- Page title -->
        <div class="page-header d-print-none">
            <div class="row align-items-center">
                <div class="col">
                    <!-- Page pre-title -->
                    <div class="page-pretitle">
                        Overview
                    </div>
                    <h2 class="page-title">
                        @yield(('title'))
                    </h2>
                </div>
                <!-- Page title actions -->
                <div class="col-auto ms-auto d-print-none">
                    <div class="btn-list">
                        <a href="{{ route('admin.manager.index') }}" class="btn btn-primary d-none d-sm-inline-block">
                            <!-- Download SVG icon from http://tabler-icons.io/i/plus -->
                            <i class="fa fa-backward"></i>
                            Back
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="page-body">
        <div class="container-xl">
            <form action="{{ isset($manager) ? route('admin.manager.update',$manager->id) : route('admin.manager.store')   }}" method="post" enctype="multipart/form-data">
                @csrf
                @isset($manager)
                    @method('PUT')
                @endisset
                <div class="row row-cards">
                <div class="col-md-6">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">Basic Info</h3>
                        </div>
                        @if ($errors->any())
                            <div class="alert alert-danger">
                                <ul>
                                    @foreach ($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        @endif
                        <div class="card-body">
                            <div class="form-group mb-3 ">
                                <label class="form-label">First Name</label>
                                <div>
                                    <input type="text" class="form-control" name="first_name" value="{{ $manager->first_name ?? old('first_name') }}" placeholder="First Name" required>
                                </div>
                                @error('first_name')
                                <div class="error">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="form-group mb-3 ">
                                <label class="form-label">Last Name</label>
                                <div>
                                    <input type="text" class="form-control" name="last_name"  value="{{ $manager->last_name ?? old('last_name') }}" placeholder="Last Name" required>
                                </div>
                            </div>
                            <div class="form-group mb-3 ">
                                <label class="form-label">Email</label>
                                <div>
                                    <input type="email" class="form-control" name="email"  value="{{ $manager->email ?? old('email') }}" placeholder="Email" required>
                                </div>
                            </div>
                            <div class="form-group mb-3 ">
                                <label class="form-label">Country</label>
                                <div>
                                    <select name="country_id" class="form-select" id="country_id" placeholder="  Select a country..." required>
                                        <option selected disabled>Select Country</option>
                                    @foreach($countries as $country)
                                        <option
                                            @isset($manager)
                                                {{ $manager->country_id == $country->id ? 'selected' : '' }}
                                            @endisset
                                            value="{{ $country->id }}">{{ $country->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="form-group mb-3 ">
                                <label class="form-label">Skype</label>
                                <div>
                                    <input type="text" class="form-control" name="skype"  value="{{ $manager->skype ?? old('skype') }}" placeholder="Skype" required>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">Password & Image</h3>
                        </div>
                        <div class="card-body">
                            <div class="form-group mb-3 ">
                                <label class="form-label">Status</label>
                                <div>
                                    <div class="input-icon">
                                        <select name="status" id="status" class="form-control">
                                            <option @isset($manager) {{ $manager->status == "active" ? 'selected' : '' }} @endisset value="active">Active</option>
                                            <option @isset($manager) {{ $manager->status == "pending" ? 'selected' : '' }} @endisset value="pending">Pending</option>
                                            <option @isset($manager) {{ $manager->status == "suspend" ? 'selected' : '' }} @endisset value="suspend">Suspend</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="form-group mb-3 ">
                                <label class="form-label">Password</label>
                                <div>
                                    <input type="password" name="password" class="form-control" placeholder="Password">
                                    <small class="form-hint">
                                        Your password must be 6-20 characters long, contain letters and numbers, and must not contain
                                        spaces, special characters, or emoji.
                                    </small>
                                </div>
                            </div>
                            <div class="form-group mb-3 ">
                                <label class="form-label">Confirm Password</label>
                                <div>
                                    <input type="password" name="password_confirmation" class="form-control" placeholder="Password">
                                </div>
                            </div>
                            <div class="form-group mb-3 ">
                                <label class="form-label">Avater</label>
                                <div>
                                    <input type="file" name="avater" class="form-control">
                                </div>
                            </div>
                            <div class="form-group mb-3 ">
                                <label class="form-label">Comission</label>
                                <div>
                                    <input type="number" name="comission" class="form-control" placeholder="Manager Comission" value="{{ $manager->comission ?? old('comission')}}" required>
                                </div>
                            </div>
                            <div class="form-footer">
                                <button type="submit" class="btn btn-primary">@isset($manager) Update @else Create @endisset</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            </form>
        </div>
    </div>
@endsection

@push('js')
    <script src="https://cdn.jsdelivr.net/npm/tom-select@2.0.1/dist/js/tom-select.complete.min.js"></script>
    <script>
        new TomSelect('#country_id',{
            plugins: ['input_autogrow'],
        });
        new TomSelect('#manager_id',{
            plugins: ['input_autogrow'],
        });

    </script>
@endpush
