@extends('layouts.backend.admin_sash')

@isset($invoice)
    @section('title', 'Edit Invoice')
@else
    @section('title','Create Invoice')
@endisset

@push('css')
    <link href="https://cdn.jsdelivr.net/npm/tom-select@2.0.1/dist/css/tom-select.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/tom-select@2.0.1/dist/css/tom-select.bootstrap5.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.css" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js" integrity="sha512-894YE6QWD5I59HgZOGReFYm4dnWc1Qt5NtvYSaNcOP+u1T9qYdvdihz0PPSiiqn/+/3e7Jo4EaG7TubfWGUrMQ==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
    <link rel="stylesheet" href="{{ asset('backend/date/bootstrap3-wysihtml5.min.css') }}">
    <link rel="stylesheet" href="{{ asset('backend/date/bootstrap-datepicker.min.css') }}">
    <link rel="stylesheet" href="{{ asset('backend/date/daterangepicker.css') }}">
@endpush

@section('content')
    <div class="container-xl">
        <!-- Page title -->
        <div class="page-header d-print-none">
            <div class="row align-items-center">
                <div class="col">
                    <!-- Page pre-title -->
                    <div class="page-pretitle">
                        Overview
                    </div>
                    <h2 class="page-title">
                        @yield(('title'))
                    </h2>
                </div>
                <!-- Page title actions -->
                <div class="col-auto ms-auto d-print-none">
                    <div class="btn-list">
                        <a href="{{ route('admin.invoice.index') }}" class="btn btn-primary d-none d-sm-inline-block">
                            <!-- Download SVG icon from http://tabler-icons.io/i/plus -->
                            <i class="fa fa-backward"></i>
                            Back
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="page-body">
        <div class="container-xl">
                <div class="row row-cards">
                    <div class="col-md-6">
                        <div class="card">
                            <div class="card-header">
                                <h3 class="card-title">Basic Info</h3>
                            </div>
                            @if ($errors->any())
                                <div class="alert alert-danger">
                                    <ul>
                                        @foreach ($errors->all() as $error)
                                            <li>{{ $error }}</li>
                                        @endforeach
                                    </ul>
                                </div>
                            @endif
                            @include('layouts.backend.partials.flash-message')
                            <form action="{{ route('admin.invoice.store') }}" method="POST">
                                @csrf
                            <div class="card-body">
                                <div class="form-group mb-3 ">
                                    <label class="form-label">Affiliate</label>
                                    <div>
                                        <select name="user_id" class="form-select" id="user_id" placeholder="  Select a Affiliate..." required>
                                            <option value="">Select a Affiliate...</option>
                                            @foreach($users as $user)
                                                <option
                                                    @isset($invoice)
                                                    {{ $user->user_id == $user->id ? 'selected' : '' }}
                                                    @endisset
                                                    value="{{ $user->id }}">{{ $user->first_name . ' '. $user->last_name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <br>
                                    <label class="form-label">Select Invoice Date</label>
                                    <div>
                                        <input type="text" class="btn btn-default" id="date_filter" name="date_filter">
                                    </div>
                                    <br>
                                    <label class="form-label">Finance Name</label>
                                    <div>
                                        <input type="text" name="finance_name" id="finance_name" class="form-control" required>
                                    </div>
                                    <label class="form-label">Wallet</label>
                                    <div>
                                        <textarea name="wallet" id="wallet" class="form-control" required></textarea>
                                    </div>
                                    <br>
                                    <label class="form-label">Conversion</label>
                                    <div>
                                        <input type="text" name="conversion" id="conversion" class="form-control" required>
                                    </div>
                                    <br>
                                    <label class="form-label">Amount</label>
                                    <div>
                                        <input type="text" name="amount" id="amount" class="form-control" required>
                                    </div>
                                    <br>
                                    <div>
                                        <button type="submit" value="submit" class="btn btn-success">Generate</button>
                                    </div>
                                </div>
                            </div>
                            </form>
                        </div>
                    </div>
                </div>
        </div>
    </div>
@endsection

@push('js')
    <script src="https://cdn.jsdelivr.net/npm/tom-select@2.0.1/dist/js/tom-select.complete.min.js"></script>
    <script src="{{ asset('backend/date/moment.min.js') }}"></script>
    <script src="{{ asset('backend/date/daterangepicker.js') }}"></script>
    <!-- datepicker -->
    <script src="{{ asset('backend/date/bootstrap-datepicker.min.js') }}"></script>
    <script type="text/javascript">
        $(function() {
            let dateInterval = getQueryParameter('date_filter');
            let start = moment().startOf('last Monday');
            let end = moment().endOf('this Sunday');
            if (dateInterval) {
                dateInterval = dateInterval.split(' - ');
                start = dateInterval[0];
                end = dateInterval[1];
            }
            $('#date_filter').daterangepicker({
                "showDropdowns": true,
                "showWeekNumbers": true,
                "alwaysShowCalendars": false,
                startDate: start,
                endDate: end,
                locale: {
                    format: 'YYYY-MM-DD',
                    firstDay: 1,
                },
                ranges: {
                    'Today': [moment(), moment()],
                    'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                    'Last 7 Days': [moment().subtract(6, 'days'), moment()],
                    'Last 30 Days': [moment().subtract(29, 'days'), moment()],
                    'This Month': [moment().startOf('month'), moment().endOf('month')],
                    'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1,
                        'month').endOf('month')],
                    'This Year': [moment().startOf('year'), moment().endOf('year')],
                    'Last Year': [moment().subtract(1, 'year').startOf('year'), moment().subtract(1, 'year')
                        .endOf('year')
                    ],
                    'All time': [moment().subtract(30, 'year').startOf('month'), moment().endOf('month')],
                }
            });
        });

        function getQueryParameter(name) {
            const url = window.location.href;
            name = name.replace(/[\[\]]/g, "\\$&");
            const regex = new RegExp("[?&]" + name + "(=([^&#]*)|&|#|$)"),
                results = regex.exec(url);
            if (!results) return null;
            if (!results[2]) return '';
            return decodeURIComponent(results[2].replace(/\+/g, " "));
        }
    </script>
    <script>
        new TomSelect('#user_id',{
            plugins: ['input_autogrow'],
        });
        $(document).ready(function() {
            $('#user_id').change(function(){
                var user_id = $(this).val();
                var data = null;
                $.ajax({
                    url: "{{ route('admin.invoice.get-wallet') }}",
                    type: "GET",
                    data: {user_id: user_id},
                    success: function(data) {
                        if(data.status == 'success') {
                            $('#wallet').val(data.wallet);
                            $('#finance_name').val(data.method_name);
                        }else{
                            alert(data.message);
                        }
                    }
                });
            });
            $('#date_filter').change(function(){
                var user_id = $('#user_id').val();
                var date_filter = $(this).val();
                $.ajax({
                    url: "{{ route('admin.invoice.get-report') }}",
                    type: "GET",
                    data: {
                        date_filter: date_filter,
                        user_id: user_id
                    },
                    success: function(data) {
                        $('#amount').val(data.amount);
                        $('#conversion').val(data.conversion);
                    }
                });
            });
        });

    </script>
@endpush
