@extends('layouts.backend.admin_sash')

@section('title','Manage Offers')

@push('css')
    <link href="https://cdn.jsdelivr.net/npm/tom-select@2.0.1/dist/css/tom-select.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/tom-select@2.0.1/dist/css/tom-select.bootstrap5.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.css" rel="stylesheet">
    <link href="{{ asset('backend/dist/css/tabler-flags.min.css')}}" rel="stylesheet"/>
@endpush

@section('content')
    @php
        $id = request()->get('id');
        $status = request()->get('status');
        $name = request()->get('name');
        $category_id = request()->get('category_id');
        $device_id = request()->get('device_id');
        $country_id = request()->get('country_id');
        $type = request()->get('type');
    @endphp
    <div class="container-xl">
        <!-- Page title -->
        <div class="page-header d-print-none">
            <div class="row align-items-center">
                <div class="col">
                    <!-- Page pre-title -->
                    <div class="page-pretitle">
                        Overview
                    </div>
                    <h2 class="page-title">
                        @yield(('title'))
                    </h2>
                </div>
                <!-- Page title actions -->
                <div class="col-auto ms-auto d-print-none">
                    <div class="btn-list">
                        <a href="{{ route('admin.offer.create') }}" class="btn btn-primary d-none d-sm-inline-block">
                            <!-- Download SVG icon from http://tabler-icons.io/i/plus -->
                            <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"></path><line x1="12" y1="5" x2="12" y2="19"></line><line x1="5" y1="12" x2="19" y2="12"></line></svg>
                            Create Offers
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="page-body">
        <div class="container-xl">
            <div class="col-md-12">
                <form action="">
                    <input type="hidden" name="filter" value="filter">
                    <div class="card">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-4">
                                    <h3 class="form-group">Name/ID</h3>
                                    <div class="input-icon">
                                        <input name="name" type="text"  class="form-control" placeholder="Name…" value="{{ $name ?? old('name') }}">
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <h3 class="form-group">Category</h3>
                                    <select  name="category_id" class="form-select" id="category_id" placeholder="  Select a category...">
                                        @foreach($categories as $category)
                                            <option @isset($category_id) {{ $category_id == $category->id ? 'selected' : ''  }}@endisset value="{{ $category->id }}">{{ $category->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-4">
                                    <h3 class="form-group">Country</h3>
                                    <select multiple name="country_id[]" class="form-select" id="country_id" placeholder="  Select a country...">
                                        @foreach($countries as $country)
                                            <option
                                                @isset($country_id)
                                                @foreach($country_id as $id)
                                                {{ $id == $country->id ? 'selected' : '' }}
                                                @endforeach
                                                @endisset
                                                value="{{ $country->id }}">{{ $country->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <br>
                            <div class="row">
                                <div class="col-md-4">
                                    <h3 class="form-group">Device</h3>
                                    <select multiple name="device_id[]" class="form-select" id="device_id" placeholder="  Select a devices...">
                                        @foreach($devices as $device)
                                            <option
                                                @isset($device_id)
                                                @foreach($device_id as $id)
                                                {{ $id == $device->id ? 'selected' : '' }}
                                                @endforeach
                                                @endisset
                                                value="{{ $device->id }}">{{ $device->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-4">
                                    <h3 class="form-group">Type</h3>
                                    <select  name="type" class="form-select" id="type" placeholder="  Select a type...">
                                        <option value="" >All</option>
                                        <option @isset($type) {{ $type == "offer" ? 'selected' : '' }} @endisset value="offer">Offer</option>
                                        <option @isset($type) {{ $type == "smartlink" ? 'selected' : '' }} @endisset value="smartlink">Smartlink</option>
                                    </select>
                                </div>
                                <div class="col-md-4">
                                    <h3 class="form-group">Status</h3>
                                    <div class="input-icon">
                                        <select  name="status" id="status" class="form-select"  placeholder="  Select a status...">
                                            <option value="" >All</option>
                                            <option @isset($status) {{ $status == "pending" ? 'selected' : '' }} @endisset value="active">Pending</option>
                                            <option @isset($status) {{ $status == "active" ? 'selected' : '' }} @endisset value="pending">Active</option>
                                            <option @isset($status) {{ $status == "requestApproved" ? 'selected' : '' }} @endisset value="requestApproved">ReqestApproved</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card-footer">
                            <div class="row align-items-center">
                                <div  class="col">Affiliate Filter</div>
                                <div class="col-auto">
                                    <button  class="btn btn-primary">
                                        Filter
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
            <br>
            <div class="col-12">
                <div class="card">
                    <div class="table-responsive">
                        <table class="table table-vcenter table-mobile-md card-table">
                            <thead>
                            <tr>
                                <th>Name</th>
                                <th>Advertiser</th>
                                <th>Country</th>
                                <th>Device</th>
                                <th>Type</th>
                                <th>Revenue</th>
                                <th>Payout</th>
                                <th>Conversion Status</th>
                                <th>Daily Cap</th>
                                <th>Expiration Date</th>
                                <th>Category</th>
                                <th>Verticle</th>
                                <th>Action</th>
                            </tr>
                            </thead>
                            <tbody>
                                @foreach($offers as $offer)
                                
                                    <tr>
                                        <td data-label="Basic Info">
                                            <div class="d-flex py-1 align-items-center">
                                               <span class="avatar me-2" style="background-image: url({{ $offer->getFirstMediaUrl('avater') ? $offer->getFirstMediaUrl('avater')  : '' }})"></span>
                                                <div class="flex-fill">
                                                    <div class="font-weight-medium"><a href="{{ route('admin.offer.show',$offer->id) }}">({{ $offer->id }}){{ $offer->name }}</a></div>
                                                    <div class="text-muted">
                                                        <a href="" class="text-reset">
                                                            @if ($offer->status == 'active')
                                                                <span class="badge bg-success">Active</span>
                                                                @elseif ($offer->status == 'requestApproved')
                                                                <span class="badge bg-warning">Request Approved</span>
                                                            @else
                                                                <span class="badge bg-danger">Pending</span>
                                                            @endif
                                                        </a>
                                                    </div>
                                                </div>
                                            </div>
                                        </td>
                                        <td data-label="Advertiser">
                                            <div>{{ $offer->advertiser->name }}</div>
                                        </td>
                                        <td data-label="Countries">
                                            @if (!$offer->countries->isEmpty())
                                                @php $count = 0; @endphp
                                                @foreach ($offer->countries as $country)
                                                    @if ($count < 5)
                                                        <span class="flag flag-country-{{ Str::lower($country->code) }}"></span>
                                                        @php $count++; @endphp
                                                    @else
                                                        @break
                                                    @endif
                                                @endforeach
                                                @if ($offer->countries->count() > 5)
                                                    <span class="badge bg-secondary">+{{ $offer->countries->count() - 5 }} more</span>
                                                @endif
                                            @else
                                                <span class="badge bg-success">Global</span>
                                            @endif
                                        </td>

                                        <td data-label="Devices">
                                            @if (!$offer->devices->isEmpty())
                                                @foreach($offer->devices as $device)
                                                    <i  class="fa fa-{{Str::lower($device->name)}}"></i>
                                                @endforeach
                                            @else
                                                @foreach($devices as $device)
                                                    <i  class="fa fa-{{Str::lower($device->name)}}"></i>
                                                @endforeach
                                            @endif
                                        </td>
                                        <td data-label="Type">
                                            @if ($offer->type == "offer")
                                                <div class="text-muted"><span class="badge bg-success">Offer</span></div>
                                            @else
                                                <div class="text-muted"><span class="badge bg-cyan">Revinue Share</span></div>
                                            @endif
                                        </td>
                                        <td data-label="Revenue">
                                            @if ($offer->type == "offer")
                                                <div class="text-muted"><span class="badge bg-success">${{ $offer->revenue }}</span></div>
                                            @else
                                                <div class="text-muted"><span class="badge bg-cyan">%{{ $offer->revenue }}</span></div>
                                            @endif
                                        </td>
                                        <td data-label="Payout">
                                            @if ($offer->type == "offer")
                                                <div class="text-muted"><span class="badge bg-success">${{ $offer->payout }}</span></div>
                                            @else
                                                <div class="text-muted"><span class="badge bg-cyan">%{{ $offer->payout }}</span></div>
                                            @endif
                                        </td>
                                        <td data-label="Conversion Status">
                                            @if ($offer->conversion_status == false)
                                                <div class="text-muted"><span class="badge bg-danger">Pending</span></div>
                                            @else
                                                <div class="text-muted"><span class="badge bg-success">Approved</span></div>
                                            @endif
                                        </td>
                                        <td data-label="Daily Cap">
                                            <div class="text-muted"><span class="badge bg-success">{{ $offer->daily_cap }}</span></div>
                                        </td>
                                        <td data-label="Expiration Date">
                                            <div class="text-muted"><span class="badge bg-success">{{ $offer->expiration_date }}</span></div>
                                        </td>
                                        <td data-label="Category">
                                            <div class="text-muted"><span class="badge bg-success">{{ $offer->category->name }}</span></div>
                                        </td>
                                         <td data-label="Verticle">
                                            <div class="text-muted"><span class="badge bg-success">{{ optional($offer->verticle)->name }}</span></div>
                                        </td>
                                        <td>
                                            <a href="{{ route('admin.offer.edit',$offer->id) }}" class="btn btn-success btn-sm">
                                                <i class="fa fa-pencil"></i>
                                            </a>
                                            <a href="{{ route('admin.offer.show',$offer->id) }}" class="btn btn-primary btn-sm">
                                                <i class="fa fa-eye"></i>
                                            </a>
                                            <form action="{{ route('admin.offer.destroy', $offer->id) }}" method="POST" onclick="return confirm('are u sure to delete?')">
                                                @method('DELETE')
                                                @csrf
                                                <button class="btn btn-danger btn-sm">
                                                    <i class="fa fa-trash"></i>
                                                </button>
                                            </form>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                       <div style="margin: 0 auto;float: right">
                           {{$offers->withQueryString()->links() }}
                       </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('js')
    <script src="https://cdn.jsdelivr.net/npm/tom-select@2.0.1/dist/js/tom-select.complete.min.js"></script>
    <script>
        new TomSelect('#category_id',{
            plugins: ['input_autogrow'],
        });
        new TomSelect('#country_id',{
            plugins: ['input_autogrow'],
        });
        new TomSelect('#type',{
            plugins: ['input_autogrow'],
        });
        new TomSelect('#status',{
            plugins: ['input_autogrow'],
        });
        new TomSelect('#device_id',{
            plugins: ['input_autogrow'],
        });


    </script>
@endpush
