@extends('layouts.backend.admin_sash')

@section('title', $offer->name)

@push('css')
    <link href="https://cdn.jsdelivr.net/npm/tom-select@2.0.1/dist/css/tom-select.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/tom-select@2.0.1/dist/css/tom-select.bootstrap5.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.css" rel="stylesheet">
    <link href="{{ asset('backend/dist/css/tabler-flags.min.css') }}" rel="stylesheet" />
     <style>
        tr {
            font-weight: bold;
        }
        #short_url{
            display: none;
        }
            /* Absolute Center Spinner */
        .loading {
            position: fixed;
            z-index: 999;
            height: 2em;
            width: 2em;
            overflow: visible;
            margin: auto;
            top: 0;
            left: 0;
            bottom: 0;
            right: 0;
        }

        /* Transparent Overlay */
        .loading:before {
            content: '';
            display: block;
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0,0,0,0.3);
        }

        /* :not(:required) hides these rules from IE9 and below */
        .loading:not(:required) {
            /* hide "loading..." text */
            font: 0/0 a;
            color: transparent;
            text-shadow: none;
            background-color: transparent;
            border: 0;
        }

        .loading:not(:required):after {
            content: '';
            display: block;
            font-size: 10px;
            width: 1em;
            height: 1em;
            margin-top: -0.5em;
            -webkit-animation: spinner 1500ms infinite linear;
            -moz-animation: spinner 1500ms infinite linear;
            -ms-animation: spinner 1500ms infinite linear;
            -o-animation: spinner 1500ms infinite linear;
            animation: spinner 1500ms infinite linear;
            border-radius: 0.5em;
            -webkit-box-shadow: rgba(0, 0, 0, 0.75) 1.5em 0 0 0, rgba(0, 0, 0, 0.75) 1.1em 1.1em 0 0, rgba(0, 0, 0, 0.75) 0 1.5em 0 0, rgba(0, 0, 0, 0.75) -1.1em 1.1em 0 0, rgba(0, 0, 0, 0.5) -1.5em 0 0 0, rgba(0, 0, 0, 0.5) -1.1em -1.1em 0 0, rgba(0, 0, 0, 0.75) 0 -1.5em 0 0, rgba(0, 0, 0, 0.75) 1.1em -1.1em 0 0;
            box-shadow: rgba(0, 0, 0, 0.75) 1.5em 0 0 0, rgba(0, 0, 0, 0.75) 1.1em 1.1em 0 0, rgba(0, 0, 0, 0.75) 0 1.5em 0 0, rgba(0, 0, 0, 0.75) -1.1em 1.1em 0 0, rgba(0, 0, 0, 0.75) -1.5em 0 0 0, rgba(0, 0, 0, 0.75) -1.1em -1.1em 0 0, rgba(0, 0, 0, 0.75) 0 -1.5em 0 0, rgba(0, 0, 0, 0.75) 1.1em -1.1em 0 0;
        }

        /* Animation */

        @-webkit-keyframes spinner {
            0% {
                -webkit-transform: rotate(0deg);
                -moz-transform: rotate(0deg);
                -ms-transform: rotate(0deg);
                -o-transform: rotate(0deg);
                transform: rotate(0deg);
            }
            100% {
                -webkit-transform: rotate(360deg);
                -moz-transform: rotate(360deg);
                -ms-transform: rotate(360deg);
                -o-transform: rotate(360deg);
                transform: rotate(360deg);
            }
        }
        @-moz-keyframes spinner {
            0% {
                -webkit-transform: rotate(0deg);
                -moz-transform: rotate(0deg);
                -ms-transform: rotate(0deg);
                -o-transform: rotate(0deg);
                transform: rotate(0deg);
            }
            100% {
                -webkit-transform: rotate(360deg);
                -moz-transform: rotate(360deg);
                -ms-transform: rotate(360deg);
                -o-transform: rotate(360deg);
                transform: rotate(360deg);
            }
        }
        @-o-keyframes spinner {
            0% {
                -webkit-transform: rotate(0deg);
                -moz-transform: rotate(0deg);
                -ms-transform: rotate(0deg);
                -o-transform: rotate(0deg);
                transform: rotate(0deg);
            }
            100% {
                -webkit-transform: rotate(360deg);
                -moz-transform: rotate(360deg);
                -ms-transform: rotate(360deg);
                -o-transform: rotate(360deg);
                transform: rotate(360deg);
            }
        }
        @keyframes spinner {
            0% {
                -webkit-transform: rotate(0deg);
                -moz-transform: rotate(0deg);
                -ms-transform: rotate(0deg);
                -o-transform: rotate(0deg);
                transform: rotate(0deg);
            }
            100% {
                -webkit-transform: rotate(360deg);
                -moz-transform: rotate(360deg);
                -ms-transform: rotate(360deg);
                -o-transform: rotate(360deg);
                transform: rotate(360deg);
            }
        }
    #loading{
        display: none;
    }
    </style>
@endpush

@section('content')
  <div class="loading" id="loading">Loading&#8230;</div>
    <div class="container-xl">
        <!-- Page title -->
        <div class="page-header d-print-none">
            <div class="row align-items-center">
                <div class="col">
                    <!-- Page pre-title -->
                    <div class="page-pretitle">
                        Overview
                    </div>
                    <h2 class="page-title">
                        @yield(('title'))
                    </h2>
                </div>
                <!-- Page title actions -->
                <div class="col-auto ms-auto d-print-none">
                    <div class="btn-list">
                        <a href="{{ route('admin.offer.index') }}" class="btn btn-primary d-none d-sm-inline-block">
                            <!-- Download SVG icon from http://tabler-icons.io/i/plus -->
                            <i class="fa fa-backward" aria-hidden="true"></i>
                            Back
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="page-body">
        <div class="container-xl">
            <div class="row row-cards">
                <div class="col-lg-8">
                    <div class="card card-lg">
                        <div class="card-body">
                            <div class="markdown">
                                <h3 id="tabler-free-license">{{ $offer->name }}</h3>
                                <h4>Discription</h4>
                                <p>{!! $offer->description !!}</p>
                                <br>
                                <br>
                                <h3 id="tabler-pro-and-tabler-email-license">Traking Link</h3>
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label for="affiliate">Affiliate</label>
                                        <br>
                                        <select name="affiliate" id="affiliate" class="form-select">
                                            <option selected disabled>Select Affiliate</option>
                                            @foreach ($affiliates as $affiliate)
                                                <option value="{{ $affiliate->id }}">({{ $affiliate->id }})
                                                    {{ $affiliate->first_name }} {{ $affiliate->last_name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <br>
                                    <div class="form-group">
                                        <!-- Target -->
                                        <input id="link" class="form-control">
                                        <button class="btn" data-clipboard-target="#link" style="margin-top: 1%">
                                            <img src="https://clipboardjs.com/assets/images/clippy.svg" width="13"
                                                alt="Copy to clipboard">
                                        </button>
                                         <br>
                                        <br>
                                        <label for="short_click"><strong>Short Url</strong></label>
                                        <input type="checkbox" name="short_click" id="short_click">
                                        <br>
                                        <br>
                                        <input type="text" class="form-control" id="short_url">
                                    </div>
                                    <br>
                                    <div class="form-group">
                                        <div class="row">
                                            <div class="col-md-3">
                                                <label for="aff_click_id">Aff Click Id</label>
                                                <input type="text" class="form-control" id="aff_click_id"
                                                    placeholder="Unique Click Id">
                                            </div>
                                            <div class="col-md-3">
                                                <label for="aff_sub_1">Aff Sub 1</label>
                                                <input type="text" class="form-control" id="aff_sub_1"
                                                    placeholder="aff_sub_1">
                                            </div>
                                            <div class="col-md-3">
                                                <label for="aff_sub_2">Aff Sub 2</label>
                                                <input type="text" class="form-control" id="aff_sub_2"
                                                    placeholder="aff_sub_2">
                                            </div>
                                            <div class="col-md-3">
                                                <label for="aff_sub_3">Aff Sub 3</label>
                                                <input type="text" class="form-control" id="aff_sub_3"
                                                    placeholder="aff_sub_3">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="card">
                        <div class="card-body">
                            <div class="d-flex align-items-center mb-3">
                                <div class="me-3">
                                    <div>
                                        <h3 class="lh-1">Payouts and Goal</h3>
                                    </div>
                                    <a href="{{ route('admin.payout.index', $offer->id) }}"
                                        class="btn btn-primary btn-sm">
                                        <i class="fa fa-pencil"></i>
                                        <span>Advance</span>
                                    </a>
                                </div>

                            </div>
                            <h4>Allow Countries</h4>
                            <ul class="list-unstyled space-y-1">
                                @if (!$offer->countries->isEmpty())
                                    @foreach ($offer->countries as $country)
                                        <span class="flag flag-country-{{ Str::lower($country->code) }}"></span>
                                    @endforeach
                                @endif
                            </ul>
                            <h4>Allow Devices</h4>
                            <ul class="list-unstyled space-y-1">
                                @if (!$offer->devices->isEmpty())
                                    @foreach ($offer->devices as $device)
                                        <i style="width:30px;" class="fa fa-{{ Str::lower($device->name) }}"></i>
                                    @endforeach
                                @endif
                            </ul>
                            <h4>Daily Cap</h4>
                            <ul class="list-unstyled space-y-1">
                                <span class="badge bg-success">{{ $offer->daily_cap }}</span>
                            </ul>
                            <h4>Payouts</h4>
                            @if ($offer->type == 'offer')
                                @if (!$offer->countryPayouts->isEmpty())
                                    @foreach ($offer->countryPayouts as $payout)
                                        @if (!$payout->devices->isEmpty())
                                            @foreach ($payout->devices as $device)
                                                <ul class="list-unstyled space-y-1">
                                                    <li>
                                                        <!-- Download SVG icon from http://tabler-icons.io/i/x -->
                                                        <span
                                                            class="flag flag-country-{{ Str::lower($device->countryPayout->country->code) }}"></span>
                                                        <i style="width:30px;"
                                                            class="fa fa-{{ Str::lower($device->device->name) }}"></i>
                                                        <span class="badge bg-success">{{ $device->device->name }}</span>
                                                        <span class="badge bg-success">${{ $device->payout }}</span>
                                                    </li>
                                                </ul>
                                            @endforeach
                                        @else
                                            <span
                                                class="flag flag-country-{{ Str::lower($payout->country->code) }}"></span>
                                            <span class="badge bg-success">{{ $payout->country->code }}</span>
                                            <span class="badge bg-success">${{ $payout->payout }}</span>
                                            <br>
                                            <br>
                                        @endif
                                    @endforeach
                                @else
                                    <span class="badge bg-success">${{ $offer->payout }}</span>
                                @endif
                            @else
                                <span class="badge bg-success">Revenue Share</span>
                            @endif

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('js')
    <script src="https://cdn.jsdelivr.net/npm/tom-select@2.0.1/dist/js/tom-select.complete.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"
        integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous"></script>
    <script src="https://cdn.jsdelivr.net/npm/clipboard@2.0.10/dist/clipboard.min.js"></script>
    <script>
        new TomSelect('#affiliate', {
            plugins: ['input_autogrow'],
        });
        new TomSelect('#country_id', {
            plugins: ['input_autogrow'],
        });
        new TomSelect('#type', {
            plugins: ['input_autogrow'],
        });
        new TomSelect('#status', {
            plugins: ['input_autogrow'],
        });
        new TomSelect('#device_id', {
            plugins: ['input_autogrow'],
        });
    </script>
    <script>
        //traking link

        var affiliate = '';
        var domain = '{{ setting('tracking_domain') }}';
        var aff_click_id = '';
        var aff_sub_1 = '';
        var aff_sub_2 = '';
        var aff_sub_3 = '';
        var offer_id = '';

        jQuery(document).ready(function($) {
            offer_id = '&offer_id={{ $offer->id }}';
        });


        jQuery('#affiliate').on('change', function($) {

            affiliate = jQuery(this).val();


            affiliate = affiliate == '' ? '' : '/redirect?aff_id=' + affiliate;


            jQuery('input#link').val(domain + affiliate + offer_id + aff_click_id + aff_sub_1 + aff_sub_2 +
                aff_sub_3);

        });


        jQuery('#domain').on('change', function($) {

            domain = jQuery(this).val();


            jQuery('input#link').val(domain + affiliate + offer_id + aff_sub_1 + aff_sub_2 + aff_sub_3);

        });

        jQuery('#aff_click_id').on('keyup', function($) {

            aff_click_id = jQuery(this).val();


            aff_click_id = aff_click_id == '' ? '' : '&aff_click_id=' + aff_click_id;


            jQuery('input#link').val(domain + affiliate + offer_id + aff_click_id + aff_sub_1 + aff_sub_2 +
                aff_sub_3);

        });
        jQuery('#aff_sub_1').on('keyup', function($) {

            aff_sub_1 = jQuery(this).val();


            aff_sub_1 = aff_sub_1 == '' ? '' : '&aff_sub_1=' + aff_sub_1;


            jQuery('input#link').val(domain + affiliate + offer_id + aff_click_id + aff_sub_1 + aff_sub_2 +
                aff_sub_3);

        });


        jQuery('#aff_sub_2').on('keyup', function($) {

            aff_sub_2 = jQuery(this).val();


            aff_sub_2 = aff_sub_2 == '' ? '' : '&aff_sub_2=' + aff_sub_2;


            jQuery('input#link').val(domain + affiliate + offer_id + aff_click_id + aff_sub_1 + aff_sub_2 +
                aff_sub_3);

        });


        jQuery('#aff_sub_3').on('keyup', function($) {

            aff_sub_3 = jQuery(this).val();


            aff_sub_3 = aff_sub_3 == '' ? '' : '&aff_sub_3=' + aff_sub_3;


            jQuery('input#link').val(domain + affiliate + offer_id + aff_click_id + aff_sub_1 + aff_sub_2 +
                aff_sub_3);

        });

        $(function() {
            $("#subid").on("click", function() {
                $(".subid").toggle(this.checked);
            });
        });
        new ClipboardJS('.btn');
        
        $(function() {
            $("#short_click").on("click", function() {
                $("#loading").show();
                const link = 'https://shtr.me/api/shorturl';
                const url = $('#link').val();

                //base condition

                if(url == ''){
                    $("#loading").hide();
                    alert('Select Affiliate First');
                    return false;
                }
                if ($(this).is(":checked")) {
                    $.ajax({
                        type: "POST",
                        url: link,
                        dataType:"json",
                        data: {
                            url: url
                        },
                        success: function(response){
                            $("#loading").hide();
                            $("#short_url").show();
                            $("#short_url").val(response.short_url);
                            $(':checkbox').prop('checked', false).removeAttr('checked');
                        }
                    });
                }
            });
        });
    </script>
@endpush
