@extends('layouts.backend.admin_sash')

@section('title','Advance Payouts '.$offer->name)

@push('css')
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.css" rel="stylesheet">
@endpush

@section('content')
    <div class="container-xl">
        <!-- Page title -->
        <div class="page-header d-print-none">
            <div class="row align-items-center">
                <div class="col">
                    <!-- Page pre-title -->
                    <div class="page-pretitle">
                        Overview
                    </div>
                    <h2 class="page-title">
                        @yield(('title'))
                    </h2>
                </div>
                <!-- Page title actions -->
                <div class="col-auto ms-auto d-print-none">
                    <div class="btn-list">
                        <a href="{{ route('admin.offer.show',$offer->id) }}" class="btn btn-primary d-none d-sm-inline-block">
                            <!-- Download SVG icon from http://tabler-icons.io/i/plus -->
                            <i class="fa fa-backward" aria-hidden="true"></i>
                            Back
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="page-body">
        <div class="container-xl">
            <div class="row row-cards">
                <div class="col-md-4">
                    <div class="card">
                        <ul class="nav nav-tabs" data-bs-toggle="tabs">
                            <li class="nav-item">
                                <a href="#tabs-home-7" class="nav-link active" data-bs-toggle="tab">Country Payouts</a>
                            </li>
                            <li class="nav-item ms-auto">
                                <a href="{{ route('admin.payout.country',$offer->id) }}" class="nav-link" title="Settings">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"></path><path d="M10.325 4.317c.426 -1.756 2.924 -1.756 3.35 0a1.724 1.724 0 0 0 2.573 1.066c1.543 -.94 3.31 .826 2.37 2.37a1.724 1.724 0 0 0 1.065 2.572c1.756 .426 1.756 2.924 0 3.35a1.724 1.724 0 0 0 -1.066 2.573c.94 1.543 -.826 3.31 -2.37 2.37a1.724 1.724 0 0 0 -2.572 1.065c-.426 1.756 -2.924 1.756 -3.35 0a1.724 1.724 0 0 0 -2.573 -1.066c-1.543 .94 -3.31 -.826 -2.37 -2.37a1.724 1.724 0 0 0 -1.065 -2.572c-1.756 -.426 -1.756 -2.924 0 -3.35a1.724 1.724 0 0 0 1.066 -2.573c-.94 -1.543 .826 -3.31 2.37 -2.37c1 .608 2.296 .07 2.572 -1.065z"></path><circle cx="12" cy="12" r="3"></circle></svg>
                                </a>
                            </li>
                        </ul>
                        <div class="card-body">
                            <div class="tab-content">
                                <div class="tab-pane show active" id="tabs-home-7">
                                    <table class="table table-responsive">
                                        <thead>
                                            <tr>
                                                <th>Country</th>
                                                <th>Revenue</th>
                                                <th>Payout</th>
                                                <th>Action</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                        @foreach($offer->countryPayouts as $payout)
                                            <tr>
                                                <td title="{{ $payout->country->name }}"><span class="flag flag-country-{{Str::lower($payout->country->code)}}"></span></td>
                                                <td><span class="badge bg-success">{{ $payout->revenue }}</span></td>
                                                <td><span class="badge bg-success">{{ $payout->payout }}</span></td>
                                                <td>
                                                    <a onclick="return confirm('are u sure to delete?')" href="{{ route('admin.payout.country.delete',$payout->id) }}" class="btn btn-danger btn-sm">
                                                        <i class="fa fa-trash"></i>
                                                    </a>
                                                </td>
                                            </tr>
                                        @endforeach
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-8">
                    <div class="card">
                        <ul class="nav nav-tabs" data-bs-toggle="tabs">
                            <li class="nav-item">
                                <a href="#tabs-home-7" class="nav-link active" data-bs-toggle="tab">Device Payouts</a>
                            </li>
                            <li class="nav-item ms-auto">
                                <a href="{{ route('admin.payout.device',$offer->id) }}" class="nav-link" title="Settings">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"></path><path d="M10.325 4.317c.426 -1.756 2.924 -1.756 3.35 0a1.724 1.724 0 0 0 2.573 1.066c1.543 -.94 3.31 .826 2.37 2.37a1.724 1.724 0 0 0 1.065 2.572c1.756 .426 1.756 2.924 0 3.35a1.724 1.724 0 0 0 -1.066 2.573c.94 1.543 -.826 3.31 -2.37 2.37a1.724 1.724 0 0 0 -2.572 1.065c-.426 1.756 -2.924 1.756 -3.35 0a1.724 1.724 0 0 0 -2.573 -1.066c-1.543 .94 -3.31 -.826 -2.37 -2.37a1.724 1.724 0 0 0 -1.065 -2.572c-1.756 -.426 -1.756 -2.924 0 -3.35a1.724 1.724 0 0 0 1.066 -2.573c-.94 -1.543 .826 -3.31 2.37 -2.37c1 .608 2.296 .07 2.572 -1.065z"></path><circle cx="12" cy="12" r="3"></circle></svg>
                                </a>
                            </li>
                        </ul>
                        <div class="card-body">
                            <div class="tab-content">
                                <div class="tab-pane show active" id="tabs-home-7">
                                    <table class="table table-responsive">
                                        <thead>
                                        <tr>
                                            <th>Country</th>
                                            <th>Device</th>
                                            <th>Revenue</th>
                                            <th>Payout</th>
                                            <th>Action</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        @foreach($offer->countryPayouts as $payout)
                                            @foreach($payout->devices as $device)
                                                <tr>
                                                    <td title="{{ $device->countryPayout->country->name }}"><span class="flag flag-country-{{Str::lower($device->countryPayout->country->code)}}"></span></td>
                                                    <td title="{{ $device->device->name }}"><i class="fa fa-{{Str::lower($device->device->name)}}"></i></td>
                                                    <td><span class="badge bg-success">{{ $device->revenue }}</span></td>
                                                    <td><span class="badge bg-success">{{ $device->payout }}</span></td>
                                                    <td>
                                                        <a onclick="return confirm('are u sure to delete?')" href="{{ route('admin.payout.device.delete',$device->id) }}" class="btn btn-danger btn-sm">
                                                            <i class="fa fa-trash"></i>
                                                        </a>
                                                    </td>
                                                </tr>
                                        @endforeach
                                        @endforeach
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="card">
                        <ul class="nav nav-tabs" data-bs-toggle="tabs">
                            <li class="nav-item">
                                <a href="#tabs-home-7" class="nav-link active" data-bs-toggle="tab">Coustom Affiliate Caping</a>
                            </li>
                            <li class="nav-item ms-auto">
                                <a href="{{ route('admin.payout.coustom.cap',$offer->id) }}" class="nav-link" title="Settings">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"></path><path d="M10.325 4.317c.426 -1.756 2.924 -1.756 3.35 0a1.724 1.724 0 0 0 2.573 1.066c1.543 -.94 3.31 .826 2.37 2.37a1.724 1.724 0 0 0 1.065 2.572c1.756 .426 1.756 2.924 0 3.35a1.724 1.724 0 0 0 -1.066 2.573c.94 1.543 -.826 3.31 -2.37 2.37a1.724 1.724 0 0 0 -2.572 1.065c-.426 1.756 -2.924 1.756 -3.35 0a1.724 1.724 0 0 0 -2.573 -1.066c-1.543 .94 -3.31 -.826 -2.37 -2.37a1.724 1.724 0 0 0 -1.065 -2.572c-1.756 -.426 -1.756 -2.924 0 -3.35a1.724 1.724 0 0 0 1.066 -2.573c-.94 -1.543 .826 -3.31 2.37 -2.37c1 .608 2.296 .07 2.572 -1.065z"></path><circle cx="12" cy="12" r="3"></circle></svg>
                                </a>
                            </li>
                        </ul>
                        <div class="card-body">
                            <div class="tab-content">
                                <div class="tab-pane show active" id="tabs-home-7">
                                    <table class="table table-responsive">
                                        <thead>
                                        <tr>
                                            <th>Affiliate</th>
                                            <th>Daily Cap</th>
                                            <th>Action</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        @foreach($offer->caps as $cap)
                                            <tr>
                                                <td>({{ $cap->user_id }}){{ $cap->user->first_name }} {{ $cap->user->last_name }}</td>
                                                <td><span class="badge bg-success">{{ $cap->cap }}</span></td>
                                                <td>
                                                    <a onclick="return confirm('are u sure to delete?')" href="{{ route('admin.payout.coustom.cap.delete',$cap->id) }}" class="btn btn-danger btn-sm">
                                                        <i class="fa fa-trash"></i>
                                                    </a>
                                                </td>
                                            </tr>
                                        @endforeach
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-8">
                    <div class="card">
                        <ul class="nav nav-tabs" data-bs-toggle="tabs">
                            <li class="nav-item">
                                <a href="#tabs-home-7" class="nav-link active" data-bs-toggle="tab">Coustom Affiliate Payouts</a>
                            </li>
                            <li class="nav-item ms-auto">
                                <a href="{{ route('admin.payout.coustom',$offer->id) }}" class="nav-link" title="Settings">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"></path><path d="M10.325 4.317c.426 -1.756 2.924 -1.756 3.35 0a1.724 1.724 0 0 0 2.573 1.066c1.543 -.94 3.31 .826 2.37 2.37a1.724 1.724 0 0 0 1.065 2.572c1.756 .426 1.756 2.924 0 3.35a1.724 1.724 0 0 0 -1.066 2.573c.94 1.543 -.826 3.31 -2.37 2.37a1.724 1.724 0 0 0 -2.572 1.065c-.426 1.756 -2.924 1.756 -3.35 0a1.724 1.724 0 0 0 -2.573 -1.066c-1.543 .94 -3.31 -.826 -2.37 -2.37a1.724 1.724 0 0 0 -1.065 -2.572c-1.756 -.426 -1.756 -2.924 0 -3.35a1.724 1.724 0 0 0 1.066 -2.573c-.94 -1.543 .826 -3.31 2.37 -2.37c1 .608 2.296 .07 2.572 -1.065z"></path><circle cx="12" cy="12" r="3"></circle></svg>
                                </a>
                            </li>
                        </ul>
                        <div class="card-body">
                            <div class="tab-content">
                                <div class="tab-pane show active" id="tabs-home-7">
                                    <table class="table table-responsive">
                                        <thead>
                                        <tr>
                                            <th>Affiliate</th>
                                            <th>Revenue</th>
                                            <th>Payout</th>
                                            <th>Action</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        @foreach($offer->coustomPayouts as $payout)
                                            <tr>
                                                <td>({{ $payout->user_id }}) {{ $payout->user->first_name }} {{ $payout->user->last_name }}</td>
                                                <td><span class="badge bg-success">{{ $payout->revenue }}</span></td>
                                                <td><span class="badge bg-success">{{ $payout->payout }}</span></td>
                                                <td>
                                                    <a onclick="return confirm('are u sure to delete?')" href="{{ route('admin.payout.coustom.delete',$payout->id) }}" class="btn btn-danger btn-sm">
                                                        <i class="fa fa-trash"></i>
                                                    </a>
                                                </td>
                                            </tr>
                                        @endforeach
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="card">
                        <ul class="nav nav-tabs" data-bs-toggle="tabs">
                            <li class="nav-item">
                                <a href="#tabs-home-7" class="nav-link active" data-bs-toggle="tab">Coustom Country Payouts</a>
                            </li>
                            <li class="nav-item ms-auto">
                                <a href="{{ route('admin.payout.coustom.country',$offer->id) }}" class="nav-link" title="Settings">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"></path><path d="M10.325 4.317c.426 -1.756 2.924 -1.756 3.35 0a1.724 1.724 0 0 0 2.573 1.066c1.543 -.94 3.31 .826 2.37 2.37a1.724 1.724 0 0 0 1.065 2.572c1.756 .426 1.756 2.924 0 3.35a1.724 1.724 0 0 0 -1.066 2.573c.94 1.543 -.826 3.31 -2.37 2.37a1.724 1.724 0 0 0 -2.572 1.065c-.426 1.756 -2.924 1.756 -3.35 0a1.724 1.724 0 0 0 -2.573 -1.066c-1.543 .94 -3.31 -.826 -2.37 -2.37a1.724 1.724 0 0 0 -1.065 -2.572c-1.756 -.426 -1.756 -2.924 0 -3.35a1.724 1.724 0 0 0 1.066 -2.573c-.94 -1.543 .826 -3.31 2.37 -2.37c1 .608 2.296 .07 2.572 -1.065z"></path><circle cx="12" cy="12" r="3"></circle></svg>
                                </a>
                            </li>
                        </ul>
                        <div class="card-body">
                            <div class="tab-content">
                                <div class="tab-pane show active" id="tabs-home-7">
                                    <table class="table table-responsive">
                                        <thead>
                                        <tr>
                                            <th>Affiliate</th>
                                            <th>Country</th>
                                            <th>Revenue</th>
                                            <th>Payout</th>
                                            <th>Action</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        @foreach($offer->coustomCountryPayouts as $payout)
                                            <tr>
                                                <td><span class="badge bg-success">({{ $payout->user_id }}) {{ $payout->user->first_name }} {{ $payout->last_name }}</span></td>
                                                <td title="{{ $payout->country->name }}"><span class="flag flag-country-{{Str::lower($payout->country->code)}}"></span></td>
                                                <td><span class="badge bg-success">{{ $payout->revenue }}</span></td>
                                                <td><span class="badge bg-success">{{ $payout->payout }}</span></td>
                                                <td>
                                                    <a onclick="return confirm('are u sure to delete?')" href="{{ route('admin.payout.coustom.country.delete',$payout->id) }}" class="btn btn-danger btn-sm">
                                                        <i class="fa fa-trash"></i>
                                                    </a>
                                                </td>
                                            </tr>
                                        @endforeach
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-8">
                    <div class="card">
                        <ul class="nav nav-tabs" data-bs-toggle="tabs">
                            <li class="nav-item">
                                <a href="#tabs-home-7" class="nav-link active" data-bs-toggle="tab">Coustom Country Device Payouts</a>
                            </li>
                            <li class="nav-item ms-auto">
                                <a href="{{ route('admin.payout.coustom.device',$offer->id) }}" class="nav-link" title="Settings">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"></path><path d="M10.325 4.317c.426 -1.756 2.924 -1.756 3.35 0a1.724 1.724 0 0 0 2.573 1.066c1.543 -.94 3.31 .826 2.37 2.37a1.724 1.724 0 0 0 1.065 2.572c1.756 .426 1.756 2.924 0 3.35a1.724 1.724 0 0 0 -1.066 2.573c.94 1.543 -.826 3.31 -2.37 2.37a1.724 1.724 0 0 0 -2.572 1.065c-.426 1.756 -2.924 1.756 -3.35 0a1.724 1.724 0 0 0 -2.573 -1.066c-1.543 .94 -3.31 -.826 -2.37 -2.37a1.724 1.724 0 0 0 -1.065 -2.572c-1.756 -.426 -1.756 -2.924 0 -3.35a1.724 1.724 0 0 0 1.066 -2.573c-.94 -1.543 .826 -3.31 2.37 -2.37c1 .608 2.296 .07 2.572 -1.065z"></path><circle cx="12" cy="12" r="3"></circle></svg>
                                </a>
                            </li>
                        </ul>
                        <div class="card-body">
                            <div class="tab-content">
                                <div class="tab-pane show active" id="tabs-home-7">
                                    <table class="table table-responsive">
                                        <thead>
                                        <tr>
                                            <th>Affiliate</th>
                                            <th>Country</th>
                                            <th>Device</th>
                                            <th>Revenue</th>
                                            <th>Payout</th>
                                            <th>Action</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        @foreach($offer->coustomCountryPayouts as $payout)
                                            @foreach($payout->devices as $device)
                                                <tr>
                                                    <td>({{ $device->country->user_id }}) {{ $device->country->user->first_name }} {{ $device->country->user->last_name }}</td>
                                                    <td title="{{ $device->country->country->name }}"><span class="flag flag-country-{{Str::lower($device->country->country->code)}}"></span></td>
                                                    <td title="{{ $device->device->name }}"><i class="fa fa-{{Str::lower($device->device->name)}}"></i></td>
                                                    <td><span class="badge bg-success">{{ $device->revenue }}</span></td>
                                                    <td><span class="badge bg-success">{{ $device->payout }}</span></td>
                                                    <td>
                                                        <a onclick="return confirm('are u sure to delete?')" href="{{ route('admin.payout.coustom.device.delete',$device->id) }}" class="btn btn-danger btn-sm">
                                                            <i class="fa fa-trash"></i>
                                                        </a>
                                                    </td>
                                                </tr>
                                        @endforeach
                                        @endforeach
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                 <div class="col-md-8">
                    <div class="card">
                        <ul class="nav nav-tabs" data-bs-toggle="tabs">
                            <li class="nav-item">
                                <a href="#tabs-home-7" class="nav-link active" data-bs-toggle="tab">Conversion Optimize</a>
                            </li>
                            <li class="nav-item ms-auto">
                                <a href="#" data-bs-toggle="modal" class="nav-link" title="Settings" data-bs-target="#modal-team">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"></path><path d="M10.325 4.317c.426 -1.756 2.924 -1.756 3.35 0a1.724 1.724 0 0 0 2.573 1.066c1.543 -.94 3.31 .826 2.37 2.37a1.724 1.724 0 0 0 1.065 2.572c1.756 .426 1.756 2.924 0 3.35a1.724 1.724 0 0 0 -1.066 2.573c.94 1.543 -.826 3.31 -2.37 2.37a1.724 1.724 0 0 0 -2.572 1.065c-.426 1.756 -2.924 1.756 -3.35 0a1.724 1.724 0 0 0 -2.573 -1.066c-1.543 .94 -3.31 -.826 -2.37 -2.37a1.724 1.724 0 0 0 -1.065 -2.572c-1.756 -.426 -1.756 -2.924 0 -3.35a1.724 1.724 0 0 0 1.066 -2.573c-.94 -1.543 .826 -3.31 2.37 -2.37c1 .608 2.296 .07 2.572 -1.065z"></path><circle cx="12" cy="12" r="3"></circle></svg>
                                </a>
                            </li>
                        </ul>
                        <div class="card-body">
                            <div class="tab-content">
                                <div class="tab-pane show active" id="tabs-home-7">
                                    <table class="table table-responsive">
                                        <thead>
                                        <tr>
                                            <th>Offer ID</th>
                                            <th>Offer Name</th>
                                            <th>Optimize Value</th>
                                            <th>Action</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        @if ($offer->optimize)
                                            <tr>
                                                <td>{{ $offer->id }}</td>
                                                <td>{{ $offer->name }}</td>
                                                <td>{{ $offer->optimize->percentage }}0%</td>
                                                <td>
                                                    <a onclick="return confirm('are u sure to delete?')" href="{{ route('admin.payout.optimize.delete',$offer->optimize->id) }}" class="btn btn-danger btn-sm">
                                                        <i class="fa fa-trash"></i>
                                                    </a>
                                                </td>
                                            </tr>
                                        @endif
                                    </table>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </div>
    {{--    models--}}

    <div class="modal modal-blur fade" id="modal-team" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Add a new team</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form action="{{ route('admin.payout.optimize') }}" method="post">
                    @csrf
                    <input type="hidden" name="offer_id" value="{{ $offer->id }}">
                    <div class="modal-body">
                        <div>
                            <label class="form-label">Ratio</label>
                            <select name="percentage" id="optimizes" class="form-control" required>
                                <option selected disabled>Select Conversion Ratio</option>
                                <option value="1">10% Auto Hide</option>
                                <option value="2">20% Auto Hide</option>
                                <option value="3">30% Auto Hide</option>
                                <option value="4">40% Auto Hide</option>
                                <option value="5">50% Auto Hide</option>
                                <option value="6">60% Auto Hide</option>
                            </select>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn me-auto" data-bs-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary">Add Ratio</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection

@push('js')
@endpush
