@extends('layouts.backend.admin_sash')

@section('title','Aff Sub 2 Reports')

@push('css')
    <link href="https://cdn.jsdelivr.net/npm/tom-select@2.0.1/dist/css/tom-select.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/tom-select@2.0.1/dist/css/tom-select.bootstrap5.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.css" rel="stylesheet">
    <link href="{{ asset('backend/dist/css/tabler-flags.min.css')}}" rel="stylesheet"/>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js" integrity="sha512-894YE6QWD5I59HgZOGReFYm4dnWc1Qt5NtvYSaNcOP+u1T9qYdvdihz0PPSiiqn/+/3e7Jo4EaG7TubfWGUrMQ==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
    <link rel="stylesheet" href="{{ asset('backend/date/bootstrap3-wysihtml5.min.css') }}">
    <link rel="stylesheet" href="{{ asset('backend/date/bootstrap-datepicker.min.css') }}">
    <link rel="stylesheet" href="{{ asset('backend/date/daterangepicker.css') }}">
    <style>
        .total{
            font-weight: bold;
        }
    </style>
@endpush

@section('content')
    @php
      $user_id = request('user_id');
      $offer_id = request('offer_id');
      $country_id = request('country_id');
    $advertiser_id = request('advertiser_id');
    @endphp
    <div class="container-xl">
        <!-- Page title -->
        <div class="page-header d-print-none">
            <div class="row align-items-center">
                <div class="col">
                    <!-- Page pre-title -->
                    <div class="page-pretitle">
                        Overview
                    </div>
                    <h2 class="page-title">
                        @yield(('title'))
                    </h2>
                </div>
                <!-- Page title actions -->
            </div>
        </div>
    </div>
    <div class="page-body">
        <div class="container-xl">
            <div class="col-md-12">
                <form action="">
                    <input type="hidden" name="filter" value="filter">
                    <div class="card">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-2">
                                    <h3 class="form-group">Affiliate</h3>
                                    <div class="input-icon">
                                        <select multiple name="user_id[]" id="user_id" class="form-select" placeholder="Select Affiliate">
                                            @foreach($users as $user)
                                                <option
                                                    @isset($user_id)
                                                        @foreach($user_id as $id)
                                                           {{ $id == $user->id ? 'selected' : '' }}
                                                         @endforeach
                                                    @endisset
                                                    value="{{ $user->id }}">{{ $user->first_name . $user->last_name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <h3 class="form-group">Offers</h3>
                                    <div class="input-icon">
                                        <select multiple name="offer_id[]" id="offer_id" class="form-select" placeholder="Select Offers">
                                            @foreach($offers as $offer)
                                                <option
                                                    @isset($offer_id)
                                                        @foreach($offer_id as $id)
                                                        {{ $id == $offer->id ? 'selected' : '' }}
                                                        @endforeach
                                                    @endisset
                                                    value="{{ $offer->id }}">{{ $offer->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <h3 class="form-group">Countries</h3>
                                    <div class="input-icon">
                                        <select multiple name="country_id[]" id="country_id" class="form-select" placeholder="Select Country">
                                            @foreach($countries as $country)
                                                <option
                                                    @isset($country_id)
                                                        @foreach($country_id as $id)
                                                          {{ $id == $country->id ? 'selected' : '' }}
                                                        @endforeach
                                                    @endisset
                                                    value="{{ $country->id }}">{{ $country->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <h3 class="form-group">Advertiser</h3>
                                    <div class="input-icon">
                                        <select multiple name="advertiser_id[]" id="advertiser_id" class="form-select" placeholder="Select Advertiser">
                                            @foreach($advertisers as $advertiser)
                                                <option
                                                    @isset($advertiser_id)
                                                        @foreach($advertiser_id as $id)
                                                         {{ $id == $advertiser->id ? 'selected' : '' }}
                                                        @endforeach
                                                    @endisset
                                                    value="{{ $advertiser->id }}">{{ $advertiser->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <h3 class="form-group">Date</h3>
                                    <div class="input-icon">
                                        <input type="text" class="btn btn-default" id="date_filter" name="date_filter">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card-footer">
                            <div class="row align-items-center">
                                <div class="col-auto">
                                    <button  class="btn btn-primary">
                                        Filter
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
            <br>
            <div class="col-12">
                <div class="card">
                    <div class="table-responsive">
                        <table class="table table-vcenter table-mobile-md card-table">
                            <thead>
                            <tr>
                                <th>Aff Sub 2</th>
                                <th>Click</th>
                                <th>Unique</th>
                                <th>Conversion</th>
                                <th>Revenue</th>
                                <th>Payout</th>
                                <th>Profit</th>
                            </tr>
                            </thead>
                            <tbody>
                            @foreach ($reports as $date => $report)
                                @if (count(array_filter(is_array($report) ? $report : (array) $report)) < 1)
                                    @continue
                                @endif
                                <tr>
                                    <td data-label="Date">{{ $date }}</td>
                                    <td data-label="Click">{{ $report['click'] }}</td>
                                    <td data-label="Unique">{{ $report['unique'] }}</td>
                                    <td data-label="Conversion">{{ $report['conversion'] }}</td>
                                    <td data-label="Revenue">${{ $report['revenue'] }}</td>
                                    <td data-label="Payout">${{ $report['payout'] }}</td>
                                    <td data-label="Profit">${{ $report['profit'] }}</td>
                                </tr>
                            @endforeach
                            <tr>
                                <td data-label="Date" class="total">Total</td>
                                <td data-label="Click" class="total">{{ $total['clicks'] }}</td>
                                <td data-label="Unique" class="total">{{ $total['uniques'] }}</td>
                                <td data-label="Conversion" class="total">{{ data_get($total,'conversions',0) }}</td>
                                <td data-label="Revenue" class="total">$ {{ $total['revenues'] }}</td>
                                <td data-label="Payout" class="total">$ {{ $total['payouts'] }}</td>
                                <td data-label="Profit" class="total">$ {{ $total['profits'] }}</td>
                            </tr>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('js')
    <script src="https://cdn.jsdelivr.net/npm/tom-select@2.0.1/dist/js/tom-select.complete.min.js"></script>
    <script src="{{ asset('backend/dist/libs/apexcharts/dist/apexcharts.min.js') }}"></script>
    <script src="{{ asset('backend/date/moment.min.js') }}"></script>
    <script src="{{ asset('backend/date/daterangepicker.js') }}"></script>
    <!-- datepicker -->
    <script src="{{ asset('backend/date/bootstrap-datepicker.min.js') }}"></script>
    <script type="text/javascript">
        $(function() {
            let dateInterval = getQueryParameter('date_filter');
            let start = moment().startOf('last Monday');
            let end = moment().endOf('this Sunday');
            if (dateInterval) {
                dateInterval = dateInterval.split(' - ');
                start = dateInterval[0];
                end = dateInterval[1];
            }
            $('#date_filter').daterangepicker({
                "showDropdowns": true,
                "showWeekNumbers": true,
                "alwaysShowCalendars": false,
                startDate: start,
                endDate: end,
                locale: {
                    format: 'YYYY-MM-DD',
                    firstDay: 1,
                },
                ranges: {
                    'Today': [moment(), moment()],
                    'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                    'Last 7 Days': [moment().subtract(6, 'days'), moment()],
                    'Last 30 Days': [moment().subtract(29, 'days'), moment()],
                    'This Month': [moment().startOf('month'), moment().endOf('month')],
                    'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1,
                        'month').endOf('month')],

                }
            });
        });

        function getQueryParameter(name) {
            const url = window.location.href;
            name = name.replace(/[\[\]]/g, "\\$&");
            const regex = new RegExp("[?&]" + name + "(=([^&#]*)|&|#|$)"),
                results = regex.exec(url);
            if (!results) return null;
            if (!results[2]) return '';
            return decodeURIComponent(results[2].replace(/\+/g, " "));
        }
    </script>
    <script>
        new TomSelect('#user_id',{
            plugins: ['input_autogrow'],
        });
        new TomSelect('#offer_id',{
            plugins: ['input_autogrow'],
        });
        new TomSelect('#country_id',{
            plugins: ['input_autogrow'],
        });
        new TomSelect('#advertiser_id',{
            plugins: ['input_autogrow'],
        });
    </script>
@endpush
