@extends('layouts.backend.admin_sash')

@section('title','Click Reports')

@push('css')
    <link href="https://cdn.jsdelivr.net/npm/tom-select@2.0.1/dist/css/tom-select.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/tom-select@2.0.1/dist/css/tom-select.bootstrap5.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.css" rel="stylesheet">
    <link href="{{ asset('backend/dist/css/tabler-flags.min.css')}}" rel="stylesheet"/>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js" integrity="sha512-894YE6QWD5I59HgZOGReFYm4dnWc1Qt5NtvYSaNcOP+u1T9qYdvdihz0PPSiiqn/+/3e7Jo4EaG7TubfWGUrMQ==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
    <link rel="stylesheet" href="{{ asset('backend/date/bootstrap3-wysihtml5.min.css') }}">
    <link rel="stylesheet" href="{{ asset('backend/date/bootstrap-datepicker.min.css') }}">
    <link rel="stylesheet" href="{{ asset('backend/date/daterangepicker.css') }}">
    <style>
        .total{
            font-weight: bold;
        }
    </style>
@endpush

@section('content')
    @php
      $user_id = request('user_id');
      $offer_id = request('offer_id');
      $country_id = request('country_id');
    $advertiser_id = request('advertiser_id');
    @endphp
    @section('filters_table')
        <form action="" method="get">
            <input type="hidden" name="filter" value="filter">
            <table class="table table-bordered filter-table">
                <thead>
                    <tr>
                        <th style="width:220px">Filter</th>
                        <th>Value</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td class="label-cell"><label for="user_id" class="m-0">Affiliate</label></td>
                        <td>
                            <select multiple name="user_id[]" id="user_id" class="form-select" placeholder="Select Affiliate">
                                @foreach($users as $user)
                                    <option @isset($user_id) @foreach($user_id as $id) {{ $id == $user->id ? 'selected' : '' }} @endforeach @endisset value="{{ $user->id }}">{{ $user->first_name . $user->last_name }}</option>
                                @endforeach
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <td class="label-cell"><label for="offer_id" class="m-0">Offers</label></td>
                        <td>
                            <select multiple name="offer_id[]" id="offer_id" class="form-select" placeholder="Select Offers">
                                @foreach($offers as $offer)
                                    <option @isset($offer_id) @foreach($offer_id as $id) {{ $id == $offer->id ? 'selected' : '' }} @endforeach @endisset value="{{ $offer->id }}">{{ $offer->name }}</option>
                                @endforeach
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <td class="label-cell"><label for="country_id" class="m-0">Countries</label></td>
                        <td>
                            <select multiple name="country_id[]" id="country_id" class="form-select" placeholder="Select Country">
                                @foreach($countries as $country)
                                    <option @isset($country_id) @foreach($country_id as $id) {{ $id == $country->id ? 'selected' : '' }} @endforeach @endisset value="{{ $country->id }}">{{ $country->name }}</option>
                                @endforeach
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <td class="label-cell"><label for="advertiser_id" class="m-0">Advertiser</label></td>
                        <td>
                            <select multiple name="advertiser_id[]" id="advertiser_id" class="form-select" placeholder="Select Advertiser">
                                @foreach($advertisers as $advertiser)
                                    <option @isset($advertiser_id) @foreach($advertiser_id as $id) {{ $id == $advertiser->id ? 'selected' : '' }} @endforeach @endisset value="{{ $advertiser->id }}">{{ $advertiser->name }}</option>
                                @endforeach
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <td class="label-cell"><label for="date_filter" class="m-0">Date</label></td>
                        <td>
                            <input type="text" class="btn btn-default" id="date_filter" name="date_filter">
                        </td>
                    </tr>
                    <tr>
                        <td class="label-cell">Actions</td>
                        <td>
                            <div class="filter-actions">
                                <button class="btn btn-outline-dark" type="submit">Filter</button>
                            </div>
                        </td>
                    </tr>
                </tbody>
            </table>
        </form>
    @endsection

    @section('data_table')
        @if(isset($clicks) && count($clicks))
            <table class="table table-bordered text-nowrap border-bottom">
                <thead>
                    <tr>
                        <th>Offer</th>
                        <th>Affiliate</th>
                        <th>Click ID</th>
                        <th>Aff Click ID</th>
                        <th>Aff Sub 1</th>
                        <th>Aff Sub 2</th>
                        <th>Aff Sub 3</th>
                        <th>Source</th>
                        <th>Fraud</th>
                        <th>Os Name</th>
                        <th>Browser</th>
                        <th>Browser Version</th>
                        <th>User Agent</th>
                        <th>Device Brand</th>
                        <th>Device Model</th>
                        <th>Os Version</th>
                        <th>Ip Address</th>
                        <th>Country</th>
                        <th>City</th>
                        <th>Region</th>
                        <th>Payout</th>
                        <th>Click Time</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($clicks as $click)
                        <tr>
                            <td style="white-space:nowrap;">
                                <a href="{{ route('admin.offer.show',$click->offer_id) }}">({{ $click->offer_id }}) {{ optional($click->offer)->name }}</a>
                            </td>
                            <td style="white-space:nowrap;">
                                <a href="{{ route('admin.offer.show',$click->offer_id) }}">({{ $click->user_id }}) {{ optional($click->user)->first_name . optional($click->user)->last_name }}</a>
                            </td>
                            <td>{{ $click->click_id }}</td>
                            <td>{{ $click->aff_click_id }}</td>
                            <td style="white-space:nowrap;">{{ $click->aff_sub_1 }}</td>
                            <td style="white-space:nowrap;">{{ $click->aff_sub_2 }}</td>
                            <td style="white-space:nowrap;">{{ $click->aff_sub_3 }}</td>
                            <td>{{ $click->source }}</td>
                            <td>{{ $click->fraud }}</td>
                            <td>{{ $click->os_name }}</td>
                            <td style="white-space:nowrap;">{{ $click->browser }}</td>
                            <td style="white-space:nowrap;">{{ $click->browser_version }}</td>
                            <td style="white-space:nowrap;">{{ $click->user_agent }}</td>
                            <td>{{ $click->device_brand }}</td>
                            <td>{{ $click->device_model }}</td>
                            <td>{{ $click->os_version }}</td>
                            <td>{{ $click->ip_address }}</td>
                            <td style="white-space:nowrap;">{{ $click->country->name ?? 'N/A' }}</td>
                            <td>{{ $click->geo_city }}</td>
                            <td>{{ $click->geo_region }}</td>
                            <td>${{ $click->payout }}</td>
                            <td style="white-space:nowrap;">{{ $click->created_at }}</td>
                            <td>
                                <a onclick="return confirm('are u sure to approved?')" href="{{ route('admin.report.convert',$click->id) }}" class="btn btn-success btn-sm">
                                    <i class="fa fa-check"></i>
                                </a>
                            </td>
                        </tr>
                    @endforeach
                    <tr>
                        <td>Total</td>
                        <td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td>
                        <td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td>
                        <td></td><td></td>
                        <td>({{ $total }})</td>
                    </tr>
                </tbody>
            </table>
            <div class="d-flex justify-content-center mt-3">
                {{ $clicks->withQueryString()->links() }}
            </div>
        @else
            <div class="alert alert-info m-0">No clicks found for the selected filters and date range.</div>
        @endif
    @endsection

    @includeIf('partials.affiliate-report-layout')
@endsection

@push('js')
    <script src="https://cdn.jsdelivr.net/npm/tom-select@2.0.1/dist/js/tom-select.complete.min.js"></script>
    <script src="{{ asset('backend/dist/libs/apexcharts/dist/apexcharts.min.js') }}"></script>
    <script src="{{ asset('backend/date/moment.min.js') }}"></script>
    <script src="{{ asset('backend/date/daterangepicker.js') }}"></script>
    <!-- datepicker -->
    <script src="{{ asset('backend/date/bootstrap-datepicker.min.js') }}"></script>
    <script type="text/javascript">
        $(function() {
            let dateInterval = getQueryParameter('date_filter');
            let start = moment().startOf('last Monday');
            let end = moment().endOf('this Sunday');
            if (dateInterval) {
                dateInterval = dateInterval.split(' - ');
                start = dateInterval[0];
                end = dateInterval[1];
            }
            $('#date_filter').daterangepicker({
                "showDropdowns": true,
                "showWeekNumbers": true,
                "alwaysShowCalendars": false,
                startDate: start,
                endDate: end,
                locale: {
                    format: 'YYYY-MM-DD',
                    firstDay: 1,
                },
                ranges: {
                    'Today': [moment(), moment()],
                    'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                    'Last 7 Days': [moment().subtract(6, 'days'), moment()],
                    'Last 30 Days': [moment().subtract(29, 'days'), moment()],
                    'This Month': [moment().startOf('month'), moment().endOf('month')],
                    'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1,
                        'month').endOf('month')],

                }
            });
        });

        function getQueryParameter(name) {
            const url = window.location.href;
            name = name.replace(/[\[\]]/g, "\\$&");
            const regex = new RegExp("[?&]" + name + "(=([^&#]*)|&|#|$)"),
                results = regex.exec(url);
            if (!results) return null;
            if (!results[2]) return '';
            return decodeURIComponent(results[2].replace(/\+/g, " "));
        }
    </script>
    <script>
        new TomSelect('#user_id',{
            plugins: ['input_autogrow'],
        });
        new TomSelect('#offer_id',{
            plugins: ['input_autogrow'],
        });
        new TomSelect('#country_id',{
            plugins: ['input_autogrow'],
        });
        new TomSelect('#advertiser_id',{
            plugins: ['input_autogrow'],
        });
    </script>
@endpush
