@extends('layouts.backend.admin_sash')

@section('title','Country Reports')

@push('css')
    <link href="https://cdn.jsdelivr.net/npm/tom-select@2.0.1/dist/css/tom-select.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/tom-select@2.0.1/dist/css/tom-select.bootstrap5.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.css" rel="stylesheet">
    <link href="{{ asset('backend/dist/css/tabler-flags.min.css')}}" rel="stylesheet"/>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js" integrity="sha512-894YE6QWD5I59HgZOGReFYm4dnWc1Qt5NtvYSaNcOP+u1T9qYdvdihz0PPSiiqn/+/3e7Jo4EaG7TubfWGUrMQ==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
    <link rel="stylesheet" href="{{ asset('backend/date/bootstrap3-wysihtml5.min.css') }}">
    <link rel="stylesheet" href="{{ asset('backend/date/bootstrap-datepicker.min.css') }}">
    <link rel="stylesheet" href="{{ asset('backend/date/daterangepicker.css') }}">
    <style>
        .total{
            font-weight: bold;
        }
    </style>
@endpush

@section('content')
    @php
        $user_id = request('user_id');
        $offer_id = request('offer_id');
        $country_id = request('country_id');
       $advertiser_id = request('advertiser_id');
    @endphp
    @section('filters_table')
        <form action="" method="get">
            <input type="hidden" name="filter" value="filter">
            <table class="table table-bordered filter-table">
                <thead>
                    <tr>
                        <th style="width:220px">Filter</th>
                        <th>Value</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td class="label-cell"><label for="user_id" class="m-0">Affiliate</label></td>
                        <td>
                            <select multiple name="user_id[]" id="user_id" class="form-select" placeholder="Select Affiliate">
                                @foreach($users as $user)
                                    <option @isset($user_id) @foreach($user_id as $id) {{ $id == $user->id ? 'selected' : '' }} @endforeach @endisset value="{{ $user->id }}">{{ $user->first_name . $user->last_name }}</option>
                                @endforeach
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <td class="label-cell"><label for="offer_id" class="m-0">Offers</label></td>
                        <td>
                            <select multiple name="offer_id[]" id="offer_id" class="form-select" placeholder="Select Offers">
                                @foreach($offers as $offer)
                                    <option @isset($offer_id) @foreach($offer_id as $id) {{ $id == $offer->id ? 'selected' : '' }} @endforeach @endisset value="{{ $offer->id }}">{{ $offer->name }}</option>
                                @endforeach
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <td class="label-cell"><label for="country_id" class="m-0">Countries</label></td>
                        <td>
                            <select multiple name="country_id[]" id="country_id" class="form-select" placeholder="Select Country">
                                @foreach($countries as $country)
                                    <option @isset($country_id) @foreach($country_id as $id) {{ $id == $country->id ? 'selected' : '' }} @endforeach @endisset value="{{ $country->id }}">{{ $country->name }}</option>
                                @endforeach
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <td class="label-cell"><label for="advertiser_id" class="m-0">Advertiser</label></td>
                        <td>
                            <select multiple name="advertiser_id[]" id="advertiser_id" class="form-select" placeholder="Select Advertiser">
                                @foreach($advertisers as $advertiser)
                                    <option @isset($advertiser_id) @foreach($advertiser_id as $id) {{ $id == $advertiser->id ? 'selected' : '' }} @endforeach @endisset value="{{ $advertiser->id }}">{{ $advertiser->name }}</option>
                                @endforeach
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <td class="label-cell"><label for="date_filter" class="m-0">Date</label></td>
                        <td>
                            <input type="text" class="btn btn-default" id="date_filter" name="date_filter">
                        </td>
                    </tr>
                    <tr>
                        <td class="label-cell">Actions</td>
                        <td>
                            <div class="filter-actions">
                                <button class="btn btn-outline-dark" type="submit">Filter</button>
                            </div>
                        </td>
                    </tr>
                </tbody>
            </table>
        </form>
    @endsection

    @section('data_table')
        @if(isset($reports) && count($reports))
            <table class="table table-bordered text-nowrap border-bottom">
                <thead>
                    <tr>
                        <th>Country</th>
                        <th>Click</th>
                        <th>Unique</th>
                        <th>Conversion</th>
                        <th>Revenue</th>
                        <th>Payout</th>
                        <th>Profit</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($reports as $date => $report)
                        @if (count(array_filter(is_array($report) ? $report : (array) $report)) < 1)
                            @continue
                        @endif
                        @php $country = App\Country::find($date); @endphp
                        <tr>
                            <td>{{ $country ? $country->name : 'Unknown Country (ID: ' . $date . ')' }}</td>
                            <td>{{ $report['click'] }}</td>
                            <td>{{ $report['unique'] }}</td>
                            <td>{{ $report['conversion'] }}</td>
                            <td>${{ $report['revenue'] }}</td>
                            <td>${{ $report['payout'] }}</td>
                            <td>${{ $report['profit'] }}</td>
                        </tr>
                    @endforeach
                    <tr>
                        <td class="total">Total</td>
                        <td class="total">{{ $total['clicks'] }}</td>
                        <td class="total">{{ $total['uniques'] }}</td>
                        <td class="total">{{ data_get($total,'conversions',0) }}</td>
                        <td class="total">$ {{ $total['revenues'] }}</td>
                        <td class="total">$ {{ $total['payouts'] }}</td>
                        <td class="total">$ {{ $total['profits'] }}</td>
                    </tr>
                </tbody>
            </table>
        @else
            <div class="alert alert-info m-0">No reports found for the selected filters and date range.</div>
        @endif
    @endsection

    @includeIf('partials.affiliate-report-layout')
@endsection

@push('js')
    <script src="https://cdn.jsdelivr.net/npm/tom-select@2.0.1/dist/js/tom-select.complete.min.js"></script>
    <script src="{{ asset('backend/dist/libs/apexcharts/dist/apexcharts.min.js') }}"></script>
    <script src="{{ asset('backend/date/moment.min.js') }}"></script>
    <script src="{{ asset('backend/date/daterangepicker.js') }}"></script>
    <!-- datepicker -->
    <script src="{{ asset('backend/date/bootstrap-datepicker.min.js') }}"></script>
    <script type="text/javascript">
        $(function() {
            let dateInterval = getQueryParameter('date_filter');
            let start = moment().startOf('last Monday');
            let end = moment().endOf('this Sunday');
            if (dateInterval) {
                dateInterval = dateInterval.split(' - ');
                start = dateInterval[0];
                end = dateInterval[1];
            }
            $('#date_filter').daterangepicker({
                "showDropdowns": true,
                "showWeekNumbers": true,
                "alwaysShowCalendars": false,
                startDate: start,
                endDate: end,
                locale: {
                    format: 'YYYY-MM-DD',
                    firstDay: 1,
                },
                ranges: {
                    'Today': [moment(), moment()],
                    'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                    'Last 7 Days': [moment().subtract(6, 'days'), moment()],
                    'Last 30 Days': [moment().subtract(29, 'days'), moment()],
                    'This Month': [moment().startOf('month'), moment().endOf('month')],
                    'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1,
                        'month').endOf('month')],
                }
            });
        });
        function getQueryParameter(name) {
            const url = window.location.href;
            name = name.replace(/[\[\]]/g, "\\$&");
            const regex = new RegExp("[?&]" + name + "(=([^&#]*)|&|#|$)"),
                results = regex.exec(url);
            if (!results) return null;
            if (!results[2]) return '';
            return decodeURIComponent(results[2].replace(/\+/g, " "));
        }
    </script>
    <script>
        new TomSelect('#user_id',{
            plugins: ['input_autogrow'],
        });
        new TomSelect('#offer_id',{
            plugins: ['input_autogrow'],
        });
        new TomSelect('#country_id',{
            plugins: ['input_autogrow'],
        });
        new TomSelect('#advertiser_id',{
            plugins: ['input_autogrow'],
        });
    </script>
@endpush
