@extends('layouts.backend.admin_sash')

@section('title','Pending Conversion Reports')

@push('css')
    <link href="https://cdn.jsdelivr.net/npm/tom-select@2.0.1/dist/css/tom-select.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/tom-select@2.0.1/dist/css/tom-select.bootstrap5.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.css" rel="stylesheet">
    <link href="{{ asset('backend/dist/css/tabler-flags.min.css')}}" rel="stylesheet"/>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js" integrity="sha512-894YE6QWD5I59HgZOGReFYm4dnWc1Qt5NtvYSaNcOP+u1T9qYdvdihz0PPSiiqn/+/3e7Jo4EaG7TubfWGUrMQ==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
    <link rel="stylesheet" href="{{ asset('backend/date/bootstrap3-wysihtml5.min.css') }}">
    <link rel="stylesheet" href="{{ asset('backend/date/bootstrap-datepicker.min.css') }}">
    <link rel="stylesheet" href="{{ asset('backend/date/daterangepicker.css') }}">
    <style>
        .total{
            font-weight: bold;
        }
    </style>
@endpush

@section('content')
    @php
      $user_id = request('user_id');
      $offer_id = request('offer_id');
      $country_id = request('country_id');
    $advertiser_id = request('advertiser_id');
    @endphp
    <div class="container-xl">
        <!-- Page title -->
        <div class="page-header d-print-none">
            <div class="row align-items-center">
                <div class="col">
                    <!-- Page pre-title -->
                    <div class="page-pretitle">
                        Overview
                    </div>
                    <h2 class="page-title">
                        @yield(('title'))
                    </h2>
                </div>
                <!-- Page title actions -->
            </div>
        </div>
    </div>
    <div class="page-body">
        <div class="container-xl">
            <div class="col-md-12">
                <form action="">
                    <input type="hidden" name="filter" value="filter">
                    <div class="card">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-2">
                                    <h3 class="form-group">Affiliate</h3>
                                    <div class="input-icon">
                                        <select multiple name="user_id[]" id="user_id" class="form-select" placeholder="Select Affiliate">
                                            @foreach($users as $user)
                                                <option
                                                    @isset($user_id)
                                                        @foreach($user_id as $id)
                                                           {{ $id == $user->id ? 'selected' : '' }}
                                                         @endforeach
                                                    @endisset
                                                    value="{{ $user->id }}">{{ $user->first_name . $user->last_name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <h3 class="form-group">Offers</h3>
                                    <div class="input-icon">
                                        <select multiple name="offer_id[]" id="offer_id" class="form-select" placeholder="Select Offers">
                                            @foreach($offers as $offer)
                                                <option
                                                    @isset($offer_id)
                                                        @foreach($offer_id as $id)
                                                        {{ $id == $offer->id ? 'selected' : '' }}
                                                        @endforeach
                                                    @endisset
                                                    value="{{ $offer->id }}">{{ $offer->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <h3 class="form-group">Countries</h3>
                                    <div class="input-icon">
                                        <select multiple name="country_id[]" id="country_id" class="form-select" placeholder="Select Country">
                                            @foreach($countries as $country)
                                                <option
                                                    @isset($country_id)
                                                        @foreach($country_id as $id)
                                                          {{ $id == $country->id ? 'selected' : '' }}
                                                        @endforeach
                                                    @endisset
                                                    value="{{ $country->id }}">{{ $country->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <h3 class="form-group">Advertiser</h3>
                                    <div class="input-icon">
                                        <select multiple name="advertiser_id[]" id="advertiser_id" class="form-select" placeholder="Select Advertiser">
                                            @foreach($advertisers as $advertiser)
                                                <option
                                                    @isset($advertiser_id)
                                                        @foreach($advertiser_id as $id)
                                                         {{ $id == $advertiser->id ? 'selected' : '' }}
                                                        @endforeach
                                                    @endisset
                                                    value="{{ $advertiser->id }}">{{ $advertiser->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <h3 class="form-group">Date</h3>
                                    <div class="input-icon">
                                        <input type="text" class="btn btn-default" id="date_filter" name="date_filter">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card-footer">
                            <div class="row align-items-center">
                                <div class="col-auto">
                                    <button  class="btn btn-primary">
                                        Filter
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
            <br>
            <div class="col-12">
                <div class="card">
                    @include('layouts.backend.partials.flash-message')
                    <div class="table-responsive">
                        <table class="table table-vcenter table-mobile-md card-table">
                            <thead>
                            <tr>
                                <th>Offer</th>
                                <th>Affiliate</th>
                                <th>Click ID</th>
                                <th>Aff Click ID</th>
                                <th>Aff Sub 1</th>
                                <th>Aff Sub 2</th>
                                <th>Aff Sub 3</th>
                                <th>Source</th>
                                <th>Fraud</th>
                                <th>Os Name</th>
                                <th>Browser</th>
                                <th>Browser Version</th>
                                <th>User Agent</th>
                                <th>Device Brand</th>
                                <th>Device Model</th>
                                <th>Os Version</th>
                                <th>Ip Address</th>
                                <th>Country</th>
                                <th>City</th>
                                <th>Region</th>
                                <th>Revenue</th>
                                <th>Payout</th>
                                <th>Profit</th>
                                <th>Click Time</th>
                                <th>Action</th>
                            </tr>
                            </thead>
                            <tbody>
                            @foreach ($conversions as $conversion)
                                <tr>
                                    <td data-label="Offer Name" style="white-space:nowrap;">
                                        <a href="{{ route('admin.offer.show',$conversion->offer_id) }}">({{ $conversion->offer_id }}) {{ $conversion->offer->name }}</a>
                                    </td>
                                    <td data-label="Affiliate Name" style="white-space:nowrap;">
                                        <a href="{{ route('admin.offer.show',$conversion->offer_id) }}">({{ $conversion->user_id }}) {{ $conversion->user->first_name . $conversion->user->last_name }}</a>
                                    </td>
                                    <td data-label="Click ID">{{ $conversion->click_id }}</td>
                                    <td data-label="Aff Click ID">{{ $conversion->aff_click_id }}</td>
                                    <td data-label="Aff Sub 1" style="white-space:nowrap;">{{ $conversion->aff_sub_1 }}</td>
                                    <td data-label="Aff Sub 2" style="white-space:nowrap;">{{ $conversion->aff_sub_2 }}</td>
                                    <td data-label="Aff Sub 3" style="white-space:nowrap;">{{ $conversion->aff_sub_3 }}</td>
                                    <td data-label="Source">{{ $conversion->source }}</td>
                                    <td data-label="Fraud">{{ $conversion->fraud }}</td>
                                    <td data-label="Os Name">{{ $conversion->os_name }}</td>
                                    <td data-label="Browser" style="white-space:nowrap;">{{ $conversion->browser }}</td>
                                    <td data-label="Browser Version" style="white-space:nowrap;">{{ $conversion->browser_version }}</td>
                                    <td data-label="User Agent" style="white-space:nowrap;">{{ $conversion->user_agent }}</td>
                                    <td data-label="Device Brand">{{ $conversion->device_brand }}</td>
                                    <td data-label="Device Model">{{ $conversion->device_model }}</td>
                                    <td data-label="Os Version">{{ $conversion->os_version }}</td>
                                    <td data-label="Ip Address">{{ $conversion->ip_address }}</td>
                                    <td data-label="Country" style="white-space:nowrap;">{{ $conversion->country->name ?? 'N/A' }}</td>
                                    <td data-label="City">{{ $conversion->geo_city }}</td>
                                    <td data-label="Region">{{ $conversion->geo_region }}</td>
                                    <td data-label="Payout">${{ $conversion->revenue }}</td>
                                    <td data-label="Payout">${{ $conversion->payout }}</td>
                                    <td data-label="Payout">${{ $conversion->profit }}</td>
                                    <td data-label="Click Time" style="white-space:nowrap;">{{ $conversion->created_at }}</td>
                                    <td data-label="Action">
                                        <a onclick="return confirm('are u sure to conversion?')" href="{{ route('admin.report.convert',$conversion->id) }}" class="btn btn-success btn-sm">
                                            <i class="fa fa-check"></i>
                                        </a>
                                    </td>
                                </tr>
                            @endforeach
                            <tr style="font-style: inherit">
                                <td>Total</td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td>({{ $total }})</td>
                            </tr>
                        </table>
                        {{ $conversions->withQueryString()->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('js')
    <script src="https://cdn.jsdelivr.net/npm/tom-select@2.0.1/dist/js/tom-select.complete.min.js"></script>
    <script src="{{ asset('backend/dist/libs/apexcharts/dist/apexcharts.min.js') }}"></script>
    <script src="{{ asset('backend/date/moment.min.js') }}"></script>
    <script src="{{ asset('backend/date/daterangepicker.js') }}"></script>
    <!-- datepicker -->
    <script src="{{ asset('backend/date/bootstrap-datepicker.min.js') }}"></script>
    <script type="text/javascript">
        $(function() {
            let dateInterval = getQueryParameter('date_filter');
            let start = moment().startOf('last Monday');
            let end = moment().endOf('this Sunday');
            if (dateInterval) {
                dateInterval = dateInterval.split(' - ');
                start = dateInterval[0];
                end = dateInterval[1];
            }
            $('#date_filter').daterangepicker({
                "showDropdowns": true,
                "showWeekNumbers": true,
                "alwaysShowCalendars": false,
                startDate: start,
                endDate: end,
                locale: {
                    format: 'YYYY-MM-DD',
                    firstDay: 1,
                },
                ranges: {
                    'Today': [moment(), moment()],
                    'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                    'Last 7 Days': [moment().subtract(6, 'days'), moment()],
                    'Last 30 Days': [moment().subtract(29, 'days'), moment()],
                    'This Month': [moment().startOf('month'), moment().endOf('month')],
                    'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1,
                        'month').endOf('month')],

                }
            });
        });

        function getQueryParameter(name) {
            const url = window.location.href;
            name = name.replace(/[\[\]]/g, "\\$&");
            const regex = new RegExp("[?&]" + name + "(=([^&#]*)|&|#|$)"),
                results = regex.exec(url);
            if (!results) return null;
            if (!results[2]) return '';
            return decodeURIComponent(results[2].replace(/\+/g, " "));
        }
    </script>
    <script>
        new TomSelect('#user_id',{
            plugins: ['input_autogrow'],
        });
        new TomSelect('#offer_id',{
            plugins: ['input_autogrow'],
        });
        new TomSelect('#country_id',{
            plugins: ['input_autogrow'],
        });
        new TomSelect('#advertiser_id',{
            plugins: ['input_autogrow'],
        });
    </script>
@endpush
