@extends('layouts.backend.admin_sash')

@section('title','Country Reports')

@push('css')
    <link href="https://cdn.jsdelivr.net/npm/tom-select@2.0.1/dist/css/tom-select.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/tom-select@2.0.1/dist/css/tom-select.bootstrap5.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.css" rel="stylesheet">
    <link href="{{ asset('backend/dist/css/tabler-flags.min.css')}}" rel="stylesheet"/>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js" integrity="sha512-894YE6QWD5I59HgZOGReFYm4dnWc1Qt5NtvYSaNcOP+u1T9qYdvdihz0PPSiiqn/+/3e7Jo4EaG7TubfWGUrMQ==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
    <link rel="stylesheet" href="{{ asset('backend/date/bootstrap3-wysihtml5.min.css') }}">
    <link rel="stylesheet" href="{{ asset('backend/date/bootstrap-datepicker.min.css') }}">
    <link rel="stylesheet" href="{{ asset('backend/date/daterangepicker.css') }}">
    <style>
        .total{
            font-weight: bold;
        }
    </style>
@endpush

@section('content')
    @php
      $user_id = request('user_id');
      $offer_id = request('offer_id');
      $country_id = request('country_id');
    $advertiser_id = request('advertiser_id');
    @endphp
    <div class="container-xl">
        <!-- Page title -->
        <div class="page-header d-print-none">
            <div class="row align-items-center">
                <div class="col">
                    <!-- Page pre-title -->
                    <div class="page-pretitle">
                        Overview
                    </div>
                    <h2 class="page-title">
                        @yield(('title'))
                    </h2>
                </div>
                <!-- Page title actions -->
            </div>
        </div>
    </div>
    <div class="page-body">
        <div class="container-xl">
            <div class="col-md-12">
                <form action="">
                    <div class="card">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-2">
                                    <h3 class="form-group">Statistics</h3>
                                    <div class="mb-3">
                                        <label class="form-check mb-2">
                                            <input class="form-check-input" name="click_id" type="checkbox">
                                            <span class="form-check-label">
                                                Click ID
                                            </span>
                                        </label>
                                    </div>
                                    <div class="mb-3">
                                        <label class="form-check mb-2">
                                            <input class="form-check-input" name="aff_click_id" type="checkbox">
                                            <span class="form-check-label">
                                                Aff Click ID
                                            </span>
                                        </label>
                                    </div>
                                    <div class="mb-3">
                                        <label class="form-check mb-2">
                                            <input class="form-check-input" name="device_brand" type="checkbox">
                                            <span class="form-check-label">
                                               Device
                                            </span>
                                        </label>
                                    </div>
                                    <div class="mb-3">
                                        <label class="form-check mb-2">
                                            <input class="form-check-input" name="ip_address" type="checkbox">
                                            <span class="form-check-label">
                                               IP
                                            </span>
                                        </label>
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <h3 class="form-group">Indicator</h3>
                                    <div class="mb-3">
                                        <label class="form-check mb-2">
                                            <input class="form-check-input" name="user_id" type="checkbox">
                                            <span class="form-check-label">
                                                Affiliate
                                            </span>
                                        </label>
                                    </div>
                                    <div class="mb-3">
                                        <label class="form-check mb-2">
                                            <input class="form-check-input" name="offer_id" type="checkbox">
                                            <span class="form-check-label">
                                                Offer
                                            </span>
                                        </label>
                                    </div>
                                    <div class="mb-3">
                                        <label class="form-check mb-2">
                                            <input class="form-check-input" name="country_id" type="checkbox">
                                            <span class="form-check-label">
                                                Countries
                                            </span>
                                        </label>
                                    </div>
                                    <div class="mb-3">
                                        <label class="form-check mb-2">
                                            <input class="form-check-input" name="advertiser" type="checkbox">
                                            <span class="form-check-label">
                                                Advertiser
                                            </span>
                                        </label>
                                    </div>
                                    <div class="mb-3">
                                        <label class="form-check mb-2">
                                            <input class="form-check-input" name="aff_sub_1" type="checkbox">
                                            <span class="form-check-label">
                                                Sub 1
                                            </span>
                                        </label>
                                    </div>
                                    <div class="mb-3">
                                        <label class="form-check mb-2">
                                            <input class="form-check-input" name="device_brand" type="checkbox">
                                            <span class="form-check-label">
                                                Device
                                            </span>
                                        </label>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card-footer">
                            <div class="row align-items-center">
                                <div class="col-auto">
                                    <button  class="btn btn-primary">
                                        Filter
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
            <br>


            @if (isset($reports))
            <div class="col-12">
                <div class="card">
                    <div class="table-responsive">
                        <table class="table table-vcenter table-mobile-md card-table">
                            <thead>
                                @php
                                    $titles = array_keys($reports->first()->toArray());
                                @endphp

                                @foreach($titles as $title)
                                    <th>{{ $title }}</th>
                                @endforeach
                            </thead>

                            <tbody>
                                @foreach($reports as $report)
                                    @php
                                        $report = array_values($report->toArray());
                                    @endphp
                                    <tr>
                                        @foreach ($report as $item)
{{--                                            @if (!$item)--}}
{{--                                                @continue--}}
{{--                                            @endif--}}

                                            <td>{{ $item }}</td>
                                        @endforeach
                                    </tr>
                                @endforeach

{{--                            @foreach ($reports as $date => $report)--}}
{{--                                @if (count(array_filter($report)) < 1)--}}
{{--                                    @continue--}}
{{--                                @endif--}}
{{--                                <tr>--}}
{{--                                    <td data-label="Date">{{ $date }}</td>--}}
{{--                                    <td data-label="Click">{{ $report['click'] }}</td>--}}
{{--                                    <td data-label="Unique">{{ $report['unique'] }}</td>--}}
{{--                                    <td data-label="Conversion">{{ $report['conversion'] }}</td>--}}
{{--                                    <td data-label="Revenue">${{ $report['revenue'] }}</td>--}}
{{--                                    <td data-label="Payout">${{ $report['payout'] }}</td>--}}
{{--                                    <td data-label="Profit">${{ $report['profit'] }}</td>--}}
{{--                                </tr>--}}
{{--                            @endforeach--}}
{{--                            <tr>--}}
{{--                                <td data-label="Date" class="total">Total</td>--}}
{{--                                <td data-label="Click" class="total">{{ $totalClick }}</td>--}}
{{--                                <td data-label="Unique" class="total">{{ $totalUnique }}</td>--}}
{{--                                <td data-label="Conversion" class="total">{{ $totalConversion }}</td>--}}
{{--                                <td data-label="Revenue" class="total">$ {{ $totalRevenue }}</td>--}}
{{--                                <td data-label="Payout" class="total">$ {{  $totalPayout }}</td>--}}
{{--                                <td data-label="Profit" class="total">$ {{ $totalProfit  }}</td>--}}
{{--                            </tr>--}}
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            @endif
        </div>
    </div>
@endsection

@push('js')
    <script src="https://cdn.jsdelivr.net/npm/tom-select@2.0.1/dist/js/tom-select.complete.min.js"></script>
    <script src="{{ asset('backend/dist/libs/apexcharts/dist/apexcharts.min.js') }}"></script>
    <script src="{{ asset('backend/date/moment.min.js') }}"></script>
    <script src="{{ asset('backend/date/daterangepicker.js') }}"></script>
    <!-- datepicker -->
    <script src="{{ asset('backend/date/bootstrap-datepicker.min.js') }}"></script>
    <script type="text/javascript">
        $(function() {
            let dateInterval = getQueryParameter('date_filter');
            let start = moment().startOf('last Monday');
            let end = moment().endOf('this Sunday');
            if (dateInterval) {
                dateInterval = dateInterval.split(' - ');
                start = dateInterval[0];
                end = dateInterval[1];
            }
            $('#date_filter').daterangepicker({
                "showDropdowns": true,
                "showWeekNumbers": true,
                "alwaysShowCalendars": false,
                startDate: start,
                endDate: end,
                locale: {
                    format: 'YYYY-MM-DD',
                    firstDay: 1,
                },
                ranges: {
                    'Today': [moment(), moment()],
                    'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                    'Last 7 Days': [moment().subtract(6, 'days'), moment()],
                    'Last 30 Days': [moment().subtract(29, 'days'), moment()],
                    'This Month': [moment().startOf('month'), moment().endOf('month')],
                    'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1,
                        'month').endOf('month')],

                }
            });
        });

        function getQueryParameter(name) {
            const url = window.location.href;
            name = name.replace(/[\[\]]/g, "\\$&");
            const regex = new RegExp("[?&]" + name + "(=([^&#]*)|&|#|$)"),
                results = regex.exec(url);
            if (!results) return null;
            if (!results[2]) return '';
            return decodeURIComponent(results[2].replace(/\+/g, " "));
        }
    </script>
    <script>
        new TomSelect('#user_id',{
            plugins: ['input_autogrow'],
        });
        new TomSelect('#offer_id',{
            plugins: ['input_autogrow'],
        });
        new TomSelect('#country_id',{
            plugins: ['input_autogrow'],
        });
        new TomSelect('#advertiser_id',{
            plugins: ['input_autogrow'],
        });
    </script>
@endpush
