@extends('layouts.backend.admin_sash')

@section('title','Postback Log Reports')

@push('css')
    <link href="https://cdn.jsdelivr.net/npm/tom-select@2.0.1/dist/css/tom-select.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/tom-select@2.0.1/dist/css/tom-select.bootstrap5.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.css" rel="stylesheet">
    <link href="{{ asset('backend/dist/css/tabler-flags.min.css')}}" rel="stylesheet"/>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js" integrity="sha512-894YE6QWD5I59HgZOGReFYm4dnWc1Qt5NtvYSaNcOP+u1T9qYdvdihz0PPSiiqn/+/3e7Jo4EaG7TubfWGUrMQ==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
    <link rel="stylesheet" href="{{ asset('backend/date/bootstrap3-wysihtml5.min.css') }}">
    <link rel="stylesheet" href="{{ asset('backend/date/bootstrap-datepicker.min.css') }}">
    <link rel="stylesheet" href="{{ asset('backend/date/daterangepicker.css') }}">
    <style>
        .total{
            font-weight: bold;
        }
    </style>
@endpush

@section('content')
    @php
      $user_id = request('user_id');
      $offer_id = request('offer_id');
    @endphp
    <div class="container-xl">
        <!-- Page title -->
        <div class="page-header d-print-none">
            <div class="row align-items-center">
                <div class="col">
                    <!-- Page pre-title -->
                    <div class="page-pretitle">
                        Overview
                    </div>
                    <h2 class="page-title">
                        @yield(('title'))
                    </h2>
                </div>
                <!-- Page title actions -->
            </div>
        </div>
    </div>
    <div class="page-body">
        <div class="container-xl">
            <div class="col-md-12">
                <form action="">
                    <input type="hidden" name="filter" value="filter">
                    <div class="card">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-2">
                                    <h3 class="form-group">Affiliate</h3>
                                    <div class="input-icon">
                                        <select multiple name="user_id[]" id="user_id" class="form-select" placeholder="Select Affiliate">
                                            @foreach($users as $user)
                                                <option
                                                    @isset($user_id)
                                                        @foreach($user_id as $id)
                                                           {{ $id == $user->id ? 'selected' : '' }}
                                                         @endforeach
                                                    @endisset
                                                    value="{{ $user->id }}">{{ $user->first_name .' '. $user->last_name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <h3 class="form-group">Offers</h3>
                                    <div class="input-icon">
                                        <select multiple name="offer_id[]" id="offer_id" class="form-select" placeholder="Select Offers">
                                            @foreach($offers as $offer)
                                                <option
                                                    @isset($offer_id)
                                                        @foreach($offer_id as $id)
                                                        {{ $id == $offer->id ? 'selected' : '' }}
                                                        @endforeach
                                                    @endisset
                                                    value="{{ $offer->id }}">{{ $offer->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <h3 class="form-group">Date</h3>
                                    <div class="input-icon">
                                        <input type="text" class="btn btn-default" id="date_filter" name="date_filter">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card-footer">
                            <div class="row align-items-center">
                                <div class="col-auto">
                                    <button  class="btn btn-primary">
                                        Filter
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
            <br>
            <div class="col-12">
                <div class="card">
                    @include('layouts.backend.partials.flash-message')
                    <div class="table-responsive">
                        <table class="table table-vcenter table-mobile-md card-table">
                            <thead>
                                <tr>
                                    <td>ID</td>
                                    <th>Offer Name</th>
                                    <th>Affiliate Name</th>
                                    <th>Status</th>
                                    <th>Ip</th>
                                    <th>Country</th>
                                    <th>Request Url</th>
                                    <th>Source</th>
                                    <th>User Agent</th>
                                    <th>Request At</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($postbacks as $postback)
                                    <tr>
                                        <td data-label="ID">#{{ $postback->id }}</td>
                                        <td data-label="Offer Name" style="white-space:nowrap;">{{ optional($postback->offer)->name }}</td>
                                        <td data-label="Affiliate Name" style="white-space:nowrap;">{{ optional($postback->user)->first_name .' '.optional($postback->user)->last_name }}</td>
                                        <td data-label="Status" style="white-space:nowrap;">
                                            @if ($postback->status == "approved")
                                                <span class="badge bg-success">Approved</span>
                                            @elseif($postback->status == "duplicate")
                                                <span class="badge bg-warning">Duplicate</span>
                                                @else
                                                <span class="badge bg-danger">{{$postback->status}}</span>
                                            @endif
                                        </td>
                                        <td data-label="Ip Address" style="white-space:nowrap;">{{ $postback->ip }}</td>
                                        <td data-label="Country" style="white-space:nowrap;">{{ $postback->country }}</td>
                                        <td data-label="Request Url" style="white-space:nowrap;">{{ $postback->request_url }}</td>
                                        <td data-label="Source" style="white-space:nowrap;">{{ $postback->source }}</td>
                                        <td data-label="User Agent" style="white-space:nowrap;">{{ $postback->user_agent }}</td>
                                        <td data-label="Time" style="white-space:nowrap;">{{ $postback->created_at }}</td>
                                    </tr>
                                @endforeach
                        </table>
                        {{ $postbacks->withQueryString()->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('js')
    <script src="https://cdn.jsdelivr.net/npm/tom-select@2.0.1/dist/js/tom-select.complete.min.js"></script>
    <script src="{{ asset('backend/dist/libs/apexcharts/dist/apexcharts.min.js') }}"></script>
    <script src="{{ asset('backend/date/moment.min.js') }}"></script>
    <script src="{{ asset('backend/date/daterangepicker.js') }}"></script>
    <!-- datepicker -->
    <script src="{{ asset('backend/date/bootstrap-datepicker.min.js') }}"></script>
    <script type="text/javascript">
        $(function() {
            let dateInterval = getQueryParameter('date_filter');
            let start = moment().startOf('last Monday');
            let end = moment().endOf('this Sunday');
            if (dateInterval) {
                dateInterval = dateInterval.split(' - ');
                start = dateInterval[0];
                end = dateInterval[1];
            }
            $('#date_filter').daterangepicker({
                "showDropdowns": true,
                "showWeekNumbers": true,
                "alwaysShowCalendars": false,
                startDate: start,
                endDate: end,
                locale: {
                    format: 'YYYY-MM-DD',
                    firstDay: 1,
                },
                ranges: {
                    'Today': [moment(), moment()],
                    'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                    'Last 7 Days': [moment().subtract(6, 'days'), moment()],
                    'Last 30 Days': [moment().subtract(29, 'days'), moment()],
                    'This Month': [moment().startOf('month'), moment().endOf('month')],
                    'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1,
                        'month').endOf('month')],

                }
            });
        });

        function getQueryParameter(name) {
            const url = window.location.href;
            name = name.replace(/[\[\]]/g, "\\$&");
            const regex = new RegExp("[?&]" + name + "(=([^&#]*)|&|#|$)"),
                results = regex.exec(url);
            if (!results) return null;
            if (!results[2]) return '';
            return decodeURIComponent(results[2].replace(/\+/g, " "));
        }
    </script>
    <script>
        new TomSelect('#user_id',{
            plugins: ['input_autogrow'],
        });
        new TomSelect('#offer_id',{
            plugins: ['input_autogrow'],
        });
        new TomSelect('#country_id',{
            plugins: ['input_autogrow'],
        });
        new TomSelect('#advertiser_id',{
            plugins: ['input_autogrow'],
        });
    </script>
@endpush
