@extends('layouts.backend.admin_sash')


@section('title','Appearance Settings')


@push('css')
    <link href="https://cdn.jsdelivr.net/npm/tom-select@2.0.1/dist/css/tom-select.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/tom-select@2.0.1/dist/css/tom-select.bootstrap5.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.css" rel="stylesheet">
@endpush

@section('content')
    <div class="container-xl">
        <!-- Page title -->
        <div class="page-header d-print-none">
            <div class="row align-items-center">
                <div class="col">
                    <!-- Page pre-title -->
                    <div class="page-pretitle">
                        Overview
                    </div>
                    <h2 class="page-title">
                        @yield(('title'))
                    </h2>
                </div>
                <!-- Page title actions -->
            </div>
        </div>
    </div>
    <div class="page-body">
        <div class="container-xl">
            <form action="{{ route('admin.setting.appearance.update')  }}" method="post" enctype="multipart/form-data" >
                @method('PUT')
                @csrf
                <div class="row row-cards">
                    <div class="col-md-3">
                        <div class="card">
                            <div class="list-group">
                                @include('admin.settings.sidebar')
                            </div>
                        </div>
                    </div>
                    <div class="col-md-9">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">Appearance Setting</h3>
                        </div>
                        @include('layouts.backend.partials.flash-message')
                        @if ($errors->any())
                            <div class="alert alert-danger">
                                <ul>
                                    @foreach ($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        @endif
                        <div class="card-body">
                            <div class="form-group mb-3 ">
                                <label class="form-label">Site Logo (For Dark Backgrounds)</label>
                                <div class="mb-2">
                                    @if(setting('site_logo_light'))
                                        <div class="d-flex align-items-center gap-2">
                                            <img src="{{ url('public') . Storage::url(setting('site_logo_light')) }}" alt="Current Light Logo" width="110" height="32" class="img-thumbnail">
                                            <a href="{{ route('admin.setting.logo.delete', 'site_logo_light') }}" class="btn btn-sm btn-outline-danger" onclick="return confirm('Are you sure you want to delete this logo?')">
                                                <i class="fa fa-trash"></i> Delete
                                            </a>
                                        </div>
                                    @else
                                        <div class="text-muted">No light theme logo uploaded</div>
                                    @endif
                                </div>
                                <div>
                                    <input type="file" name="site_logo_light" class="form-control" accept="image/*">
                                    <small class="form-text text-muted">Logo for dark backgrounds (shows in light theme). Recommended size: 110x32px. Supported formats: JPEG, PNG, GIF, SVG. Max size: 10MB</small>
                                </div>
                            </div>
                            <div class="form-group mb-3 ">
                                <label class="form-label">Site Logo (For Light Backgrounds)</label>
                                <div class="mb-2">
                                    @if(setting('site_logo_dark'))
                                        <div class="d-flex align-items-center gap-2">
                                            <img src="{{ url('public') . Storage::url(setting('site_logo_dark')) }}" alt="Current Dark Logo" width="110" height="32" class="img-thumbnail">
                                            <a href="{{ route('admin.setting.logo.delete', 'site_logo_dark') }}" class="btn btn-sm btn-outline-danger" onclick="return confirm('Are you sure you want to delete this logo?')">
                                                <i class="fa fa-trash"></i> Delete
                                            </a>
                                        </div>
                                    @else
                                        <div class="text-muted">No dark theme logo uploaded</div>
                                    @endif
                                </div>
                                <div>
                                    <input type="file" name="site_logo_dark" class="form-control" accept="image/*">
                                    <small class="form-text text-muted">Logo for light backgrounds (shows in dark theme). Recommended size: 110x32px. Supported formats: JPEG, PNG, GIF, SVG. Max size: 10MB</small>
                                </div>
                            </div>
                            <div class="form-group mb-3 ">
                                <label class="form-label">Site Small Logo (For Dark Backgrounds)</label>
                                <div class="mb-2">
                                    @if(setting('site_logo_small_light'))
                                        <div class="d-flex align-items-center gap-2">
                                            <img src="{{ url('public') . Storage::url(setting('site_logo_small_light')) }}" alt="Current Small Light Logo" height="30" class="img-thumbnail">
                                            <a href="{{ route('admin.setting.logo.delete', 'site_logo_small_light') }}" class="btn btn-sm btn-outline-danger" onclick="return confirm('Are you sure you want to delete this logo?')">
                                                <i class="fa fa-trash"></i> Delete
                                            </a>
                                        </div>
                                    @else
                                        <div class="text-muted">No small light theme logo uploaded</div>
                                    @endif
                                </div>
                                <div>
                                    <input type="file" name="site_logo_small_light" class="form-control" accept="image/*">
                                    <small class="form-text text-muted">Small logo for dark backgrounds (shows in light theme). Used for sidebar and mobile views. Recommended size: 30x30px. Supported formats: JPEG, PNG, GIF, SVG. Max size: 10MB</small>
                                </div>
                            </div>
                            <div class="form-group mb-3 ">
                                <label class="form-label">Site Small Logo (For Light Backgrounds)</label>
                                <div class="mb-2">
                                    @if(setting('site_logo_small_dark'))
                                        <div class="d-flex align-items-center gap-2">
                                            <img src="{{ url('public') . Storage::url(setting('site_logo_small_dark')) }}" alt="Current Small Dark Logo" height="30" class="img-thumbnail">
                                            <a href="{{ route('admin.setting.logo.delete', 'site_logo_small_dark') }}" class="btn btn-sm btn-outline-danger" onclick="return confirm('Are you sure you want to delete this logo?')">
                                                <i class="fa fa-trash"></i> Delete
                                            </a>
                                        </div>
                                    @else
                                        <div class="text-muted">No small dark theme logo uploaded</div>
                                    @endif
                                </div>
                                <div>
                                    <input type="file" name="site_logo_small_dark" class="form-control" accept="image/*">
                                    <small class="form-text text-muted">Small logo for light backgrounds (shows in dark theme). Used for sidebar and mobile views. Recommended size: 30x30px. Supported formats: JPEG, PNG, GIF, SVG. Max size: 10MB</small>
                                </div>
                            </div>
                            <div class="form-group mb-3 ">
                                <label class="form-label">Site Favicon</label>
                                <div class="mb-2">
                                    @if(setting('site_favicon'))
                                        <div class="d-flex align-items-center gap-2">
                                            <img src="{{ url('public') . Storage::url(setting('site_favicon')) }}" alt="Current Favicon" height="30" class="img-thumbnail">
                                            <a href="{{ route('admin.setting.logo.delete', 'site_favicon') }}" class="btn btn-sm btn-outline-danger" onclick="return confirm('Are you sure you want to delete this favicon?')">
                                                <i class="fa fa-trash"></i> Delete
                                            </a>
                                        </div>
                                    @else
                                        <div class="text-muted">No favicon uploaded</div>
                                    @endif
                                </div>
                                <div>
                                    <input type="file" name="site_favicon" class="form-control" accept="image/*">
                                    <small class="form-text text-muted">Recommended size: 32x32px or 16x16px. Supported formats: ICO, PNG, JPEG, GIF. Max size: 10MB</small>
                                </div>
                            </div>
                            <div class="form-group mb-3 ">
                                <label class="form-label">Site Theme</label>
                                <div>
                                    <select name="site_theme" id="site_theme" class="form-control">
                                        <option {{ setting('site_theme') == "theme-light" ? 'selected' : '' }} value="theme-light">Light Theme</option>
                                        <option {{ setting('site_theme') == "theme-dark" ? 'selected' : '' }} value="theme-dark">Dark Theme</option>
                                    </select>
                                </div>
                            </div>
                            <div class="form-footer">
                                <button type="submit" class="btn btn-primary">Update</button>
                            </div>
                        </div>
                    </div>
                </div>
                 </div>
            </form>
        </div>
    </div>
@endsection

@push('js')
    <script src="https://cdn.jsdelivr.net/npm/tom-select@2.0.1/dist/js/tom-select.complete.min.js"></script>
    <script>
        new TomSelect('#site_time_zone',{
            plugins: ['input_autogrow'],
        });
        new TomSelect('#manager_id',{
            plugins: ['input_autogrow'],
        });

        // Preview uploaded images
        document.querySelectorAll('input[type="file"]').forEach(function(input) {
            input.addEventListener('change', function(e) {
                const file = e.target.files[0];
                if (file) {
                    const reader = new FileReader();
                    reader.onload = function(e) {
                        const preview = input.parentElement.querySelector('.preview-image');
                        if (preview) {
                            preview.src = e.target.result;
                        } else {
                            const img = document.createElement('img');
                            img.src = e.target.result;
                            img.className = 'preview-image img-thumbnail mt-2';
                            img.style.maxWidth = '200px';
                            img.style.maxHeight = '100px';
                            input.parentElement.appendChild(img);
                        }
                    };
                    reader.readAsDataURL(file);
                }
            });
        });
    </script>
@endpush
