@extends('layouts.backend.admin_sash')


@section('title','General Settings')


@push('css')
    <link href="https://cdn.jsdelivr.net/npm/tom-select@2.0.1/dist/css/tom-select.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/tom-select@2.0.1/dist/css/tom-select.bootstrap5.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.css" rel="stylesheet">
@endpush

@section('content')
    <div class="container-xl">
        <!-- Page title -->
        <div class="page-header d-print-none">
            <div class="row align-items-center">
                <div class="col">
                    <!-- Page pre-title -->
                    <div class="page-pretitle">
                        Overview
                    </div>
                    <h2 class="page-title">
                        @yield(('title'))
                    </h2>
                </div>
                <!-- Page title actions -->
            </div>
        </div>
    </div>
    <div class="page-body">
        <div class="container-xl">
            <form action="{{ route('admin.setting.general.update')  }}" method="post" >
                @method('PUT')
                @csrf
                <div class="row row-cards">
                    <div class="col-md-3">
                        <div class="card">
                            <div class="list-group">
                                @include('admin.settings.sidebar')
                            </div>
                        </div>
                    </div>
                    <div class="col-md-9">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">General Setting</h3>
                        </div>
                        @include('layouts.backend.partials.flash-message')
                        @if ($errors->any())
                            <div class="alert alert-danger">
                                <ul>
                                    @foreach ($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        @endif
                        <div class="card-body">
                            <div class="form-group mb-3 ">
                                <label class="form-label">Site Title</label>
                                <div>
                                    <input type="text" class="form-control" name="site_title" value="{{ setting('site_title') ?? old('site_title') }}" placeholder="Site Title" required>
                                </div>
                                @error('site_title')
                                    <div class="error">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="form-group mb-3 ">
                                <label class="form-label">Default Tracking Domain</label>
                                <div>
                                    <input type="text" class="form-control" name="tracking_domain" value="{{ setting('tracking_domain') ?? old('tracking_domain') }}" placeholder="Default Tracking Domain" required>
                                </div>
                                @error('tracking_domain')
                                 <div class="error">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="form-group mb-3 ">
                                <label class="form-label">Site Time Zone (Current Time : {{now(setting('site_time_zone'))->format('M j, Y g:i A')}})</label>
                                <div>
                                    <select name="site_time_zone" id="site_time_zone" class="form-select">
                                        <option value="Asia/Dhaka" {{ setting('site_time_zone') == 'Asia/Dhaka' ? 'selected' : '' }}>Bangladesh time zone</option>
                                        <option value="America/New_York" {{ setting('site_time_zone') == 'America/New_York' ? 'selected' : '' }}>(GMT-04:00) America/New_York</option>

                                    </select>
                                </div>
                                @error('site_time_zone')
                                <div class="error">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="form-group mb-3 ">
                                <label class="form-label">Affiliate Register</label>
                                <div>
                                    <select name="affiliate_register" id="affiliate_register" class="form-control">
                                        <option {{ setting('affiliate_register') == 1 ? 'selected' : '' }} value="1">Enable</option>
                                        <option {{ setting('affiliate_register') == 0 ? 'selected' : '' }} value="0">Disable</option>
                                    </select>
                                </div>
                            </div>
                            <div class="form-group mb-3 ">
                                <label class="form-label">Affiliate Register Status</label>
                                <div>
                                    <select name="affiliate_register_status" id="affiliate_register_status" class="form-control">
                                        <option {{ setting('affiliate_register_status') == 1 ? 'selected' : '' }} value="1">Auto Approved</option>
                                        <option {{ setting('affiliate_register_status') == 0 ? 'selected' : '' }} value="0">Menual Approved</option>
                                    </select>
                                </div>
                            </div>
                            <div class="form-group mb-3 ">
                                <label class="form-label">Site Conversion Status</label>
                                <div>
                                    <select name="site_conversion_status" id="site_conversion_status" class="form-control">
                                        <option {{ setting('site_conversion_status') == 1 ? 'selected' : '' }} value="1">Auto Approved</option>
                                        <option {{ setting('site_conversion_status') == 0 ? 'selected' : '' }} value="0">Pending</option>
                                    </select>
                                </div>
                            </div>
                            <div class="form-group mb-3 ">
                                <label class="form-label">Refer Commission</label>
                                <div>
                                    <input type="text" class="form-control" name="refer_commission" id="refer_commission" value="{{ setting('refer_commission') ?? old('refer_commission') }} ">
                                </div>
                            </div>
                            <div class="form-group mb-3 ">
                                <label class="form-label">Copyright Text</label>
                                <div>
                                    <input type="text" class="form-control" name="copyright_text" id="copyright_text" value="{{ setting('copyright_text') ?? old('copyright_text') }}">
                                </div>
                            </div>
                            <div class="form-group mb-3 ">
                                <label class="form-label">Traffic Back Url</label>
                                <div>
                                    <input type="text" class="form-control" name="traffic_back" id="traffic_back" value="{{ setting('traffic_back') ?? old('traffic_back') }}">
                                </div>
                            </div>

                            <div class="form-group mb-3 ">
                                <label class="form-label">Auto invoice</label>
                                <div>
                                    <select name="auto_invoice" id="" class="form-control">
                                        <option {{ setting('auto_invoice') == 'on' ? 'selected' : '' }} value="on">On</option>
                                        <option {{ setting('auto_invoice') == 'off' ? 'selected' : '' }} value="off">Off</option>
                                        
                                    </select>
                                </div>
                            </div>

                            <div class="form-group mb-3 ">
                                <label class="form-label">Invoice schedule</label>
                                <div>
                                    <select name="invoice_schedule" id="" class="form-control">
                                        <option {{ setting('invoice_schedule') == 'net7' ? 'selected' : '' }} value="net7">Net 7</option>
                                        <option {{ setting('invoice_schedule') == 'net15' ? 'selected' : '' }} value="net15">Net 15</option>
                                        <option {{ setting('invoice_schedule') == 'net30' ? 'selected' : '' }} value="net30">Net 30</option>
                                    </select>
                                </div>
                            </div>

                            <div class="form-group mb-3 ">
                                <label class="form-label">Minimum invoice amount</label>
                                <div>
                                   <input type="number" name="minimum_invoice" value="{{ setting('minimum_invoice')}}" class="form-control">
                                </div>
                            </div>
                            <div class="form-group mb-3 ">
                                <label class="form-label">Detect Frauds</label>
                                <div>
                                    <select name="fraud_detect" id="" class="form-control">
                                        <option {{ setting('fraud_detect') == 'active' ? 'selected' : '' }} value="active">Active</option>
                                        <option {{ setting('fraud_detect') == 'inactive' ? 'selected' : '' }} value="inactive">Disabled</option>
                                        
                                    </select>
                                </div>
                            </div>
                            <div class="form-group mb-3 ">
                                <label class="form-label">Ip quality score api key</label>
                                <div>
                                   <input type="text" name="ip_score_api_key" value="{{ setting('ip_score_api_key')}}" class="form-control">
                                </div>
                            </div>
                            <div class="form-group mb-3 ">
                                <label class="form-label">Scroll text</label>
                                <div>
                                    <textarea name="scroll_text" class="form-control" placeholder="Set empty if don't want scroll text">{{ setting('scroll_text')}}</textarea>
                                </div>
                            </div>
                            <div class="form-footer">
                                <button type="submit" class="btn btn-primary">Update</button>
                            </div>
                        </div>
                    </div>
                </div>
                 </div>
            </form>
        </div>
    </div>
@endsection

@push('js')
    <script src="https://cdn.jsdelivr.net/npm/tom-select@2.0.1/dist/js/tom-select.complete.min.js"></script>
    <script>
        new TomSelect('#site_time_zone',{
            plugins: ['input_autogrow'],
        });
        new TomSelect('#manager_id',{
            plugins: ['input_autogrow'],
        });

    </script>
@endpush
