@extends('layouts.backend.admin_sash')


@section('title','Mail Settings')


@push('css')
    <link href="https://cdn.jsdelivr.net/npm/tom-select@2.0.1/dist/css/tom-select.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/tom-select@2.0.1/dist/css/tom-select.bootstrap5.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.css" rel="stylesheet">
@endpush

@section('content')
    <div class="container-xl">
        <!-- Page title -->
        <div class="page-header d-print-none">
            <div class="row align-items-center">
                <div class="col">
                    <!-- Page pre-title -->
                    <div class="page-pretitle">
                        Overview
                    </div>
                    <h2 class="page-title">
                        @yield(('title'))
                    </h2>
                </div>
                <!-- Page title actions -->
            </div>
        </div>
    </div>
    <div class="page-body">
        <div class="container-xl">
            <form action="{{ route('admin.setting.mail.update')  }}" method="post" >
                @method('PUT')
                @csrf
                <div class="row row-cards">
                    <div class="col-md-3">
                        <div class="card">
                            <div class="list-group">
                                @include('admin.settings.sidebar')
                            </div>
                        </div>
                    </div>
                    <div class="col-md-9">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">Mail Setting</h3>
                        </div>
                        @include('layouts.backend.partials.flash-message')
                        @if ($errors->any())
                            <div class="alert alert-danger">
                                <ul>
                                    @foreach ($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        @endif
                        <div class="card-body">
                            <div class="form-group mb-3 ">
                                <label class="form-label">Mail Driver</label>
                                <div>
                                    <input type="text" class="form-control" name="mail_driver" value="{{ setting('mail_driver') ?? old('mail_driver') }}" placeholder="ex:smtp" required>
                                </div>
                                @error('mail_driver')
                                    <div class="error">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="form-group mb-3 ">
                                <label class="form-label">Mail Host</label>
                                <div>
                                    <input type="text" class="form-control" name="mail_host" value="{{ setting('mail_host') ?? old('mail_host') }}" placeholder="ex: mail.example.com" required>
                                </div>
                                @error('mail_host')
                                    <div class="error">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="form-group mb-3 ">
                                <label class="form-label">Mail Port</label>
                                <div>
                                    <input type="text" class="form-control" name="mail_port" value="{{ setting('mail_port') ?? old('mail_port') }}" placeholder="ex: 465,25,587" required>
                                </div>
                                @error('mail_port')
                                <div class="error">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="form-group mb-3 ">
                                <label class="form-label">Mail Username</label>
                                <div>
                                    <input type="text" class="form-control" name="mail_username" value="{{ setting('mail_username') ?? old('mail_username') }}" placeholder="ex: test@example.com" required>
                                </div>
                                @error('mail_username')
                                <div class="error">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="form-group mb-3 ">
                                <label class="form-label">Mail Password</label>
                                <div>
                                    <input type="password" class="form-control" name="mail_password" value="{{ setting('mail_password') ?? old('mail_password') }}" placeholder="ex: smtp password" required>
                                </div>
                                @error('mail_password')
                                    <div class="error">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="form-group mb-3 ">
                                <label class="form-label">Mail Encryption</label>
                                <div>
                                    <input type="text" class="form-control" name="mail_encryption" value="{{ setting('mail_encryption') ?? old('mail_encryption') }}" placeholder="ex: SSL,TLS" required>
                                </div>
                                @error('mail_password')
                                    <div class="error">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="form-group mb-3 ">
                                <label class="form-label">Mail From</label>
                                <div>
                                    <input type="text" class="form-control" name="mail_from_address" value="{{ setting('mail_from_address') ?? old('mail_from_address') }}" placeholder="ex: test@example.com" required>
                                </div>
                                @error('mail_from_address')
                                    <div class="error">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="form-footer">
                                <button type="submit" class="btn btn-primary">Update</button>
                            </div>
                        </div>
                    </div>
                </div>
                 </div>
            </form>
        </div>
    </div>
@endsection

@push('js')
    <script src="https://cdn.jsdelivr.net/npm/tom-select@2.0.1/dist/js/tom-select.complete.min.js"></script>
    <script>
        new TomSelect('#site_time_zone',{
            plugins: ['input_autogrow'],
        });
        new TomSelect('#manager_id',{
            plugins: ['input_autogrow'],
        });

    </script>
@endpush
