@extends('layouts.backend.admin_sash')


@section('title','Register Question')


@push('css')
    <link href="https://cdn.jsdelivr.net/npm/tom-select@2.0.1/dist/css/tom-select.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/tom-select@2.0.1/dist/css/tom-select.bootstrap5.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.css" rel="stylesheet">
@endpush

@section('content')
    <div class="container-xl">
        <!-- Page title -->
        <div class="page-header d-print-none">
            <div class="row align-items-center">
                <div class="col">
                    <!-- Page pre-title -->
                    <div class="page-pretitle">
                        Overview
                    </div>
                    <h2 class="page-title">
                        @yield(('title'))
                    </h2>
                </div>
                <!-- Page title actions -->
            </div>
        </div>
    </div>
    <div class="page-body">
        <div class="container-xl">
            <div class="row">
                @method('PUT')
                @csrf
                <div class="row row-cards">
                    <div class="col-md-3">
                        <div class="card">
                            <div class="list-group">
                                @include('admin.settings.sidebar')
                            </div>
                        </div>
                    </div>
                    <div class="col-md-9">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">Register Question</h3>
                            <a href="#" class="btn m-auto pull-right" data-bs-toggle="modal" data-bs-target="#modal-team">
                                Add Question
                            </a>
                        </div>
                        @include('layouts.backend.partials.flash-message')
                        @if ($errors->any())
                            <div class="alert alert-danger">
                                <ul>
                                    @foreach ($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        @endif
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-hover table-outline table-vcenter text-nowrap card-table">
                                    <thead>
                                    <tr>
                                        <th>Question</th>
                                        <th>Placeholder</th>
                                        <th>Required Status</th>
                                        <th>Created At</th>
                                        <th>Action</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @foreach($questions as $question)
                                        <tr>
                                            <td>
                                                <div class="btn btn-default btn-sm">{{ $question->name }}</div>
                                            </td>
                                            <td>
                                                <div class="btn btn-default btn-sm">{{ $question->placeholder }}</div>
                                            </td>
                                            <td>
                                                <div>
                                                    @if($question->required == 1)
                                                        <span class="badge bg-success">Required</span>
                                                    @else
                                                        <span class="badge bg-danger">Optional</span>
                                                    @endif
                                                </div>
                                            </td>
                                            <td>
                                                <div class="btn-group">
                                                    {{ $question->created_at->diffForHumans() }}
                                                </div>
                                            </td>
                                            <td>
                                                <a href="{{ route('admin.setting.question.delete',$question->id) }}" class="btn btn-danger btn-sm" onclick="return confirm('are u sure to delete?')">
                                                    <i class="fa fa-trash"></i>
                                                </a>
                                            </td>
                                            @endforeach
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <div class="modal modal-blur fade" id="modal-team" tabindex="-1" role="dialog" aria-hidden="true">
                            <div class="modal-dialog modal-dialog-centered" role="document">
                                <form action="{{ route('admin.setting.question') }}" method="post">
                                    @csrf
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <h5 class="modal-title">Add a Question</h5>
                                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                        </div>
                                        <div class="modal-body">
                                            <div class="row mb-3 align-items-end">
                                                <div class="col">
                                                    <label class="form-label">Name</label>
                                                    <input type="text" name="name" class="form-control" required />
                                                </div>
                                            </div>
                                            <div class="row mb-3 align-items-end">
                                                <div class="col">
                                                    <label class="form-label">Placeholder</label>
                                                    <input type="text" name="placeholder"  class="form-control" required />
                                                </div>
                                            </div>
                                            <div class="row mb-3 align-items-end">
                                                <div class="col">
                                                    <label class="form-label">Required Status</label>
                                                    <select name="status" id="status" class="form-control ">
                                                        <option value="0">Optional</option>
                                                        <option value="1">Required</option>
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="modal-footer">
                                            <button type="button" class="btn me-auto" data-bs-dismiss="modal">Close</button>
                                            <button type="submit" class="btn btn-primary" data-bs-dismiss="modal">Create</button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

@endsection

@push('js')
    <script src="https://cdn.jsdelivr.net/npm/tom-select@2.0.1/dist/js/tom-select.complete.min.js"></script>
    <script>
        new TomSelect('#site_time_zone',{
            plugins: ['input_autogrow'],
        });
        new TomSelect('#manager_id',{
            plugins: ['input_autogrow'],
        });

    </script>
@endpush
