﻿@extends('layouts.backend.affiliate_sash')

@section('title', 'Edit Profile')

@push('css')
    <link href="https://cdn.jsdelivr.net/npm/tom-select@2.0.1/dist/css/tom-select.bootstrap5.min.css" rel="stylesheet">
    {{-- Assuming your custom app.css includes necessary styles --}}
    <link href="{{ asset('css/app.css') }}" rel="stylesheet">
@endpush

@section('content')

    <div class="page-header d-print-none">
        <div class="row align-items-center">
            <div class="col">
                <h2 class="page-title">
                    <i class="fa fa-user-circle me-2"></i> Affiliate Profile Settings
                </h2>
            </div>
        </div>
    </div>

    <div class="page-body">
        <div class="row">
            {{-- Sidebar Navigation (Tabs) --}}
            <div class="col-lg-3 col-md-4">
                <div class="list-group list-group-transparent mb-3" role="tablist">
                    <a class="list-group-item list-group-item-action d-flex align-items-center active"
                        id="personal-preference-tab" data-bs-toggle="list" href="#personal-preference" role="tab"
                        aria-controls="personal-preference" aria-selected="true">
                        <i class="fa fa-cog me-2"></i> Personal Preferences
                    </a>
                    <a class="list-group-item list-group-item-action d-flex align-items-center" id="payment-info-tab"
                        data-bs-toggle="list" href="#payment-info" role="tab" aria-controls="payment-info"
                        aria-selected="false">
                        <i class="fa fa-credit-card me-2"></i> Payment Info
                    </a>

                    @if (!empty($finances) && $finances->contains('name', 'Bank'))
                        <a class="list-group-item list-group-item-action d-flex align-items-center" id="bank-info-tab"
                            data-bs-toggle="list" href="#bank-info" role="tab" aria-controls="bank-info"
                            aria-selected="false">
                            <i class="fa fa-university me-2"></i> Bank Info
                        </a>
                    @endif

                    <a class="list-group-item list-group-item-action d-flex align-items-center" id="referral-log-tab"
                        data-bs-toggle="list" href="#referral-log" role="tab" aria-controls="referral-log"
                        aria-selected="false">
                        <i class="fa fa-users me-2"></i> Referral Log
                    </a>
                </div>
            </div>

            {{-- Main Content (Tab Panes) --}}
            <div class="col-lg-9 col-md-8">
                <div class="tab-content">

                    {{-- 1. Personal Preference Tab --}}
                    <div class="tab-pane fade show active" id="personal-preference" role="tabpanel"
                        aria-labelledby="personal-preference-tab">
                        <form action="{{ route('affiliate.account.update') }}" method="post" enctype="multipart/form-data">
                            @csrf
                            @method('PUT')

                            <div class="card">
                                <div class="card-header">
                                    <h3 class="card-title">Update Personal Information & Password</h3>
                                </div>
                                <div class="card-body">
                                    {{-- Flash Messages & Errors --}}
                                    @include('layouts.backend.partials.flash-message')
                                    @if ($errors->any())
                                        <div class="alert alert-danger">
                                            <ul class="mb-0">
                                                @foreach ($errors->all() as $error)
                                                    <li>{{ $error }}</li>
                                                @endforeach
                                            </ul>
                                        </div>
                                    @endif
                                    
                                    {{-- Avatar --}}
                                    <div class="mb-3 d-flex align-items-end">
                                        <div class="avatar avatar-xl me-3"
                                            style="background-image: url('{{ Auth::user()->getAvatarUrl() ?: asset('images/default-avatar.png') }}')">
                                        </div>
                                        <div>
                                            <label for="avatarInput" class="form-label">Change Avatar</label>
                                            <input type="file" name="avatar" class="form-control" id="avatarInput">
                                        </div>
                                    </div>

                                    <h4 class="mb-3 text-primary">Personal Details</h4>

                                    {{-- First Name and Last Name --}}
                                    <div class="row mb-3">
                                        <div class="col-md-6">
                                            <label for="firstNameInput" class="form-label">First Name</label>
                                            <input type="text" class="form-control" name="first_name" id="firstNameInput"
                                                value="{{ Auth::user()->first_name ?? old('first_name') }}">
                                            @error('first_name') <small class="text-danger">{{ $message }}</small> @enderror
                                        </div>
                                        <div class="col-md-6">
                                            <label for="lastNameInput" class="form-label">Last Name</label>
                                            <input type="text" class="form-control" name="last_name" id="lastNameInput"
                                                value="{{ Auth::user()->last_name ?? old('last_name') }}">
                                            @error('last_name') <small class="text-danger">{{ $message }}</small> @enderror
                                        </div>
                                    </div>

                                    {{-- Email and Skype --}}
                                    <div class="row mb-3">
                                        <div class="col-md-6">
                                            <label for="emailInput" class="form-label">Email</label>
                                            <input type="email" class="form-control" name="email" id="emailInput"
                                                value="{{ Auth::user()->email ?? old('email') }}" readonly disabled>
                                            <small class="form-text text-muted">Email cannot be changed.</small>
                                            @error('email') <small class="text-danger">{{ $message }}</small> @enderror
                                        </div>

                                        <div class="col-md-6">
                                            <label for="skypeInput" class="form-label">Skype (Optional)</label>
                                            <input type="text" class="form-control" name="skype" id="skypeInput"
                                                value="{{ Auth::user()->skype ?? old('skype') }}">
                                        </div>
                                    </div>

                                    {{-- Country Select --}}
                                    <div class="mb-4">
                                        <label for="country_id" class="form-label">Country</label>
                                        <select name="country_id" class="form-select" id="country_id">
                                            <option value="" disabled>Select Country</option>
                                            @foreach ($countries as $country)
                                                <option {{ Auth::user()->country_id == $country->id ? 'selected' : '' }}
                                                    value="{{ $country->id }}">{{ $country->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>

                                    <h4 class="mb-3 text-primary">Change Password</h4>

                                    {{-- Password Inputs --}}
                                    <div class="mb-3">
                                        <label for="currentPasswordInput" class="form-label">Current Password</label>
                                        <input type="password" name="old_password" class="form-control" id="currentPasswordInput">
                                    </div>

                                    <div class="row mb-3">
                                        <div class="col-md-6">
                                            <label for="newPasswordInput" class="form-label">New Password</label>
                                            <input type="password" name="password" class="form-control" id="newPasswordInput">
                                            <small class="form-text text-muted">
                                                Your password must be 6-20 characters long.
                                            </small>
                                        </div>
                                        <div class="col-md-6">
                                            <label for="confirmPasswordInput" class="form-label">Confirm New Password</label>
                                            <input type="password" name="password_confirmation" class="form-control"
                                                id="confirmPasswordInput">
                                        </div>
                                    </div>
                                </div>
                                <div class="card-footer text-end">
                                    <button type="submit" class="btn btn-primary mybtnMain submit">Update Profile</button>
                                </div>
                            </div>
                        </form>
                    </div>

                    {{-- 2. Payment Info Tab (Non-Bank) --}}
                    <div class="tab-pane fade" id="payment-info" role="tabpanel" aria-labelledby="payment-info-tab">
                        <div class="card">
                            <div class="card-header">
                                <h3 class="card-title">Update General Payment Wallet</h3>
                            </div>
                            <div class="card-body">
                                @if ($message = Session::get('payment_info_success'))
                                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                                        <strong>{{ $message }}</strong>
                                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                                    </div>
                                @endif
                                @if ($errors->any())
                                    <div class="alert alert-danger">
                                        <ul class="mb-0">
                                            @foreach ($errors->all() as $error)
                                                <li>{{ $error }}</li>
                                            @endforeach
                                        </ul>
                                    </div>
                                @endif

                                <form action="{{ route('affiliate.account.paymentUpdate') }}" method="POST">
                                    @csrf

                                    {{-- Payment Method Select --}}
                                    <div class="mb-3">
                                        <label class="form-label">Payment Method</label>
                                        <select name="finance_id" class="form-select" id="finance_id"
                                            placeholder="Select a Payment Method...">
                                            @foreach ($finances as $finance)
                                                @if ($finance->name != 'Bank')
                                                    <option
                                                        @isset(Auth::user()->paymentMethod) {{ Auth::user()->paymentMethod->finance_id == $finance->id ? 'selected' : '' }} @endisset
                                                        value="{{ $finance->id }}">{{ $finance->name }}</option>
                                                @endif
                                            @endforeach
                                        </select>
                                    </div>

                                    {{-- Wallet/Account Details --}}
                                    <div class="mb-3" id="wallet-field">
                                        <label class="form-label">Wallet/Account Details (e.g., PayPal email, Crypto address)</label>
                                        @php
                                            $isBank = isset(Auth::user()->paymentMethod) && Auth::user()->paymentMethod->finance && Auth::user()->paymentMethod->finance->name === 'Bank';
                                            $wallet_value = !$isBank ? (Auth::user()->paymentMethod->wallet ?? old('wallet')) : '';
                                        @endphp
                                        <textarea name="wallet" id="wallet" class="form-control" rows="3">{{ $wallet_value }}</textarea>
                                        <small class="form-text text-muted">Enter your payment account details for the selected method.</small>
                                    </div>

                                    <div class="form-footer text-end">
                                        <button type="submit" class="btn btn-primary mybtnMain">Update Payment Info</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>

                    {{-- 3. Bank Info Tab (Conditional) --}}
                    @if (!empty($finances) && $finances->contains('name', 'Bank'))
                        @php
                            $bankFinance = $finances->firstWhere('name', 'Bank');
                            $wallet_data = [];
                            if (Auth::user()->paymentMethod && Auth::user()->paymentMethod->finance_id == $bankFinance->id && Auth::user()->paymentMethod->wallet) {
                                $wallet_data = json_decode(Auth::user()->paymentMethod->wallet, true);
                            }
                        @endphp
                        <div class="tab-pane fade" id="bank-info" role="tabpanel" aria-labelledby="bank-info-tab">
                            <div class="card">
                                <div class="card-header">
                                    <h3 class="card-title">Bank Transfer Information</h3>
                                </div>
                                <div class="card-body">

                                    @if ($message = Session::get('payment_info_success'))
                                        <div class="alert alert-success alert-dismissible fade show" role="alert">
                                            <strong>{{ $message }}</strong>
                                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                                        </div>
                                    @endif

                                    @if ($errors->any())
                                        <div class="alert alert-danger">
                                            <ul class="mb-0">
                                                @foreach ($errors->all() as $error)
                                                    <li>{{ $error }}</li>
                                                @endforeach
                                            </ul>
                                        </div>
                                    @endif

                                    <form action="{{ route('affiliate.account.paymentUpdate') }}" method="POST">
                                        @csrf

                                        <div class="row">
                                            {{-- Bank Name --}}
                                            <div class="col-md-6 mb-3">
                                                <label class="form-label">Bank Name</label>
                                                <input type="text" name="bank_name" class="form-control"
                                                    value="{{ $wallet_data['bank_name'] ?? old('bank_name') }}">
                                            </div>

                                            {{-- Account Number --}}
                                            <div class="col-md-6 mb-3">
                                                <label class="form-label">Account Number / IBAN</label>
                                                <input type="text" name="account_number" class="form-control"
                                                    value="{{ $wallet_data['account_number'] ?? old('account_number') }}">
                                            </div>
                                        </div>

                                        <div class="row">
                                            {{-- Routing (ABA) --}}
                                            <div class="col-md-4 mb-3">
                                                <label class="form-label">Routing Number (ABA)</label>
                                                <input type="text" name="routing_number" class="form-control"
                                                    value="{{ $wallet_data['routing_number'] ?? old('routing_number') }}">
                                            </div>

                                            {{-- SWIFT Code --}}
                                            <div class="col-md-4 mb-3">
                                                <label class="form-label">SWIFT / BIC Code</label>
                                                <input type="text" name="swift_code" class="form-control"
                                                    value="{{ $wallet_data['swift_code'] ?? old('swift_code') }}">
                                            </div>
                                             {{-- Beneficiary Name --}}
                                            <div class="col-md-4 mb-3">
                                                <label class="form-label">Beneficiary Name</label>
                                                <input type="text" name="beneficiary_name" class="form-control"
                                                    value="{{ $wallet_data['beneficiary_name'] ?? old('beneficiary_name') }}">
                                            </div>
                                        </div>


                                        {{-- Add Bank to Payment Method Checkbox (Hidden Field for finance_id and Checkbox for selection) --}}
                                        <input type="hidden" name="finance_id_bank_update" value="{{ $bankFinance->id }}">
                                        <div class="mb-3 form-check">
                                            <input type="checkbox" class="form-check-input" name="use_bank_method"
                                                id="bankFinanceCheck" value="1"
                                                @if (isset(Auth::user()->paymentMethod) && Auth::user()->paymentMethod->finance_id == $bankFinance->id) checked @endif>
                                            <label class="form-check-label" for="bankFinanceCheck">
                                                Set Bank as your **Preferred Payment Method**
                                            </label>
                                        </div>

                                        <div class="form-footer text-end">
                                            <button type="submit" class="btn btn-primary mybtnMain">Update Bank Info</button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    @endif


                    {{-- 4. Referral Log Tab --}}
                    <div class="tab-pane fade" id="referral-log" role="tabpanel" aria-labelledby="referral-log-tab">
                        <div class="card">
                            <div class="card-header">
                                <h3 class="card-title">Referral Log and Link</h3>
                            </div>
                            <div class="card-body">
                                <div class="mb-4">
                                    <label class="form-label">Your Unique Referral Link</label>
                                    <div class="input-group">
                                        <input type="text" id="referralLink" class="form-control"
                                            value="{{ route('register') }}?refer_id={{ Auth::user()->id }}"
                                            aria-label="Referral Link" readonly>
                                        <button class="btn btn-primary" type="button" id="copyButton">
                                            <i class="fa fa-clipboard me-2"></i> Copy Link
                                        </button>
                                    </div>
                                </div>

                                <h4>Your Referred Users</h4>
                                <div class="table-responsive">
                                    <table class="table table-hover table-vcenter">
                                        <thead>
                                            <tr>
                                                <th>Name</th>
                                                <th>Email</th>
                                                <th class="text-end">Total Earned</th>
                                                <th class="text-end">Your Commission</th>
                                                <th>Join Date</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @forelse ($refer_list as $r)
                                                <tr>
                                                    <td>{{ $r->first_name }}</td>
                                                    <td>{{ $r->email }}</td>
                                                    <td class="text-end">{{ $r->balance }}</td>
                                                    <td class="text-end">{{ referedCommission(Auth::user()->id, $r->id) }}</td>
                                                    <td>{{ $r->created_at->format('d M Y') }}</td>
                                                </tr>
                                            @empty
                                                <tr>
                                                    <td colspan="5" class="text-center text-muted">No referrals found yet. Start sharing your link!</td>
                                                </tr>
                                            @endforelse
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

@endsection

@push('js')
    <script src="https://cdn.jsdelivr.net/npm/tom-select@2.0.1/dist/js/tom-select.complete.min.js"></script>
    <script>
        // Initialize TomSelect for select fields
        new TomSelect('#country_id', {
            plugins: ['input_autogrow'],
        });
        new TomSelect('#finance_id', {
            plugins: ['input_autogrow'],
        });

        // Copy button functionality
        document.getElementById("copyButton").addEventListener("click", function() {
            var referralLinkInput = document.getElementById("referralLink");
            // Select the text field
            referralLinkInput.select();
            referralLinkInput.setSelectionRange(0, 99999); // For mobile devices

            // Copy the text inside the text field
            navigator.clipboard.writeText(referralLinkInput.value).then(() => {
                // Change button text temporarily on successful copy
                this.innerHTML = '<i class="fa fa-check me-2"></i> Copied!';
                setTimeout(() => {
                    this.innerHTML = '<i class="fa fa-clipboard me-2"></i> Copy Link';
                }, 2000);
            }).catch(err => {
                console.error('Could not copy text: ', err);
                alert("Failed to copy link. Please copy it manually.");
            });
        });
    </script>
@endpush