﻿@extends('layouts.backend.affiliate_sash')

@section('title', 'Postback')

@push('css')
    <link href="https://cdn.jsdelivr.net/npm/tom-select@2.0.1/dist/css/tom-select.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/tom-select@2.0.1/dist/css/tom-select.bootstrap5.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.css" rel="stylesheet">
    <script src="{{ asset('css/app.css') }}"></script>
@endpush
@section('content')


    <div class="page-body mt-0 ps-md-3 d-flex flex-wrap justify-content-between">
        <div class="col-12 tab-content " id="myTabContent">
            <div class="tab-pane mytab fade show active" id="postback" role="tabpanel" aria-labelledby="postback-tab">
                <div class="card">

                    @if ($message = Session::get('postback'))
                        <div class="alert alert-success alert-block">
                            <button type="button" class="close" data-dismiss="alert">Ã—</button>
                            <strong>{{ $message }}</strong>
                        </div>
                    @endif
                    @if ($errors->any())
                        <div class="alert alert-danger">
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif
                    <div class="card-body">
                        <div class="row mb-3 ">
                            <form class="col-12" action="{{ route('affiliate.account.postback') }}" method="POST">
                                @csrf
                                <div class="input-container">
                                    <input id="postback-url" type="text" class="form-control" name="url" value="{{ Auth::user()->postback->url ?? old('url') }}" placeholder=" "> 
                                    <label class="form-label" for="postback-url">Postback Url</label> <!-- Label after input -->
                                </div>
                               
                                <div class="form-footer mt-3">
                                    <button type="submit" class="btn mybtnMain submit">Update</button>
                                </div>
                                <br>
                            </form>
                        </div>
                    </div>
                </div>

                <div class="col-12 mt-5 d-flex flex-column gap-2 postback-wrapper">
                    <h1>How it works</h1>
                    <p class="m-0 p-0 postback-title">Available options:</p>
                    <p class="text-danger">http://pattern.domain.ru/random.php?var=value&varN=value</p>

                    <p class="m-0 p-0 postback-title">Available options:</p>
                    <p class="d-flex gap-2 p-0 m-0"><span class="text-danger">{aff_click_id}</span> click id </p>
                    <p class="d-flex gap-2 p-0 m-0"><span class="text-danger">{payout}</span> payout </p>
                    <p class="d-flex gap-2 p-0 m-0"><span class="text-danger">{aff_sub_1}</span> source 1 </p>
                    <p class="d-flex gap-2 p-0 m-0"><span class="text-danger">{aff_sub_2}</span> source 2 </p>
                    <p class="d-flex gap-2 p-0 m-0"><span class="text-danger">{aff_sub_3}</span> source 3 </p>
                </div>
            </div>
        </div>



    </div>

    </div>

    <script>
        document.addEventListener("DOMContentLoaded", function() {
            const tabs = document.querySelectorAll('.nav-link');
            tabs.forEach(tab => {
                tab.addEventListener('click', function(event) {
                    event.preventDefault();

                    const target = document.querySelector(this.getAttribute('href'));
                    const tabPanes = document.querySelectorAll('.tab-pane');

                    tabs.forEach(tab => tab.classList.remove('active'));
                    tabs.forEach(tab => tab.classList.remove(
                        'show')); // Remove 'show' from all tabs

                    tab.classList.add('active');
                    target.classList.add('show'); // Add 'show' to the target tab

                    tabPanes.forEach(pane => pane.classList.remove('active', 'show'));
                    target.classList.add('active',
                        'show'); // Add both 'active' and 'show' to the target pane
                });
            });
        });
    </script>

@endsection

@push('js')
    <script src="https://cdn.jsdelivr.net/npm/tom-select@2.0.1/dist/js/tom-select.complete.min.js"></script>
    <script src="{{ asset('js/app.js') }}"></script>
    <script>
        new TomSelect('#country_id', {
            plugins: ['input_autogrow'],
        });
        new TomSelect('#finance_id', {
            plugins: ['input_autogrow'],
        });
    </script>
@endpush


