﻿@extends('layouts.backend.affiliate_sash')
@section('title', 'Announcements')

@section('content')


    <div class="page-body mt-0">
        <div class="d-flex flex-column">
            <div class="col-12 mt-0">
                <div class="card">
                    <div class="table-responsive s-shadow">
                        <table class="table table-vcenter table-mobile-md card-table">
                            <thead>
                                <tr>
                                    <th class="top-left">Photo</th>
                                    <th>Title</th>
                                    <th>Date</th>
                                    <th>View</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($announcements as $a)
                                <tr>
                                    <td data-label="Photo">
                                        <img src="{{ asset(Storage::url($a->photo)) }}" width="80" alt="">
                                    </td>
                                    <td data-label="Title">
                                        <div>{{ $a->title }}</div>
                                    </td>
                                   
                                    <td data-label="Date">
                                        <div>{{ $a->created_at->format('d F y H:m') }}</div>
                                    </td>
                                    <td>
                                        <a style="min-width:fit-content;padding:5px 8px" href="{{ route('affiliate.announcement.show',$a->id) }}" class="btn mybtnMain btn-sm">
                                            <i class="fa fa-eye"></i>
                                        </a>
                                        
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>

                    </div>
                </div>
            </div>
        </div>

    </div>
@endsection


