﻿@extends('layouts.backend.affiliate_sash')

    @section('title', 'Dashboard')

    @push('css')
    <style>
        /* Compact daterangepicker */
        .daterangepicker { font-size: 12px; }
        .daterangepicker .drp-calendar { max-width: 230px; }
        .daterangepicker .calendar-table th,
        .daterangepicker .calendar-table td { width: 28px; height: 28px; }
        .daterangepicker .ranges li { padding: 4px 8px; font-size: 12px; }
        .daterangepicker .drp-buttons .btn { padding: 2px 8px; font-size: 12px; }
        /* Single-calendar look: hide the right calendar */
        .daterangepicker .drp-calendar.right { display: none !important; }
        .daterangepicker .drp-calendar.left { border-right: 0; }
        /* Custom compact calendar */
        .drp-compact { border-radius: 0 !important; }
        .drp-compact .day-btn { border: 0; background: transparent; padding: 4px 0; font-size: 12px; border-radius: 0 !important; }
        .drp-compact .day-muted { color: #9ba6b5; }
        .drp-compact .in-range { background: rgba(108,95,252,0.08); }
        .drp-compact .start, .drp-compact .end { background: #6c5ffc; color: #fff; border-radius: 0 !important; }
        .drp-compact .today { outline: 1px dashed rgba(108,95,252,0.5); }
        
        /* Dark mode table headers */
        .dark-mode .table-light {
            background-color: #2a2a4a !important;
            color: #e2e8f0 !important;
        }
    </style>
    @endpush
@section('content')
    @php
        if (Request::get('date_filter')) {
            switch ($request->date_filter) {
                case 'today':
                    $time = 'Today';
                    break;
                case '7D':
                    $time = 'Last 7 days';
                    break;
                case '14D':
                    $time = 'Last 14 days';
                    break;
                case '30D':
                    $time = 'Last 30 days';
                    break;
                case '90D':
                    $time = 'Last 90 days';
                    break;
                default:
                    $time = 'Today';
                    break;
            }
        } else {
            $time = 'Today';
        }
    @endphp
    @php
        $payoutTotalCurrent = collect($chartData ?? [])->sum('payout');
    @endphp

    <div class="container-fluid">
        <div class="row g-3 align-items-center mb-3">
            <div class="col-auto"><h4 class="mb-0">Quick Stats</h4></div>
            <div class="col ms-auto">
                <div class="d-flex gap-2 justify-content-end align-items-center">
                    <button id="daterange-btn" type="button" class="btn btn-sm btn-outline-secondary d-flex align-items-center gap-2">
                        <i class="fe fe-calendar"></i>
                        <span id="daterange-label">Select range</span>
                    </button>
                    <div id="drp-popover" class="drp-compact shadow border bg-white" style="display:none; position:absolute; top:60px; right:16px; z-index:1050; width: 260px; border-radius: 0 !important;">
                        <div class="p-2 border-bottom d-flex align-items-center justify-content-between">
                            <button class="btn btn-xs btn-light" id="drp-prev" type="button"><i class="fe fe-chevron-left"></i></button>
                            <div id="drp-month" class="fw-semibold small"></div>
                            <button class="btn btn-xs btn-light" id="drp-next" type="button"><i class="fe fe-chevron-right"></i></button>
                        </div>
                        <div class="px-2 pt-2 pb-1 d-flex gap-1 flex-wrap">
                            <button type="button" class="btn btn-xs btn-outline-secondary" data-preset="today">Today</button>
                            <button type="button" class="btn btn-xs btn-outline-secondary" data-preset="7d">7D</button>
                            <button type="button" class="btn btn-xs btn-outline-secondary" data-preset="14d">14D</button>
                            <button type="button" class="btn btn-xs btn-outline-secondary" data-preset="30d">30D</button>
                        </div>
                        <div class="px-2 pt-2 pb-1">
                            <div class="d-grid" style="grid-template-columns: repeat(7, 1fr); gap: 2px;">
                                <div class="text-center text-muted" style="font-size:11px;">Su</div>
                                <div class="text-center text-muted" style="font-size:11px;">Mo</div>
                                <div class="text-center text-muted" style="font-size:11px;">Tu</div>
                                <div class="text-center text-muted" style="font-size:11px;">We</div>
                                <div class="text-center text-muted" style="font-size:11px;">Th</div>
                                <div class="text-center text-muted" style="font-size:11px;">Fr</div>
                                <div class="text-center text-muted" style="font-size:11px;">Sa</div>
                            </div>
                            <div id="drp-grid" class="d-grid mt-1" style="grid-template-columns: repeat(7, 1fr); gap: 2px;"></div>
                        </div>
                        <div class="d-flex justify-content-between align-items-center p-2 border-top">
                            <button type="button" id="drp-clear" class="btn btn-xs btn-light">Clear</button>
                            <div class="d-flex gap-1">
                                <button type="button" id="drp-cancel" class="btn btn-xs btn-light">Cancel</button>
                                <button type="button" id="drp-apply" class="btn btn-xs btn-primary">Apply</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="row g-3">
            <div class="col-12 col-sm-6 col-lg-3">
                    <div class="card overflow-hidden">
                        <div class="card-body">
                            <div class="d-flex">
                                <div class="mt-2">
                                    <h6 class="">Clicks</h6>
                                    <h2 class="mb-0 number-font">{{ $totalClick }}</h2>
                                <span class="text-muted fs-12">{{ $time }}</span>
                                </div>
                                <div class="ms-auto">
                                    <div class="chart-wrapper mt-1">
                                        <canvas id="saleschart" class="h-8 w-9 chart-dropshadow"></canvas>
                                    </div>
                                </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-12 col-sm-6 col-lg-3">
                    <div class="card overflow-hidden">
                        <div class="card-body">
                            <div class="d-flex">
                                <div class="mt-2">
                                    <h6 class="">Payout</h6>
                                    <h2 class="mb-0 number-font">{{ $totalPayout }}</h2>
                                <span class="text-muted fs-12">{{ $time }}</span>
                                </div>
                                <div class="ms-auto">
                                    <div class="chart-wrapper mt-1">
                                        <canvas id="leadschart" class="h-8 w-9 chart-dropshadow"></canvas>
                                    </div>
                                </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-12 col-sm-6 col-lg-3">
                    <div class="card overflow-hidden">
                        <div class="card-body">
                            <div class="d-flex">
                                <div class="mt-2">
                                <h6 class="">Conversion</h6>
                                    <h2 class="mb-0 number-font">{{ $totalConversion }}</h2>
                                <span class="text-muted fs-12">{{ $time }}</span>
                                </div>
                                <div class="ms-auto">
                                    <div class="chart-wrapper mt-1">
                                        <canvas id="profitchart" class="h-8 w-9 chart-dropshadow"></canvas>
                                    </div>
                                </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-12 col-sm-6 col-lg-3">
                    <div class="card overflow-hidden">
                        <div class="card-body">
                            <div class="d-flex">
                                <div class="mt-2">
                                <h6 class="">EPC</h6>
                                    @php
                                        $totalClicksSeries = collect($chartData ?? [])->sum('clicks');
                                        $totalPayoutSeries = collect($chartData ?? [])->sum('payout');
                                        $epcVal = $totalClicksSeries ? ($totalPayoutSeries / $totalClicksSeries) : 0;
                                    @endphp
                                <h2 class="mb-0 number-font">{{ number_format($epcVal, 2) }}</h2>
                                <span class="text-muted fs-12">{{ $time }}</span>
                                </div>
                                <div class="ms-auto">
                                    <div class="chart-wrapper mt-1">
                                        <canvas id="costchart" class="h-8 w-9 chart-dropshadow"></canvas>
                                    </div>
                                </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="row g-3 mt-1">
            <div class="col-lg-8">
                <div class="card">
                    <div class="card-header">
                        <h6 class="card-title mb-0">Sales Analytics</h6>
                    </div>
                    <div class="card-body">
                        <div class="d-flex mx-auto text-center justify-content-center mb-3">
                            <div class="d-flex text-center justify-content-center me-3"><span class="dot-label bg-primary my-auto"></span>Clicks</div>
                            <div class="d-flex text-center justify-content-center"><span class="dot-label bg-secondary my-auto"></span>Conversions</div>
                        </div>
                        <div class="chartjs-wrapper-demo">
                            <canvas id="chartBar2" class="h-275 chart-dropshadow"></canvas>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-4">
                <div class="card h-100">
                    <div class="card-header">
                        <h6 class="card-title mb-0">Top Offers</h6>
                    </div>
                    <div class="card-body p-0">
                        @if($globalTopOffers->count() > 0)
                            <div class="table-responsive">
                                <table class="table table-hover mb-0">
                                    <thead class="table-light">
                                        <tr>
                                            <th class="border-0">Offer</th>
                                            <th class="border-0">Category</th>
                                            <th class="border-0">Payout</th>
                                            <th class="border-0">Status</th>
                                            <th class="border-0 text-center">Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($globalTopOffers as $topOffer)
                                            @if($topOffer->offer)
                                                <tr>
                                                    <td>
                                                        <div>
                                                            <h6 class="mb-0 fw-semibold">{{ $topOffer->offer->name }}</h6>
                                                            @if($topOffer->offer->type)
                                                                <small class="text-muted">{{ ucfirst($topOffer->offer->type) }}</small>
                                                            @endif
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <span class="badge bg-info-transparent text-info">
                                                            {{ $topOffer->offer->category->name ?? 'N/A' }}
                                                        </span>
                                                    </td>
                                                    <td>
                                                        <span class="fw-semibold text-success">
                                                            ${{ number_format($topOffer->offer->payout, 2) }}
                                                        </span>
                                                    </td>
                                                    <td>
                                                        <span class="badge bg-success-transparent text-success">
                                                            {{ ucfirst($topOffer->offer->status) }}
                                                        </span>
                                                    </td>
                                                    <td class="text-center">
                                                        <a href="{{ route('affiliate.offer.show', $topOffer->offer->id) }}" 
                                                           class="btn btn-sm btn-outline-primary">
                                                            <i class="fe fe-eye"></i>
                                                        </a>
                                                    </td>
                                                </tr>
                                            @endif
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        @else
                            <div class="text-center py-5">
                                <div class="mb-3">
                                    <span class="avatar avatar-lg bg-secondary-transparent text-secondary">
                                        <i class="fe fe-layers fs-24"></i>
                                    </span>
                                </div>
                                <h6 class="text-muted mb-2">No Top Offers Available</h6>
                                <p class="fs-13 text-muted mb-3">Check back later for featured offers</p>
                                <a href="{{ route('affiliate.offer.index') }}" class="btn btn-outline-primary btn-sm">
                                    <i class="fe fe-layers me-1"></i> Browse All Offers
                                </a>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>

        <!-- Chat UI and Manager Info Section - 8/4 Split -->
        <div class="row g-3 mt-1">
            <div class="col-lg-8">
                @include('components.chat-ui')
            </div>
            <div class="col-lg-4">
                @include('components.manager-info')
            </div>
        </div>

        <!--
        <div class="row g-3 mt-1">
            <div class="col-lg-4">
                <div class="card">
                    <div class="card-header"><h6 class="card-title mb-0">Country</h6></div>
                    <div class="card-body">
                        <div id="countryChart" style="height:224px"></div>
                    </div>
                </div>
            </div>
            <div class="col-lg-4">
                <div class="card">
                    <div class="card-header"><h6 class="card-title mb-0">Browser</h6></div>
                    <div class="card-body">
                        <div id="browserChart" style="height:224px"></div>
                    </div>
                </div>
            </div>
            <div class="col-lg-4">
                <div class="card">
                    <div class="card-header"><h6 class="card-title mb-0">Os</h6></div>
                    <div class="card-body">
                        <div id="osChart" style="height:224px"></div>
                    </div>
                </div>
            </div>
        </div>
        -->
        <div class="row g-3 mt-1">
            <div class="col-lg-6">
                <div class="card">
                    <div class="card-header"><h6 class="card-title mb-0">Offer ranking</h6></div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-striped mb-0">
                                <thead>
                                    <tr>
                                        <th>Name</th>
                                        <th>Click</th>
                                        <th>Conversion</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($top_offers as $offer)
                                        @if ($offer->reports_count > 0)
                                            <tr>
                                                <td><a href="{{ route('affiliate.offer.show', $offer->id) }}">({{ $offer->id }}) {{ $offer->name }}</a></td>
                                                <td>({{ $offer->reports_count }})</td>
                                                <td>({{ $offer->reports->count() }})</td>
                                            </tr>
                                        @endif
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-6">
                <div class="card">
                    <div class="card-header"><h6 class="card-title mb-0">Country ranking</h6></div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-striped mb-0">
                                <thead>
                                    <tr>
                                        <th>Country</th>
                                        <th>Click</th>
                                        <th>Conversion</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($top_countries as $country)
                                        @if ($country->reports_count > 0)
                                            <tr>
                                                <td>{{ $country->name }}</td>
                                                <td>({{ $country->reports_count }})</td>
                                                <td>({{ $country->reports->count() }})</td>
                                            </tr>
                                        @endif
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection


@push('js')
    <script src="{{ asset('assets/plugins/bootstrap-daterangepicker/moment.min.js') }}"></script>
    <script src="{{ asset('assets/plugins/chart/Chart.bundle.js') }}"></script>
    <script>
    document.addEventListener('DOMContentLoaded', function () {
        // Custom compact calendar
        var drBtn = document.getElementById('daterange-btn');
        var drLabel = document.getElementById('daterange-label');
        var pop = document.getElementById('drp-popover');
        var grid = document.getElementById('drp-grid');
        var monthEl = document.getElementById('drp-month');
        var prevEl = document.getElementById('drp-prev');
        var nextEl = document.getElementById('drp-next');
        var applyEl = document.getElementById('drp-apply');
        var cancelEl = document.getElementById('drp-cancel');
        var clearEl = document.getElementById('drp-clear');

        var qs = new URLSearchParams(window.location.search);
        var startQS = qs.get('start');
        var endQS = qs.get('end');
        var start = startQS ? moment(startQS, 'YYYY-MM-DD') : moment().subtract(6,'days').startOf('day');
        var end = endQS ? moment(endQS, 'YYYY-MM-DD') : moment().endOf('day');
        var current = (start || moment()).clone().startOf('month');

        function fmt(d){ return d ? d.format('YYYY-MM-DD') : ''; }
        function inRange(d){ if (start && end) return d.isSameOrAfter(start,'day') && d.isSameOrBefore(end,'day'); return false; }
        function renderCal(){
            monthEl.textContent = current.format('MMMM YYYY');
            grid.innerHTML = '';
            var begin = current.clone().startOf('month').startOf('week');
            var stop = current.clone().endOf('month').endOf('week');
            var it = begin.clone();
            while(it.isSameOrBefore(stop,'day')){
                var btn = document.createElement('button');
                btn.type = 'button';
                btn.className = 'day-btn w-100 text-center';
                btn.textContent = it.date();
                if (!it.isSame(current,'month')) btn.classList.add('day-muted');
                if (start && it.isSame(start,'day')) btn.classList.add('start');
                if (end && it.isSame(end,'day')) btn.classList.add('end');
                if (inRange(it)) btn.classList.add('in-range');
                if (it.isSame(moment(),'day')) btn.classList.add('today');
                (function(d){ btn.addEventListener('click', function(){
                    if (!start || (start && end)) { start = d.clone(); end = null; }
                    else if (d.isBefore(start,'day')) { end = start.clone(); start = d.clone(); }
                    else { end = d.clone(); }
                    renderCal();
                });})(it.clone());
                grid.appendChild(btn);
                it.add(1,'day');
            }
        }

        function openPop(){ pop.style.display = 'block'; document.addEventListener('click', onDoc, true); }
        function closePop(){ pop.style.display = 'none'; document.removeEventListener('click', onDoc, true); }
        function onDoc(e){ if (!pop.contains(e.target) && e.target !== drBtn) closePop(); }

        if (drLabel) { drLabel.textContent = fmt(start) + ' to ' + fmt(end); }

        if (drBtn) {
            drBtn.addEventListener('click', function(){
                if (pop.style.display === 'block') closePop(); else { renderCal(); openPop(); }
            });
        }
        prevEl.addEventListener('click', function(){ current.subtract(1,'month'); renderCal(); });
        nextEl.addEventListener('click', function(){ current.add(1,'month'); renderCal(); });
        cancelEl.addEventListener('click', closePop);
        clearEl.addEventListener('click', function(){ start=null; end=null; renderCal(); });
        // Preset buttons
        pop.querySelectorAll('[data-preset]').forEach(function(btn){
            btn.addEventListener('click', function(){
                var now = moment();
                var key = btn.getAttribute('data-preset');
                if (key === 'today') { start = now.clone().startOf('day'); end = now.clone().endOf('day'); }
                if (key === '7d') { start = now.clone().subtract(6,'days').startOf('day'); end = now.clone().endOf('day'); }
                if (key === '14d') { start = now.clone().subtract(13,'days').startOf('day'); end = now.clone().endOf('day'); }
                if (key === '30d') { start = now.clone().subtract(29,'days').startOf('day'); end = now.clone().endOf('day'); }
                if (drLabel) drLabel.textContent = fmt(start) + ' to ' + fmt(end);
                // Auto-apply on preset
                var params = new URLSearchParams(window.location.search);
                params.set('start', start.format('YYYY-MM-DD'));
                params.set('end', end.format('YYYY-MM-DD'));
                params.delete('date_filter');
                window.location.search = params.toString();
            });
        });
        applyEl.addEventListener('click', function(){
            if (!start) return; var s = start.clone(); var e = end ? end.clone() : start.clone();
            var params = new URLSearchParams(window.location.search);
            params.set('start', s.format('YYYY-MM-DD'));
            params.set('end', e.format('YYYY-MM-DD'));
            params.delete('date_filter');
            window.location.search = params.toString();
        });
        // Build dynamic data from $chartData
        const chartData = @json($chartData ?? []);
        const dates = chartData.map(i => String((i.date ?? i.day ?? '')));
        let clicks = chartData.map(i => Number((i.clicks ?? i.click ?? 0)));
        let conversions = chartData.map(i => Number((i.conversions ?? i.conversion ?? 0)));
        let payout = chartData.map(i => Number((i.payout ?? i.payouts ?? 0)));
        
        // Build hourly stats data for mini charts
        const hourlyStats = @json($hourlyStats ?? []);
        const hourlyClicks = Object.values(hourlyStats).map(s => Number(s.hourlyClick || 0));
        const hourlyConversions = Object.values(hourlyStats).map(s => Number(s.hourlyConversion || 0));
        const hourlyPayout = Object.values(hourlyStats).map(s => Number(s.hourlyPayout || 0));
        const hourlyLabels = Object.keys(hourlyStats);
        
        // Show different hours for bar charts vs line charts
        const now = new Date();
        const currentHour = now.getHours();
        
        // For bar charts: last 7 hours
        const startIdxBar = Math.max(0, currentHour - 6);
        const endIdxBar = Math.min(24, currentHour + 1);
        const recentClicks = hourlyClicks.slice(startIdxBar, endIdxBar);
        const recentConversions = hourlyConversions.slice(startIdxBar, endIdxBar);
        const recentLabels = hourlyLabels.slice(startIdxBar, endIdxBar);
        
        // For line charts: last 12 hours
        const startIdxLine = Math.max(0, currentHour - 11);
        const endIdxLine = Math.min(24, currentHour + 1);
        const recentPayout = hourlyPayout.slice(startIdxLine, endIdxLine);
        const recentLabelsLine = hourlyLabels.slice(startIdxLine, endIdxLine);
        // Helper to parse possibly formatted numbers (e.g., "1,234.56" or "$ 123.45")
        const toNum = (v) => {
            const s = String(v ?? '').replace(/[^0-9+\-.]/g, '');
            const n = s.length ? Number(s) : 0;
            return isNaN(n) ? 0 : n;
        };
        // PHP totals as fallback (may be formatted in Blade elsewhere)
        const totalClickFallback = toNum(@json($totalClick ?? 0));
        const totalConvFallback = toNum(@json($totalConversion ?? 0));
        const totalPayoutFallback = toNum(@json($totalPayout ?? 0));
        if (!clicks.length && totalClickFallback) clicks = [totalClickFallback];
        if (!conversions.length && totalConvFallback) conversions = [totalConvFallback];
        if (!payout.length && totalPayoutFallback) payout = [totalPayoutFallback];
        const seriesLen = Math.min(clicks.length || 0, payout.length || 0);
        let epc = Array.from({length: seriesLen}, (_, idx) => {
            const pv = payout[idx] || 0;
            const cv = clicks[idx] || 0;
            const val = cv ? (pv / cv) : 0;
            return isNaN(val) ? 0 : val;
        });
        if (!epc.length && (totalClickFallback || totalPayoutFallback)) {
            const val = totalClickFallback ? (totalPayoutFallback / totalClickFallback) : 0;
            epc = [ isNaN(val) ? 0 : val ];
        }

        // saleschart (Clicks as bar, cyan palette) - using hourly data
        var ctx = document.getElementById('saleschart'); if (ctx) {
            // Use recent hours (current hour going back 7 hours)
            const clicksSample = recentClicks;
            const labelsSample = recentLabels;
            
            new Chart(ctx.getContext('2d'), {
                type: 'bar',
                data: {
                    labels: labelsSample,
                    datasets: [{
                        barPercentage: 0.4, barThickness: 6, barGap: 0.5, maxBarThickness: 8, minBarLength: 2,
                        label: 'Clicks',
                        data: clicksSample,
                        backgroundColor: clicksSample.map((_, i) => (i % 2 === 1 ? '#05c3fb' : 'rgba(5,195,251,0.3)')),
                        borderColor: clicksSample.map((_, i) => (i % 2 === 1 ? '#05c3fb' : 'rgba(5,195,251,0.6)')),
                        borderWidth: 1, borderRadius: 2
                    }]
                },
                options: { maintainAspectRatio: false, plugins: { legend: { display: false }, tooltip: { enabled: false } }, responsive: true, scales: { x: { display: false, categoryPercentage: 0.6, barPercentage: 0.4 }, y: { display: false } }, elements: { point: { radius: 0 } } }
            });
        }

        // leadschart (Payout as line, pink #f46ef4) - using hourly data (last 12 hours)
        var ctx1 = document.getElementById('leadschart'); if (ctx1) {
            // compact height for mini sparkline
            if (ctx1 && ctx1.getContext) { ctx1.height = 40; }
            const payoutMini = recentPayout;
            new Chart(ctx1.getContext('2d'), {
                type: 'line',
                data: { labels: recentLabelsLine, datasets: [{ label: 'Payout', data: payoutMini, backgroundColor: 'transparent', borderColor: '#f46ef4', borderWidth: 2.5, pointBorderColor: 'transparent', pointBackgroundColor: 'transparent', tension: 0.4, cubicInterpolationMode: 'monotone', fill: false, pointRadius: 0 }] },
                options: { maintainAspectRatio: false, plugins: { legend: { display: false }, tooltip: { enabled: false } }, responsive: true, scales: { x: { display: false }, y: { display: false } }, elements: { line: { borderCapStyle: 'round', borderJoinStyle: 'round' }, point: { radius: 0 } } }
            });
        }

        // profitchart (Conversions as bar, green #4ecc48) - using hourly data
        var ctx2 = document.getElementById('profitchart'); if (ctx2) {
            // Use recent hours (current hour going back 7 hours)
            const conversionsSample = recentConversions;
            const labelsSample = recentLabels;
            
            new Chart(ctx2.getContext('2d'), {
                type: 'bar',
                data: { 
                    labels: labelsSample, 
                    datasets: [{ 
                        barPercentage: 0.4, barThickness: 6, maxBarThickness: 8, minBarLength: 2, 
                        label: 'Conversions', barGap: 0.5, barSizeRatio: 1, 
                        data: conversionsSample, 
                        backgroundColor: '#4ecc48', 
                        borderColor: '#4ecc48', 
                        borderWidth: 1, borderRadius: 2 
                    }] 
                },
                options: { maintainAspectRatio: false, plugins: { legend: { display: false }, tooltip: { enabled: false } }, responsive: true, scales: { x: { display: false, categoryPercentage: 0.6, barPercentage: 0.4 }, y: { display: false } }, elements: { point: { radius: 0 } } }
            });
        }

        // costchart (EPC as line, amber #f7ba48) - using hourly data (last 12 hours)
        var ctx3 = document.getElementById('costchart'); if (ctx3) {
            // compact height for mini sparkline
            if (ctx3 && ctx3.getContext) { ctx3.height = 40; }
            // Calculate EPC from hourly data for last 12 hours
            let hourlyEpc = hourlyClicks.map((clicks, idx) => {
                const payout = hourlyPayout[idx] || 0;
                return clicks ? (payout / clicks) : 0;
            });
            const epcMini = hourlyEpc.slice(startIdxLine, endIdxLine);
            new Chart(ctx3.getContext('2d'), {
                type: 'line',
                data: { labels: recentLabelsLine, datasets: [{ label: 'EPC', data: epcMini, backgroundColor: 'transparent', borderColor: '#f7ba48', borderWidth: 2.5, pointBorderColor: 'transparent', pointBackgroundColor: 'transparent', tension: 0.4, cubicInterpolationMode: 'monotone', fill: false, pointRadius: 0 }] },
                options: { maintainAspectRatio: false, plugins: { legend: { display: false }, tooltip: { enabled: false } }, responsive: true, scales: { x: { display: false }, y: { display: false } }, elements: { line: { borderCapStyle: 'round', borderJoinStyle: 'round' }, point: { radius: 0 } } }
            });
        }

        // Main: Bar Chart2 style (Clicks vs Conversions)
        var cbar2 = document.getElementById('chartBar2'); if (cbar2) {
            var ctxBar2 = cbar2.getContext('2d');
            new Chart(ctxBar2, {
                type: 'bar',
                data: {
                    labels: dates,
                    datasets: [
                        {
                            label: 'Clicks',
                            data: clicks,
                            backgroundColor: '#6c5ffc',
                            borderColor: '#6c5ffc',
                            borderWidth: 2,
                            barThickness: 8,
                        },
                        {
                            label: 'Conversions',
                            data: conversions,
                            backgroundColor: '#05c3fb',
                            borderColor: '#05c3fb',
                            borderWidth: 2,
                            barThickness: 8,
                        }
                    ]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    plugins: { legend: { display: false } },
                    scales: {
                        x: {
                            stacked: false,
                            grid: { display: false },
                            ticks: { color: '#9ba6b5', autoSkip: true }
                        },
                        y: {
                            beginAtZero: true,
                            grid: { color: 'rgba(119,119,142,0.2)' },
                            ticks: { color: '#9ba6b5' }
                        }
                    }
                }
            });
        }
    });
    </script>
@endpush


