﻿@extends('layouts.backend.affiliate_sash')

@section('title','Invoice')

@push('css')
    <link href="https://cdn.jsdelivr.net/npm/tom-select@2.0.1/dist/css/tom-select.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/tom-select@2.0.1/dist/css/tom-select.bootstrap5.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.css" rel="stylesheet">
@endpush

@section('content')

    <div class="page-body mt-0">
        <div class="">
            <div class="col-12 mt-0">
                <div class="card">
                    @include('layouts.backend.partials.flash-message')
                    <div class="table-responsive">
                        <table class="table table-vcenter table-mobile-md card-table">
                            <thead>
                            <tr>
                                <th class="top-left">ID</th>
                                <th>Finance Name</th>
                                <th>Conversion</th>
                                <th>Amount</th>
                                <th>Wallet</th>
                                <th>Start Date</th>
                                <th>End Date</th>
                                <th>Generate Time</th>
                                <th>Paid At</th>
                                <th class="top-right">Status</th>
                            </tr>
                            </thead>
                            <tbody>
                                @foreach($invoices as $invoice)
                                    <tr>
                                        <td>#{{ $invoice->id }}</td>
                                        <td>{{ $invoice->finance_name }}</td>
                                        <td>{{ $invoice->conversion }}</td>
                                        <td>{{ $invoice->amount }}</td>
                                        <td>{{ $invoice->wallet }}</td>

                                        <td>{{ $invoice->start_date }}</td>
                                        <td>{{ $invoice->end_date }}</td>
                                        <td>{{ $invoice->created_at }}</td>
                                        <td>{{ $invoice->paid_at }}</td>
                                        <td>
                                            @if ($invoice->status == false)
                                                <span class="badge bg-danger">Pending</span>
                                            @else
                                                <span class="badge bg-success">Paid</span>
                                            @endif
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                        <div style="margin: 0 auto;float: right">
                           {{ $invoices->withQueryString()->links() }}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('js')
    <script src="https://cdn.jsdelivr.net/npm/tom-select@2.0.1/dist/js/tom-select.complete.min.js"></script>
    <script>
        new TomSelect('#country_id',{
            plugins: ['input_autogrow'],
        });
        new TomSelect('#manager_id',{
            plugins: ['input_autogrow'],
        });
    </script>
@endpush


