@extends('layouts.backend.affiliate_sash')
@section('title', 'All Offers')

@push('css')
    <link href="https://cdn.jsdelivr.net/npm/tom-select@2.0.1/dist/css/tom-select.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/tom-select@2.0.1/dist/css/tom-select.bootstrap5.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.css" rel="stylesheet">
    <link href="{{ asset('backend/dist/css/tabler-flags.min.css') }}" rel="stylesheet" />
    <!-- DataTables Bootstrap 5 + Buttons CSS (CDN) -->
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.8/css/dataTables.bootstrap5.min.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.4.2/css/buttons.bootstrap5.min.css">
@endpush

@section('content')
    @php
        $id = request()->get('id');
        $status = request()->get('status');
        $name = request()->get('name');
        $category_id = request()->get('category_id');
        $device_id = request()->get('device_id');
        $country_id = request()->get('country_id');
        $type = request()->get('type');
    @endphp


    <div class="page-body mt-0">
        <div class="d-flex flex-column">
            <div class="col-12 mb-md-0 s-shadow mt-0">

                <form action="" class="card card-body p-3">
                    <input type="hidden" name="filter" value="filter">
                    <div class="row g-3 align-items-end">
                        <!-- Name -->
                        <div class="col-12 col-md-3">
                            <label class="form-label" for="name">Name</label>
                            <div class="input-group input-group-sm" style="min-height: calc(1.5em + .5rem + 2px)">
                                <span class="input-group-text"><i class="fa fa-search"></i></span>
                                <input name="name" id="name" type="text" class="form-control" value="{{ $name ?? old('name') }}" placeholder="Search by name">
                            </div>
                        </div>
                        <!-- Category -->
                        <div class="col-12 col-md-2">
                            <label class="form-label" for="category_id">Category</label>
                            <select name="category_id" class="form-select form-select-sm" id="category_id">
                                <option value="">All categories</option>
                                @foreach ($categories as $category)
                                    <option @isset($category_id) {{ $category_id == $category->id ? 'selected' : '' }} @endisset value="{{ $category->id }}">{{ $category->name }}</option>
                                @endforeach
                            </select>
                        </div>
                        <!-- Countries -->
                        <div class="col-12 col-md-3">
                            <label class="form-label" for="country_id">Countries</label>
                            <select multiple name="country_id[]" class="form-select form-select-sm" id="country_id" placeholder="Select countries">
                                @foreach ($countries as $country)
                                    <option @isset($country_id) @foreach ($country_id as $id) {{ $id == $country->id ? 'selected' : '' }} @endforeach @endisset value="{{ $country->id }}">{{ $country->name }}</option>
                                @endforeach
                            </select>
                        </div>
                        <!-- Status -->
                        <div class="col-12 col-md-2">
                            <label class="form-label" for="status">Status</label>
                            <select name="status" class="form-select form-select-sm" id="status">
                                <option value="" {{ $status == '' ? 'selected' : '' }}>All</option>
                                <option value="active" {{ $status == 'active' ? 'selected' : '' }}>Active</option>
                                <option value="requestApproved" {{ $status == 'requestApproved' ? 'selected' : '' }}>Request Approved</option>
                                <option value="Approval Pending" {{ $status == 'Approval Pending' ? 'selected' : '' }}>Approval Pending</option>
                                <option value="Approved" {{ $status == 'Approved' ? 'selected' : '' }}>Approved</option>
                            </select>
                        </div>
                        <!-- Actions -->
                        <div class="col-12 col-md-2 d-flex gap-2">
                            <button type="submit" class="btn btn-primary btn-sm flex-fill">Apply</button>
                            <button type="button" id="offerFiltersReset" class="btn btn-light btn-sm">Reset</button>
                        </div>
                    </div>
                </form>
            </div>

            <div class="col-12 mt-3">
                
                @if ($list)
                    <div class="row row-sm">
                        <div class="col-lg-12">
                            <div class="card">
                                <div class="card-header d-flex align-items-center justify-content-between">
                                    <h3 class="card-title mb-0">Offers</h3>
                                    <div class="btn-list d-none" id="offersTableActions"></div>
                                </div>
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table id="offers-table" class="table table-bordered border text-nowrap mb-0">
                                            <thead>
                                                <tr>
                                                    <th style="width:70px">Id</th>
                                                    <th>Name</th>
                                                    <th>Country</th>
                                                    <th>Device</th>
                                                    <th>Payout</th>
                                                    <th>Category</th>
                                                    <th>Vertical</th>
                                                    <th class="text-center">Actions</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach ($offers as $offer)
                                                    <tr>
                                                        <td>{{ $offer->id }}</td>
                                                        <td>
                                                            <div class="d-flex align-items-center gap-2">
                                                                <div>
                                                                    <a href="{{ route('affiliate.offer.show', $offer->id) }}" class="fw-semibold text-dark">{{ $offer->name }}</a>
                                                                    <div class="small text-muted">
                                                                        @php
                                                                            $application = \App\OfferApplication::where('offer_id', $offer->id)->where('user_id', Auth::user()->id)->first();
                                                                            $offer_blocked = Auth::user()->offers()->where('offer_id', $offer->id)->first();
                                                                        @endphp
                                                                        @if ($offer_blocked)
                                                                            <span class="badge bg-danger">Blocked</span>
                                                                        @elseif ($offer->status == 'requestApproved')
                                                                            @if ($application == null)
                                                                                <span class="badge bg-warning text-dark">Request To Access</span>
                                                                            @elseif ($application && $application->status == false)
                                                                                <span class="badge bg-danger">Pending</span>
                                                                            @elseif ($application && $application->status == true)
                                                                                <span class="badge bg-success">Approved</span>
                                                                            @endif
                                                                        @else
                                                                            <span class="badge bg-success">Approved</span>
                                                                        @endif
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </td>
                                                        <td>
                                                            @if (!$offer->countries->isEmpty())
                                                                @php $count = 0; @endphp
                                                                @foreach ($offer->countries as $country)
                                                                    @if ($count < 5)
                                                                        <span class="flag flag-country-{{ Str::lower($country->code) }}"></span>
                                                                        @php $count++; @endphp
                                                                    @else
                                                                        @break
                                                                    @endif
                                                                @endforeach
                                                                @if ($offer->countries->count() > 5)
                                                                    <span class="badge bg-light text-secondary">+{{ $offer->countries->count() - 5 }} more</span>
                                                                @endif
                                                            @else
                                                                <span class="badge bg-success">Global</span>
                                                            @endif
                                                        </td>
                                                        <td>
                                                            @if (!$offer->devices->isEmpty())
                                                                @foreach ($offer->devices as $device)
                                                                    <i class="fa fa-{{ Str::lower($device->name) }} me-1"></i>
                                                                @endforeach
                                                            @else
                                                                @foreach ($devices as $device)
                                                                    <i class="fa fa-{{ Str::lower($device->name) }} me-1"></i>
                                                                @endforeach
                                                            @endif
                                                        </td>
                                                        @php
                                                            $customPayout = \App\CoustomPayout::where('offer_id', $offer->id)->where('user_id', Auth::id())->first();
                                                        @endphp
                                                        <td>
                                                            @if ($offer->type == 'offer')
                                                                @if (!$offer->countryPayouts->isEmpty())
                                                                    <span class="badge bg-success">Dynamic</span>
                                                                @elseif ($customPayout)
                                                                    <span class="badge bg-success">${{ $customPayout->payout }}</span>
                                                                @else
                                                                    <span class="badge bg-success">${{ $offer->payout }}</span>
                                                                @endif
                                                            @else
                                                                <span class="badge bg-info">Revenue Share</span>
                                                            @endif
                                                        </td>
                                                        <td><span class="badge bg-secondary">{{ $offer->category->name }}</span></td>
                                                        <td><span class="badge bg-secondary">{{ optional($offer->verticle)->name }}</span></td>
                                                        <td class="text-center">
                                                            <div class="btn-list justify-content-center">
                                                                <a href="{{ route('affiliate.offer.show', $offer->id) }}" class="btn btn-sm btn-primary">
                                                                    <span class="fe fe-eye"></span>
                                                                </a>
                                                            </div>
                                                        </td>
                                                    </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                @else
                    <div class="row g-0 row-cols-1 row-cols-md-5">
                        @foreach ($offers as $offer)
                            <div class="col p-2">
                                <div class="offer-glary">
                                    <img src="{{ $offer->getFirstMediaUrl('avater') ? $offer->getFirstMediaUrl('avater')  : 'https://placehold.co/400' }}"
                                        alt="" class="" height="200" weight="300">
                                    <a href="" class="text-reset">
                                        @php
                                            $application = \App\OfferApplication::where('offer_id', $offer->id)
                                                ->where('user_id', Auth::user()->id)
                                                ->first();
                                            $offer_blocked = Auth::user()
                                                ->offers()
                                                ->where('offer_id', $offer->id)
                                                ->first();
                                        @endphp
                                        @if ($offer_blocked)
                                            <span class="badge bg-danger">Blocked</span>
                                        @elseif ($offer->status == 'requestApproved')
                                            @if ($application == null)
                                                <span class="badge bg-warning">Request To Access</span>
                                            @elseif ($application && $application->status == false)
                                                <span class="badge bg-danger">Pending</span>
                                            @elseif ($application && $application->status == true)
                                                <span class="badge bg-success">Approved</span>
                                            @endif
                                        @else
                                            <span class="badge bg-success">Approved</span>
                                        @endif
                                    </a>
                                    <a class="o-link"
                                        href="{{ route('affiliate.offer.show', $offer->id) }}">{{ $offer->name }}</a>
                                        <div class="offer-glary-btn">
                                            $ {{ $offer->payout }} per lead
                                        </div>
                                </div>
                            </div>
                        @endforeach
                    </div>

            @endif
            <div style="margin: 0 auto; float: right;">
                {{ $offers->withQueryString()->links() }}
            </div>
        </div>
    </div>
</div>

</div>
@endsection

@push('js')
<script src="https://cdn.jsdelivr.net/npm/tom-select@2.0.1/dist/js/tom-select.complete.min.js"></script>
<!-- DataTables Core + Bootstrap 5 + Responsive + Buttons -->
<script src="{{ asset('assets/plugins/datatable/js/jquery.dataTables.min.js') }}"></script>
<script src="{{ asset('assets/plugins/datatable/js/dataTables.bootstrap5.js') }}"></script>
<script src="{{ asset('assets/plugins/datatable/dataTables.responsive.min.js') }}"></script>
<script src="{{ asset('assets/plugins/datatable/js/dataTables.buttons.min.js') }}"></script>
<script src="{{ asset('assets/plugins/datatable/js/buttons.bootstrap5.min.js') }}"></script>
<script src="{{ asset('assets/plugins/datatable/js/buttons.html5.min.js') }}"></script>
<script src="{{ asset('assets/plugins/datatable/js/buttons.print.min.js') }}"></script>
<script src="{{ asset('assets/plugins/datatable/js/buttons.colVis.min.js') }}"></script>
<script>
    new TomSelect('#category_id', {
        plugins: ['input_autogrow'],
    });
    new TomSelect('#country_id', {
        plugins: ['input_autogrow'],
    });
    new TomSelect('#type', {
        plugins: ['input_autogrow'],
    });
    new TomSelect('#status', {
        plugins: ['input_autogrow'],
    });
    new TomSelect('#device_id', {
        plugins: ['input_autogrow'],
    });

    // Initialize DataTable with Buttons for offers list
    $(document).ready(function(){
        if ($('#offers-table').length) {
            $('#offers-table').DataTable({
                responsive: true,
                pageLength: 25,
                lengthMenu: [10,25,50,100],
                order: [],
                dom: "<'row'<'col-md-6'B><'col-md-6'f>>tr<'row'<'col-md-5'i><'col-md-7'p>>",
                buttons: [
                    { extend: 'copy', className: 'btn btn-sm btn-light' },
                    { extend: 'csv', className: 'btn btn-sm btn-light' },
                    { extend: 'excel', className: 'btn btn-sm btn-light' },
                    { extend: 'pdf', className: 'btn btn-sm btn-light' },
                    { extend: 'print', className: 'btn btn-sm btn-light' },
                    { extend: 'colvis', className: 'btn btn-sm btn-light' },
                ]
            });
        }
        // Reset filter form
        $('#offerFiltersReset').on('click', function(){
            $('#name').val('');
            $('#category_id').val('').trigger('change');
            $('#status').val('').trigger('change');
            $('#country_id').val([]).trigger('change');
            $(this).closest('form')[0].submit();
        });
    });
</script>
@endpush


