@extends('layouts.backend.affiliate_sash')

@section('title', $offer->name)

@push('css')
    <link href="{{ asset('public/backend/dist/css/tabler-flags.min.css') }}" rel="stylesheet" />
    <style>
        .card {
            border: none;
            box-shadow: 0 0.125rem 0.25rem rgba(0, 0, 0, 0.075);
            margin-bottom: 1.5rem;
        }

        .card-header {
            background-color: #f8f9fa;
            border-bottom: 1px solid rgba(0, 0, 0, 0.05);
            font-weight: 600;
            padding: 1rem 1.25rem;
        }

        .card-body {
            padding: 1.5rem;
        }

        .payout-item {
            margin-bottom: 0.75rem;
            padding: 0.75rem;
            background: #f8f9fa;
            border-radius: 0.5rem;
            display: flex;
            align-items: center;
            justify-content: space-between;
        }

        .application-note {
            background: #f8f9fa;
            border-radius: 0.5rem;
            padding: 1rem;
            font-size: 0.875rem;
            border-left: 3px solid #4e73df;
        }

        .badge {
            font-weight: 500;
            padding: 1em 0.65em;
        }

        .badge-soft-primary {
            background-color: rgba(78, 115, 223, 0.1);
            color: #4e73df;
        }

        .badge-soft-secondary {
            background-color: rgba(108, 117, 125, 0.1);
            color: #6c757d;
        }

        .badge-soft-success {
            background-color: rgba(40, 167, 69, 0.1);
            color: #28a745;
        }

        .badge-soft-danger {
            background-color: rgba(220, 53, 69, 0.1);
            color: #dc3545;
        }

        .badge-soft-warning {
            background-color: rgba(255, 193, 7, 0.1);
            color: #ffc107;
        }

        .badge-soft-info {
            background-color: rgba(23, 162, 184, 0.1);
            color: #17a2b8;
        }

        @media (max-width: 768px) {
            .card-body {
                padding: 1rem;
            }

            .payout-item {
                flex-direction: column;
                align-items: flex-start;
                gap: 0.5rem;
            }
        }
    </style>
@endpush

@php
    $customCap = \App\CoustomCap::where('offer_id', $offer->id)
        ->where('user_id', Auth::id())
        ->first();
    $customPayout = \App\CoustomPayout::where('offer_id', $offer->id)
        ->where('user_id', Auth::id())
        ->first();
    $customCountryPayout = \App\CoustomCountryPayout::where('offer_id', $offer->id)
        ->where('user_id', Auth::id())
        ->get();
    $application = $offer->applications->where('user_id', Auth::id())->first();
    $offerBlocked = Auth::user()
        ->offers()
        ->where('offer_id', $offer->id)
        ->first();
    $isRequestAccess = $offer->status === 'requestApproved';
    $trackingDomain = rtrim(setting('tracking_domain'), '/');
    if (!Str::startsWith($trackingDomain, ['http://', 'https://'])) {
        $trackingDomain = 'https://' . $trackingDomain;
    }
    $trackingUrl = $trackingDomain . '/redirect?aff_id=' . Auth::id() . '&offer_id=' . $offer->id;
@endphp

@section('content')
    <div class="page-body">
        <div class="container-xl">
            <div class="row g-4">
                <div class="col-12">
                    <div class="card">
                        <div class="card-body">
                            <div class="d-flex justify-content-between align-items-start flex-wrap gap-3 mb-4">
                                <div>
                                    <h1 class="h3 mb-1">{{ $offer->name }}</h1>
                                    <div class="text-muted">Offer ID: #{{ $offer->id }}</div>
                                </div>
                                <div class="d-flex gap-2 flex-wrap">
                                    @if ($offerBlocked)
                                        <span class="badge badge-soft-danger">
                                            <i class="fe fe-slash me-1"></i> Blocked
                                        </span>
                                    @elseif ($isRequestAccess)
                                        @if (is_null($application))
                                            <span class="badge badge-soft-warning">
                                                <i class="fe fe-lock me-1"></i> Request Access
                                            </span>
                                        @elseif ($application->status === false)
                                            <span class="badge badge-soft-warning">
                                                <i class="fe fe-clock me-1"></i> Pending Approval
                                            </span>
                                        @else
                                            <span class="badge badge-soft-success">
                                                <i class="fe fe-check-circle me-1"></i> Approved
                                            </span>
                                        @endif
                                    @else
                                        <span class="badge badge-soft-success">
                                            <i class="fe fe-check-circle me-1"></i> Approved
                                        </span>
                                    @endif

                                    <span class="badge badge-soft-primary">
                                        <i class="fe fe-tag me-1"></i>
                                        {{ $offer->type === 'offer' ? 'CPA Offer' : 'Revenue Share' }}
                                    </span>

                                    @if ($offer->preview_link)
                                        <a href="{{ $offer->preview_link }}" target="_blank" class="btn btn-outline-primary btn-sm">
                                            <i class="fe fe-eye me-1"></i> Preview
                                        </a>
                                    @endif
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-8">
                                    <div class="card mb-4">
                                        <div class="card-header">
                                            <i class="fe fe-info me-2"></i>Offer Details
                                        </div>
                                        <div class="card-body">
                                            <div class="mb-4">
                                                <h6 class="fw-semibold mb-3">Description</h6>
                                                <div class="text-muted">{!! $offer->description !!}</div>
                                            </div>

                                            <div class="row">
                                                <div class="col-md-6 mb-3">
                                                    <h6 class="fw-semibold mb-2">Expiration Date</h6>
                                                    <div class="text-muted">
                                                        @if($offer->expiration_date)
                                                            @php
                                                                try {
                                                                    echo \Carbon\Carbon::parse($offer->expiration_date)->format('M d, Y');
                                                                } catch (\Exception $e) {
                                                                    echo $offer->expiration_date;
                                                                }
                                                            @endphp
                                                        @else
                                                            No expiration
                                                        @endif
                                                    </div>
                                                </div>
                                                <div class="col-md-6 mb-3">
                                                    <h6 class="fw-semibold mb-2">Daily Cap</h6>
                                                    <div>
                                                        @if ($customCap)
                                                            <span class="badge badge-soft-success d-flex">{{ $customCap->cap }}</span>
                                                        @else
                                                            <span class="badge badge-soft-success">{{ $offer->daily_cap ?: 'Unlimited' }}</span>
                                                        @endif
                                                    </div>
                                                </div>
                                                <div class="col-12">
                                                    <h6 class="fw-semibold mb-2">Payouts</h6>
                                                    <div class="payout-list">
                                                        @if ($customCountryPayout->isNotEmpty())
                                                            @foreach ($customCountryPayout as $payout)
                                                                @if ($payout->devices && $payout->devices->isNotEmpty())
                                                                    @foreach ($payout->devices as $device)
                                                                        <div class="payout-item">
                                                                            <div class="d-flex align-items-center gap-2">
                                                                                <span class="flag flag-country-{{ Str::lower(optional(optional($device->country)->country)->code) }}"></span>
                                                                                <span class="fw-medium">{{ optional($device->country->country)->name }}</span>
                                                                                <span class="badge bg-light text-dark">{{ $device->device->name }}</span>
                                                                            </div>
                                                                            <span class="badge badge-soft-success">${{ number_format($device->payout, 2) }}</span>
                                                                        </div>
                                                                    @endforeach
                                                                @else
                                                                    <div class="payout-item">
                                                                        <div class="d-flex align-items-center gap-2">
                                                                            <span class="flag flag-country-{{ Str::lower(optional($payout->country)->code) }}"></span>
                                                                            <span class="fw-medium">{{ optional($payout->country)->name ?: 'Global' }}</span>
                                                                        </div>
                                                                        <span class="badge badge-soft-success">${{ number_format($payout->payout, 2) }}</span>
                                                                    </div>
                                                                @endif
                                                            @endforeach
                                                        @elseif ($offer->countryPayouts->isNotEmpty())
                                                            @foreach ($offer->countryPayouts as $payout)
                                                                @if ($payout->devices && $payout->devices->isNotEmpty())
                                                                    @foreach ($payout->devices as $device)
                                                                        <div class="payout-item">
                                                                            <div class="d-flex align-items-center gap-2">
                                                                                <span class="flag flag-country-{{ Str::lower(optional(optional($device->countryPayout)->country)->code) }}"></span>
                                                                                <span class="fw-medium">{{ optional($device->countryPayout->country)->name }}</span>
                                                                                <span class="badge bg-light text-dark">{{ $device->device->name }}</span>
                                                                            </div>
                                                                            <span class="badge badge-soft-success">${{ number_format($device->payout, 2) }}</span>
                                                                        </div>
                                                                    @endforeach
                                                                @else
                                                                    <div class="payout-item">
                                                                        <div class="d-flex align-items-center gap-2">
                                                                            <span class="flag flag-country-{{ Str::lower(optional($payout->country)->code) }}"></span>
                                                                            <span class="fw-medium">{{ optional($payout->country)->name ?: 'Global' }}</span>
                                                                        </div>
                                                                        <span class="badge badge-soft-success">${{ number_format($payout->payout, 2) }}</span>
                                                                    </div>
                                                                @endif
                                                            @endforeach
                                                        @elseif ($customPayout)
                                                            <div class="payout-item">
                                                                <span class="fw-medium">Default Payout</span>
                                                                <span class="badge badge-soft-success">${{ number_format($customPayout->payout, 2) }}</span>
                                                            </div>
                                                        @elseif ($offer->type === 'offer')
                                                            <div class="payout-item">
                                                                <span class="fw-medium">Default Payout</span>
                                                                <span class="badge badge-soft-success">${{ number_format($offer->payout, 2) }}</span>
                                                            </div>
                                                        @else
                                                            <div class="payout-item">
                                                                <span class="fw-medium">Revenue Share</span>
                                                                <span class="badge badge-soft-info">Percentage Based</span>
                                                            </div>
                                                        @endif
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    @if (!$offerBlocked && (!$isRequestAccess || ($application && $application->status !== false)))
                                        <div class="card">
                                            <div class="card-header">
                                                <i class="fe fe-link me-2"></i>Tracking Link
                                            </div>
                                            <div class="card-body">
                                                <div class="mb-3">
                                                    <label class="form-label">Your Tracking URL</label>
                                                    <div class="input-group">
                                                        <input type="text" class="form-control" id="trackingLink" value="{{ $trackingUrl }}" data-base="{{ $trackingUrl }}" readonly>
                                                        <button type="button" class="btn btn-primary" id="copyTrackingLink">
                                                            <i class="fe fe-copy me-1"></i> Copy
                                                        </button>
                                                    </div>
                                                    <div class="form-text small mt-1">Use this link to track your conversions</div>
                                                </div>

                                                <div class="mb-3">
                                                    <h6 class="fw-semibold mb-3">Tracking Parameters</h6>
                                                    <div class="row g-3">
                                                        <div class="col-md-6">
                                                            <label for="aff_click_id" class="form-label">Click ID</label>
                                                            <input type="text" class="form-control" id="aff_click_id" data-tracking-param="aff_click_id" placeholder="e.g., campaign123">
                                                        </div>
                                                        <div class="col-md-6">
                                                            <label for="aff_sub_1" class="form-label">Sub ID 1</label>
                                                            <input type="text" class="form-control" id="aff_sub_1" data-tracking-param="aff_sub_1" placeholder="e.g., source">
                                                        </div>
                                                        <div class="col-md-6">
                                                            <label for="aff_sub_2" class="form-label">Sub ID 2</label>
                                                            <input type="text" class="form-control" id="aff_sub_2" data-tracking-param="aff_sub_2" placeholder="e.g., medium">
                                                        </div>
                                                        <div class="col-md-6">
                                                            <label for="aff_sub_3" class="form-label">Sub ID 3</label>
                                                            <input type="text" class="form-control" id="aff_sub_3" data-tracking-param="aff_sub_3" placeholder="e.g., campaign">
                                                        </div>
                                                        <div class="col-12">
                                                            <label class="form-label">Link Preview</label>
                                                            <div class="form-control bg-light text-truncate small" id="linkPreview">{{ $trackingUrl }}</div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    @endif
                                </div>

                                <div class="col-md-4">
                                    <div class="card mb-4">
                                        <div class="card-header">
                                            <i class="fe fe-info me-2"></i>Offer Information
                                        </div>
                                        <div class="card-body">
                                            <div class="mb-3">
                                                <h6 class="fw-semibold mb-2">Category</h6>
                                                <span class="badge badge-soft-secondary">{{ $offer->category->name }}</span>
                                            </div>

                                            @if (optional($offer->verticle)?->name)
                                                <div class="mb-3">
                                                    <h6 class="fw-semibold mb-2">Vertical</h6>
                                                    <span class="badge badge-soft-info">{{ $offer->verticle->name }}</span>
                                                </div>
                                            @endif

                                            @if(isset($offer->countries) && $offer->countries->isNotEmpty())
                                                <div class="mb-3">
                                                    <h6 class="fw-semibold mb-2">Target Countries</h6>
                                                    <div class="d-flex flex-wrap gap-2">
                                                        @foreach ($offer->countries as $country)
                                                            <span class="badge d-flex align-items-center bg-light text-dark">
                                                                @if(isset($country->code))
                                                                    <span class="flag flag-country-{{ Str::lower($country->code) }} me-1"></span>
                                                                @endif
                                                                {{ $country->name ?? 'N/A' }}
                                                            </span>
                                                        @endforeach
                                                    </div>
                                                </div>
                                            @else
                                                <div class="mb-3">
                                                    <h6 class="fw-semibold mb-2">Target</h6>
                                                    <span class="badge badge-soft-success">Global Traffic</span>
                                                </div>
                                            @endif

                                            @if(isset($offer->devices) && $offer->devices->isNotEmpty())
                                                <div class="mb-3">
                                                    <h6 class="fw-semibold mb-2">Devices</h6>
                                                    <div class="d-flex flex-wrap gap-2">
                                                        @foreach ($offer->devices as $device)
                                                            @if(isset($device->name))
                                                                <span class="badge bg-light text-dark">
                                                                    @php
                                                                        $deviceIcon = 'tablet';
                                                                        $deviceName = strtolower($device->name);
                                                                        if (str_contains($deviceName, 'mobile') || str_contains($deviceName, 'phone')) {
                                                                            $deviceIcon = 'smartphone';
                                                                        } elseif (str_contains($deviceName, 'desktop')) {
                                                                            $deviceIcon = 'monitor';
                                                                        }
                                                                    @endphp
                                                                    <i class="fe fe-{{ $deviceIcon }} me-1"></i>
                                                                    {{ $device->name }}
                                                                </span>
                                                            @endif
                                                        @endforeach
                                                    </div>
                                                </div>
                                            @endif

                                            @if(isset($offer->browsers) && $offer->browsers->isNotEmpty())
                                                <div class="mb-3">
                                                    <h6 class="fw-semibold mb-2">Browsers</h6>
                                                    <div class="d-flex flex-wrap gap-2">
                                                        @foreach ($offer->browsers as $browser)
                                                            @if(isset($browser->name))
                                                                <span class="badge bg-light text-dark">{{ $browser->name }}</span>
                                                            @endif
                                                        @endforeach
                                                    </div>
                                                </div>
                                            @endif

                                            @if(isset($offer->operatingSystems) && $offer->operatingSystems->isNotEmpty())
                                                <div class="mb-3">
                                                    <h6 class="fw-semibold mb-2">Operating Systems</h6>
                                                    <div class="d-flex flex-wrap gap-2">
                                                        @foreach ($offer->operatingSystems as $os)
                                                            @if(isset($os->name))
                                                                <span class="badge bg-light text-dark">{{ $os->name }}</span>
                                                            @endif
                                                        @endforeach
                                                    </div>
                                                </div>
                                            @endif
                                        </div>
                                    </div>

                                    @if ($offerBlocked)
                                        <div class="card border-danger">
                                            <div class="card-header bg-danger text-white">
                                                <i class="fe fe-slash me-2"></i>Access Blocked
                                            </div>
                                            <div class="card-body">
                                                <p class="text-muted small mb-0">This offer is currently blocked for your account. Please contact support for assistance.</p>
                                            </div>
                                        </div>
                                    @elseif ($isRequestAccess && is_null($application))
                                        <div class="card border-warning">
                                            <div class="card-header" style="background-color: rgba(255, 193, 7, 0.1);">
                                                <i class="fe fe-lock me-2"></i>Request Access
                                            </div>
                                            <div class="card-body">
                                                <p class="text-muted small mb-3">This offer requires approval. Please submit a request to promote this offer.</p>
                                                <form action="{{ route('affiliate.offer.request-access', $offer->id) }}" method="POST">
                                                    @csrf
                                                    <div class="mb-3">
                                                        <label for="message" class="form-label">Message (Optional)</label>
                                                        <textarea class="form-control" id="message" name="message" rows="3" placeholder="Tell us about your promotion methods..."></textarea>
                                                    </div>
                                                    <button type="submit" class="btn btn-warning w-100">
                                                        <i class="fe fe-send me-1"></i> Send Request
                                                    </button>
                                                </form>
                                            </div>
                                        </div>
                                    @elseif ($isRequestAccess && $application && $application->status === false)
                                        <div class="card border-warning">
                                            <div class="card-header" style="background-color: rgba(255, 193, 7, 0.1);">
                                                <i class="fe fe-clock me-2"></i>Request Pending
                                            </div>
                                            <div class="card-body">
                                                <p class="text-muted small mb-3">Your request to access this offer is pending approval. We'll notify you once it's been reviewed.</p>
                                                @if ($application->message)
                                                    <div class="application-note">
                                                        <strong>Your Message:</strong>
                                                        <p class="mb-0 mt-2">{{ $application->message }}</p>
                                                    </div>
                                                @endif
                                            </div>
                                        </div>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('js')
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const linkInput = document.getElementById('trackingLink');
            if (!linkInput) return;

            const baseUrl = linkInput.dataset.base;
            const paramsInputs = Array.from(document.querySelectorAll('[data-tracking-param]'));
            const linkPreview = document.getElementById('linkPreview');

            function rebuildLink() {
                try {
                    const url = new URL(baseUrl);

                    paramsInputs.forEach(function (input) {
                        const key = input.dataset.trackingParam;
                        const value = input.value.trim();
                        if (value) {
                            url.searchParams.set(key, value);
                        } else {
                            url.searchParams.delete(key);
                        }
                    });

                    const finalUrl = url.toString();
                    linkInput.value = finalUrl;

                    if (linkPreview) {
                        linkPreview.textContent = finalUrl.length > 80
                            ? finalUrl.substring(0, 80) + '...'
                            : finalUrl;
                        linkPreview.title = finalUrl;
                    }

                    return finalUrl;
                } catch (error) {
                    console.error('Unable to build tracking link', error);
                    return baseUrl;
                }
            }

            paramsInputs.forEach(function (input) {
                input.addEventListener('input', rebuildLink);
            });

            const copyBtn = document.getElementById('copyTrackingLink');
            if (copyBtn) {
                copyBtn.addEventListener('click', function () {
                    const finalUrl = rebuildLink();
                    navigator.clipboard.writeText(finalUrl)
                        .then(function () {
                            const originalText = copyBtn.innerHTML;
                            copyBtn.innerHTML = '<i class="fe fe-check me-1"></i>Copied!';
                            copyBtn.classList.remove('btn-primary');
                            copyBtn.classList.add('btn-success');

                            setTimeout(function () {
                                copyBtn.innerHTML = originalText;
                                copyBtn.classList.remove('btn-success');
                                copyBtn.classList.add('btn-primary');
                            }, 2000);
                        })
                        .catch(function (err) {
                            console.error('Could not copy text: ', err);
                            const alert = document.createElement('div');
                            alert.className = 'alert alert-danger mt-2 mb-0';
                            alert.role = 'alert';
                            alert.textContent = 'Failed to copy. Please copy the link manually.';
                            copyBtn.parentNode.parentNode.appendChild(alert);
                            setTimeout(() => alert.remove(), 3000);
                        });
                });
            }

            rebuildLink();
        });
    </script>
@endpush
