﻿@extends('layouts.backend.affiliate_sash')
@section('title', 'Smart link')

@push('css')
    <link href="https://cdn.jsdelivr.net/npm/tom-select@2.0.1/dist/css/tom-select.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/tom-select@2.0.1/dist/css/tom-select.bootstrap5.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.css" rel="stylesheet">
    <link href="{{ asset('backend/dist/css/tabler-flags.min.css') }}" rel="stylesheet" />
@endpush

@section('content')
    @php
        $id = request()->get('id');
        $status = request()->get('status');
        $name = request()->get('name');
        $category_id = request()->get('category_id');
        $device_id = request()->get('device_id');
        $country_id = request()->get('country_id');
        $type = request()->get('type');
    @endphp


    <div class="page-body mt-0">
        <div class="d-flex flex-column flex-md-row gap-3">
            <div class="col-12 mt-0">
                <div class="card">
                    <div class="table-responsive s-shadow">
                        <table class="table table-vcenter table-mobile-md card-table">
                            <thead>
                                <tr>
                                    <th class="top-left">Name</th>

                                    <th>Payout</th>

                                    <th>Category</th>
                                    <th>Verticle</th>
                                    <th class="top-right">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($offers as $offer)
                                    <tr>
                                        <td data-label="Basic Info">
                                            <div class="d-flex py-1 align-items-center">
                                                <span class="avatar me-2"
                                                    style="background-image: url({{ $offer->getFirstMediaUrl('avater') ? $offer->getFirstMediaUrl('avater') : '' }})"></span>
                                                <div class="flex-fill">
                                                    <div class="font-weight-medium"><a
                                                            href="{{ route('affiliate.offer.show', $offer->id) }}">({{ $offer->id }}){{ $offer->name }}
                                                        </a>
                                                    </div>
                                                    <div class="text-muted">
                                                        <a href="" class="text-reset">
                                                            @php
                                                                $application = \App\OfferApplication::where(
                                                                    'offer_id',
                                                                    $offer->id,
                                                                )
                                                                    ->where('user_id', Auth::user()->id)
                                                                    ->first();
                                                                $offer_blocked = Auth::user()
                                                                    ->offers()
                                                                    ->where('offer_id', $offer->id)
                                                                    ->first();
                                                            @endphp
                                                            @if ($offer_blocked)
                                                                <span class="badge bg-danger">Blocked</span>
                                                            @elseif ($offer->status == 'requestApproved')
                                                                @if ($application == null)
                                                                    <span class="badge bg-warning">Request To Access</span>
                                                                @elseif ($application && $application->status == false)
                                                                    <span class="badge bg-danger">Pending</span>
                                                                @elseif ($application && $application->status == true)
                                                                    <span class="badge bg-success">Approved</span>
                                                                @endif
                                                            @else
                                                                <span class="badge bg-success">Approved</span>
                                                            @endif
                                                        </a>
                                                    </div>
                                                </div>
                                            </div>
                                        </td>

                                        @php
                                            $coustomPayout = \App\CoustomPayout::where('offer_id', $offer->id)
                                                ->where('user_id', Auth::id())
                                                ->first();
                                        @endphp
                                        <td data-label="Payout">
                                            @if ($offer->type == 'offer')
                                                @if (!$offer->countryPayouts->isEmpty())
                                                    <div class="text-muted"><span class="badge bg-success">Dynamic</span>
                                                    </div>
                                                @elseif ($coustomPayout)
                                                    <div class="text-muted"><span
                                                            class="badge bg-success">${{ $coustomPayout->payout }}</span>
                                                    </div>
                                                @else
                                                    <div class="text-muted"><span
                                                            class="badge bg-success">${{ $offer->payout }}</span></div>
                                                @endif
                                            @else
                                                <div class="text-muted"><span class="badge bg-success">Revenue
                                                        Share</span></div>
                                            @endif
                                        </td>

                                        <td data-label="Category">
                                            <div class="text-muted"><span
                                                    class="badge bg-success">{{ $offer->category->name }}</span></div>
                                        </td>
                                        <td data-label="Verticle">
                                            <div class="text-muted"><span
                                                    class="badge bg-success">{{ optional($offer->verticle)->name }}</span>
                                            </div>
                                        </td>
                                        <td>
                                            
                                            @if ($offer_blocked)
                                                <span class="badge bg-danger">Blocked</span>
                                            @elseif ($offer->status == 'requestApproved')
                                                @if ($application && $application == null)
                                                <a style="min-width:fit-content;width:fit-content;padding:5px 8px"
                                                href="{{ route('affiliate.offer.show', $offer->id) }}"
                                                class="btn mybtnMain btn-sm">
                                                <i class="fa fa-eye"></i>
                                            </a>
                                            @elseif ($application && $application->status == false)
                                            <a style="min-width:fit-content;width:fit-content;padding:5px 8px"
                                            href="{{ route('affiliate.offer.show', $offer->id) }}"
                                            class="btn mybtnMain btn-sm">
                                            <i class="fa fa-eye"></i>
                                        </a>
                                                @elseif ($application && $application->status == true)
                                                    <button style="min-width: fit-content;padding:5px 8px"
                                                        onclick="findData({{ $offer->id }})"
                                                        class="btn mybtnMain btn-sm">
                                                        <i class="fa fa-eye"></i>
                                                    </button>
                                                @endif
                                            @else
                                                <button style="min-width: fit-content;padding:5px 8px"
                                                    onclick="findData({{ $offer->id }})" class="btn mybtnMain btn-sm">
                                                    <i class="fa fa-eye"></i>
                                                </button>
                                            @endif

                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                        <div style="margin: 0 auto;float: right">
                            {{ $offers->withQueryString()->links() }}
                        </div>
                    </div>
                </div>

                <div class="card smart-alert mt-4">
                    <div class="card-body">
                        <strong class="flex">
                            <div class="badge bg-danger me-2">New</div> Push Monetization
                        </strong>
                        <p class="mt-2">Push monetization has been added! Monetize your traffic with Push Subscriptions.
                            You can combine
                            it with your main monetization method.Please ask your manager or support team for more details.
                        </p>
                    </div>
                </div>

                <div class="card mt-4 smart-alert-2">
                    <div class="card-body">
                        <strong>Smartlinks</strong>

                        <p class="">
                            At the moment, we have global smartlinks for the following verticals:
                        </p>
                        <ul>

                            <li>Mainstream (Sweepstakes)</li>
                            <li>Crypto</li>
                            <li>Gaming</li>
                            <li>House Rental</li>
                        </ul>
                        <p>For more details and links, please feel free to contact our support team.</p>

                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="smartlinksModal" tabindex="-1" aria-labelledby="showModelLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-xl modal-dialog-scrollable">
            <div class="modal-content" id="dataApi">


            </div>
        </div>
    </div>

    <script>
        function copyLink() {
            const linkInput = document.getElementById('directLink');
            linkInput.select();
            document.execCommand('copy');
            alert('Link copied to clipboard!');
        }

        function findData(offerId) {
            const urlTemplate = `{{ route('affiliate.offer.show.api', ['id' => ':id']) }}`;
            const url = urlTemplate.replace(':id', offerId);
            fetch(url)
                .then(response => {
                    // Check if the response is successful
                    if (!response.ok) {
                        throw new Error('Network response was not ok');
                    }
                    return response.text();
                })
                .then(data => {
                    console.log(data);
                    const modalBody = document.getElementById('dataApi');
                    modalBody.innerHTML = data;
                    const modal = new bootstrap.Modal(document.getElementById('smartlinksModal'));
                    modal.show();
                })
                .catch(error => {
                    console.error('Error fetching data:', error);
                    alert('Failed to load offer details. Please try again later.');
                });
        }
    </script>


@endsection

@push('js')
    <script src="https://cdn.jsdelivr.net/npm/tom-select@2.0.1/dist/js/tom-select.complete.min.js"></script>
    <script>
        new TomSelect('#country_id', {
            plugins: ['input_autogrow'],
        });
        new TomSelect('#type', {
            plugins: ['input_autogrow'],
        });
        new TomSelect('#status', {
            plugins: ['input_autogrow'],
        });
        new TomSelect('#device_id', {
            plugins: ['input_autogrow'],
        });
    </script>
@endpush


