@php
    $trackingDomain = rtrim(setting('tracking_domain'), '/');
    if (!Str::startsWith($trackingDomain, ['http://', 'https://'])) {
        $trackingDomain = 'https://' . $trackingDomain;
    }
    $trackingUrl = $trackingDomain . '/redirect?aff_id=' . Auth::id() . '&offer_id=' . $offer->id;
@endphp

<div class="modal-header border-bottom border-light pb-3">
    <div class="w-100">
        <div class="d-flex justify-content-between align-items-start">
            <div>
                <h5 class="modal-title mb-1">{{ $offer->name }}</h5>
                <div class="text-muted small">Offer ID: #{{ $offer->id }}</div>
            </div>
            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        
        <div class="d-flex flex-wrap gap-2 mt-3">
            <span class="badge bg-primary-soft">
                <i class="fe fe-tag me-1"></i>
                {{ $offer->type === 'offer' ? 'CPA Offer' : 'Revenue Share' }}
            </span>
            <span class="badge bg-secondary-soft">
                <i class="fe fe-grid me-1"></i>
                {{ $offer->category->name }}
            </span>
            @if (optional($offer->verticle)?->name)
                <span class="badge bg-info-soft">{{ $offer->verticle->name }}</span>
            @endif
            @if ($offer->countries->isNotEmpty())
                @foreach ($offer->countries as $country)
                    <span class="badge bg-light text-dark">
                        <i class="fe fe-globe me-1"></i>
                        {{ $country->name }}
                    </span>
                @endforeach
            @else
                <span class="badge bg-success-soft">
                    <i class="fe fe-globe me-1"></i>
                    Global Traffic
                </span>
            @endif
        </div>
    </div>
</div>

<div class="modal-body pt-4">
    @if($offer->description)
    <div class="card border-0 shadow-sm mb-4">
        <div class="card-body">
            <h6 class="fw-semibold mb-3 d-flex align-items-center">
                <i class="fe fe-info text-primary me-2"></i>Offer Details
            </h6>
            <div class="text-muted">{!! $offer->description !!}</div>
        </div>
    </div>
    @endif

    <div class="card border-0 shadow-sm mb-4">
        <div class="card-body">
            <h6 class="fw-semibold mb-3 d-flex align-items-center">
                <i class="fe fe-link text-primary me-2"></i>Tracking Link
            </h6>
            <div class="input-group">
                <input type="text" class="form-control form-control-lg" id="directLink" value="{{ $trackingUrl }}" data-base="{{ $trackingUrl }}" readonly>
                <button type="button" class="btn btn-primary" id="copyDirectLink">
                    <i class="fe fe-copy me-2"></i>Copy
                </button>
            </div>
            <div class="form-text small mt-2">Use this link to track your conversions</div>
        </div>
    </div>

    <div class="card border-0 shadow-sm mb-4">
        <div class="card-body">
            <h6 class="fw-semibold mb-3 d-flex align-items-center">
                <i class="fe fe-sliders text-primary me-2"></i>Tracking Parameters
            </h6>
            <div class="row g-3">
                <div class="col-12">
                    <label for="modal_aff_click_id" class="form-label">Click ID <span class="text-muted">(Optional)</span></label>
                    <input type="text" class="form-control" id="modal_aff_click_id" data-tracking-param="aff_click_id" placeholder="e.g., campaign123">
                </div>
                <div class="col-md-6">
                    <label for="modal_aff_sub_1" class="form-label">Sub ID 1</label>
                    <input type="text" class="form-control" id="modal_aff_sub_1" data-tracking-param="aff_sub_1" placeholder="e.g., source">
                </div>
                <div class="col-md-6">
                    <label for="modal_aff_sub_2" class="form-label">Sub ID 2</label>
                    <input type="text" class="form-control" id="modal_aff_sub_2" data-tracking-param="aff_sub_2" placeholder="e.g., medium">
                </div>
                <div class="col-md-6">
                    <label for="modal_aff_sub_3" class="form-label">Sub ID 3</label>
                    <input type="text" class="form-control" id="modal_aff_sub_3" data-tracking-param="aff_sub_3" placeholder="e.g., campaign">
                </div>
                <div class="col-md-6">
                    <label class="form-label">Link Preview</label>
                    <div class="form-control bg-light text-truncate small" id="linkPreview">{{ $trackingUrl }}</div>
                </div>
            </div>
        </div>
    </div>

    @if ($offer->preview_link)
        <a href="{{ $offer->preview_link }}" target="_blank" class="btn btn-outline-primary w-100">
            <i class="fe fe-eye me-2"></i> Preview Landing Page
        </a>
    @endif
</div>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        const linkInput = document.getElementById('directLink');
        if (!linkInput) return;

        const baseUrl = linkInput.dataset.base;
        const paramsInputs = Array.from(document.querySelectorAll('[data-tracking-param]'));
        const linkPreview = document.getElementById('linkPreview');

        function rebuildLink() {
            try {
                const url = new URL(baseUrl);
                let hasParams = false;
                
                paramsInputs.forEach(function (input) {
                    const key = input.dataset.trackingParam;
                    const value = input.value.trim();
                    if (value) {
                        url.searchParams.set(key, value);
                        hasParams = true;
                    } else {
                        url.searchParams.delete(key);
                    }
                });
                
                const finalUrl = url.toString();
                linkInput.value = finalUrl;
                if (linkPreview) {
                    linkPreview.textContent = finalUrl.length > 80 
                        ? finalUrl.substring(0, 80) + '...' 
                        : finalUrl;
                    linkPreview.title = finalUrl;
                }
                
                return finalUrl;
            } catch (error) {
                console.error('Unable to build tracking link', error);
                return baseUrl;
            }
        }

        // Initialize tooltips
        const tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
        tooltipTriggerList.map(function (tooltipTriggerEl) {
            return new bootstrap.Tooltip(tooltipTriggerEl);
        });

        // Update link when inputs change
        paramsInputs.forEach(function (input) {
            input.addEventListener('input', rebuildLink);
        });

        // Copy to clipboard functionality
        const copyBtn = document.getElementById('copyDirectLink');
        if (copyBtn) {
            copyBtn.addEventListener('click', function () {
                const finalUrl = rebuildLink();
                navigator.clipboard.writeText(finalUrl)
                    .then(function () {
                        const originalText = copyBtn.innerHTML;
                        copyBtn.innerHTML = '<i class="fe fe-check me-2"></i>Copied!';
                        copyBtn.classList.remove('btn-primary');
                        copyBtn.classList.add('btn-success');
                        
                        setTimeout(function () {
                            copyBtn.innerHTML = originalText;
                            copyBtn.classList.remove('btn-success');
                            copyBtn.classList.add('btn-primary');
                        }, 2000);
                    })
                    .catch(function (err) {
                        console.error('Could not copy text: ', err);
                        const alert = document.createElement('div');
                        alert.className = 'alert alert-danger mt-2 mb-0';
                        alert.role = 'alert';
                        alert.textContent = 'Failed to copy. Please copy the link manually.';
                        copyBtn.parentNode.insertBefore(alert, copyBtn.nextSibling);
                        setTimeout(() => alert.remove(), 3000);
                    });
            });
        }
        
        // Initial build
        rebuildLink();
    });
</script>
