﻿@extends('layouts.backend.affiliate_sash')

@section('title', 'Payment Method')


@push('css')
    <link href="https://cdn.jsdelivr.net/npm/tom-select@2.0.1/dist/css/tom-select.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/tom-select@2.0.1/dist/css/tom-select.bootstrap5.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.css" rel="stylesheet">
    <script src="{{ asset('css/app.css') }}"></script>
@endpush

@section('content')
    
    <div class="page-body mainbody2">
        <div class="container-xl">
            <form action="{{ route('affiliate.account.update') }}" method="post" enctype="multipart/form-data">
                @csrf
                @method('PUT')
                <div class="row row-cards">
                    <div class="col-md-6">
                        <div class="card">
                            <div class="card-header">
                                <h3 class="card-title">Payment Method Info</h3>
                            </div>
                            @include('layouts.backend.partials.flash-message')
                            @if ($errors->any())
                                <div class="alert alert-danger">
                                    <ul>
                                        @foreach ($errors->all() as $error)
                                            <li>{{ $error }}</li>
                                        @endforeach
                                    </ul>
                                </div>
                            @endif
                            <div class="card-body">
                                <div class="form-group mb-3 ">
                                    <label class="form-label">Payment Method</label>
                                    <div>
                                        <select name="finance_id" id="finance_id" class="form-select">
                                            @foreach ($finances as $finance)
                                                <option value="{{ $finance->id }}"}}>{{ $finance->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    @error('finance_id')
                                        <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="form-group mb-3 ">
                                    <label class="form-label">Wallet</label>
                                    <div>
                                        <textarea name="wallet" id="wallet" class="form-control"></textarea>
                                    </div>
                                    @error('wallet')
                                        <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="form-group mb-3 ">
                                    <button type="submit" class="btn mybtnMain">Added</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection

@push('js')
    <script src="https://cdn.jsdelivr.net/npm/tom-select@2.0.1/dist/js/tom-select.complete.min.js"></script>
    <script src="{{ asset('js/app.js') }}"></script>
    <script>
        new TomSelect('#finance_id', {
            plugins: ['input_autogrow'],
        });
    </script>
@endpush


