﻿@extends('layouts.backend.affiliate_sash')

@section('title', 'Aff Sub 1 Reports')

@push('css')
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.8/css/dataTables.bootstrap5.min.css">
    <link rel="stylesheet" href="{{ asset('backend/date/daterangepicker.css') }}">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css">

    <style>
        .filter-section {
            background: #f8f9fa;
            border: 1px solid #dee2e6;
            padding: 20px;
            margin-bottom: 20px;
            border-radius: 5px;
        }

        .filter-section h4 {
            margin-bottom: 15px;
            color: #333;
        }

        .form-group {
            margin-bottom: 15px;
        }

        .form-group label {
            display: block;
            margin-bottom: 5px;
            font-weight: 500;
        }

        .checkbox-group {
            display: flex;
            flex-wrap: wrap;
            gap: 15px;
        }

        .checkbox-group .checkbox-group {
            display: inline-block;
            position: relative;
        }

        .form-check {
            margin: 0;
        }

        .btn-group {
            margin-top: 15px;
        }

        .btn {
            margin-right: 10px;
        }

        .total {
            font-weight: bold;
        }

        /* Select2 Custom Styling */
        .select2-container--default .select2-selection--multiple {
            border: 1px solid #ced4da;
            border-radius: 0.375rem;
            min-height: 38px;
            padding: 2px 5px;
        }

        .select2-container--default .select2-selection--multiple .select2-selection__choice {
            background-color: #007bff;
            border: 1px solid #007bff;
            color: white;
            border-radius: 3px;
            padding: 2px 8px;
            margin: 2px;
        }

        .select2-container--default .select2-selection--multiple .select2-selection__choice__remove {
            color: white;
            margin-right: 5px;
        }

        .select2-container--default .select2-selection--multiple .select2-selection__choice__remove:hover {
            color: #ff6b6b;
        }

        .select2-dropdown {
            border: 1px solid #ced4da;
            border-radius: 0.375rem;
        }

        .select2-container--default .select2-results__option--highlighted[aria-selected] {
            background-color: #007bff;
        }
    </style>
@endpush

@section('content')
    @php
        $offer_id = request('offer_id');
        $country_id = request('country_id');
    @endphp

    @section('page_title','Aff Sub 1 Reports')
    @section('breadcrumb_parent','Reports')
    @section('breadcrumb_active','Aff Sub 1 Reports')
    @section('card_title','Aff Sub 1 Reports')

    @section('filters_table')
        <form method="get">
            <table class="table table-bordered filter-table">
                <thead>
                    <tr>
                        <th style="width:220px">Filter</th>
                        <th>Value</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td class="label-cell">Data Fields</td>
                        <td>
                            <div class="checkbox-group">
                                <div class="checkbox-group">
                                    <input class="checkbox-normal" name="offer" value="1" type="checkbox" id="offer" {{ request('offer', 1) ? 'checked' : '' }}>
                                    <label for="offer">Offer</label>
                                </div>
                                <div class="checkbox-group">
                                    <input class="checkbox-normal" name="country" value="1" type="checkbox" id="country" {{ request('country') ? 'checked' : '' }}>
                                    <label for="country">Country</label>
                                </div>
                                <div class="checkbox-group">
                                    <input class="checkbox-normal" name="device" value="1" type="checkbox" id="device" {{ request('device') ? 'checked' : '' }}>
                                    <label for="device">Device</label>
                                </div>
                                <div class="checkbox-group">
                                    <input class="checkbox-normal" name="os" value="1" type="checkbox" id="os" {{ request('os') ? 'checked' : '' }}>
                                    <label for="os">OS</label>
                                </div>
                                <div class="checkbox-group">
                                    <input class="checkbox-normal" name="browser" value="1" type="checkbox" id="browser" {{ request('browser') ? 'checked' : '' }}>
                                    <label for="browser">Browser</label>
                                </div>
                                <div class="checkbox-group">
                                    <input class="checkbox-normal" name="s1" value="1" type="checkbox" id="s1" {{ request('s1') ? 'checked' : '' }}>
                                    <label for="s1">S1</label>
                                </div>
                                <div class="checkbox-group">
                                    <input class="checkbox-normal" name="s2" value="1" type="checkbox" id="s2" {{ request('s2') ? 'checked' : '' }}>
                                    <label for="s2">S2</label>
                                </div>
                                <div class="checkbox-group">
                                    <input class="checkbox-normal" name="s3" value="1" type="checkbox" id="s3" {{ request('s3') ? 'checked' : '' }}>
                                    <label for="s3">S3</label>
                                </div>
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <td class="label-cell">Statistics Fields</td>
                        <td>
                            <div class="checkbox-group">
                                <div class="checkbox-group">
                                    <input class="checkbox-normal" name="click" value="1" type="checkbox" id="click" {{ request('click', 1) ? 'checked' : '' }}>
                                    <label for="click">Click</label>
                                </div>
                                <div class="checkbox-group">
                                    <input class="checkbox-normal" name="unique" value="1" type="checkbox" id="unique" {{ request('unique', 1) ? 'checked' : '' }}>
                                    <label for="unique">Unique</label>
                                </div>
                                <div class="checkbox-group">
                                    <input class="checkbox-normal" name="payout" value="1" type="checkbox" id="payout" {{ request('payout', 1) ? 'checked' : '' }}>
                                    <label for="payout">Payout</label>
                                </div>
                                <div class="checkbox-group">
                                    <input class="checkbox-normal" name="epc" value="1" type="checkbox" id="epc" {{ request('epc') ? 'checked' : '' }}>
                                    <label for="epc">EPC</label>
                                </div>
                                <div class="checkbox-group">
                                    <input class="checkbox-normal" name="conversions" value="1" type="checkbox" id="conversions" {{ request('conversions', 1) ? 'checked' : '' }}>
                                    <label for="conversions">Conversions</label>
                                </div>
                                <div class="checkbox-group">
                                    <input class="checkbox-normal" name="cr" value="1" type="checkbox" id="cr" {{ request('cr') ? 'checked' : '' }}>
                                    <label for="cr">CR</label>
                                </div>
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <td class="label-cell"><label for="date_filter" class="m-0">Date Range</label></td>
                        <td>
                            <input type="text" class="form-control" id="date_filter" name="date_filter" value="{{ request('date_filter') }}" placeholder="Select Date Range">
                        </td>
                    </tr>
                    <tr>
                        <td class="label-cell"><label for="offer_id" class="m-0">Offers</label></td>
                        <td>
                            <select multiple name="offer_id[]" id="offer_id" class="form-control select2-offers" data-placeholder="Select offers...">
                                @foreach($offers as $offer)
                                    <option @isset($offer_id) @foreach($offer_id as $id) {{ $id == $offer->id ? 'selected' : '' }} @endforeach @endisset value="{{ $offer->id }}">{{ $offer->name }}</option>
                                @endforeach
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <td class="label-cell"><label for="country_id" class="m-0">Countries</label></td>
                        <td>
                            <select multiple name="country_id[]" id="country_id" class="form-control select2-countries" data-placeholder="Select countries...">
                                @foreach($countries as $country)
                                    <option @isset($country_id) @foreach($country_id as $id) {{ $id == $country->id ? 'selected' : '' }} @endforeach @endisset value="{{ $country->id }}">{{ $country->name }}</option>
                                @endforeach
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <td class="label-cell">Actions</td>
                        <td>
                            <div class="filter-actions">
                                <button type="submit" class="btn btn-outline-dark">Generate Report</button>
                                <button type="button" id="resetFilters" class="btn btn-outline-secondary">Reset</button>
                                <button type="button" id="exportCsv" class="btn btn-outline-primary">Export CSV</button>
                            </div>
                        </td>
                    </tr>
                </tbody>
            </table>
        </form>
    @endsection

    @section('data_table')
        @if(isset($reports) && count($reports))
            <table id="reportTable" class="table table-bordered text-nowrap border-bottom">
                <thead>
                    <tr>
                        @if (request('s1', 1))
                            <th class="wd-20p border-bottom-0">Aff Sub 1</th>
                        @endif
                        @if (request('offer', 1))
                            <th class="wd-15p border-bottom-0">Offer</th>
                        @endif
                        @if (request('country'))
                            <th class="wd-15p border-bottom-0">Country</th>
                        @endif
                        @if (request('device'))
                            <th class="wd-15p border-bottom-0">Device</th>
                        @endif
                        @if (request('os'))
                            <th class="wd-15p border-bottom-0">OS</th>
                        @endif
                        @if (request('browser'))
                            <th class="wd-15p border-bottom-0">Browser</th>
                        @endif
                        @if (request('s2'))
                            <th class="wd-15p border-bottom-0">S2</th>
                        @endif
                        @if (request('s3'))
                            <th class="wd-15p border-bottom-0">S3</th>
                        @endif
                        @if (request('click', 1))
                            <th class="wd-15p border-bottom-0">Click</th>
                        @endif
                        @if (request('unique', 1))
                            <th class="wd-15p border-bottom-0">Unique</th>
                        @endif
                        @if (request('conversions', 1))
                            <th class="wd-15p border-bottom-0">Conversion</th>
                        @endif
                        @if (request('payout', 1))
                            <th class="wd-15p border-bottom-0">Payout</th>
                        @endif
                        @if (request('epc'))
                            <th class="wd-15p border-bottom-0">EPC</th>
                        @endif
                        @if (request('cr'))
                            <th class="wd-15p border-bottom-0">CR</th>
                        @endif
                    </tr>
                </thead>
                <tbody>
                    @foreach ($reports as $date => $report)
                        @if (count(array_filter(is_array($report) ? $report : (array) $report)) < 1)
                            @continue
                        @endif
                        <tr>
                            @if (request('s1', 1))
                                <td>{{ $date }}</td>
                            @endif
                            @if (request('offer', 1))
                                <td>{{ $report['offer_name'] ?? '-' }}</td>
                            @endif
                            @if (request('country'))
                                <td>{{ $report['country_name'] ?? '-' }}</td>
                            @endif
                            @if (request('device'))
                                <td>{{ $report['device_brand'] ? ($report['device_brand'] . ($report['device_model'] ? ' ' . $report['device_model'] : '')) : '-' }}</td>
                            @endif
                            @if (request('os'))
                                <td>{{ $report['os_name'] ?? '-' }}</td>
                            @endif
                            @if (request('browser'))
                                <td>{{ $report['browser'] ?? '-' }}</td>
                            @endif
                            @if (request('s2'))
                                <td>{{ $report['aff_sub_2'] ?? '-' }}</td>
                            @endif
                            @if (request('s3'))
                                <td>{{ $report['aff_sub_3'] ?? '-' }}</td>
                            @endif
                            @if (request('click', 1))
                                <td>{{ $report['click'] }}</td>
                            @endif
                            @if (request('unique', 1))
                                <td>{{ $report['unique_count'] }}</td>
                            @endif
                            @if (request('conversions', 1))
                                <td>{{ $report['conversion'] }}</td>
                            @endif
                            @if (request('payout', 1))
                                <td>${{ $report['payout'] }}</td>
                            @endif
                            @if (request('epc'))
                                <td>${{ $report['click'] != 0 ? number_format($report['payout'] / $report['click'], 2) : '0.00' }}</td>
                            @endif
                            @if (request('cr'))
                                <td>{{ $report['click'] != 0 ? number_format(($report['conversion'] / $report['click']) * 100, 2) . '%' : '0.00%' }}</td>
                            @endif
                        </tr>
                    @endforeach
                    <tr class="total">
                        @if (request('s1', 1))
                            <td><strong>Total</strong></td>
                        @endif
                        @if (request('offer', 1))
                            <td><strong>-</strong></td>
                        @endif
                        @if (request('country'))
                            <td><strong>-</strong></td>
                        @endif
                        @if (request('device'))
                            <td><strong>-</strong></td>
                        @endif
                        @if (request('os'))
                            <td><strong>-</strong></td>
                        @endif
                        @if (request('browser'))
                            <td><strong>-</strong></td>
                        @endif
                        @if (request('s2'))
                            <td><strong>-</strong></td>
                        @endif
                        @if (request('s3'))
                            <td><strong>-</strong></td>
                        @endif
                        @if (request('click', 1))
                            <td><strong>{{ $total['clicks'] }}</strong></td>
                        @endif
                        @if (request('unique', 1))
                            <td><strong>{{ $total['uniques'] }}</strong></td>
                        @endif
                        @if (request('conversions', 1))
                            <td><strong>{{ data_get($total,'conversions',0) }}</strong></td>
                        @endif
                        @if (request('payout', 1))
                            <td><strong>${{ $total['payouts'] }}</strong></td>
                        @endif
                        @if (request('epc'))
                            <td><strong>${{ $total['clicks'] != 0 ? number_format($total['payouts'] / $total['clicks'], 2) : '0.00' }}</strong></td>
                        @endif
                        @if (request('cr'))
                            <td><strong>{{ $total['clicks'] != 0 ? number_format(($total['conversions'] / $total['clicks']) * 100, 2) . '%' : '0.00%' }}</strong></td>
                        @endif
                    </tr>
                </tbody>
            </table>
        @else
            <div class="alert alert-info m-0">No reports found for the selected filters and date range.</div>
        @endif
    @endsection

    @includeIf('partials.affiliate-report-layout')

@endsection

@push('js')
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
    <script src="{{ asset('backend/date/moment.min.js') }}"></script>
    <script src="{{ asset('backend/date/daterangepicker.js') }}"></script>
    <script src="{{ asset('assets/plugins/datatable/js/jquery.dataTables.min.js') }}"></script>
    <script src="{{ asset('assets/plugins/datatable/js/dataTables.bootstrap5.js') }}"></script>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

    <script>
        $(function() {
            // Date Range Picker
            let dateInterval = getQueryParameter('date_filter');
            let start = moment().startOf('last Monday');
            let end = moment().endOf('this Sunday');
            if (dateInterval) {
                dateInterval = dateInterval.split(' - ');
                start = dateInterval[0];
                end = dateInterval[1];
            }
            $('#date_filter').daterangepicker({
                "showDropdowns": true,
                "showWeekNumbers": true,
                "alwaysShowCalendars": false,
                startDate: start,
                endDate: end,
                locale: {
                    format: 'YYYY-MM-DD',
                    firstDay: 1,
                },
                ranges: {
                    'Today': [moment(), moment()],
                    'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                    'Last 7 Days': [moment().subtract(6, 'days'), moment()],
                    'Last 30 Days': [moment().subtract(29, 'days'), moment()],
                    'This Month': [moment().startOf('month'), moment().endOf('month')],
                    'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
                }
            });

            // Initialize Select2 dropdowns
            $('.select2-offers').select2({
                placeholder: 'Select offers...',
                allowClear: true,
                width: '100%',
                closeOnSelect: false
            });

            $('.select2-countries').select2({
                placeholder: 'Select countries...',
                allowClear: true,
                width: '100%',
                closeOnSelect: false
            });

            // DataTable
            if ($('#reportTable').length) {
                $('#reportTable').DataTable({
                    responsive: true,
                    pageLength: 25,
                    lengthMenu: [10, 25, 50, 100],
                    order: [],
                    language: {
                        search: "",
                        searchPlaceholder: "Search reports..."
                    }
                });
            }

            // Reset Filters
            $('#resetFilters').on('click', function(){
                $('#offer_id').val(null).trigger('change');
                $('#country_id').val(null).trigger('change');
                $('#date_filter').val('');
                $("input[type='checkbox']").prop('checked', false);
                $('#offer, #click, #unique, #payout, #conversions').prop('checked', true);
            });

            // Export CSV
            $('#exportCsv').on('click', function(){
                const csv = tableToCSV(document.getElementById('reportTable'));
                const blob = new Blob([csv], { type: 'text/csv;charset=utf-8;' });
                const url = URL.createObjectURL(blob);
                const link = document.createElement('a');
                link.setAttribute('href', url);
                link.setAttribute('download', 'aff-sub-1-report.csv');
                document.body.appendChild(link);
                link.click();
                document.body.removeChild(link);
                URL.revokeObjectURL(url);
            });
        });

        function getQueryParameter(name) {
            const url = window.location.href;
            name = name.replace(/[\[\]]/g, "\\$&");
            const regex = new RegExp("[?&]" + name + "(=([^&#]*)|&|#|$)"),
                results = regex.exec(url);
            if (!results) return null;
            if (!results[2]) return '';
            return decodeURIComponent(results[2].replace(/\+/g, " "));
        }
        
        function tableToCSV(table) {
            const rows = Array.from(table.querySelectorAll('tr'));
            return rows.map(row => Array.from(row.querySelectorAll('th,td'))
                .map(cell => '"' + (cell.innerText ?? '').replace(/"/g, '""') + '"')
                .join(',')
            ).join('\n');
        }
    </script>
@endpush
