@extends('layouts.backend.affiliate_sash')

@section('title', 'Offer Reports')

@push('css')
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.8/css/dataTables.bootstrap5.min.css">
    <link rel="stylesheet" href="{{ asset('backend/date/daterangepicker.css') }}">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css">

    <style>
        .filter-section {
            background: #f8f9fa;
            border: 1px solid #dee2e6;
            padding: 20px;
            margin-bottom: 20px;
            border-radius: 5px;
        }

        .filter-section h4 {
            margin-bottom: 15px;
            color: #333;
        }

        .form-group {
            margin-bottom: 15px;
        }

        .form-group label {
            display: block;
            margin-bottom: 5px;
            font-weight: 500;
        }

        .btn-group {
            margin-top: 15px;
        }

        .btn {
            margin-right: 10px;
        }

        .total {
            font-weight: bold;
        }

        /* Select2 Custom Styling */
        .select2-container--default .select2-selection--multiple {
            border: 1px solid #ced4da;
            border-radius: 0.375rem;
            min-height: 38px;
            padding: 2px 5px;
        }

        .select2-container--default .select2-selection--multiple .select2-selection__choice {
            background-color: #007bff;
            border: 1px solid #007bff;
            color: white;
            border-radius: 3px;
            padding: 2px 8px;
            margin: 2px;
        }

        .select2-container--default .select2-selection--multiple .select2-selection__choice__remove {
            color: white;
            margin-right: 5px;
        }

        .select2-container--default .select2-selection--multiple .select2-selection__choice__remove:hover {
            color: #ff6b6b;
        }

        .select2-dropdown {
            border: 1px solid #ced4da;
            border-radius: 0.375rem;
        }

        .select2-container--default .select2-results__option--highlighted[aria-selected] {
            background-color: #007bff;
        }
    </style>
@endpush

@section('content')
    @php
        $offer_id = request('offer_id');
        $country_id = request('country_id');
    @endphp

    @section('page_title','Offer Reports')
    @section('breadcrumb_parent','Reports')
    @section('breadcrumb_active','Offer Reports')
    @section('card_title','Offer Reports')

    @section('filters_table')
        <form method="get">
            <table class="table table-bordered filter-table">
                <thead>
                    <tr>
                        <th style="width:220px">Filter</th>
                        <th>Value</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td class="label-cell"><label for="offer_id" class="m-0">Offers</label></td>
                        <td>
                            <select multiple name="offer_id[]" id="offer_id" class="form-control select2-offers" data-placeholder="Select offers...">
                                @foreach($offers as $offer)
                                    <option @isset($offer_id) @foreach($offer_id as $id) {{ $id == $offer->id ? 'selected' : '' }} @endforeach @endisset value="{{ $offer->id }}">{{ $offer->name }}</option>
                                @endforeach
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <td class="label-cell"><label for="country_id" class="m-0">Countries</label></td>
                        <td>
                            <select multiple name="country_id[]" id="country_id" class="form-control select2-countries" data-placeholder="Select countries...">
                                @foreach($countries as $country)
                                    <option @isset($country_id) @foreach($country_id as $id) {{ $id == $country->id ? 'selected' : '' }} @endforeach @endisset value="{{ $country->id }}">{{ $country->name }}</option>
                                @endforeach
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <td class="label-cell"><label for="date_filter" class="m-0">Date Range</label></td>
                        <td>
                            <input type="text" class="form-control" id="date_filter" name="date_filter" value="{{ request('date_filter') }}" placeholder="Select Date Range">
                        </td>
                    </tr>
                    <tr>
                        <td class="label-cell">Actions</td>
                        <td>
                            <div class="filter-actions">
                                <button type="submit" class="btn btn-outline-dark">Generate Report</button>
                                <button type="button" id="resetFilters" class="btn btn-outline-secondary">Reset</button>
                                <button type="button" id="exportCsv" class="btn btn-outline-primary">Export CSV</button>
                            </div>
                        </td>
                    </tr>
                </tbody>
            </table>
        </form>
    @endsection

    @section('data_table')
        @if(isset($reports) && count($reports))
            <table id="reportTable" class="table table-bordered text-nowrap border-bottom">
                <thead>
                    <tr>
                        <th class="wd-20p border-bottom-0">Offer</th>
                        <th class="wd-15p border-bottom-0">Click</th>
                        <th class="wd-15p border-bottom-0">Unique</th>
                        <th class="wd-15p border-bottom-0">Conversion</th>
                        <th class="wd-15p border-bottom-0">Payout</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($reports as $date => $report)
                        @if (count(array_filter(is_array($report) ? $report : (array) $report)) < 1)
                            @continue
                        @endif
                        @php $offer = \App\Offer::find($date); @endphp
                        <tr>
                            <td><a href="{{ route('admin.offer.show', $date) }}">({{ $date }}) {{ $offer->name??'N/A' }}</a></td>
                            <td>{{ $report['click'] }}</td>
                            <td>{{ $report['unique'] }}</td>
                            <td>{{ $report['conversion'] }}</td>
                            <td>${{ $report['payout'] }}</td>
                        </tr>
                    @endforeach
                    <tr class="total">
                        <td><strong>Total</strong></td>
                        <td><strong>{{ $total['clicks'] }}</strong></td>
                        <td><strong>{{ $total['uniques'] }}</strong></td>
                        <td><strong>{{ data_get($total,'conversions',0) }}</strong></td>
                        <td><strong>${{ $total['payouts'] }}</strong></td>
                    </tr>
                </tbody>
            </table>
        @else
            <div class="alert alert-info m-0">No reports found for the selected filters and date range.</div>
        @endif
    @endsection

    @includeIf('partials.affiliate-report-layout')

@endsection

@push('js')
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
    <script src="{{ asset('backend/date/moment.min.js') }}"></script>
    <script src="{{ asset('backend/date/daterangepicker.js') }}"></script>
    <script src="{{ asset('assets/plugins/datatable/js/jquery.dataTables.min.js') }}"></script>
    <script src="{{ asset('assets/plugins/datatable/js/dataTables.bootstrap5.js') }}"></script>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

    <script>
        $(function() {
            // Date Range Picker
            let dateInterval = getQueryParameter('date_filter');
            let start = moment().startOf('last Monday');
            let end = moment().endOf('this Sunday');
            if (dateInterval) {
                dateInterval = dateInterval.split(' - ');
                start = dateInterval[0];
                end = dateInterval[1];
            }
            $('#date_filter').daterangepicker({
                "showDropdowns": true,
                "showWeekNumbers": true,
                "alwaysShowCalendars": false,
                startDate: start,
                endDate: end,
                locale: {
                    format: 'YYYY-MM-DD',
                    firstDay: 1,
                },
                ranges: {
                    'Today': [moment(), moment()],
                    'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                    'Last 7 Days': [moment().subtract(6, 'days'), moment()],
                    'Last 30 Days': [moment().subtract(29, 'days'), moment()],
                    'This Month': [moment().startOf('month'), moment().endOf('month')],
                    'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
                }
            });

            // Initialize Select2 dropdowns
            $('.select2-offers').select2({
                placeholder: 'Select offers...',
                allowClear: true,
                width: '100%',
                closeOnSelect: false
            });

            $('.select2-countries').select2({
                placeholder: 'Select countries...',
                allowClear: true,
                width: '100%',
                closeOnSelect: false
            });

            // DataTable
            if ($('#reportTable').length) {
                $('#reportTable').DataTable({
                    responsive: true,
                    pageLength: 25,
                    lengthMenu: [10, 25, 50, 100],
                    order: [],
                    language: {
                        search: "",
                        searchPlaceholder: "Search reports..."
                    }
                });
            }

            // Reset Filters
            $('#resetFilters').on('click', function(){
                $('#offer_id').val(null).trigger('change');
                $('#country_id').val(null).trigger('change');
                $('#date_filter').val('');
            });

            // Export CSV
            $('#exportCsv').on('click', function(){
                const csv = tableToCSV(document.getElementById('reportTable'));
                const blob = new Blob([csv], { type: 'text/csv;charset=utf-8;' });
                const url = URL.createObjectURL(blob);
                const link = document.createElement('a');
                link.setAttribute('href', url);
                link.setAttribute('download', 'offer-report.csv');
                document.body.appendChild(link);
                link.click();
                document.body.removeChild(link);
                URL.revokeObjectURL(url);
            });
        });

        function getQueryParameter(name) {
            const url = window.location.href;
            name = name.replace(/[\[\]]/g, "\\$&");
            const regex = new RegExp("[?&]" + name + "(=([^&#]*)|&|#|$)"),
                results = regex.exec(url);
            if (!results) return null;
            if (!results[2]) return '';
            return decodeURIComponent(results[2].replace(/\+/g, " "));
        }
        
        function tableToCSV(table) {
            const rows = Array.from(table.querySelectorAll('tr'));
            return rows.map(row => Array.from(row.querySelectorAll('th,td'))
                .map(cell => '"' + (cell.innerText ?? '').replace(/"/g, '""') + '"')
                .join(',')
            ).join('\n');
        }
    </script>
@endpush


