@extends('auth.layouts.app')

@section('title','Reset Password')

@section('content')
    @if ($errors->any())
        <div class="alert alert-warning alert-dismissible">
            <h4><i class="icon fa fa-warning"></i> Alert!</h4>
            @foreach ($errors->all() as $error)
                <p><i class="fa fa-exclamation-circle mr-2" aria-hidden="true"></i> {{ $error }}</p>
            @endforeach
        </div>
    @endif
    <div class="card-body">
        @if (session('status'))
            <div class="alert alert-success" role="alert">
                {{ session('status') }}
            </div>
        @endif
    </div>
    @include('layouts.backend.partials.flash-message')
    <form class="card card-md" method="post" action="{{ route('password.email') }}" id="loginForm">
        @csrf
        <div class="card-body">
            <h2 class="card-title text-center mb-4">Reset Password</h2>
            <div class="mb-3">
                <label class="form-label">Email address</label>
                <input type="email" name="email" value="{{ old('email') }}"
                       class="form-control @error('email') is-invalid @enderror" placeholder="Enter email">
                @error('email')
                <span class="invalid-feedback" role="alert">
                        <strong>{{ $message }}</strong>
                    </span>
                @enderror
            </div>
            <div class="form-footer">
                {{--                <button type="submit" class="btn btn-primary w-100">Sign in</button>--}}
                <input type="submit" value="Send Password Reset Link" class="btn btn-primary w-100">
            </div>
        </div>
    </form>
@endsection
