<div class="card shadow-sm border-0 rounded-3">
    <div class="card-header bg-white border-0 d-flex justify-content-between align-items-center py-3 px-4">
        <h6 class="card-title mb-0 fw-bold text-dark">
            <i class="fe fe-user me-2 text-primary"></i>Account Manager
        </h6>
        <div class="d-flex align-items-center">
            <span class="badge bg-opacity-10 text-success me-2 fw-semibold" id="managerStatus">
                <i class="fe fe-circle me-1" style="font-size: 0.5rem;"></i>Online
            </span>
        </div>
    </div>
    <div class="card-body p-4" id="managerInfoDisplay">
        <div class="d-flex align-items-start mb-3">
            <div class="bg-primary rounded-circle d-flex align-items-center justify-content-center text-white fw-bold me-3" 
                 style="width: 60px; height: 60px; font-size: 20px;" id="managerAvatar">
                <img id="managerImage" src="" alt="Manager" class="rounded-circle" style="display: none; width: 100%; height: 100%; object-fit: cover;">
                <span id="managerInitials">AM</span>
            </div>
            <div class="flex-grow-1">
                <h6 class="mb-1 text-truncate fw-semibold" id="managerName">Your Account Manager</h6>
                <div class="mb-0">
                    <div class="fw-semibold text-dark" id="managerFullName">John Wilson</div>
                    <div class="text-muted small fst-italic" id="managerTitle">(Senior Account Manager)</div>
                </div>
            </div>
        </div>

        <div class="border-top pt-3 mb-3">
            <p class="text-muted mb-2 small" id="managerMessage">
                Feel free to contact me if you have any questions, comments, or requests.
            </p>
            <div class="fw-bold small" id="managerHours">
                <i class="fe fe-clock me-1 text-primary"></i>
                Best time to reach me is: <span class="text-primary">9am - 6pm (PST)</span>
            </div>
        </div>

        <div class="mt-auto">
            @if(auth()->user()->role === 'admin' || auth()->user()->role === 'manager')
            <div class="d-flex justify-content-between align-items-center mb-3">
                <button class="btn btn-primary flex-grow-1 me-2" id="openChatBtn">
                    <i class="fe fe-message-square me-1"></i>Start Chat
                </button>
                <button class="btn btn-outline-secondary" id="openChatPageBtn" title="Open in fullscreen">
                    <i class="fe fe-maximize-2"></i>
                </button>
            </div>
            @else
            <div class="mb-3">
                <button class="btn btn-primary w-100" id="openChatBtn">
                    <i class="fe fe-message-square me-1"></i>Start Chat
                </button>
            </div>
            @endif
            <div class="text-end small text-muted" id="managerUsername">@JohnW</div>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Load manager information
    function loadManagerInfo() {
        return fetch('{{ route("chat.data") }}')
        .then(response => {
            if (!response.ok) throw new Error('Network response was not ok.');
            return response.json();
        })
        .then(data => {
            if (data.success && data.users.length > 0) {
                const manager = data.users[0];
                const initials = manager.first_name.charAt(0).toUpperCase() + manager.last_name.charAt(0).toUpperCase();
                const fullName = `${manager.first_name} ${manager.last_name}`;
                const username = '@' + manager.first_name + manager.last_name.charAt(0);
                const title = '(Senior Account Manager)';

                // Update manager display
                document.getElementById('managerInitials').textContent = initials;
                document.getElementById('managerFullName').textContent = fullName;
                document.getElementById('managerTitle').textContent = title;
                document.getElementById('managerUsername').textContent = username;

                // Handle dynamic image
                const managerImage = document.getElementById('managerImage');
                const managerInitials = document.getElementById('managerInitials');
                
                if (manager.profile_image && manager.profile_image !== '' && manager.profile_image !== null) {
                    managerImage.src = manager.profile_image;
                    managerImage.style.display = 'block';
                    managerInitials.style.display = 'none';
                    
                    managerImage.onerror = function() {
                        managerImage.style.display = 'none';
                        managerInitials.style.display = 'flex';
                        managerInitials.textContent = initials;
                    };
                } else {
                    managerImage.style.display = 'none';
                    managerInitials.style.display = 'flex';
                    managerInitials.textContent = initials;
                }
                
                window.currentManagerId = manager.id;
                document.getElementById('openChatBtn').disabled = false;
            } else {
                document.getElementById('managerInitials').textContent = '?';
                document.getElementById('managerFullName').textContent = 'No Manager Assigned';
                document.getElementById('managerTitle').textContent = '';
                document.getElementById('managerMessage').textContent = 'Please contact support to assign a manager.';
                document.getElementById('managerHours').textContent = '';
                document.getElementById('managerUsername').textContent = '';
                document.getElementById('openChatBtn').disabled = true;
                window.currentManagerId = null;
            }
        })
        .catch(error => {
            console.error('Error loading manager info:', error);
        });
    }

    // Open Chat button - triggers chat UI component
    document.getElementById('openChatBtn').addEventListener('click', function() {
        if (!window.currentManagerId) {
             alert('No manager assigned to you');
             return;
        }
        
        fetch('{{ route("chat.get-or-create") }}', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
            },
            body: JSON.stringify({ user_id: window.currentManagerId })
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                // Trigger chat selection in chat UI component
                if (window.selectChatInUI) {
                    window.selectChatInUI(data.chat.id);
                }
                
                // On mobile, show the sidebar first, then select chat
                if (window.innerWidth <= 768 && window.showChatSidebar) {
                    window.showChatSidebar();
                    setTimeout(() => {
                        if (window.selectChatInUI) {
                            window.selectChatInUI(data.chat.id);
                        }
                    }, 100);
                }
            } else {
                alert('Error: ' + (data.error || 'Failed to create chat'));
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert('Failed to start chat');
        });
    });
    
    // Open Chat Page button (External link logic) - Only for Admin and Manager
    const openChatPageBtn = document.getElementById('openChatPageBtn');
    if (openChatPageBtn) {
        openChatPageBtn.addEventListener('click', function() {
            if (window.currentManagerId) {
                const isAdmin = {{ auth()->user()->role === 'admin' ? 'true' : 'false' }};
                const isManager = {{ auth()->user()->role === 'manager' ? 'true' : 'false' }};
                
                if (isAdmin) {
                    const chatUrl = `{{ route('admin.chat.index') }}?manager_id=${window.currentManagerId}`;
                    window.open(chatUrl, '_blank');
                } else if (isManager) {
                    const chatUrl = `{{ route('manager.chat.index') }}?manager_id=${window.currentManagerId}`;
                    window.open(chatUrl, '_blank');
                }
            } else {
                alert('No manager assigned to you');
            }
        });
    }

    // Initialize manager info
    loadManagerInfo();
});
</script>
