<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}" x-data="{ sidebarOpen: false, dark: false }" x-init="
    dark = (localStorage.getItem('aftheme') || 'dark') === 'dark';
    document.documentElement.classList.toggle('dark', dark);
" xmlns:x="http://www.w3.org/1999/xhtml">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>@yield('title') | {{ config('app.name', 'Laravel') }}</title>

    @vite(['resources/css/app.css', 'resources/js/app.js'])
    <style>[x-cloak]{display:none!important}</style>
</head>
<body class="min-h-screen bg-gradient-to-br from-gray-50 to-gray-100 text-gray-900 dark:from-gray-950 dark:to-gray-900 dark:text-gray-100 transition-colors duration-300">
    <div class="flex min-h-screen">
        <aside
            :class="sidebarOpen ? 'translate-x-0' : '-translate-x-full lg:translate-x-0'"
            class="fixed inset-y-0 left-0 z-50 w-64 transform transition-transform duration-300 ease-out lg:static lg:translate-x-0"
            @click.away="sidebarOpen = false"
        >
            <div class="flex h-full flex-col border-r border-gray-200/50 bg-white shadow-xl dark:border-gray-800/50 dark:bg-gray-900/95 backdrop-blur-xl">
                <div class="flex h-16 items-center justify-between border-b border-gray-200/50 px-5 dark:border-gray-800/50">
                    <a href="{{ route('affiliate.dashboard') }}" class="flex items-center gap-3 transition-transform hover:scale-105">
                        <div class="flex h-9 w-9 items-center justify-center rounded-xl bg-gradient-to-br from-blue-600 to-blue-700 text-white shadow-lg shadow-blue-500/30 dark:from-blue-500 dark:to-blue-600">
                            <span class="text-lg font-bold">A</span>
                        </div>
                        <span class="text-lg font-bold tracking-tight">{{ config('app.name', 'App') }}</span>
                    </a>
                    <button
                        class="lg:hidden inline-flex h-8 w-8 items-center justify-center rounded-lg text-gray-500 hover:bg-gray-100 hover:text-gray-900 dark:text-gray-400 dark:hover:bg-gray-800 dark:hover:text-gray-100 transition-colors"
                        @click="sidebarOpen=false"
                        aria-label="Close sidebar"
                    >
                        <svg class="h-5 w-5" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M6 18L18 6M6 6l12 12" />
                        </svg>
                    </button>
                </div>

                <nav class="flex-1 space-y-1 overflow-y-auto px-3 py-4">
                    <a href="{{ route('affiliate.dashboard') }}" class="group flex items-center gap-3 rounded-xl px-3 py-2.5 text-sm font-medium transition-all hover:bg-gray-100 dark:hover:bg-gray-800 {{ request()->is('affiliate/dashboard') ? 'bg-gradient-to-r from-blue-50 to-blue-100 text-blue-700 shadow-sm dark:from-blue-900/30 dark:to-blue-800/30 dark:text-blue-400' : 'text-gray-700 dark:text-gray-300' }}">
                        <svg class="h-5 w-5 flex-none {{ request()->is('affiliate/dashboard') ? 'text-blue-600 dark:text-blue-400' : 'text-gray-400 group-hover:text-gray-600 dark:text-gray-500 dark:group-hover:text-gray-300' }}" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0h6"/>
                        </svg>
                        <span>Dashboard</span>
                    </a>

                    <a href="{{ route('affiliate.offer.index') }}" class="group flex items-center gap-3 rounded-xl px-3 py-2.5 text-sm font-medium transition-all hover:bg-gray-100 dark:hover:bg-gray-800 {{ request()->is('affiliate/offer*') ? 'bg-gradient-to-r from-blue-50 to-blue-100 text-blue-700 shadow-sm dark:from-blue-900/30 dark:to-blue-800/30 dark:text-blue-400' : 'text-gray-700 dark:text-gray-300' }}">
                        <svg class="h-5 w-5 flex-none {{ request()->is('affiliate/offer*') ? 'text-blue-600 dark:text-blue-400' : 'text-gray-400 group-hover:text-gray-600 dark:text-gray-500 dark:group-hover:text-gray-300' }}" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M7 7h.01M7 3h5c.512 0 1.024.195 1.414.586l7 7a2 2 0 010 2.828l-7 7a2 2 0 01-2.828 0l-7-7A1.994 1.994 0 013 12V7a4 4 0 014-4z"/>
                        </svg>
                        <span>Offers</span>
                    </a>

                    <a href="{{ route('affiliate.offer.smartlink') }}" class="group flex items-center gap-3 rounded-xl px-3 py-2.5 text-sm font-medium transition-all hover:bg-gray-100 dark:hover:bg-gray-800 {{ request()->routeIs('affiliate.offer.smartlink') ? 'bg-gradient-to-r from-blue-50 to-blue-100 text-blue-700 shadow-sm dark:from-blue-900/30 dark:to-blue-800/30 dark:text-blue-400' : 'text-gray-700 dark:text-gray-300' }}">
                        <svg class="h-5 w-5 flex-none {{ request()->routeIs('affiliate.offer.smartlink') ? 'text-blue-600 dark:text-blue-400' : 'text-gray-400 group-hover:text-gray-600 dark:text-gray-500 dark:group-hover:text-gray-300' }}" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M13.828 10.172a4 4 0 00-5.656 0l-4 4a4 4 0 105.656 5.656l1.102-1.101m-.758-4.899a4 4 0 005.656 0l4-4a4 4 0 00-5.656-5.656l-1.1 1.1"/>
                        </svg>
                        <span>Smart Link</span>
                    </a>

                    <a href="{{ route('affiliate.announcement') }}" class="group flex items-center gap-3 rounded-xl px-3 py-2.5 text-sm font-medium transition-all hover:bg-gray-100 dark:hover:bg-gray-800 {{ request()->routeIs('affiliate.announcement') ? 'bg-gradient-to-r from-blue-50 to-blue-100 text-blue-700 shadow-sm dark:from-blue-900/30 dark:to-blue-800/30 dark:text-blue-400' : 'text-gray-700 dark:text-gray-300' }}">
                        <svg class="h-5 w-5 flex-none {{ request()->routeIs('affiliate.announcement') ? 'text-blue-600 dark:text-blue-400' : 'text-gray-400 group-hover:text-gray-600 dark:text-gray-500 dark:group-hover:text-gray-300' }}" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M15 17h5l-1.405-1.405A2.032 2.032 0 0118 14.158V11a6.002 6.002 0 00-4-5.659V5a2 2 0 10-4 0v.341C7.67 6.165 6 8.388 6 11v3.159c0 .538-.214 1.055-.595 1.436L4 17h5m6 0v1a3 3 0 11-6 0v-1m6 0H9"/>
                        </svg>
                        <span>Announcements</span>
                    </a>

                    <div class="pt-4">
                        <div class="group">
                            <div class="flex items-center gap-3 rounded-xl px-3 py-2.5 text-sm font-medium text-gray-700 dark:text-gray-300">
                                <svg class="h-5 w-5 flex-none text-gray-400 group-hover:text-gray-600 dark:text-gray-500 dark:group-hover:text-gray-300" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                    <path stroke-linecap="round" stroke-linejoin="round" d="M3 12h18M3 6h18M3 18h18" />
                                </svg>
                                <span>Reports</span>
                            </div>
                            <div class="ml-8 mt-2 space-y-1">
                                <a href="{{ route('affiliate.report.day') }}" class="block px-3 py-2 text-sm text-gray-600 hover:text-gray-900 dark:text-gray-400 dark:hover:text-gray-100">Day</a>
                                <a href="{{ route('affiliate.report.offer') }}" class="block px-3 py-2 text-sm text-gray-600 hover:text-gray-900 dark:text-gray-400 dark:hover:text-gray-100">Offer</a>
                                <a href="{{ route('affiliate.report.country') }}" class="block px-3 py-2 text-sm text-gray-600 hover:text-gray-900 dark:text-gray-400 dark:hover:text-gray-100">Country</a>
                                <a href="{{ route('affiliate.report.aff_sub_1') }}" class="block px-3 py-2 text-sm text-gray-600 hover:text-gray-900 dark:text-gray-400 dark:hover:text-gray-100">Aff Sub 1</a>
                                <a href="{{ route('affiliate.report.aff_sub_2') }}" class="block px-3 py-2 text-sm text-gray-600 hover:text-gray-900 dark:text-gray-400 dark:hover:text-gray-100">Aff Sub 2</a>
                                <a href="{{ route('affiliate.report.aff_sub_3') }}" class="block px-3 py-2 text-sm text-gray-600 hover:text-gray-900 dark:text-gray-400 dark:hover:text-gray-100">Aff Sub 3</a>
                                <a href="{{ route('affiliate.report.click') }}" class="block px-3 py-2 text-sm text-gray-600 hover:text-gray-900 dark:text-gray-400 dark:hover:text-gray-100">Click</a>
                                <a href="{{ route('affiliate.report.conversion') }}" class="block px-3 py-2 text-sm text-gray-600 hover:text-gray-900 dark:text-gray-400 dark:hover:text-gray-100">Conversion</a>
                            </div>
                        </div>
                    </div>

                    <div class="border-t border-gray-200/50 pt-4 dark:border-gray-800/50">
                        <a href="{{ route('affiliate.invoice.index') }}" class="group flex items-center gap-3 rounded-xl px-3 py-2.5 text-sm font-medium transition-all hover:bg-gray-100 dark:hover:bg-gray-800 {{ request()->is('affiliate/invoice*') ? 'bg-gradient-to-r from-blue-50 to-blue-100 text-blue-700 shadow-sm dark:from-blue-900/30 dark:to-blue-800/30 dark:text-blue-400' : 'text-gray-700 dark:text-gray-300' }}">
                            <svg class="h-5 w-5 flex-none {{ request()->is('affiliate/invoice*') ? 'text-blue-600 dark:text-blue-400' : 'text-gray-400 group-hover:text-gray-600 dark:text-gray-500 dark:group-hover:text-gray-300' }}" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"/>
                            </svg>
                            <span>Invoices</span>
                        </a>

                        <a href="{{ route('affiliate.account.postbackurl') }}" class="group flex items-center gap-3 rounded-xl px-3 py-2.5 text-sm font-medium transition-all hover:bg-gray-100 dark:hover:bg-gray-800 {{ request()->is('affiliate/account/global-postback') ? 'bg-gradient-to-r from-blue-50 to-blue-100 text-blue-700 shadow-sm dark:from-blue-900/30 dark:to-blue-800/30 dark:text-blue-400' : 'text-gray-700 dark:text-gray-300' }}">
                            <svg class="h-5 w-5 flex-none {{ request()->is('affiliate/account/global-postback') ? 'text-blue-600 dark:text-blue-400' : 'text-gray-400 group-hover:text-gray-600 dark:text-gray-500 dark:group-hover:text-gray-300' }}" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M8 9l3 3-3 3m5 0h3M5 20h14a2 2 0 002-2V6a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"/>
                            </svg>
                            <span>Postback URL</span>
                        </a>

                        <a href="{{ route('affiliate.account.index') }}" class="group flex items-center gap-3 rounded-xl px-3 py-2.5 text-sm font-medium transition-all hover:bg-gray-100 dark:hover:bg-gray-800 {{ request()->is('affiliate/account*') && !request()->is('affiliate/account/global-postback') ? 'bg-gradient-to-r from-blue-50 to-blue-100 text-blue-700 shadow-sm dark:from-blue-900/30 dark:to-blue-800/30 dark:text-blue-400' : 'text-gray-700 dark:text-gray-300' }}">
                            <svg class="h-5 w-5 flex-none {{ request()->is('affiliate/account*') && !request()->is('affiliate/account/global-postback') ? 'text-blue-600 dark:text-blue-400' : 'text-gray-400 group-hover:text-gray-600 dark:text-gray-500 dark:group-hover:text-gray-300' }}" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"/>
                            </svg>
                            <span>Account</span>
                        </a>
                    </div>

                    @if (Session::has('orig_user'))
                        <div class="border-t border-gray-200/50 pt-4 dark:border-gray-800/50">
                            <a href="{{ (App\User::find(Session::get('orig_user'))?->role ?? '') === 'manager' ? route('user.rollback.manager') : route('user.rollback') }}" class="group flex items-center gap-3 rounded-xl bg-amber-50 px-3 py-2.5 text-sm font-medium text-amber-800 transition-all hover:bg-amber-100 dark:bg-amber-900/20 dark:text-amber-400 dark:hover:bg-amber-900/30">
                                <svg class="h-5 w-5 flex-none" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                    <path stroke-linecap="round" stroke-linejoin="round" d="M3 10h10a8 8 0 018 8v2M3 10l6 6m-6-6l6-6"/>
                                </svg>
                                <span>Exit Impersonation</span>
                            </a>
                        </div>
                    @endif
                </nav>
            </div>
        </aside>

        <div class="flex min-h-screen flex-1 flex-col">
            <header class="sticky top-0 z-40 border-b border-gray-200/50 bg-white/80 backdrop-blur-xl dark:border-gray-800/50 dark:bg-gray-900/80">
                <div class="flex h-16 items-center justify-between px-4 sm:px-6 lg:px-8">
                    <div class="flex items-center gap-4">
                        <button
                            class="lg:hidden inline-flex h-9 w-9 items-center justify-center rounded-lg text-gray-500 hover:bg-gray-100 hover:text-gray-900 dark:text-gray-400 dark:hover:bg-gray-800 dark:hover:text-gray-100 transition-colors"
                            @click="sidebarOpen=true"
                            aria-label="Open sidebar"
                        >
                            <svg class="h-5 w-5" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M4 6h16M4 12h16M4 18h16"/>
                            </svg>
                        </button>
                        <div class="flex items-center gap-2 rounded-lg bg-gray-100 px-3 py-1.5 dark:bg-gray-800">
                            <span class="text-xs font-medium text-gray-500 dark:text-gray-400">ID</span>
                            <span class="text-sm font-semibold text-gray-900 dark:text-gray-100">{{ Auth::id() }}</span>
                        </div>
                    </div>

                    <div class="flex items-center gap-3">
                        <button
                            @click="dark=!dark; localStorage.setItem('aftheme', dark ? 'dark' : 'light'); document.documentElement.classList.toggle('dark', dark)"
                            class="inline-flex h-9 w-9 items-center justify-center rounded-lg text-gray-500 hover:bg-gray-100 hover:text-gray-900 dark:text-gray-400 dark:hover:bg-gray-800 dark:hover:text-gray-100 transition-colors"
                            aria-label="Toggle dark mode"
                        >
                            <svg x-show="!dark" x-cloak class="h-5 w-5" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M12 3v1m0 16v1m9-9h-1M4 12H3m15.364 6.364l-.707-.707M6.343 6.343l-.707-.707m12.728 0l-.707.707M6.343 17.657l-.707.707"/>
                                <circle cx="12" cy="12" r="4"/>
                            </svg>
                            <svg x-show="dark" x-cloak class="h-5 w-5" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M21 12.79A9 9 0 1111.21 3 7 7 0 0021 12.79z"/>
                            </svg>
                        </button>

                        <div class="flex items-center gap-3 rounded-xl border border-gray-200/50 bg-white/50 px-3 py-2 shadow-sm dark:border-gray-800/50 dark:bg-gray-800/50">
                            <img
                                class="h-8 w-8 rounded-full border-2 border-gray-200 object-cover dark:border-gray-700"
                                src="{{ Auth::user()->getAvatarUrl() ?: 'https://ui-avatars.com/api/?name='.urlencode(Auth::user()->first_name.' '.Auth::user()->last_name).'&background=3b82f6&color=fff' }}"
                                alt="{{ Auth::user()->first_name.' '.Auth::user()->last_name }}"
                            />
                            <div class="hidden sm:block">
                                <div class="text-sm font-semibold text-gray-900 dark:text-gray-100">
                                    {{ Auth::user()->first_name.' '.Auth::user()->last_name }}
                                </div>
                                <div class="text-xs font-medium text-gray-600 dark:text-gray-400">
                                    Balance: <span class="text-green-600 dark:text-green-400">${{ number_format(Auth::user()->balance, 2) }}</span>
                                </div>
                            </div>
                        </div>

                        <form method="POST" action="{{ route('logout') }}">
                            @csrf
                            <button class="inline-flex items-center gap-2 rounded-lg bg-gradient-to-r from-red-600 to-red-700 px-4 py-2 text-sm font-medium text-white shadow-lg shadow-red-500/30 transition-all hover:from-red-700 hover:to-red-800 hover:shadow-red-500/40">
                                <svg class="h-4 w-4" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                    <path stroke-linecap="round" stroke-linejoin="round" d="M17 16l4-4m0 0l-4-4m4 4H7m6 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h4a3 3 0 013 3v1"/>
                                </svg>
                                <span>Logout</span>
                            </button>
                        </form>
                    </div>
                </div>
            </header>

            <main class="flex-1 p-4 sm:p-6 lg:p-8">
                <div class="mx-auto max-w-7xl">
                    @yield('content')
                </div>
            </main>

            <footer class="border-t border-gray-200/50 bg-white/50 dark:border-gray-800/50 dark:bg-gray-900/50">
                <div class="mx-auto max-w-7xl px-4 py-6 sm:px-6 lg:px-8">
                    <div class="flex flex-col items-center justify-between gap-4 sm:flex-row">
                        <p class="text-sm text-gray-600 dark:text-gray-400">
                            &copy; {{ date('Y') }} {{ config('app.name', 'App') }}. All rights reserved.
                        </p>
                        <div class="flex items-center gap-4 text-sm text-gray-500 dark:text-gray-500">
                            <a href="#" class="hover:text-gray-900 dark:hover:text-gray-300 transition-colors">Privacy</a>
                            <span>&middot;</span>
                            <a href="#" class="hover:text-gray-900 dark:hover:text-gray-300 transition-colors">Terms</a>
                            <span>&middot;</span>
                            <a href="#" class="hover:text-gray-900 dark:hover:text-gray-300 transition-colors">Support</a>
                        </div>
                    </div>
                </div>
            </footer>
        </div>
    </div>

    <div
        x-show="sidebarOpen"
        x-cloak
        @click="sidebarOpen = false"
        class="fixed inset-0 z-40 bg-gray-900/50 backdrop-blur-sm lg:hidden"
        x-transition:enter="transition-opacity ease-linear duration-300"
        x-transition:enter-start="opacity-0"
        x-transition:enter-end="opacity-100"
        x-transition:leave="transition-opacity ease-linear duration-300"
        x-transition:leave-start="opacity-100"
        x-transition:leave-end="opacity-0"
    ></div>

    @stack('css')
    @stack('js')
</body>
</html>
