<!doctype html>
<html lang="en" dir="ltr">
<head>
    <!-- META DATA -->
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>@yield('title') | {{ config('app.name', 'Laravel') }}</title>

    <!-- FAVICON -->
    <link rel="shortcut icon" type="image/x-icon" href="{{ setting('site_favicon') ? url('public') . Storage::url(setting('site_favicon')) : asset('assets/images/brand/favicon.ico') }}">

    <!-- BOOTSTRAP CSS -->
    <link id="style" href="{{ asset('assets/plugins/bootstrap/css/bootstrap.min.css') }}" rel="stylesheet">

    <!-- STYLE CSS -->
    <link href="{{ asset('assets/css/style.css') }}" rel="stylesheet">

    <!-- Plugins CSS -->
    <link href="{{ asset('assets/css/plugins.css') }}" rel="stylesheet">

    <!-- FONT-ICONS CSS -->
    <link href="{{ asset('assets/css/icons.css') }}" rel="stylesheet">

    <!-- Switcher css (optional) -->
    <link href="{{ asset('assets/switcher/css/switcher.css') }}" rel="stylesheet">
    <link href="{{ asset('assets/switcher/demo.css') }}" rel="stylesheet">

    @stack('css')
</head>

<body class="app sidebar-mini ltr light-mode">
    <!-- GLOBAL-LOADER -->
    <div id="global-loader" style="display:none">
        <img src="{{ asset('assets/images/loader.svg') }}" class="loader-img" alt="Loader">
    </div>
    <!-- /GLOBAL-LOADER -->

    <!-- PAGE -->
    <div class="page">
        <div class="page-main">
            <!-- app-Header -->
            <div class="app-header header sticky">
                <div class="container-fluid main-container">
                    <div class="d-flex w-100">
                        <a aria-label="Hide Sidebar" class="app-sidebar__toggle" data-bs-toggle="sidebar" href="javascript:void(0)"></a>
                        <a class="logo-horizontal" href="{{ route('affiliate.dashboard') }}">
                            @if(setting('site_logo_light') && setting('site_logo_dark'))
                                <img src="{{ url('public') . Storage::url(setting('site_logo_light')) }}" class="header-brand-img desktop-logo" alt="logo">
                                <img src="{{ url('public') . Storage::url(setting('site_logo_dark')) }}" class="header-brand-img light-logo1" alt="logo">
                            @elseif(setting('site_logo_light'))
                                <img src="{{ url('public') . Storage::url(setting('site_logo_light')) }}" class="header-brand-img desktop-logo" alt="logo">
                                <img src="{{ url('public') . Storage::url(setting('site_logo_light')) }}" class="header-brand-img light-logo1" alt="logo">
                            @elseif(setting('site_logo_dark'))
                                <img src="{{ url('public') . Storage::url(setting('site_logo_dark')) }}" class="header-brand-img desktop-logo" alt="logo">
                                <img src="{{ url('public') . Storage::url(setting('site_logo_dark')) }}" class="header-brand-img light-logo1" alt="logo">
                            @else
                                <img src="{{ asset('assets/images/brand/logo-white.png') }}" class="header-brand-img desktop-logo" alt="logo">
                                <img src="{{ asset('assets/images/brand/logo-dark.png') }}" class="header-brand-img light-logo1" alt="logo">
                            @endif
                        </a>
                        <div class="main-header-center ms-3 d-none d-lg-block">
                            <input type="text" class="form-control" placeholder="Search for offers…">
                            <button class="btn px-0 pt-2" type="button"><i class="fe fe-search"></i></button>
                        </div>
                        <div class="d-flex order-lg-2 ms-auto header-right-icons">
                            <button class="navbar-toggler navresponsive-toggler d-lg-none ms-auto" type="button" data-bs-toggle="collapse" data-bs-target="#affiliateHeaderNav" aria-controls="affiliateHeaderNav" aria-expanded="false" aria-label="Toggle navigation">
                                <span class="navbar-toggler-icon fe fe-more-vertical"></span>
                            </button>
                            <div class="navbar navbar-collapse responsive-navbar p-0">
                                <div class="collapse navbar-collapse" id="affiliateHeaderNav">
                                    <div class="d-flex order-lg-2 align-items-center">
                                        <div class="dropdown d-lg-none d-flex">
                                            <a href="javascript:void(0)" class="nav-link icon" data-bs-toggle="dropdown">
                                                <i class="fe fe-search"></i>
                                            </a>
                                            <div class="dropdown-menu header-search dropdown-menu-start">
                                                <div class="input-group w-100 p-2">
                                                    <input type="text" class="form-control" placeholder="Search…">
                                                    <div class="input-group-text btn btn-primary"><i class="fe fe-search"></i></div>
                                                </div>
                                            </div>
                                        </div>
                                        <!-- Balance Section -->
                                        <div class="dropdown d-flex">
                                            <a class="nav-link icon text-center" data-bs-toggle="dropdown">
                                                <i class="fe fe-dollar-sign"></i><span class="badge bg-success header-badge">{{ number_format(Auth::user()->balance ?? 0, 0) }}</span>
                                            </a>
                                            <div class="dropdown-menu dropdown-menu-end dropdown-menu-arrow">
                                                <div class="drop-heading border-bottom">
                                                    <div class="d-flex">
                                                        <h6 class="mt-1 mb-0 fs-16 fw-semibold text-dark">Account Balance</h6>
                                                        <div class="ms-auto">
                                                            <span class="badge bg-success-transparent header-badge text-success fs-14">Active</span>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="header-dropdown-list message-menu">
                                                    <div class="dropdown-item d-flex p-4">
                                                        <div class="me-3 notifyimg bg-success brround box-shadow-success">
                                                            <i class="fe fe-dollar-sign"></i>
                                                        </div>
                                                        <div class="wd-80p">
                                                            <h5 class="notification-label mb-1">Current Balance</h5>
                                                            <span class="notification-subtext">${{ number_format(Auth::user()->balance ?? 0, 2) }}</span>
                                                        </div>
                                                    </div>
                                                    <div class="dropdown-item d-flex p-4">
                                                        <div class="me-3 notifyimg bg-warning brround box-shadow-warning">
                                                            <i class="fe fe-clock"></i>
                                                        </div>
                                                        <div class="wd-80p">
                                                            <h5 class="notification-label mb-1">Pending Amount</h5>
                                                            <span class="notification-subtext">$0.00</span>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="dropdown-divider m-0"></div>
                                                <div class="dropdown-footer">
                                                    <a class="btn btn-primary btn-pill w-sm btn-sm py-2" href="{{ route('affiliate.invoice.index') }}"><i class="fe fe-file-text"></i> View Invoices</a>
                                                    <span class="float-end p-2 fs-17 fw-semibold">Total: ${{ number_format(Auth::user()->balance ?? 0, 2) }}</span>
                                                </div>
                                            </div>
                                        </div>
                                        <!-- /Balance Section -->
                                        <div class="d-flex">
                                            <a class="nav-link icon theme-layout nav-link-bg layout-setting" href="javascript:void(0)" data-action="toggle-theme" aria-label="Toggle theme">
                                                <span class="dark-layout"><i class="fe fe-moon"></i></span>
                                                <span class="light-layout"><i class="fe fe-sun"></i></span>
                                            </a>
                                        </div>
                                        <div class="dropdown d-flex profile-1 ms-2">
                                            <a href="javascript:void(0)" data-bs-toggle="dropdown" class="nav-link leading-none d-flex align-items-center">
                                                <img src="{{ Auth::user()->getAvatarUrl() ?: 'https://ui-avatars.com/api/?name='.urlencode(Auth::user()->first_name.' '.Auth::user()->last_name).'&background=3b82f6&color=fff' }}" alt="profile-user" class="avatar profile-user brround cover-image me-2" style="width:36px;height:36px;">
                                                <span class="d-none d-md-inline fw-semibold">{{ Auth::user()->first_name.' '.Auth::user()->last_name }}</span>
                                            </a>
                                            <div class="dropdown-menu dropdown-menu-end dropdown-menu-arrow">
                                                <div class="drop-heading text-center border-bottom pb-2">
                                                    <h6 class="mb-0 fw-semibold">{{ Auth::user()->first_name.' '.Auth::user()->last_name }}</h6>
                                                    <small class="text-muted">Affiliate</small>
                                                </div>
                                                <a class="dropdown-item" href="{{ route('affiliate.account.index') }}"><i class="fe fe-user me-2"></i>Account</a>
                                                <div class="dropdown-divider"></div>
                                                <form method="POST" action="{{ route('logout') }}">
                                                    @csrf
                                                    <button class="dropdown-item" type="submit"><i class="fe fe-log-out me-2"></i>Logout</button>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /app-Header -->

            <!-- app-Sidebar -->
            <div class="app-sidebar__overlay" data-bs-toggle="sidebar"></div>
            <div class="app-sidebar">
                <div class="side-header">
                    <a class="header-brand1" href="{{ route('affiliate.dashboard') }}">
                        @if(setting('site_logo_light') && setting('site_logo_dark') && setting('site_logo_small_light') && setting('site_logo_small_dark'))
                            <img src="{{ url('public') . Storage::url(setting('site_logo_light')) }}" class="header-brand-img desktop-logo" alt="logo">
                            <img src="{{ url('public') . Storage::url(setting('site_logo_small_light')) }}" class="header-brand-img toggle-logo" alt="logo">
                            <img src="{{ url('public') . Storage::url(setting('site_logo_small_dark')) }}" class="header-brand-img light-logo" alt="logo">
                            <img src="{{ url('public') . Storage::url(setting('site_logo_dark')) }}" class="header-brand-img light-logo1" alt="logo">
                        @elseif(setting('site_logo_light') && setting('site_logo_dark'))
                            <img src="{{ url('public') . Storage::url(setting('site_logo_light')) }}" class="header-brand-img desktop-logo" alt="logo">
                            <img src="{{ url('public') . Storage::url(setting('site_logo_light')) }}" class="header-brand-img toggle-logo" alt="logo">
                            <img src="{{ url('public') . Storage::url(setting('site_logo_dark')) }}" class="header-brand-img light-logo" alt="logo">
                            <img src="{{ url('public') . Storage::url(setting('site_logo_dark')) }}" class="header-brand-img light-logo1" alt="logo">
                        @elseif(setting('site_logo_light'))
                            <img src="{{ url('public') . Storage::url(setting('site_logo_light')) }}" class="header-brand-img desktop-logo" alt="logo">
                            <img src="{{ url('public') . Storage::url(setting('site_logo_light')) }}" class="header-brand-img toggle-logo" alt="logo">
                            <img src="{{ url('public') . Storage::url(setting('site_logo_light')) }}" class="header-brand-img light-logo" alt="logo">
                            <img src="{{ url('public') . Storage::url(setting('site_logo_light')) }}" class="header-brand-img light-logo1" alt="logo">
                        @elseif(setting('site_logo_dark'))
                            <img src="{{ url('public') . Storage::url(setting('site_logo_dark')) }}" class="header-brand-img desktop-logo" alt="logo">
                            <img src="{{ url('public') . Storage::url(setting('site_logo_dark')) }}" class="header-brand-img toggle-logo" alt="logo">
                            <img src="{{ url('public') . Storage::url(setting('site_logo_dark')) }}" class="header-brand-img light-logo" alt="logo">
                            <img src="{{ url('public') . Storage::url(setting('site_logo_dark')) }}" class="header-brand-img light-logo1" alt="logo">
                        @else
                            <img src="{{ asset('assets/images/brand/logo-white.png') }}" class="header-brand-img desktop-logo" alt="logo">
                            <img src="{{ asset('assets/images/brand/icon-white.png') }}" class="header-brand-img toggle-logo" alt="logo">
                            <img src="{{ asset('assets/images/brand/icon-dark.png') }}" class="header-brand-img light-logo" alt="logo">
                            <img src="{{ asset('assets/images/brand/logo-dark.png') }}" class="header-brand-img light-logo1" alt="logo">
                        @endif
                    </a>
                    <!-- LOGO -->
                </div>
                <div class="main-sidemenu">
                    <div class="slide-left disabled" id="slide-left"><svg xmlns="http://www.w3.org/2000/svg"
                            fill="#7b8191" width="24" height="24" viewBox="0 0 24 24">
                            <path d="M13.293 6.293 7.586 12l5.707 5.707 1.414-1.414L10.414 12l4.293-4.293z" />
                        </svg></div>
                    <ul class="side-menu">
                        <li class="sub-category">
                            <h3>Main</h3>
                        </li>
                        <li class="slide">
                            <a class="side-menu__item has-link {{ request()->is('affiliate/dashboard') ? 'active' : '' }}" data-bs-toggle="slide" href="{{ route('affiliate.dashboard') }}">
                                <i class="side-menu__icon fe fe-home"></i>
                                <span class="side-menu__label">Dashboard</span>
                            </a>
                        </li>
                        <li class="sub-category">
                            <h3>Marketing</h3>
                        </li>
                        <li class="slide">
                            <a class="side-menu__item {{ request()->is('affiliate/offer*') ? 'active' : '' }}" href="{{ route('affiliate.offer.index') }}">
                                <i class="side-menu__icon fe fe-layers"></i>
                                <span class="side-menu__label">Offers</span>
                            </a>
                        </li>
                        <li class="slide">
                            <a class="side-menu__item {{ request()->routeIs('affiliate.offer.smartlink') ? 'active' : '' }}" href="{{ route('affiliate.offer.smartlink') }}">
                                <i class="side-menu__icon fe fe-link"></i>
                                <span class="side-menu__label">Smart Link</span>
                            </a>
                        </li>
                        <li class="slide">
                            <a class="side-menu__item {{ request()->routeIs('affiliate.announcement') ? 'active' : '' }}" href="{{ route('affiliate.announcement') }}">
                                <i class="side-menu__icon fe fe-bell"></i>
                                <span class="side-menu__label">Announcements</span>
                            </a>
                        </li>
                        <li class="sub-category">
                            <h3>Analytics</h3>
                        </li>
                        <li class="slide">
                            <a class="side-menu__item {{ request()->is('affiliate/report*') ? 'active' : '' }}" data-bs-toggle="slide" href="javascript:void(0)">
                                <i class="side-menu__icon fe fe-bar-chart-2"></i>
                                <span class="side-menu__label">Reports</span>
                                <i class="angle fe fe-chevron-right"></i>
                            </a>
                            <ul class="slide-menu">
                                <li><a href="{{ route('affiliate.report.day') }}" class="slide-item">Day</a></li>
                                <li><a href="{{ route('affiliate.report.offer') }}" class="slide-item">Offer</a></li>
                                <li><a href="{{ route('affiliate.report.country') }}" class="slide-item">Country</a></li>
                                <li><a href="{{ route('affiliate.report.aff_sub_1') }}" class="slide-item">Aff Sub 1</a></li>
                                <li><a href="{{ route('affiliate.report.aff_sub_2') }}" class="slide-item">Aff Sub 2</a></li>
                                <li><a href="{{ route('affiliate.report.aff_sub_3') }}" class="slide-item">Aff Sub 3</a></li>
                                <li><a href="{{ route('affiliate.report.click') }}" class="slide-item">Click</a></li>
                                <li><a href="{{ route('affiliate.report.conversion') }}" class="slide-item">Conversion</a></li>
                            </ul>
                        </li>
                        <li class="sub-category">
                            <h3>Account</h3>
                        </li>
                        <li class="slide">
                            <a class="side-menu__item {{ request()->is('affiliate/invoice*') ? 'active' : '' }}" href="{{ route('affiliate.invoice.index') }}">
                                <i class="side-menu__icon fe fe-file-text"></i>
                                <span class="side-menu__label">Invoices</span>
                            </a>
                        </li>
                        <li class="slide">
                            <a class="side-menu__item {{ request()->is('affiliate/account/global-postback') ? 'active' : '' }}" href="{{ route('affiliate.account.postbackurl') }}">
                                <i class="side-menu__icon fe fe-refresh-ccw"></i>
                                <span class="side-menu__label">Postback URL</span>
                            </a>
                        </li>
                        <li class="slide">
                            <a class="side-menu__item {{ request()->is('affiliate/account*') && !request()->is('affiliate/account/global-postback') ? 'active' : '' }}" href="{{ route('affiliate.account.index') }}">
                                <i class="side-menu__icon fe fe-user"></i>
                                <span class="side-menu__label">Account</span>
                            </a>
                        </li>
                    </ul>
                    
                </div>
            </div>
            <!-- /app-Sidebar -->

            <!-- app-content -->
            <div class="main-content app-content">
                <div class="side-app">
                    <div class="container-fluid main-container p-3">
                        @yield('content')
                    </div>
                </div>
            </div>
            <!-- /app-content -->
        </div>

        <!-- Footer -->
        <footer class="footer mt-auto py-3 bg-white border-top">
            <div class="container-fluid main-container d-flex justify-content-between">
                <span class="text-muted">&copy; <span id="year"></span> {{ config('app.name', 'App') }}</span>
                <span class="text-muted">Affiliate Panel</span>
            </div>
        </footer>
        <!-- /Footer -->
    </div>
    <!-- /PAGE -->

    <!-- SCRIPTS -->
    <script src="{{ asset('assets/js/jquery.min.js') }}"></script>
    <script src="{{ asset('assets/plugins/bootstrap/js/bootstrap.bundle.min.js') }}"></script>
    <!-- Perfect Scrollbar dependencies required by Sash sidemenu.js -->
    <script src="{{ asset('assets/plugins/p-scroll/perfect-scrollbar.js') }}"></script>
    <script src="{{ asset('assets/plugins/p-scroll/pscroll.js') }}"></script>
    <script src="{{ asset('assets/plugins/p-scroll/pscroll-1.js') }}"></script>
    <!-- Sash Sidebar -->
    <script src="{{ asset('assets/plugins/sidemenu/sidemenu.js') }}"></script>
    <!-- Shim: some Sash scripts call global index() from index1.js; provide no-op to avoid errors on pages that don't include it -->
    <script>window.index = window.index || function(){};</script>
    <script src="{{ asset('assets/js/themeColors.js') }}"></script>
    <script src="{{ asset('assets/js/custom.js') }}"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const body = document.body;
            const storageKey = 'affiliate_theme_mode';
            const toggles = document.querySelectorAll('[data-action="toggle-theme"]');
            const darkIcons = document.querySelectorAll('.layout-setting .dark-layout');
            const lightIcons = document.querySelectorAll('.layout-setting .light-layout');

            if (window.jQuery) {
                window.jQuery(document).off('click', '.layout-setting');
                window.jQuery('.layout-setting').off('click');
            }

            const applyMode = (mode) => {
                const isDark = mode === 'dark';

                body.classList.toggle('dark-mode', isDark);
                body.classList.toggle('light-mode', !isDark);
                body.classList.remove('transparent-mode');
                body.classList.remove('bg-img1', 'bg-img2', 'bg-img3', 'bg-img4');

                darkIcons.forEach(el => el.classList.toggle('d-none', isDark));
                lightIcons.forEach(el => el.classList.toggle('d-none', !isDark));

                if (isDark) {
                    localStorage.setItem('sashdarkMode', true);
                    localStorage.removeItem('sashlightMode');
                } else {
                    localStorage.setItem('sashlightMode', true);
                    localStorage.removeItem('sashdarkMode');
                }
                localStorage.removeItem('sashtransparentMode');
                localStorage.removeItem('sashBgImage');
                localStorage.setItem(storageKey, mode);
            };

            const stored = localStorage.getItem(storageKey);
            if (stored === 'dark' || stored === 'light') {
                applyMode(stored);
            } else {
                applyMode(body.classList.contains('dark-mode') ? 'dark' : 'light');
            }

            toggles.forEach(toggle => {
                toggle.addEventListener('click', function (event) {
                    event.preventDefault();
                    applyMode(body.classList.contains('dark-mode') ? 'light' : 'dark');
                });
            });
        });

    </script>

    <style>
    </style>

    @stack('js')
    
    <!-- Pusher for Live Chat -->
    <script src="https://js.pusher.com/8.2.0/pusher.min.js"></script>
</body>
</html>
