<!doctype html>
<html lang="en">
<head>
    <meta charset="utf-8"/>
    <meta name="viewport" content="width=device-width, initial-scale=1, viewport-fit=cover"/>
    <meta http-equiv="X-UA-Compatible" content="ie=edge"/>
    <link rel="icon" type="image/x-icon" href="{{ asset(Storage::url(setting('site_favicon'))) }}">

    <title>@yield('title') | {{ env('APP_NAME') }}</title>
    <!-- CSS files -->
    <link href="{{ asset('backend/dist/css/tabler.min.css')}}" rel="stylesheet"/>
    <link href="{{ asset('backend/dist/css/tabler-flags.min.css')}}" rel="stylesheet"/>
    <link href="{{ asset('backend/dist/css/tabler-payments.min.css')}}" rel="stylesheet"/>
    <link href="{{ asset('backend/dist/css/tabler-vendors.min.css')}}" rel="stylesheet"/>
    <link href="{{ asset('backend/dist/css/demo.min.css')}}" rel="stylesheet"/>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.1/css/all.min.css" integrity="sha512-KfkfwYDsLkIlwQp6LFnl8zNdLGxu9YAA1QvwINks4PhcElQSvqcyVLLD9aMhXd13uQjoXtEKNosOWaZqXgel0g==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    
    @stack('css')

</head>
<body class="{{ setting('site_theme') }}">
<div class="wrapper">
    <header class="navbar navbar-expand-md navbar-light d-print-none chloo">
        @include('layouts.backend.partials.header')
    </header>
    <div class="navbar-expand-md">
        @include('layouts.backend.partials.navbar')
    </div>
    <div class="page-wrapper">
        @yield('content')
        <footer class="footer footer-transparent d-print-none">
           @include('layouts.backend.partials.footer')
        </footer>
    </div>
</div>
<!-- Libs JS -->
<!-- Tabler Core -->
<script src="{{ asset('backend/dist/js/tabler.min.js')}}"></script>
<script src="{{ asset('backend/dist/js/demo.min.js')}}"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.1/js/all.min.js" integrity="sha512-6PM0qYu5KExuNcKt5bURAoT6KCThUmHRewN3zUFNaoI6Di7XJPTMoT6K0nsagZKk2OB4L7E3q1uQKHNHd4stIQ==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>

@stack('js')
</body>
</html>
