<!doctype html>
<html lang="en">

<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1, viewport-fit=cover" />
    <meta http-equiv="X-UA-Compatible" content="ie=edge" />
    <link rel="icon" type="image/x-icon" href="{{ url('public') . Storage::url(setting('site_favicon')) }}">

    <title>@yield('title') | {{ env('APP_NAME') }}</title>
    <!-- CSS files -->
    <link href="{{ asset('backend/dist/css/tabler.min.css') }}" rel="stylesheet" />
    <link href="{{ asset('backend/dist/css/tabler-flags.min.css') }}" rel="stylesheet" />
    <link href="{{ asset('backend/dist/css/tabler-payments.min.css') }}" rel="stylesheet" />
    <link href="{{ asset('backend/dist/css/tabler-vendors.min.css') }}" rel="stylesheet" />
    <link href="{{ asset('backend/dist/css/demo.min.css') }}" rel="stylesheet" />
    <link id="css-mode" href="{{ asset('backend/dist/css/new.css') }}" rel="stylesheet" />

    <link href="{{ asset('backend/dist/css/affiliate.css') }}" rel="stylesheet" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.1/css/all.min.css"
        integrity="sha512-KfkfwYDsLkIlwQp6LFnl8zNdLGxu9YAA1QvwINks4PhcElQSvqcyVLLD9aMhXd13uQjoXtEKNosOWaZqXgel0g=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />
    @stack('css')



    {{-- <!--Start of Tawk.to Script-->
    <script type="text/javascript">
        var Tawk_API = Tawk_API || {},
            Tawk_LoadStart = new Date();
        (function() {
            var s1 = document.createElement("script"),
                s0 = document.getElementsByTagName("script")[0];
            s1.async = true;
            s1.src = 'https://embed.tawk.to/66dff19bea492f34bc105631/1i7dcfi1p';
            s1.charset = 'UTF-8';
            s1.setAttribute('crossorigin', '*');
            s0.parentNode.insertBefore(s1, s0);
        })();
    </script> --}}
    <!--End of Tawk.to Script-->

</head>

<body class="{{ setting('site_theme') }} body-pd" id="body-pd">
    <div class="scroll-padding"></div>
    <div class="wrapper">
        <header class="header d-flex align-items-center justify-content-between" id="header">
            <div class="col-md-2 d-flex gap-md-3 align-items-center">
                <!-- Page pre-title -->
                <a href="{{ route('affiliate.dashboard') }}" class="nav_logo-name d-none d-md-block"><img
                        src="{{ url('public') . Storage::url(setting('site_logo')) }}" width="110" height="32"
                        alt="codehut" class="navbar-brand-image"></a>
                <div class="header_toggle header-toggle d-flex d-md-none" id="">
                    <i class="fa fa-bars"></i>
                </div>
            </div>
            <marquee behavior="" direction="" class="text-white col-md-7 d-none d-md-flex">
                {{ setting('scroll_text') }}</marquee>
            <div class="d-flex align-items-center justify-content-end gap-2 col-md-3 pe-4">
                <div class="nav-item dropdown">
                    @php
                        // Fetch published announcements
                        $noti = \App\Announcement::where('status', 'published')->latest()->get();

                        // Get the NotificationAchive record for the current user
                        $userNotificationArchive = \App\NotificationAchive::where('user_id', Auth::user()->id)->first();

                        // Extract the archived notification IDs (if any)
                        $archivedIds = $userNotificationArchive
                            ? explode(',', $userNotificationArchive->notification_id)
                            : [];

                        // Filter notifications that haven't been archived
                        $unarchivedNoti = $noti->filter(function ($announcement) use ($archivedIds) {
                            return !in_array($announcement->id, $archivedIds);
                        });
                    @endphp

                    <a id="" href="#" class="td-none d-flex lh-1 text-reset p-0"
                        data-bs-toggle="dropdown" aria-label="Open user menu">
                        <span class="noti">
                            <img src="{{ asset('images/bell.png') }}" alt="">
                            @if ($unarchivedNoti->count() > 0)
                                <div class="noti-count">
                                    {{ $unarchivedNoti->count() }}
                                </div>
                            @endif
                        </span>
                    </a>

                    <div class="dropdown-menu dropdown-menu-end  dropdown-menu-arrow">
                        <div class="noti-drop">
                            @foreach ($unarchivedNoti as $i)
                                <li>
                                    <a href="{{ route('affiliate.announcement.show', ['id' => $i->id]) }}"
                                        class="noti-link">{{ \Illuminate\Support\Str::words($i->title, 5, ' ...') }}</a>
                                </li>
                            @endforeach
                        </div>

                    </div>
                </div>

                <button id="dark-toggle">
                    <svg style="display: none" id="light-icon" xmlns="http://www.w3.org/2000/svg" width="26"
                        height="26" viewBox="0 0 26 26" fill="none" style="display: none;">
                        <path
                            d="M24.0828 16.0812C22.1198 16.6267 20.0471 16.641 18.0767 16.1228C16.1064 15.6046 14.3089 14.5724 12.8683 13.1317C11.4276 11.6911 10.3954 9.89367 9.8772 7.92329C9.35898 5.95291 9.37333 3.88025 9.9188 1.91724C7.98264 2.45586 6.22171 3.49249 4.81085 4.92367C3.39998 6.35486 2.38873 8.13074 1.87785 10.0744C1.36696 12.0181 1.37427 14.0617 1.89905 16.0016C2.42382 17.9416 3.44774 19.7102 4.86881 21.1313C6.28988 22.5523 8.0585 23.5762 9.99846 24.101C11.9384 24.6257 13.982 24.633 15.9257 24.1221C17.8694 23.6112 19.6452 22.5999 21.0764 21.1891C22.5076 19.7782 23.5442 18.0173 24.0828 16.0812Z"
                            stroke="white" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" />
                    </svg>
                    <svg style="display: none" id="dark-icon" xmlns="http://www.w3.org/2000/svg" width="28"
                        height="28" viewBox="0 0 28 28" fill="none">
                        <path
                            d="M14 21.5C18.1421 21.5 21.5 18.1421 21.5 14C21.5 9.85786 18.1421 6.5 14 6.5C9.85786 6.5 6.5 9.85786 6.5 14C6.5 18.1421 9.85786 21.5 14 21.5Z"
                            stroke="#12E439" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" />
                        <path d="M14 2.5V1.5" stroke="#12E439" stroke-width="2" stroke-linecap="round"
                            stroke-linejoin="round" />
                        <path d="M5.86824 5.86824L5.16113 5.16113" stroke="#12E439" stroke-width="2"
                            stroke-linecap="round" stroke-linejoin="round" />
                        <path d="M2.5 14H1.5" stroke="#12E439" stroke-width="2" stroke-linecap="round"
                            stroke-linejoin="round" />
                        <path d="M5.86824 22.1318L5.16113 22.8389" stroke="#12E439" stroke-width="2"
                            stroke-linecap="round" stroke-linejoin="round" />
                        <path d="M14 25.5V26.5" stroke="#12E439" stroke-width="2" stroke-linecap="round"
                            stroke-linejoin="round" />
                        <path d="M22.1318 22.1318L22.8389 22.8389" stroke="#12E439" stroke-width="2"
                            stroke-linecap="round" stroke-linejoin="round" />
                        <path d="M25.5 14H26.5" stroke="#12E439" stroke-width="2" stroke-linecap="round"
                            stroke-linejoin="round" />
                        <path d="M22.1318 5.86824L22.8389 5.16113" stroke="#12E439" stroke-width="2"
                            stroke-linecap="round" stroke-linejoin="round" />
                    </svg>
                </button>

                <div class="nav-item dropdown">
                    <a id="profilepic" href="#" class="td-none d-flex lh-1 text-reset p-0"
                        data-bs-toggle="dropdown" aria-label="Open user menu">
                        <span class="user-profile"><img class="img-mn"
                                src="{{ Auth::user()->getAvatarUrl() ?? '' }}"
                                alt=""></span>
                        <div class=" ps-2">
                            <div class="username">{{ Auth::user()->first_name.' '.Auth::user()->last_name }}</div>
                            <div class="mt-1 small userid d-none d-md-block">ID # {{ Auth::id() }}</div>
                            <div class="mt-1 small userid d-block d-md-none">$ {{ Auth::user()->balance }}</div>
                        </div>
                    </a>
                    <div class="dropdown-menu dropdown-menu-end dropdown-menu-arrow">
                        <a href="{{ route('affiliate.account.index') }}" class="dropdown-item">Profile & account</a>
                        <a class="dropdown-item" href="{{ route('logout') }}"
                            onclick="event.preventDefault();
                    document.getElementById('logout-form').submit();">
                            {{ __('Logout') }}
                        </a>

                        <form id="logout-form" action="{{ route('logout') }}" method="POST" class="d-none">
                            @csrf
                        </form>
                    </div>
                </div>
            </div>
        </header>
        <div class="l-navbar" id="nav-bar">
            <nav class="nav">
                <div class="nav_list">
                    <ul id="manager" class="">
                        <div class="manager">
                            <span class="avatar avatar-xl mb-3 avatar-rounded"
                                style="background-image: url({{ Auth::user()->manager->getAvatarUrl() ?? '' }}); background-color:#273238;">
                            </span>
                            <h3 class="m-0 mb-2">
                                {{ (Auth::user()?->manager?->first_name ?? '') . ' ' . (Auth::user()?->manager?->last_name ?? '') }}</h3>
                            <p class="d-flex gap-2 m-0"><i class="fa-solid fa-envelope"></i>
                                {{ Auth::user()?->manager?->email ?? '' }}</p>
                            <p class="d-flex gap-2 m-0"><i class="fa-brands fa-skype"></i>
                                {{ Auth::user()?->manager?->skype ?? '' }}</p>
                        </div>
                    </ul>
                    <!-- Navigation Links under MANAGE -->
                    <a href="{{ route('affiliate.dashboard') }}"
                        class="position-relative nav_link {{ Request::is('affiliate/dashboard') ? 'active' : '' }}">
                        <div class="rou">
                            <img src="{{ asset('images/dashbord.png') }}" width="20" class="nav_icon">

                        </div>
                        <span class="nav_name">Dashboard</span>

                    </a>
                    <a href="{{ route('affiliate.offer.index') }}"
                        class="nav_link {{ Request::is('affiliate/offer*') ? 'active' : '' }} ">
                        <div class="rou">
                            <img src="{{ asset('images/offer.png') }}" width="20" class="nav_icon">


                        </div>
                        <span class="nav_name">Offer</span>

                    </a>



                    <a href="{{ route('affiliate.offer.smartlink') }}"
                        class="nav_link {{ Request::is('offer.smartlink') ? 'active' : '' }} ">
                        <div class="rou">
                            <img src="{{ asset('images/smartlink.png') }}" width="20" class="nav_icon">
                        </div>
                        <span class="nav_name">Smart link</span>

                    </a>

                    <a href="{{ route('affiliate.announcement') }}"
                        class="nav_link {{ Request::routeIs('affiliate.announcement') ? 'active' : '' }} ">
                        <div class="rou">
                            <img src="{{ asset('images/announcement.png') }}" width="20" class="nav_icon">
                        </div>
                        <span class="nav_name">Notice</span>

                    </a>


                    <!-- Group Header: ANALYSE -->


                    <!-- Navigation Links under ANALYSE -->
                    <div class="nav_item">
                        <a href="{{ route('affiliate.report.advanced') }}"
                            class="nav_link {{ Request::is('affiliate/report/advanced') ? 'active' : '' }}">
                            <div class="rou">
                                <img src="{{ asset('images/report.png') }}" width="20" class="nav_icon">
                            </div>
                            <span class="nav_name">Reports</span>
                        </a>
                    </div>

                    <a href="{{ route('affiliate.invoice.index') }}"
                        class="nav_link {{ Request::is('affiliate/invoice*') ? 'active' : '' }}">
                        <div class="rou">
                            <img src="{{ asset('images/invoice.png') }}" width="20" class="nav_icon">

                        </div>
                        <span class="nav_name">Invoice</span>
                    </a>
                    <!-- Navigation Links under PAY -->

                    <a href="{{ route('affiliate.account.postbackurl') }}"
                        class="nav_link {{ Request::is('affiliate/account/global-postback') ? 'active' : '' }} ">
                        <div class="rou">
                            <img src="{{ asset('images/postback.png') }}" width="20" class="nav_icon">

                        </div>
                        <span class="nav_name">Postback url</span>
                    </a>

                    <a href="{{ route('affiliate.account.index') }}"
                        class="nav_link {{ Request::is('affiliate/account*') && !Request::is('affiliate/account/global-postback') ? 'active' : '' }}">
                        <div class="rou">
                            <img src="{{ asset('images/profile.png') }}" width="20" class="nav_icon">
                        </div>
                        <span class="nav_name">Account</span>
                    </a>

                    @if (Session::has('orig_user'))
                        @if (Session::has('orig_user'))
                            @php
                                $user = App\User::find(Session::get('orig_user'));
                            @endphp
                            @if ($user->role == 'manager')
                                <a class="nav_link" href="{{ route('user.rollback.manager') }}">
                                @else
                                    <a class="nav_link" href="{{ route('user.rollback') }}">
                            @endif
                        @endif
                        <div class="rou">
                            <img src="{{ asset('images/back.png') }}" width="20" class="nav_icon">

                        </div>
                        <span class="nav_name">Rollback</span>
                        </a>

                    @endif



                </div>


            </nav>
        </div>


        <!--Container Main start-->
        <div class="page-wrapper px-0 px-md-3">
            @yield('content')

            {{-- Copyright text --}}
            <footer class="footer footer-transparent d-print-none">
                @include('layouts.backend.partials.footer')
            </footer>
        </div>
    </div>
    <!-- Libs JS -->
    <!-- Tabler Core -->
    <script src="{{ asset('backend/dist/js/tabler.min.js') }}"></script>
    <script src="{{ asset('backend/dist/js/demo.min.js') }}"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.1/js/all.min.js"
        integrity="sha512-6PM0qYu5KExuNcKt5bURAoT6KCThUmHRewN3zUFNaoI6Di7XJPTMoT6K0nsagZKk2OB4L7E3q1uQKHNHd4stIQ=="
        crossorigin="anonymous" referrerpolicy="no-referrer"></script>

    @stack('js')
    <script>
        document.addEventListener("DOMContentLoaded", function(event) {
            const isMobile = window.matchMedia('(max-width: 768px)');

            const showNavbar = (toggleId, navId, bodyId, headerId) => {
                const toggles = document.querySelectorAll('.' + toggleId),
                    nav = document.getElementById(navId),
                    bodypd = document.getElementById(bodyId),
                    headerpd = document.getElementById(headerId);

                toggles.forEach(toggle => {
                    toggle.addEventListener('click', () => {
                        if (toggle && nav && bodypd && headerpd) {
                            nav.classList.toggle('show');
                            toggle.classList.toggle('bx-x');
                            bodypd.classList.toggle('body-pd');
                            headerpd.classList.toggle('body-pd');


                            // Adjust sidebar width based on show/hide
                            if (nav.classList.contains('show')) {
                                nav.style.width = '250px';
                            } else {
                                nav.style.width = '0';
                            }
                        }
                    });
                });
            };

            showNavbar('header-toggle', 'nav-bar', 'body-pd', 'header');

            const linkColor = document.querySelectorAll('.nav_link');

            function colorLink() {
                linkColor.forEach(l => l.classList.remove('active'));
                this.classList.add('active');
            }

            linkColor.forEach(l => l.addEventListener('click', colorLink));

            // Remove 'show' class and adjust sidebar width on window load if it's a larger screen
            if (!isMobile.matches) {
                window.onload = function() {
                    const nav = document.getElementById('nav-bar');
                    const bodypd = document.getElementById('body-pd');
                    const header = document.getElementById('header');
                    nav.classList.add('show');
                    bodypd.classList.add('body-pd');
                    nav.style.width = '250px';
                }
            }
        });
    </script>
    <script>
        // Function to toggle dark and light modes
        function toggleMode() {
            const body = document.body;
            const lightIcon = document.getElementById('light-icon');
            const darkIcon = document.getElementById('dark-icon');
            const cssLink = document.getElementById('css-mode');

            // Check current mode
            if (body.classList.contains('dark-mode')) {
                // Switch to light mode
                body.classList.remove('dark-mode');
                lightIcon.style.display = 'block';
                darkIcon.style.display = 'none';
                cssLink.href = "{{ asset('backend/dist/css/new.css') }}";
                localStorage.setItem('aftheme', 'light');
            } else {
                // Switch to dark mode
                body.classList.add('dark-mode');
                lightIcon.style.display = 'none';
                darkIcon.style.display = 'block';
                cssLink.href = "{{ asset('backend/dist/css/new2.css') }}?v=2";
                localStorage.setItem('aftheme', 'dark');
            }
        }

        // Event listener for toggle button
        document.getElementById('dark-toggle').addEventListener('click', toggleMode);

        // Set theme on page load based on localStorage (default to dark if unset)
        document.addEventListener("DOMContentLoaded", function(event) {
            const body = document.body;
            const lightIcon = document.getElementById('light-icon');
            const darkIcon = document.getElementById('dark-icon');
            const cssLink = document.getElementById('css-mode');
            let storedTheme = localStorage.getItem('aftheme');

            if (!storedTheme) {
                storedTheme = 'dark';
                localStorage.setItem('aftheme', 'dark');
            }

            if (storedTheme === 'dark') {
                body.classList.add('dark-mode');
                lightIcon.style.display = 'none';
                darkIcon.style.display = 'block';
                cssLink.href = "{{ asset('backend/dist/css/new2.css') }}";
            } else {
                body.classList.remove('dark-mode');
                lightIcon.style.display = 'block';
                darkIcon.style.display = 'none';
                cssLink.href = "{{ asset('backend/dist/css/new.css') }}";
            }
        });


        document.addEventListener('DOMContentLoaded', function() {
            const dropdownToggles = document.querySelectorAll('.nav_dropdown_toggle');

            dropdownToggles.forEach(toggle => {
                toggle.addEventListener('click', function(e) {
                    console.log('hello')
                    e.preventDefault();
                    const navItem = this.parentElement;

                    // Close all other dropdowns
                    document.querySelectorAll('.nav_item').forEach(item => {
                        if (item !== navItem) {
                            item.classList.remove('active');
                        }
                    });

                    // Toggle current dropdown
                    navItem.classList.toggle('active');
                });
            });


        });
    </script>

</body>

</html>
