<div class="collapse navbar-collapse" id="navbar-menu">
    <div class="navbar navbar-light">
        <div class="container-xl">
            @if (Request::is('admin*'))
                <ul class="navbar-nav flex-wrap justify-content-center">
                    <li class="nav-item {{ Request::is('admin/dashboard') ? 'active' : '' }}">
                        <a class="nav-link" href="{{ route('admin.dashboard') }}">
                            <span class="nav-link-icon d-md-none d-lg-inline-block">
                                <svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-dashboard" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round">
                                    <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                                    <path d="M12 13m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0"></path>
                                    <path d="M13.45 11.55l2.05 -2.05"></path>
                                    <path d="M6.4 20a9 9 0 1 1 11.2 0z"></path>
                                 </svg>
                            </span>
                            <span class="nav-link-title">
                                Dashboard
                            </span>
                        </a>
                    </li>
                    <li class="nav-item {{ Request::is('fraud-detected') ? 'active' : '' }}">
                        <a class="nav-link" href="{{ route('admin.fraud-detected') }}">
                            <span class="nav-link-icon d-md-none d-lg-inline-block">
                                <svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-dashboard" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round">
                                    <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                                    <path d="M12 13m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0"></path>
                                    <path d="M13.45 11.55l2.05 -2.05"></path>
                                    <path d="M6.4 20a9 9 0 1 1 11.2 0z"></path>
                                 </svg>
                            </span>
                            <span class="nav-link-title">
                                Fraud Detected
                            </span>
                        </a>
                    </li>
                    <li class="nav-item {{ Request::is('admin/announcement*') ? 'active' : '' }}  dropdown">
                        <a class="nav-link dropdown-toggle" href="#navbar-base" data-bs-toggle="dropdown"
                            data-bs-auto-close="outside" role="button" aria-expanded="false">
                            <span class="nav-link-icon d-md-none d-lg-inline-block">
                                <svg class="icon icon-tabler" xmlns="http://www.w3.org/2000/svg" width="44" height="44" viewBox="0 0 64 64" stroke-width="3" stroke="#000000" fill="none"><path d="M11.51,20.66h8.38a0,0,0,0,1,0,0V37.21a0,0,0,0,1,0,0H11.51a2,2,0,0,1-2-2V22.66A2,2,0,0,1,11.51,20.66Z"/><path d="M19.89,37.21V20.66s4.37.1,11.64,0,15.78-4.7,21.31-9.4a1,1,0,0,1,1.65.75V45.9a1,1,0,0,1-1.61.79c-3.56-2.8-12.42-9.06-21-9.32C26.86,37.21,22.8,37.21,19.89,37.21Z"/><path d="M23.29,53h-4.8a2,2,0,0,1-2-2l-1-13.78h8.8l1,13.78A2,2,0,0,1,23.29,53Z"/></svg>
                            </span>
                            <span class="nav-link-title">
                                Announcement
                            </span>
                        </a>
                        <div class="dropdown-menu">
                            <div class="dropdown-menu-columns">
                                <div class="dropdown-menu-column">
                                    <a class="dropdown-item" href="{{ route('admin.announcement.index') }}">
                                        Manage
                                    </a>
                                    <a class="dropdown-item" href="{{ route('admin.announcement.create') }}">
                                        Create
                                    </a>
                                </div>
                            </div>
                        </div>
                    </li>

                    <li class="nav-item {{ Request::is('admin/affiliate*') ? 'active' : '' }}  dropdown">
                        <a class="nav-link dropdown-toggle" href="#navbar-base" data-bs-toggle="dropdown"
                            data-bs-auto-close="outside" role="button" aria-expanded="false">
                            <span class="nav-link-icon d-md-none d-lg-inline-block">
                                <svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-user-circle"
                                    width="44" height="44" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor"
                                    fill="none" stroke-linecap="round" stroke-linejoin="round">
                                    <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                    <circle cx="12" cy="12" r="9" />
                                    <circle cx="12" cy="10" r="3" />
                                    <path d="M6.168 18.849a4 4 0 0 1 3.832 -2.849h4a4 4 0 0 1 3.834 2.855" />
                                </svg>
                            </span>
                            <span class="nav-link-title">
                                Affiliate
                            </span>
                        </a>
                        <div class="dropdown-menu">
                            <div class="dropdown-menu-columns">
                                <div class="dropdown-menu-column">
                                    <a class="dropdown-item" href="{{ route('admin.affiliate.index') }}">
                                        Manage
                                    </a>
                                    <a class="dropdown-item" href="{{ route('admin.affiliate.create') }}">
                                        Create
                                    </a>
                                </div>
                            </div>
                        </div>
                    </li>
                    <li class="nav-item {{ Request::is('admin/manager*') ? 'active' : '' }}  dropdown">
                        <a class="nav-link dropdown-toggle" href="#navbar-base" data-bs-toggle="dropdown"
                            data-bs-auto-close="outside" role="button" aria-expanded="false">
                            <span class="nav-link-icon d-md-none d-lg-inline-block">
                                <svg xmlns="http://www.w3.org/2000/svg"
                                    class="icon icon-tabler icon-tabler-user-exclamation" width="44" height="44"
                                    viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" fill="none"
                                    stroke-linecap="round" stroke-linejoin="round">
                                    <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                    <circle cx="9" cy="7" r="4" />
                                    <path d="M3 21v-2a4 4 0 0 1 4 -4h4a4 4 0 0 1 4 4v2" />
                                    <line x1="19" y1="7" x2="19" y2="10" />
                                    <line x1="19" y1="14" x2="19" y2="14.01" />
                                </svg>
                            </span>
                            <span class="nav-link-title">
                                Affiliate Manager
                            </span>
                        </a>
                        <div class="dropdown-menu">
                            <div class="dropdown-menu-columns">
                                <div class="dropdown-menu-column">
                                    <a class="dropdown-item" href="{{ route('admin.manager.index') }}">
                                        Manage
                                    </a>
                                    <a class="dropdown-item" href="{{ route('admin.manager.create') }}">
                                        Create
                                    </a>
                                </div>
                            </div>
                        </div>
                    </li>
                    <li class="nav-item {{ Request::is('admin/verticle*') ? 'active' : '' }}  dropdown">
                        <a class="nav-link dropdown-toggle" href="#navbar-base" data-bs-toggle="dropdown"
                            data-bs-auto-close="outside" role="button" aria-expanded="false">
                            <span class="nav-link-icon d-md-none d-lg-inline-block">
                                <svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-accessible" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round">
                                   <desc>Download more icon variants from https://tabler-icons.io/i/accessible</desc>
                                   <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                                   <circle cx="12" cy="12" r="9"></circle>
                                   <path d="M10 16.5l2 -3l2 3m-2 -3v-2l3 -1m-6 0l3 1"></path>
                                   <circle cx="12" cy="7.5" r=".5" fill="currentColor"></circle>
                                </svg>
                            </span>
                            <span class="nav-link-title">
                                Verticle
                            </span>
                        </a>
                        <div class="dropdown-menu">
                            <div class="dropdown-menu-columns">
                                <div class="dropdown-menu-column">
                                    <a class="dropdown-item" href="{{ route('admin.verticle.index') }}">
                                        Manage
                                    </a>
                                    <a class="dropdown-item" href="{{ route('admin.verticle.create') }}">
                                        Create
                                    </a>
                                </div>
                            </div>
                        </div>
                    </li>
                    <li class="nav-item {{ Request::is('admin/category*') ? 'active' : '' }}  dropdown">
                        <a class="nav-link dropdown-toggle" href="#navbar-base" data-bs-toggle="dropdown"
                            data-bs-auto-close="outside" role="button" aria-expanded="false">
                            <span class="nav-link-icon d-md-none d-lg-inline-block">
                                <svg xmlns="http://www.w3.org/2000/svg"
                                    class="icon icon-tabler icon-tabler-checkup-list" width="44" height="44"
                                    viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" fill="none"
                                    stroke-linecap="round" stroke-linejoin="round">
                                    <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                    <path
                                        d="M9 5h-2a2 2 0 0 0 -2 2v12a2 2 0 0 0 2 2h10a2 2 0 0 0 2 -2v-12a2 2 0 0 0 -2 -2h-2" />
                                    <rect x="9" y="3" width="6" height="4" rx="2" />
                                    <path d="M9 14h.01" />
                                    <path d="M9 17h.01" />
                                    <path d="M12 16l1 1l3 -3" />
                                </svg>
                            </span>
                            <span class="nav-link-title">
                                Category
                            </span>
                        </a>
                        <div class="dropdown-menu">
                            <div class="dropdown-menu-columns">
                                <div class="dropdown-menu-column">
                                    <a class="dropdown-item" href="{{ route('admin.category.index') }}">
                                        Manage
                                    </a>
                                    <a class="dropdown-item" href="{{ route('admin.category.create') }}">
                                        Create
                                    </a>
                                </div>
                            </div>
                        </div>
                    </li>
                    <li class="nav-item {{ Request::is('admin/advertiser*') ? 'active' : '' }}  dropdown">
                        <a class="nav-link dropdown-toggle" href="#navbar-base" data-bs-toggle="dropdown"
                            data-bs-auto-close="outside" role="button" aria-expanded="false">
                            <span class="nav-link-icon d-md-none d-lg-inline-block">
                                <svg xmlns="http://www.w3.org/2000/svg"
                                    class="icon icon-tabler icon-tabler-brand-airtable" width="44" height="44"
                                    viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" fill="none"
                                    stroke-linecap="round" stroke-linejoin="round">
                                    <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                    <path d="M3 10v8l7 -3v-2.6z" />
                                    <path d="M3 6l9 3l9 -3l-9 -3z" />
                                    <path d="M14 12.3v8.7l7 -3v-8z" />
                                </svg>
                            </span>
                            <span class="nav-link-title">
                                Advertiser
                            </span>
                        </a>
                        <div class="dropdown-menu">
                            <div class="dropdown-menu-columns">
                                <div class="dropdown-menu-column">
                                    <a class="dropdown-item" href="{{ route('admin.advertiser.index') }}">
                                        Manage
                                    </a>
                                    <a class="dropdown-item" href="{{ route('admin.advertiser.create') }}">
                                        Create
                                    </a>
                                </div>
                            </div>
                        </div>
                    </li>
                    <li class="nav-item {{ Request::is('admin/offer*') ? 'active' : '' }}  dropdown">
                        <a class="nav-link dropdown-toggle" href="#navbar-base" data-bs-toggle="dropdown"
                            data-bs-auto-close="outside" role="button" aria-expanded="false">
                            <span class="nav-link-icon d-md-none d-lg-inline-block">
                                <svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-brand-openai" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round">
                                    <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                                    <path d="M11.217 19.384a3.501 3.501 0 0 0 6.783 -1.217v-5.167l-6 -3.35"></path>
                                    <path d="M5.214 15.014a3.501 3.501 0 0 0 4.446 5.266l4.34 -2.534v-6.946"></path>
                                    <path d="M6 7.63c-1.391 -.236 -2.787 .395 -3.534 1.689a3.474 3.474 0 0 0 1.271 4.745l4.263 2.514l6 -3.348"></path>
                                    <path d="M12.783 4.616a3.501 3.501 0 0 0 -6.783 1.217v5.067l6 3.45"></path>
                                    <path d="M18.786 8.986a3.501 3.501 0 0 0 -4.446 -5.266l-4.34 2.534v6.946"></path>
                                    <path d="M18 16.302c1.391 .236 2.787 -.395 3.534 -1.689a3.474 3.474 0 0 0 -1.271 -4.745l-4.308 -2.514l-5.955 3.42"></path>
                                 </svg>
                            </span>
                            <span class="nav-link-title">
                                Offers
                            </span>
                        </a>
                        <div class="dropdown-menu">
                            <div class="dropdown-menu-columns">
                                <div class="dropdown-menu-column">

                                    <a class="dropdown-item" href="{{ route('admin.offer.index') }}">
                                        Manage
                                    </a>
                                    <a class="dropdown-item" href="{{ route('admin.offer.create') }}">
                                        Create
                                    </a>
                                    <a class="dropdown-item" href="{{ route('admin.offer.application') }}">
                                        Application
                                    </a>
                                </div>
                            </div>
                        </div>
                    </li>
                    <li class="nav-item {{ Request::is('admin/report*') ? 'active' : '' }}  dropdown">
                        <a class="nav-link dropdown-toggle" href="#navbar-base" data-bs-toggle="dropdown"
                            data-bs-auto-close="outside" role="button" aria-expanded="false">
                            <span class="nav-link-icon d-md-none d-lg-inline-block">
                                <svg xmlns="http://www.w3.org/2000/svg"
                                    class="icon icon-tabler icon-tabler-chart-infographic" width="24" height="24"
                                    viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none"
                                    stroke-linecap="round" stroke-linejoin="round">
                                    <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                                    <circle cx="7" cy="7" r="4"></circle>
                                    <path d="M7 3v4h4"></path>
                                    <line x1="9" y1="17" x2="9" y2="21"></line>
                                    <line x1="17" y1="14" x2="17" y2="21"></line>
                                    <line x1="13" y1="13" x2="13" y2="21"></line>
                                    <line x1="21" y1="12" x2="21" y2="21"></line>
                                </svg>
                            </span>
                            <span class="nav-link-title">
                                Reports
                            </span>
                        </a>
                        <div class="dropdown-menu">
                            <div class="dropdown-menu-columns">
                                <div class="dropdown-menu-column">
                                    <a class="dropdown-item" href="{{ route('admin.report.day') }}">
                                        Day
                                    </a>
                                    <a class="dropdown-item" href="{{ route('admin.report.offer') }}">
                                        Offer
                                    </a>
                                     <a class="dropdown-item" href="{{ route('admin.report.affiliate') }}">
                                        Affiliate
                                    </a>
                                    <a class="dropdown-item" href="{{ route('admin.report.country') }}">
                                        Country
                                    </a>
                                    <a class="dropdown-item" href="{{ route('admin.report.aff_sub_1') }}">
                                        Aff Sub 1
                                    </a>
                                    <a class="dropdown-item" href="{{ route('admin.report.aff_sub_2') }}">
                                        Aff Sub 2
                                    </a>
                                    <a class="dropdown-item" href="{{ route('admin.report.aff_sub_3') }}">
                                        Aff Sub 3
                                    </a>
                                    <a class="dropdown-item" href="{{ route('admin.report.click') }}">
                                        Click
                                    </a>
                                    <a class="dropdown-item" href="{{ route('admin.report.conversion') }}">
                                        Conversion
                                    </a>
                                    <a class="dropdown-item" href="{{ route('admin.report.rejected') }}">
                                        Rejected
                                    </a>
                                    <a class="dropdown-item" href="{{ route('admin.report.pending') }}">
                                        Pending ({{ App\Report::where('date',Carbon\Carbon::now()->toDateString())->where('status','pending')->count() }})
                                    </a>
                                    <a class="dropdown-item" href="{{ route('admin.report.postback.log') }}">
                                        Postback Log
                                    </a>
                                </div>
                            </div>
                        </div>
                    </li>
                    <li class="nav-item {{ Request::is('admin/finance*') ? 'active' : '' }}  dropdown">
                        <a class="nav-link dropdown-toggle" href="#navbar-base" data-bs-toggle="dropdown"
                            data-bs-auto-close="outside" role="button" aria-expanded="false">
                            <svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-report-money"
                                width="44" height="44" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor"
                                fill="none" stroke-linecap="round" stroke-linejoin="round">
                                <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                <path
                                    d="M9 5h-2a2 2 0 0 0 -2 2v12a2 2 0 0 0 2 2h10a2 2 0 0 0 2 -2v-12a2 2 0 0 0 -2 -2h-2" />
                                <rect x="9" y="3" width="6" height="4" rx="2" />
                                <path d="M14 11h-2.5a1.5 1.5 0 0 0 0 3h1a1.5 1.5 0 0 1 0 3h-2.5" />
                                <path d="M12 17v1m0 -8v1" />
                            </svg>
                            <span class="nav-link-title">
                                Finance
                            </span>
                        </a>
                        <div class="dropdown-menu">
                            <div class="dropdown-menu-columns">
                                <div class="dropdown-menu-column">
                                    <a class="dropdown-item" href="{{ route('admin.finance.index') }}">
                                        Manage
                                    </a>
                                    <a class="dropdown-item" href="{{ route('admin.finance.create') }}">
                                        Create
                                    </a>
                                </div>
                            </div>
                        </div>
                    </li>
                    <li class="nav-item {{ Request::is('admin/invoice*') ? 'active' : '' }}  dropdown">
                        <a class="nav-link dropdown-toggle" href="#navbar-base" data-bs-toggle="dropdown"
                            data-bs-auto-close="outside" role="button" aria-expanded="false">
                            <svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-credit-card" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round">
                                <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                                <path d="M3 5m0 3a3 3 0 0 1 3 -3h12a3 3 0 0 1 3 3v8a3 3 0 0 1 -3 3h-12a3 3 0 0 1 -3 -3z"></path>
                                <path d="M3 10l18 0"></path>
                                <path d="M7 15l.01 0"></path>
                                <path d="M11 15l2 0"></path>
                             </svg>
                            <span class="nav-link-title">
                                Invoice
                            </span>
                        </a>
                        <div class="dropdown-menu">
                            <div class="dropdown-menu-columns">
                                <div class="dropdown-menu-column">
                                    <a class="dropdown-item" href="{{ route('admin.invoice.index') }}">
                                        Invoice
                                    </a>
                                    <a class="dropdown-item" href="{{ route('admin.invoice.generate') }}">
                                        Generate
                                    </a>
                                </div>
                            </div>
                        </div>
                    </li>

                    <li class="nav-item {{ Request::is('admin/setting*') ? 'active' : '' }}  dropdown">
                        <a class="nav-link dropdown-toggle" href="#navbar-base" data-bs-toggle="dropdown"
                            data-bs-auto-close="outside" role="button" aria-expanded="false">
                            <svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-settings"
                                width="44" height="44" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor"
                                fill="none" stroke-linecap="round" stroke-linejoin="round">
                                <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                <path
                                    d="M10.325 4.317c.426 -1.756 2.924 -1.756 3.35 0a1.724 1.724 0 0 0 2.573 1.066c1.543 -.94 3.31 .826 2.37 2.37a1.724 1.724 0 0 0 1.065 2.572c1.756 .426 1.756 2.924 0 3.35a1.724 1.724 0 0 0 -1.066 2.573c.94 1.543 -.826 3.31 -2.37 2.37a1.724 1.724 0 0 0 -2.572 1.065c-.426 1.756 -2.924 1.756 -3.35 0a1.724 1.724 0 0 0 -2.573 -1.066c-1.543 .94 -3.31 -.826 -2.37 -2.37a1.724 1.724 0 0 0 -1.065 -2.572c-1.756 -.426 -1.756 -2.924 0 -3.35a1.724 1.724 0 0 0 1.066 -2.573c-.94 -1.543 .826 -3.31 2.37 -2.37c1 .608 2.296 .07 2.572 -1.065z" />
                                <circle cx="12" cy="12" r="3" />
                            </svg>
                            <span class="nav-link-title">
                                Settings
                            </span>
                        </a>
                        <div class="dropdown-menu">
                            <div class="dropdown-menu-columns">
                                <div class="dropdown-menu-column">
                                    <a class="dropdown-item" href="{{ route('admin.setting.general') }}">
                                        General
                                    </a>
                                    <a class="dropdown-item" href="{{ route('admin.setting.appearance') }}">
                                        Appearance
                                    </a>
                                    <a class="dropdown-item" href="{{ route('admin.setting.mail') }}">
                                        SMTP
                                    </a>
                                    <a class="dropdown-item" href="{{ route('admin.setting.question') }}">
                                        Register Question
                                    </a>
                                    <a class="dropdown-item" href="{{ route('admin.account.index') }}">
                                        Admin Account
                                    </a>
                                </div>
                            </div>
                        </div>
                    </li>
                </ul>
            @endif
            @if (Request::is('affiliate*'))
                <ul class="navbar-nav">
                    <li class="nav-item {{ Request::is('affiliate/dashboard') ? 'active' : '' }}">
                        <a class="nav-link" href="{{ route('affiliate.dashboard') }}">
                            <span class="nav-link-icon d-md-none d-lg-inline-block">
                                <svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-dashboard" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round">
                                    <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                                    <path d="M12 13m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0"></path>
                                    <path d="M13.45 11.55l2.05 -2.05"></path>
                                    <path d="M6.4 20a9 9 0 1 1 11.2 0z"></path>
                                 </svg>
                            </span>
                            <span class="nav-link-title">
                                Dashboard
                            </span>
                        </a>
                    </li>
                         <li class="nav-item {{ Request::is('affiliate/offer*') ? 'active' : '' }}  dropdown">
                        <a class="nav-link dropdown-toggle" href="#navbar-base" data-bs-toggle="dropdown"
                            data-bs-auto-close="outside" role="button" aria-expanded="false">
                            <span class="nav-link-icon d-md-none d-lg-inline-block">
                                <svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-brand-openai" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round">
                                    <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                                    <path d="M11.217 19.384a3.501 3.501 0 0 0 6.783 -1.217v-5.167l-6 -3.35"></path>
                                    <path d="M5.214 15.014a3.501 3.501 0 0 0 4.446 5.266l4.34 -2.534v-6.946"></path>
                                    <path d="M6 7.63c-1.391 -.236 -2.787 .395 -3.534 1.689a3.474 3.474 0 0 0 1.271 4.745l4.263 2.514l6 -3.348"></path>
                                    <path d="M12.783 4.616a3.501 3.501 0 0 0 -6.783 1.217v5.067l6 3.45"></path>
                                    <path d="M18.786 8.986a3.501 3.501 0 0 0 -4.446 -5.266l-4.34 2.534v6.946"></path>
                                    <path d="M18 16.302c1.391 .236 2.787 -.395 3.534 -1.689a3.474 3.474 0 0 0 -1.271 -4.745l-4.308 -2.514l-5.955 3.42"></path>
                                 </svg>
                            </span>
                            <span class="nav-link-title">
                                Offers
                            </span>
                        </a>
                        <div class="dropdown-menu">
                            <div class="dropdown-menu-columns">
                                <div class="dropdown-menu-column">
                                     @php
                                        $categories = App\Category::all();
                                    @endphp
                                    @foreach($categories as $category)
                                         <a class="dropdown-item" href="{{ route('affiliate.offer.index') }}?filter=filter&category_id={{$category->id}}">
                                            {{$category->name}}
                                        </a>
                                    @endforeach
                                    <a class="dropdown-item" href="{{ route('affiliate.offer.index') }}">
                                        All Offers
                                    </a>

                                </div>
                            </div>
                        </div>
                    </li>
                    <li class="nav-item {{ Request::is('affiliate/report/advanced') ? 'active' : '' }}">
                        <a class="nav-link" href="{{ route('affiliate.report.advanced') }}">
                            <span class="nav-link-icon d-md-none d-lg-inline-block">
                                <svg xmlns="http://www.w3.org/2000/svg"
                                     class="icon icon-tabler icon-tabler-chart-infographic" width="24" height="24"
                                     viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none"
                                     stroke-linecap="round" stroke-linejoin="round">
                                    <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                                    <circle cx="7" cy="7" r="4"></circle>
                                    <path d="M7 3v4h4"></path>
                                    <line x1="9" y1="17" x2="9" y2="21"></line>
                                    <line x1="17" y1="14" x2="17" y2="21"></line>
                                    <line x1="13" y1="13" x2="13" y2="21"></line>
                                    <line x1="21" y1="12" x2="21" y2="21"></line>
                                </svg>
                            </span>
                            <span class="nav-link-title">
                                Reports
                            </span>
                        </a>
                    </li>
                    <li class="nav-item {{ Request::is('affiliate/invoice*') ? 'active' : '' }}">
                        <a class="nav-link" href="{{ route('affiliate.invoice.index') }}">
                            <span class="nav-link-icon d-md-none d-lg-inline-block">
                                <svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-credit-card" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round">
                                    <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                                    <path d="M3 5m0 3a3 3 0 0 1 3 -3h12a3 3 0 0 1 3 3v8a3 3 0 0 1 -3 3h-12a3 3 0 0 1 -3 -3z"></path>
                                    <path d="M3 10l18 0"></path>
                                    <path d="M7 15l.01 0"></path>
                                    <path d="M11 15l2 0"></path>
                                 </svg>
                            </span>
                            <span class="nav-link-title">
                                Invoice
                            </span>
                        </a>
                    </li>
                    <li class="nav-item {{ Request::is('affiliate/account*') ? 'active' : '' }}">
                        <a class="nav-link" href="{{ route('affiliate.account.index') }}">
                            <span class="nav-link-icon d-md-none d-lg-inline-block">
                                <svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-user-circle" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round">
                                    <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                                    <path d="M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0"></path>
                                    <path d="M12 10m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0"></path>
                                    <path d="M6.168 18.849a4 4 0 0 1 3.832 -2.849h4a4 4 0 0 1 3.834 2.855"></path>
                                 </svg>
                            </span>
                            <span class="nav-link-title">
                                Account
                            </span>
                        </a>
                    </li>
                    <li class="nav-item  dropdown">
                        <a class="nav-link dropdown-toggle" href="#navbar-base" data-bs-toggle="dropdown"
                           data-bs-auto-close="outside" role="button" aria-expanded="false">
                            <strong class="nav-link-title">
                                Your Manager
                            </strong>
                        </a>
                        <div class="dropdown-menu">
                            <div class="w-100">
                                <div class="card">
                                    <div class="card-body p-4 text-center">
                                        <span class="avatar avatar-xl mb-3 avatar-rounded" style="background-image: url({{ Auth::user()->manager->getAvatarUrl() ?: '' }})"></span>
                                        <h3 class="m-0 mb-1">{{ Auth::user()->manager->first_name .' ' . Auth::user()->manager->last_name  }}</h3>
                                        <div class="text-muted">Email : {{ Auth::user()->manager->email }}</div>
                                        <div class="text-muted">Skype : {{ Auth::user()->manager->skype }}</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </li>
                    @if (Session::has('orig_user'))
                        <li class="nav-item">
                            @if (Session::has('orig_user'))
                                @php
                                    $user = App\User::find(Session::get('orig_user'));
                                @endphp
                                @if ($user->role == 'manager')
                                    <a class="nav-link" href="{{ route('user.rollback.manager') }}">
                                    @else
                                        <a class="nav-link" href="{{ route('user.rollback') }}">
                                @endif
                            @endif
                            <span class="nav-link-icon d-md-none d-lg-inline-block">
                                <svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-arrow-back"
                                    width="44" height="44" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor"
                                    fill="none" stroke-linecap="round" stroke-linejoin="round">
                                    <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                    <path d="M9 11l-4 4l4 4m-4 -4h11a4 4 0 0 0 0 -8h-1" />
                                </svg>
                            </span>
                            <span class="nav-link-title">
                                Rollback
                            </span>
                            </a>
                        </li>
                    @endif
                </ul>
            @endif
            @if (Request::is('manager*'))
                <ul class="navbar-nav">
                    <li class="nav-item {{ Request::is('manager/dashboard') ? 'active' : '' }}">
                        <a class="nav-link" href="{{ route('manager.dashboard') }}">
                            <span class="nav-link-icon d-md-none d-lg-inline-block">

                            </span>
                            <span class="nav-link-title">
                                Dashboard
                            </span>
                        </a>
                    </li>
                    <li class="nav-item {{ Request::is('manager/affiliate*') ? 'active' : '' }}  dropdown">
                        <a class="nav-link dropdown-toggle" href="#navbar-base" data-bs-toggle="dropdown"
                            data-bs-auto-close="outside" role="button" aria-expanded="false">
                            <span class="nav-link-icon d-md-none d-lg-inline-block">
                                <svg xmlns="http://www.w3.org/2000/svg"
                                    class="icon icon-tabler icon-tabler-user-circle" width="44" height="44"
                                    viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" fill="none"
                                    stroke-linecap="round" stroke-linejoin="round">
                                    <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                    <circle cx="12" cy="12" r="9" />
                                    <circle cx="12" cy="10" r="3" />
                                    <path d="M6.168 18.849a4 4 0 0 1 3.832 -2.849h4a4 4 0 0 1 3.834 2.855" />
                                </svg>
                            </span>
                            <span class="nav-link-title">
                                Affiliate
                            </span>
                        </a>
                        <div class="dropdown-menu">
                            <div class="dropdown-menu-columns">
                                <div class="dropdown-menu-column">
                                    <a class="dropdown-item" href="{{ route('manager.affiliate.index') }}">
                                        Manage
                                    </a>
                                    <a class="dropdown-item" href="{{ route('manager.affiliate.create') }}">
                                        Create
                                    </a>
                                </div>
                            </div>
                        </div>
                    </li>
                    <li class="nav-item {{ Request::is('manager/offer*') ? 'active' : '' }}  dropdown">
                        <a class="nav-link dropdown-toggle" href="#navbar-base" data-bs-toggle="dropdown"
                            data-bs-auto-close="outside" role="button" aria-expanded="false">
                            <span class="nav-link-icon d-md-none d-lg-inline-block">
                                <svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-brand-openai" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round">
                                    <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                                    <path d="M11.217 19.384a3.501 3.501 0 0 0 6.783 -1.217v-5.167l-6 -3.35"></path>
                                    <path d="M5.214 15.014a3.501 3.501 0 0 0 4.446 5.266l4.34 -2.534v-6.946"></path>
                                    <path d="M6 7.63c-1.391 -.236 -2.787 .395 -3.534 1.689a3.474 3.474 0 0 0 1.271 4.745l4.263 2.514l6 -3.348"></path>
                                    <path d="M12.783 4.616a3.501 3.501 0 0 0 -6.783 1.217v5.067l6 3.45"></path>
                                    <path d="M18.786 8.986a3.501 3.501 0 0 0 -4.446 -5.266l-4.34 2.534v6.946"></path>
                                    <path d="M18 16.302c1.391 .236 2.787 -.395 3.534 -1.689a3.474 3.474 0 0 0 -1.271 -4.745l-4.308 -2.514l-5.955 3.42"></path>
                                 </svg>
                            </span>
                            <span class="nav-link-title">
                                Offers
                            </span>
                        </a>
                        <div class="dropdown-menu">
                            <div class="dropdown-menu-columns">
                                <div class="dropdown-menu-column">
                                    <a class="dropdown-item" href="{{ route('manager.offer.index') }}">
                                        Manage
                                    </a>
                                    <a class="dropdown-item" href="{{ route('manager.offer.application') }}">
                                        Application
                                    </a>
                                </div>
                            </div>
                        </div>
                    </li>
                    <li class="nav-item {{ Request::is('manager/report*') ? 'active' : '' }}  dropdown">
                        <a class="nav-link dropdown-toggle" href="#navbar-base" data-bs-toggle="dropdown"
                           data-bs-auto-close="outside" role="button" aria-expanded="false">
                            <span class="nav-link-icon d-md-none d-lg-inline-block">
                                <svg xmlns="http://www.w3.org/2000/svg"
                                     class="icon icon-tabler icon-tabler-chart-infographic" width="24" height="24"
                                     viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none"
                                     stroke-linecap="round" stroke-linejoin="round">
                                    <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                                    <circle cx="7" cy="7" r="4"></circle>
                                    <path d="M7 3v4h4"></path>
                                    <line x1="9" y1="17" x2="9" y2="21"></line>
                                    <line x1="17" y1="14" x2="17" y2="21"></line>
                                    <line x1="13" y1="13" x2="13" y2="21"></line>
                                    <line x1="21" y1="12" x2="21" y2="21"></line>
                                </svg>
                            </span>
                            <span class="nav-link-title">
                                Reports
                            </span>
                        </a>
                        <div class="dropdown-menu">
                            <div class="dropdown-menu-columns">
                                <div class="dropdown-menu-column">
                                    <a class="dropdown-item" href="{{ route('manager.report.day') }}">
                                        Day
                                    </a>
                                    <a class="dropdown-item" href="{{ route('manager.report.offer') }}">
                                        Offer
                                    </a>
                                    <a class="dropdown-item" href="{{ route('manager.report.country') }}">
                                        Country
                                    </a>
                                    <a class="dropdown-item" href="{{ route('manager.report.aff_sub_1') }}">
                                        Aff Sub 1
                                    </a>
                                    <a class="dropdown-item" href="{{ route('manager.report.aff_sub_2') }}">
                                        Aff Sub 2
                                    </a>
                                    <a class="dropdown-item" href="{{ route('manager.report.aff_sub_3') }}">
                                        Aff Sub 3
                                    </a>
                                    <a class="dropdown-item" href="{{ route('manager.report.click') }}">
                                        Click
                                    </a>
                                    <a class="dropdown-item" href="{{ route('manager.report.conversion') }}">
                                        Conversion
                                    </a>

                                </div>
                            </div>
                        </div>
                    </li>
                    <li class="nav-item {{ Request::is('manager/account*') ? 'active' : '' }}">
                        <a class="nav-link" href="{{ route('manager.account.index') }}">
                            <span class="nav-link-icon d-md-none d-lg-inline-block">
                                <svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-user-circle" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round">
                                    <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                                    <path d="M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0"></path>
                                    <path d="M12 10m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0"></path>
                                    <path d="M6.168 18.849a4 4 0 0 1 3.832 -2.849h4a4 4 0 0 1 3.834 2.855"></path>
                                 </svg>
                            </span>
                            <span class="nav-link-title">
                                Account
                            </span>
                        </a>
                    </li>
                    @if (Session::has('orig_user'))
                        <li class="nav-item">
                            <a class="nav-link" href="{{ route('manager.rollback') }}">
                                <span class="nav-link-icon d-md-none d-lg-inline-block">
                                    <svg xmlns="http://www.w3.org/2000/svg"
                                        class="icon icon-tabler icon-tabler-arrow-back" width="44" height="44"
                                        viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" fill="none"
                                        stroke-linecap="round" stroke-linejoin="round">
                                        <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                        <path d="M9 11l-4 4l4 4m-4 -4h11a4 4 0 0 0 0 -8h-1" />
                                    </svg>
                                </span>
                                <span class="nav-link-title">
                                    Rollback
                                </span>
                            </a>
                        </li>
                    @endif
                </ul>
            @endif
        </div>
    </div>
</div>