@extends('layouts.backend.manager_sash')

@section('title', 'Edit Profile')


@push('css')
    <link href="https://cdn.jsdelivr.net/npm/tom-select@2.0.1/dist/css/tom-select.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/tom-select@2.0.1/dist/css/tom-select.bootstrap5.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.css" rel="stylesheet">
    <script src="{{ asset('css/app.css') }}"></script>
@endpush

@section('content')
    <div class="container-xl">
        <!-- Page title -->
        <div class="page-header d-print-none">
            <div class="row align-items-center">
                <div class="col">
                    <!-- Page pre-title -->
                    <div class="page-pretitle">
                        Overview
                    </div>
                    <h2 class="page-title">
                        @yield(('title'))
                    </h2>
                </div>
                <!-- Page title actions -->
            </div>
        </div>
    </div>
    <div class="page-body">
        <div class="container-xl">
            <form action="{{ route('manager.account.update') }}" method="post" enctype="multipart/form-data">
                @csrf
                @method('PUT')
                <div class="row row-cards">
                    <div class="col-md-6">
                        <div class="card">
                            <div class="card-header">
                                <h3 class="card-title">Basic Info</h3>
                            </div>
                            @include('layouts.backend.partials.flash-message')
                            @if ($errors->any())
                                <div class="alert alert-danger">
                                    <ul>
                                        @foreach ($errors->all() as $error)
                                            <li>{{ $error }}</li>
                                        @endforeach
                                    </ul>
                                </div>
                            @endif
                            <div class="card-body">
                                <div class="form-group mb-3 ">
                                    <label class="form-label">First Name</label>
                                    <div>
                                        <input type="text" class="form-control" name="first_name"
                                            value="{{ Auth::user()->first_name ?? old('first_name') }}"
                                            placeholder="First Name" required>
                                    </div>
                                    @error('first_name')
                                        <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="form-group mb-3 ">
                                    <label class="form-label">Last Name</label>
                                    <div>
                                        <input type="text" class="form-control" name="last_name"
                                            value="{{ Auth::user()->last_name ?? old('last_name') }}"
                                            placeholder="Last Name" required>
                                    </div>
                                </div>
                                <div class="form-group mb-3 ">
                                    <label class="form-label">Email</label>
                                    <div>
                                        <input type="email" class="form-control" name="email"
                                            value="{{ Auth::user()->email ?? old('email') }}" placeholder="Email"
                                            required>
                                    </div>
                                </div>
                                <div class="form-group mb-3 ">
                                    <label class="form-label">Country</label>
                                    <div>
                                        <select name="country_id" class="form-select" id="country_id"
                                            placeholder="  Select a country..." required>
                                            <option selected disabled>Select Country</option>
                                            @foreach ($countries as $country)
                                                <option {{ Auth::user()->country_id == $country->id ? 'selected' : '' }}
                                                    value="{{ $country->id }}">{{ $country->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="form-group mb-3 ">
                                    <label class="form-label">Skype</label>
                                    <div>
                                        <input type="text" class="form-control" name="skype"
                                            value="{{ Auth::user()->skype ?? old('skype') }}" placeholder="Skype"
                                            required>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="card">
                            <div class="card-header">
                                <h3 class="card-title">Password & Image</h3>
                            </div>
                            <div class="card-body">
                                <div class="form-group mb-3 ">
                                    <label class="form-label">Current Password</label>
                                    <div>
                                        <input type="password" name="old_password" class="form-control"
                                            placeholder="Current Password">
                                    </div>
                                </div>
                                <div class="form-group mb-3 ">
                                    <label class="form-label">New Password</label>
                                    <div>
                                        <input type="password" name="password" class="form-control"
                                            placeholder="Password">
                                        <small class="form-hint">
                                            Your password must be 6-20 characters long, contain letters and numbers, and
                                            must not contain
                                            spaces, special characters, or emoji.
                                        </small>
                                    </div>
                                </div>
                                <div class="form-group mb-3 ">
                                    <label class="form-label">Confirm Password</label>
                                    <div>
                                        <input type="password" name="password_confirmation" class="form-control"
                                            placeholder="Password">
                                    </div>
                                </div>
                                <div class="form-group mb-3 ">
                                    <label class="form-label">Avater</label>
                                    <div>
                                        <input type="file" name="avater" class="form-control">
                                    </div>
                                </div>
                                <div class="form-footer">
                                    <button type="submit" class="btn btn-primary">Update</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
    <div class="page-body">
        <div class="container-xl">
            <div class="row row-cards">
                <div class="col-md-6">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">Payment Info</h3>
                        </div>
                        @if ($message = Session::get('payment_info_success'))
                            <div class="alert alert-success alert-block">
                                <button type="button" class="close" data-dismiss="alert">×</button>
                                <strong>{{ $message }}</strong>
                            </div>
                        @endif
                        @if ($errors->any())
                            <div class="alert alert-danger">
                                <ul>
                                    @foreach ($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        @endif
                        <div class="card-body">
                            <form action="{{ route('manager.account.paymentUpdate') }}" method="POST">
                                @csrf
                                <div class="form-group mb-3 ">
                                    <label class="form-label">Payment Method</label>
                                    <div>
                                        <select name="finance_id" class="form-select" id="finance_id"
                                            placeholder="  Select a Finance..." required>
                                            @foreach ($finances as $finance)
                                                <option
                                                    @isset(Auth::user()->paymentMethod) {{ Auth::user()->paymentMethod->finance_id == $finance->id ? 'selected' : '' }} @endisset
                                                    value="{{ $finance->id }}">{{ $finance->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <br>
                                    <label class="form-label">Wallet</label>
                                    <div>
                                        <textarea name="wallet" id="wallet"
                                            class="form-control">{{ Auth::user()->paymentMethod->wallet ?? old('wallet') }}</textarea>
                                    </div>
                                    <div class="form-footer">
                                        <button type="submit" class="btn btn-primary">Update</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    @endsection

    @push('js')
        <script src="https://cdn.jsdelivr.net/npm/tom-select@2.0.1/dist/js/tom-select.complete.min.js"></script>
        <script src="{{ asset('js/app.js') }}"></script>
        <script>
            new TomSelect('#country_id', {
                plugins: ['input_autogrow'],
            });
            new TomSelect('#finance_id', {
                plugins: ['input_autogrow'],
            });
        </script>
    @endpush
