@extends('layouts.backend.manager_sash')

@section('title',$affiliate->first_name.' '.$affiliate->last_name)

@push('css')
    <link href="https://cdn.jsdelivr.net/npm/tom-select@2.0.1/dist/css/tom-select.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/tom-select@2.0.1/dist/css/tom-select.bootstrap5.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.css" rel="stylesheet">
    <link href="{{ asset('backend/dist/css/tabler-flags.min.css')}}" rel="stylesheet"/>
    <style>
        tr{
            font-weight: bold;
        }
    </style>
@endpush

@section('content')
    <div class="container-xl">
        <!-- Page title -->
        <div class="page-header d-print-none">
            <div class="row align-items-center">
                <div class="col">
                    <!-- Page pre-title -->
                    <div class="page-pretitle">
                        Overview
                    </div>
                    <h2 class="page-title">
                        @yield(('title'))
                    </h2>
                </div>
                <!-- Page title actions -->
                <div class="col-auto ms-auto d-print-none">
                    <div class="btn-list">
                        <a href="{{ route('manager.affiliate.index') }}" class="btn btn-primary d-none d-sm-inline-block">
                            <!-- Download SVG icon from http://tabler-icons.io/i/plus -->
                            <i class="fa fa-backward" aria-hidden="true"></i>
                            Back
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="page-body">
        <div class="container-xl">
            <div class="row row-cards">
                <div class="col-lg-8">
                    <div class="card card-lg">
                        <div class="card-body">
                            <div class="markdown">
                                <h3 id="tabler-free-license">Affiliate Information</h3>
                                <p>Name : {{ $affiliate->first_name }} {{ $affiliate->last_name }}</p>
                                <p>Email : {{ $affiliate->email }}</p>
                                <p>Skype : {{ $affiliate->skype }}</p>
                                <p>Country : {{ $affiliate->country->name ?? 'N/A' }}</p>
                                <p>Manager Name : {{ $affiliate->manager->first_name }} {{ $affiliate->manager->last_name }}</p>
                                <p>Balance : {{ $affiliate->balance }}</p>
                                <p>Status : {{ $affiliate->status }}</p>
                                <h3 id="tabler-pro-and-tabler-email-license">Offer Blocked</h3>
                                <form action="{{  route('manager.affiliate.offer.blocked',$affiliate->id) }}" method="POST">
                                    @csrf
                                    <div class="form-group">
                                        <select multiple name="offer_id[]" id="offer_id" class="form-select">
                                            @foreach($offers as $offer)
                                                <option
                                                    @if ($affiliate->offers)
                                                        @foreach ($affiliate->offers as $data)
                                                            @if ($data->id == $offer->id)
                                                                {{ 'selected' }}
                                                            @endif
                                                        @endforeach
                                                    @endif
                                                 value="{{ $offer->id }}">{{ $offer->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <br>
                                    <div class="form-group">
                                        <button class="btn btn-success">Update</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="card">
                        <div class="card-body">
                            <div class="d-flex align-items-center mb-3">
                                <div class="me-3">
                                    <div>
                                        <h3 class="lh-1">Switch</h3>
                                    </div>
                                    <a href="" class="btn btn-success btn-sm">
                                        <i class="fa fa-unlock"></i>
                                        <span>Login</span>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('js')
    <script src="https://cdn.jsdelivr.net/npm/tom-select@2.0.1/dist/js/tom-select.complete.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js" integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous"></script>
    <script>
        new TomSelect('#offer_id',{
            plugins: ['input_autogrow'],
        });
    </script>
@endpush
