@extends('layouts.backend.manager_sash')

@section('title','Offer Application')

@push('css')
    <link href="https://cdn.jsdelivr.net/npm/tom-select@2.0.1/dist/css/tom-select.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/tom-select@2.0.1/dist/css/tom-select.bootstrap5.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.css" rel="stylesheet">
    <link href="{{ asset('backend/dist/css/tabler-flags.min.css')}}" rel="stylesheet"/>
@endpush

@section('content')
    @php
      $user_id = request('user_id');
      $offer_id = request('offer_id');
    @endphp
    <div class="container-xl">
        <!-- Page title -->
        <div class="page-header d-print-none">
            <div class="row align-items-center">
                <div class="col">
                    <!-- Page pre-title -->
                    <div class="page-pretitle">
                        Overview
                    </div>
                    <h2 class="page-title">
                        @yield(('title'))
                    </h2>
                </div>
                <!-- Page title actions -->
            </div>
        </div>
    </div>
    <div class="page-body">
        <div class="container-xl">
            <div class="col-md-12">
                <form action="">
                    <input type="hidden" name="filter" value="filter">
                    <div class="card">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-3">
                                    <h3 class="form-group">Affiliate</h3>
                                    <div class="input-icon">
                                        <select multiple name="user_id[]" id="user_id" class="form-select" placeholder="Select Affiliate">
                                            @foreach($users as $user)
                                                <option
                                                    @isset($user_id)
                                                        @foreach($user_id as $id)
                                                           {{ $id == $user->id ? 'selected' : '' }}
                                                         @endforeach
                                                    @endisset
                                                    value="{{ $user->id }}">{{ $user->first_name . $user->last_name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <h3 class="form-group">Offers</h3>
                                    <div class="input-icon">
                                        <select multiple name="offer_id[]" id="offer_id" class="form-select" placeholder="Select Offers">
                                            @foreach($offers as $offer)
                                                <option
                                                    @isset($offer_id)
                                                        @foreach($offer_id as $id)
                                                        {{ $id == $offer->id ? 'selected' : '' }}
                                                        @endforeach
                                                    @endisset
                                                    value="{{ $offer->id }}">{{ $offer->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card-footer">
                            <div class="row align-items-center">
                                <div class="col-auto">
                                    <button  class="btn btn-primary">
                                        Filter
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
            <br>
            <div class="col-12">
                <div class="card">
                    <div class="table-responsive">
                        <table class="table table-vcenter table-mobile-md card-table">
                            <thead>
                            <tr>
                                <th>ID</th>
                                <th>Offer Name</th>
                                <th>Affiliate Name</th>
                                <th>Message</th>
                                <th>Status</th>
                                <th>Action</th>
                            </tr>
                            </thead>
                            <tbody>
                            @foreach($applications as $application)
                                <tr>
                                    <td data-label="ID">
                                        {{ $application->id }}
                                    </td>
                                    <td data-label="Offer Name">
                                       {{ $application->offer->name }}
                                    </td>
                                    <td data-label="Affiliate Name">
                                        {{ $application->user->first_name . $application->user->last_name }}
                                    </td>
                                    <td data-label="Message">
                                       {{ $application->message }}
                                    </td>
                                    <td data-label="Status">
                                        @if ($application->status == false)
                                             <div class="text-muted"><span class="badge bg-danger">Pending</span></div>
                                            @else
                                            <div class="text-muted"><span class="badge bg-success">Approved</span></div>
                                        @endif
                                    </td>
                                    <td data-label="Action">
                                        <a onclick="return confirm('are u sure to approved?')" href="{{ route('manager.offer.application.approved',$application->id) }}" class="btn btn-sm btn-success">
                                            <i class="fa fa-check"></i>
                                        </a>
                                    </td>
                                </tr>
                            @endforeach
                            </tbody>
                        </table>
                        <div style="margin: 0 auto;float: right">
                            {{ $applications->withQueryString()->links() }}

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('js')
    <script src="https://cdn.jsdelivr.net/npm/tom-select@2.0.1/dist/js/tom-select.complete.min.js"></script>
    <script>
        new TomSelect('#user_id',{
            plugins: ['input_autogrow'],
        });
        new TomSelect('#offer_id',{
            plugins: ['input_autogrow'],
        });

    </script>
@endpush
