@extends('layouts.backend.manager_sash')

@isset($offer)
@section('title', 'Edit Offer')
@else
@section('title','Create Offer')
@endisset

@push('css')
    <link href="https://cdn.jsdelivr.net/npm/tom-select@2.0.1/dist/css/tom-select.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/tom-select@2.0.1/dist/css/tom-select.bootstrap5.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.css" rel="stylesheet">
@endpush

@section('content')
    <div class="container-xl">
        <!-- Page title -->
        <div class="page-header d-print-none">
            <div class="row align-items-center">
                <div class="col">
                    <!-- Page pre-title -->
                    <div class="page-pretitle">
                        Overview
                    </div>
                    <h2 class="page-title">
                        @yield(('title'))
                    </h2>
                </div>
                <!-- Page title actions -->
                <div class="col-auto ms-auto d-print-none">
                    <div class="btn-list">
                        <a href="{{ route('admin.offer.index') }}" class="btn btn-primary d-none d-sm-inline-block">
                            <!-- Download SVG icon from http://tabler-icons.io/i/plus -->
                            <i class="fa fa-backward"></i>
                            Back
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="page-body">
        <div class="container-xl">
            <form action="{{ isset($offer) ? route('admin.offer.update',$offer->id) : route('admin.offer.store')   }}" method="post" enctype="multipart/form-data">
                @csrf
                @isset($offer)
                    @method('PUT')
                @endisset
                <div class="row row-cards">
                <div class="col-md-6">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">Basic Info</h3>
                        </div>
                        @if ($errors->any())
                            <div class="alert alert-danger">
                                <ul>
                                    @foreach ($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        @endif
                        <div class="card-body">
                            <div class="form-group mb-3 ">
                                <label class="form-label">Advertiser</label>
                                <div>
                                    <select name="advertiser_id" class="form-select" id="advertiser_id" placeholder="  Select a advertiser..." required>
                                        <option selected disabled>Select Advertiser</option>
                                        @foreach($advertisers as $advertiser)
                                            <option
                                                @isset($offer)
                                                {{ $offer->advertiser_id == $advertiser->id ? 'selected' : '' }}
                                                @endisset
                                                value="{{ $advertiser->id }}">{{ $advertiser->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="form-group mb-3 ">
                                <label class="form-label">Category</label>
                                <div>
                                    <select name="category_id" class="form-select" id="category_id" placeholder="  Select a category..." required>
                                        <option selected disabled>Select Country</option>
                                        @foreach($categories as $category)
                                            <option
                                                @isset($offer)
                                                {{ $offer->category_id == $category->id ? 'selected' : '' }}
                                                @endisset
                                                value="{{ $category->id }}">{{ $category->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="form-group mb-3 ">
                                <label class="form-label">Name</label>
                                <div>
                                    <input type="text" class="form-control" name="name" value="{{ $offer->name ?? old('name') }}" placeholder="Name" required>
                                </div>
                                @error('first_name')
                                <div class="error">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="form-group mb-3 ">
                                <label class="form-label">Description</label>
                                <div>
                                    <textarea class="form-control" name="description" rows="6" placeholder="Description" required>{{ $offer->description ?? old('description') }}</textarea>
                                </div>
                            </div>
                            <div class="form-group mb-3 ">
                                <label class="form-label">Preview Url</label>
                                <div>
                                    <input type="text" class="form-control" name="preview_link"  value="{{ $offer->preview_link ?? old('preview_link') }}" placeholder="Preview Url" required>
                                </div>
                            </div>
                            <div class="form-group mb-3 ">
                                <label class="form-label">Traking Link with token</label>
                                <div>
                                    <input type="text" class="form-control" name="tracking_link"  value="{{ $offer->tracking_link ?? old('tracking_link') }}" placeholder="Traking Link with token" required>
                                </div>
                            </div>
                            <div class="form-group mb-3 ">
                                <label class="form-label">Country</label>
                                <div>
                                    <select multiple name="country_id[]" class="form-select" id="country_id" placeholder="  Select a country...">
                                    @foreach($countries as $country)
                                        <option
                                            @isset($offer)
                                                @foreach($offer->countries as $data)
                                                    {{ $data->id == $country->id ? 'selected' : '' }}
                                                 @endforeach
                                            @endisset
                                            value="{{ $country->id }}">{{ $country->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="form-group mb-3 ">
                                <label class="form-label">Device</label>
                                <div>
                                    <select multiple name="device_id[]" class="form-select" id="device_id" placeholder="  Select a device...">
                                        @foreach($devices as $device)
                                            <option
                                                @isset($offer)
                                                    @foreach($offer->devices as $data)
                                                    {{ $data->id == $device->id ? 'selected' : '' }}
                                                    @endforeach
                                                @endisset
                                                value="{{ $device->id }}">{{ $device->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">Payouts & Cap</h3>
                        </div>
                        <div class="card-body">
                            <div class="form-group mb-3 ">
                                <label class="form-label">Type</label>
                                <div>
                                    <div class="input-icon">
                                        <select name="type" id="type" class="form-control">
                                            <option @isset($offer) {{ $offer->type == "offer" }} @endisset value="offer">Offer</option>
                                            <option @isset($offer) {{ $offer->type == "smartlink" }} @endisset value="smartlink">Smartlink</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="form-group mb-3 ">
                                <label class="form-label">Revenue</label>
                                <div>
                                    <input type="text" name="revenue" class="form-control" placeholder="Revenue" value="{{ $offer->revenue ?? old('revenue') }}">
                                </div>
                            </div>
                            <div class="form-group mb-3 ">
                                <label class="form-label">Payout</label>
                                <div>
                                    <input type="text" name="payout" class="form-control" placeholder="Payout" value="{{ $offer->payout ?? old('payout') }}">
                                </div>
                            </div>
                            <div class="form-group mb-3 ">
                                <label class="form-label">Conversion Status</label>
                                <div>
                                    <select name="conversion_status" id="conversion_status" class="form-control">
                                        <option @isset($offer) {{ $offer->conversion_status == 1 ? 'selected' : '' }} @endisset value="1">Approved</option>
                                        <option @isset($offer) {{ $offer->conversion_status == 0 ? 'selected' : '' }} @endisset  value="0">Pending</option>
                                    </select>
                                </div>
                            </div>
                            <div class="form-group mb-3 ">
                                <label class="form-label">Alternative Offer</label>
                                <div>
                                    <select name="alt_offer_id" id="alt_offer_id" class="form-control">
                                        <option selected disabled>Select Alternative Offer</option>
                                        @foreach($alt_offers as $offer)
                                            <option value="{{ $offer->id }}">{{ $offer->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="form-group mb-3 ">
                                <label class="form-label">Daily Cap</label>
                                <div>
                                    <input type="number" name="daily_cap" class="form-control" placeholder="Daily Cap" value="{{ $offer->daily_cap ?? old('daily_cap') }}">
                                </div>
                            </div>
                            <div class="form-group mb-3 ">
                                <label class="form-label">Expiration Date</label>
                                <div>
                                    <input type="date" name="expiration_date" class="form-control" placeholder="Expiration Date" value="{{ $offer->expiration_date ?? old('expiration_date') }}">
                                </div>
                            </div>
                            <div class="form-group mb-3 ">
                                <label class="form-label">Status</label>
                                <div>
                                    <select name="status" id="status" class="form-control">
                                        <option @isset($offer) {{ $offer->status == 'active' ? 'selected' : '' }} @endisset value="active">Active</option>
                                        <option @isset($offer) {{ $offer->status == 'pending' ? 'selected' : '' }} @endisset  value="pending">Pending</option>
                                        <option @isset($offer) {{ $offer->status == 'requestApproved' ? 'selected' : '' }} @endisset  value="requestApproved">Request Approved</option>
                                    </select>
                                </div>
                            </div>
                            <div class="form-group mb-3 ">
                                <label class="form-label">Avater</label>
                                <div>
                                    <input type="file" name="avater" class="form-control">
                                </div>
                            </div>
                            <div class="form-footer">
                                <button type="submit" class="btn btn-primary">@isset($offer) Update @else Create @endisset</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            </form>
        </div>
    </div>
@endsection

@push('js')
    <script src="https://cdn.jsdelivr.net/npm/tom-select@2.0.1/dist/js/tom-select.complete.min.js"></script>
    <script>
        new TomSelect('#category_id',{
            plugins: ['input_autogrow'],
        });
        new TomSelect('#advertiser_id',{
            plugins: ['input_autogrow'],
        });
        new TomSelect('#country_id',{
            plugins: ['input_autogrow'],
        });
        new TomSelect('#device_id',{
            plugins: ['input_autogrow'],
        });
        new TomSelect('#manager_id',{
            plugins: ['input_autogrow'],
        });

    </script>
@endpush
