@extends('layouts.backend.manager_sash')

@section('title', 'Aff Sub 2 Reports')

@push('css')
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.8/css/dataTables.bootstrap5.min.css">
    <link rel="stylesheet" href="{{ asset('backend/date/daterangepicker.css') }}">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css">

    <style>
        .filter-section {
            background: #f8f9fa;
            border: 1px solid #dee2e6;
            padding: 20px;
            margin-bottom: 20px;
            border-radius: 5px;
        }

        .filter-section h4 {
            margin-bottom: 15px;
            color: #333;
        }

        .form-group {
            margin-bottom: 15px;
        }

        .form-group label {
            display: block;
            margin-bottom: 5px;
            font-weight: 500;
        }

        .checkbox-group {
            display: flex;
            flex-wrap: wrap;
            gap: 15px;
        }

        .checkbox-group .checkbox-group {
            display: inline-block;
            position: relative;
        }

        .form-check {
            margin: 0;
        }

        .btn-group {
            margin-top: 15px;
        }

        .btn {
            margin-right: 10px;
        }

        /* Select2 Custom Styling */
        .select2-container--default .select2-selection--multiple {
            border: 1px solid #ced4da;
            border-radius: 0.375rem;
            min-height: 38px;
            padding: 2px 5px;
        }

        .select2-container--default .select2-selection--multiple .select2-selection__choice {
            background-color: #007bff;
            border: 1px solid #007bff;
            color: white;
            border-radius: 3px;
            padding: 2px 8px;
            margin: 2px;
        }

        .select2-container--default .select2-selection--multiple .select2-selection__choice__remove {
            color: white;
            margin-right: 5px;
        }

        .select2-container--default .select2-selection--multiple .select2-selection__choice__remove:hover {
            color: #ff6b6b;
        }

        .select2-dropdown {
            border: 1px solid #ced4da;
            border-radius: 0.375rem;
        }

        .select2-container--default .select2-results__option--highlighted[aria-selected] {
            background-color: #007bff;
        }
    </style>
@endpush

@section('content')
    @php
        $offer_id = request('offer_id');
        $country_id = request('country_id');
        $user_id = request('user_id');
        $currentRouteName = \Route::currentRouteName();
    @endphp

    @section('page_title','Aff Sub 2 Reports')
    @section('breadcrumb_parent','Reports')
    @section('breadcrumb_active','Aff Sub 2 Reports')
    @section('card_title','Aff Sub 2 Reports')

    @section('report_table')
        <!-- Filter Section -->
        <div class="filter-section">
            <h4>Report Filters</h4>
            <form method="get">
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Data Fields</label>
                            <div class="checkbox-group">
                                <div class="checkbox-group">
                                    <input class="checkbox-normal" name="offer" value="1" type="checkbox" id="offer" {{ request('offer', 1) ? 'checked' : '' }}>
                                    <label for="offer">Offer</label>
                                </div>
                                <div class="checkbox-group">
                                    <input class="checkbox-normal" name="country" value="1" type="checkbox" id="country" {{ request('country', 1) ? 'checked' : '' }}>
                                    <label for="country">Country</label>
                                </div>
                                <div class="checkbox-group">
                                    <input class="checkbox-normal" name="device" value="1" type="checkbox" id="device" {{ request('device') ? 'checked' : '' }}>
                                    <label for="device">Device</label>
                                </div>
                                <div class="checkbox-group">
                                    <input class="checkbox-normal" name="os" value="1" type="checkbox" id="os" {{ request('os') ? 'checked' : '' }}>
                                    <label for="os">Operating System</label>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Statistics Fields</label>
                            <div class="checkbox-group">
                                <div class="checkbox-group">
                                    <input class="checkbox-normal" name="click" value="1" type="checkbox" id="click" {{ request('click', 1) ? 'checked' : '' }}>
                                    <label for="click">Click</label>
                                </div>
                                <div class="checkbox-group">
                                    <input class="checkbox-normal" name="unique" value="1" type="checkbox" id="unique" {{ request('unique', 1) ? 'checked' : '' }}>
                                    <label for="unique">Unique</label>
                                </div>
                                <div class="checkbox-group">
                                    <input class="checkbox-normal" name="payout" value="1" type="checkbox" id="payout" {{ request('payout', 1) ? 'checked' : '' }}>
                                    <label for="payout">Payout</label>
                                </div>
                                <div class="checkbox-group">
                                    <input class="checkbox-normal" name="conversions" value="1" type="checkbox" id="conversions" {{ request('conversions') ? 'checked' : '' }}>
                                    <label for="conversions">Conversions</label>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="date_filter">Date Range</label>
                            <input type="text" class="form-control" id="date_filter" name="date_filter" value="{{ request('date_filter') }}" placeholder="Select Date Range">
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="user_id">Affiliates</label>
                            <select multiple name="user_id[]" id="user_id" class="form-control select2-users" data-placeholder="Select affiliates...">
                                @foreach ($users ?? [] as $user)
                                    <option @isset($user_id) @foreach ($user_id as $id) {{ $id == $user->id ? 'selected' : '' }} @endforeach @endisset value="{{ $user->id }}">{{ $user->first_name .' '. $user->last_name }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="offer_id">Offers</label>
                            <select multiple name="offer_id[]" id="offer_id" class="form-control select2-offers" data-placeholder="Select offers...">
                                @foreach ($offers ?? [] as $offer)
                                    <option @isset($offer_id) @foreach ($offer_id as $id) {{ $id == $offer->id ? 'selected' : '' }} @endforeach @endisset value="{{ $offer->id }}">{{ $offer->name }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="country_id">Countries</label>
                            <select multiple name="country_id[]" id="country_id" class="form-control select2-countries" data-placeholder="Select countries...">
                                @foreach ($countries ?? [] as $country)
                                    <option @isset($country_id) @foreach ($country_id as $id) {{ $id == $country->id ? 'selected' : '' }} @endforeach @endisset value="{{ $country->id }}">{{ $country->name }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                </div>

                <div class="btn-group">
                    <button type="submit" class="btn btn-primary">Generate Report</button>
                    <button type="button" id="resetFilters" class="btn btn-secondary">Reset</button>
                    <button type="button" id="exportCsv" class="btn btn-success">Export CSV</button>
                </div>
            </form>
        </div>

        <!-- Report Table -->
        @if(isset($reports) && count($reports))
                <div class="table-responsive">
                <table id="reportTable" class="table table-bordered text-nowrap border-bottom">
                        <thead>
                        <tr>
                            @if (request('offer', 1))
                                <th class="wd-15p border-bottom-0">Sub Affiliate</th>
                            @endif
                            @if (request('click', 1))
                                <th class="wd-15p border-bottom-0">Click</th>
                            @endif
                            @if (request('unique', 1))
                                <th class="wd-15p border-bottom-0">Unique</th>
                            @endif
                            @if (request('conversions'))
                                <th class="wd-15p border-bottom-0">Conversions</th>
                            @endif
                            @if (request('country', 1))
                                <th class="wd-15p border-bottom-0">Country</th>
                            @endif
                            @if (request('device'))
                                <th class="wd-15p border-bottom-0">Device</th>
                            @endif
                            @if (request('os'))
                                <th class="wd-15p border-bottom-0">OS</th>
                            @endif
                            @if (request('payout', 1))
                                <th class="wd-15p border-bottom-0">Payout</th>
                            @endif
                        </tr>
                        </thead>
                        <tbody>
                        @foreach ($reports as $date => $report)
                            @if (count(array_filter(is_array($report) ? $report : (array) $report)) < 1)
                                @continue
                            @endif
                            <tr>
                                @if (request('offer', 1))
                                    <td>{{ $date }}</td>
                                @endif
                                @if (request('click', 1))
                                    <td>{{ number_format($report['click'] ?? 0) }}</td>
                                @endif
                                @if (request('unique', 1))
                                    <td>{{ number_format($report['unique'] ?? 0) }}</td>
                                @endif
                                @if (request('conversions'))
                                    <td>{{ number_format($report['conversion'] ?? 0) }}</td>
                                @endif
                                @if (request('country', 1))
                                    <td>{{ $report['country_name'] ?? '-' }}</td>
                                @endif
                                @if (request('device'))
                                    <td>{{ $report['device_brand'] ? ($report['device_brand'] . ($report['device_model'] ? ' ' . $report['device_model'] : '')) : '-' }}</td>
                                @endif
                                @if (request('os'))
                                    <td>{{ $report['os_name'] ?? '-' }}</td>
                                @endif
                                @if (request('payout', 1))
                                    <td>${{ number_format($report['payout'] ?? 0, 2) }}</td>
                                @endif
                            </tr>
                        @endforeach
                        @if(isset($total))
                            <tr class="table-info">
                                @if (request('offer', 1))
                                    <td><strong>Total</strong></td>
                                @endif
                                @if (request('click', 1))
                                    <td><strong>{{ number_format($total['clicks'] ?? 0) }}</strong></td>
                                @endif
                                @if (request('unique', 1))
                                    <td><strong>{{ number_format($total['uniques'] ?? 0) }}</strong></td>
                                @endif
                                @if (request('conversions'))
                                    <td><strong>{{ number_format($total['conversions'] ?? 0) }}</strong></td>
                                @endif
                                @if (request('country', 1))
                                    <td>-</td>
                                @endif
                                @if (request('device'))
                                    <td>-</td>
                                @endif
                                @if (request('os'))
                                    <td>-</td>
                                @endif
                                @if (request('payout', 1))
                                    <td><strong>${{ number_format($total['payouts'] ?? 0, 2) }}</strong></td>
                                @endif
                        </tr>
                        @endif
                    </tbody>
                    </table>
                </div>
        @else
            <div class="alert alert-info">
                No reports found for the selected filters and date range.
            </div>
        @endif
    @endsection

    @includeIf('partials.report-layout')

@endsection

@push('js')
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
    <script src="{{ asset('backend/date/moment.min.js') }}"></script>
    <script src="{{ asset('backend/date/daterangepicker.js') }}"></script>
    <script src="{{ asset('assets/plugins/datatable/js/jquery.dataTables.min.js') }}"></script>
    <script src="{{ asset('assets/plugins/datatable/js/dataTables.bootstrap5.js') }}"></script>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

    <script>
        $(function() {
            // Date Range Picker
            let dateInterval = getQueryParameter('date_filter');
            let start = moment().startOf('isoWeek');
            let end = moment().endOf('isoWeek');

            if (dateInterval) {
                dateInterval = dateInterval.split(' - ');
                start = dateInterval[0];
                end = dateInterval[1];
            }

            $('#date_filter').daterangepicker({
                showDropdowns: true,
                startDate: start,
                endDate: end,
                locale: {
                    format: 'YYYY-MM-DD',
                    firstDay: 1,
                },
                ranges: {
                    'Today': [moment(), moment()],
                    'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                    'Last 7 Days': [moment().subtract(6, 'days'), moment()],
                    'Last 30 Days': [moment().subtract(29, 'days'), moment()],
                    'This Month': [moment().startOf('month'), moment().endOf('month')],
                    'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
                }
            });

            // Initialize Select2 dropdowns
            $('.select2-users').select2({
                placeholder: 'Select affiliates...',
                allowClear: true,
                width: '100%',
                closeOnSelect: false
            });

            $('.select2-offers').select2({
                placeholder: 'Select offers...',
                allowClear: true,
                width: '100%',
                closeOnSelect: false
            });

            $('.select2-countries').select2({
                placeholder: 'Select countries...',
                allowClear: true,
                width: '100%',
                closeOnSelect: false
            });

            // DataTable
            if ($('#reportTable').length) {
                $('#reportTable').DataTable({
                    responsive: true,
                    pageLength: 25,
                    lengthMenu: [10, 25, 50, 100],
                    order: [],
                    language: {
                        search: "",
                        searchPlaceholder: "Search reports..."
                    }
                });
            }

            // Reset Filters
            $('#resetFilters').on('click', function() {
                $('#user_id').val(null).trigger('change');
                $('#offer_id').val(null).trigger('change');
                $('#country_id').val(null).trigger('change');
                $('#date_filter').val('');
                $("input[type='checkbox']").prop('checked', false);
                $('#offer, #country, #click, #unique, #payout').prop('checked', true);
            });

            // Export CSV
            $('#exportCsv').on('click', function() {
                const csv = tableToCSV(document.getElementById('reportTable'));
                const blob = new Blob([csv], { type: 'text/csv;charset=utf-8;' });
                const url = URL.createObjectURL(blob);
                const link = document.createElement('a');
                link.setAttribute('href', url);
                link.setAttribute('download', 'aff-sub-2-report-' + moment().format('YYYY-MM-DD') + '.csv');
                document.body.appendChild(link);
                link.click();
                document.body.removeChild(link);
                URL.revokeObjectURL(url);
            });
        });

        function getQueryParameter(name) {
            const url = window.location.href;
            name = name.replace(/[\[\]]/g, "\\$&");
            const regex = new RegExp("[?&]" + name + "(=([^&#]*)|&|#|$)");
            const results = regex.exec(url);
            if (!results) return null;
            if (!results[2]) return '';
            return decodeURIComponent(results[2].replace(/\+/g, " "));
        }

        function tableToCSV(table) {
            const rows = Array.from(table.querySelectorAll('tr'));
            return rows.map(row =>
                Array.from(row.querySelectorAll('th, td'))
                    .map(cell => '"' + (cell.innerText ?? '').replace(/"/g, '""') + '"')
                    .join(',')
            ).join('\n');
        }
    </script>
@endpush
                                                        @foreach($user_id as $id)
                                                           {{ $id == $user->id ? 'selected' : '' }}
                                                         @endforeach
                                                    @endisset
                                                    value="{{ $user->id }}">{{ $user->first_name . $user->last_name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <h3 class="form-group">Offers</h3>
                                    <div class="input-icon">
                                        <select multiple name="offer_id[]" id="offer_id" class="form-select" placeholder="Select Offers">
                                            @foreach($offers as $offer)
                                                <option
                                                    @isset($offer_id)
                                                        @foreach($offer_id as $id)
                                                        {{ $id == $offer->id ? 'selected' : '' }}
                                                        @endforeach
                                                    @endisset
                                                    value="{{ $offer->id }}">{{ $offer->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <h3 class="form-group">Countries</h3>
                                    <div class="input-icon">
                                        <select multiple name="country_id[]" id="country_id" class="form-select" placeholder="Select Country">
                                            @foreach($countries as $country)
                                                <option
                                                    @isset($country_id)
                                                        @foreach($country_id as $id)
                                                          {{ $id == $country->id ? 'selected' : '' }}
                                                        @endforeach
                                                    @endisset
                                                    value="{{ $country->id }}">{{ $country->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <h3 class="form-group">Date</h3>
                                    <div class="input-icon">
                                        <input type="text" class="btn btn-default" id="date_filter" name="date_filter">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card-footer">
                            <div class="row align-items-center">
                                <div class="col-auto">
                                    <button  class="btn btn-primary">
                                        Filter
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
            <br>
            <div class="col-12">
                <div class="card">
                    <div class="table-responsive">
                        <table class="table table-vcenter table-mobile-md card-table">
                            <thead>
                            <tr>
                                <th>Aff Sub 2</th>
                                <th>Click</th>
                                <th>Unique</th>
                                <th>Conversion</th>
                                <th>Payout</th>
                            </tr>
                            </thead>
                            <tbody>
                            @foreach ($reports as $date => $report)
                                @if (count(array_filter(is_array($report) ? $report : (array) $report)) < 1)
                                    @continue
                                @endif
                                <tr>
                                    <td data-label="Date">{{ $date }}</td>
                                    <td data-label="Click">{{ $report['click'] }}</td>
                                    <td data-label="Unique">{{ $report['unique'] }}</td>
                                    <td data-label="Conversion">{{ $report['conversion'] }}</td>
                                    <td data-label="Payout">${{ $report['payout'] }}</td>
                                </tr>
                            @endforeach
                            <tr>
                                <td data-label="Date" class="total">Total</td>
                                <td data-label="Click" class="total">{{ $total['clicks'] }}</td>
                                <td data-label="Unique" class="total">{{ $total['uniques'] }}</td>
                                <td data-label="Conversion" class="total">{{ data_get($total,'conversions',0) }}</td>
                                <td data-label="Payout" class="total">$ {{ $total['payouts'] }}</td>
                            </tr>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('js')
    <script src="https://cdn.jsdelivr.net/npm/tom-select@2.0.1/dist/js/tom-select.complete.min.js"></script>
    <script src="{{ asset('backend/dist/libs/apexcharts/dist/apexcharts.min.js') }}"></script>
    <script src="{{ asset('backend/date/moment.min.js') }}"></script>
    <script src="{{ asset('backend/date/daterangepicker.js') }}"></script>
    <!-- datepicker -->
    <script src="{{ asset('backend/date/bootstrap-datepicker.min.js') }}"></script>
    <script type="text/javascript">
        $(function() {
            let dateInterval = getQueryParameter('date_filter');
            let start = moment().startOf('last Monday');
            let end = moment().endOf('this Sunday');
            if (dateInterval) {
                dateInterval = dateInterval.split(' - ');
                start = dateInterval[0];
                end = dateInterval[1];
            }
            $('#date_filter').daterangepicker({
                "showDropdowns": true,
                "showWeekNumbers": true,
                "alwaysShowCalendars": false,
                startDate: start,
                endDate: end,
                locale: {
                    format: 'YYYY-MM-DD',
                    firstDay: 1,
                },
                ranges: {
                    'Today': [moment(), moment()],
                    'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                    'Last 7 Days': [moment().subtract(6, 'days'), moment()],
                    'Last 30 Days': [moment().subtract(29, 'days'), moment()],
                    'This Month': [moment().startOf('month'), moment().endOf('month')],
                    'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1,
                        'month').endOf('month')],

                }
            });
        });

        function getQueryParameter(name) {
            const url = window.location.href;
            name = name.replace(/[\[\]]/g, "\\$&");
            const regex = new RegExp("[?&]" + name + "(=([^&#]*)|&|#|$)");
            const results = regex.exec(url);
            if (!results) return null;
            if (!results[2]) return '';
            return decodeURIComponent(results[2].replace(/\+/g, " "));
        }

        function tableToCSV(table) {
            const rows = Array.from(table.querySelectorAll('tr'));
            return rows.map(row =>
                Array.from(row.querySelectorAll('th, td'))
                    .map(cell => '"' + (cell.innerText ?? '').replace(/"/g, '""') + '"')
                    .join(',')
            ).join('\n');
        }
    </script>
@endpush
