@extends('layouts.backend.manager_sash')

@section('title', 'Click Reports')

@push('css')
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.8/css/dataTables.bootstrap5.min.css">
    <link rel="stylesheet" href="{{ asset('backend/date/daterangepicker.css') }}">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css">

    <style>
        .filter-section {
            background: #f8f9fa;
            border: 1px solid #dee2e6;
            padding: 20px;
            margin-bottom: 20px;
            border-radius: 5px;
        }

        .filter-section h4 {
            margin-bottom: 15px;
            color: #333;
        }

        .form-group {
            margin-bottom: 15px;
        }

        .form-group label {
            display: block;
            margin-bottom: 5px;
            font-weight: 500;
        }

        .checkbox-group {
            display: flex;
            flex-wrap: wrap;
            gap: 15px;
        }

        .checkbox-group .checkbox-group {
            display: inline-block;
            position: relative;
        }

        .form-check {
            margin: 0;
        }

        .btn-group {
            margin-top: 15px;
        }

        .btn {
            margin-right: 10px;
        }

        /* Select2 Custom Styling */
        .select2-container--default .select2-selection--multiple {
            border: 1px solid #ced4da;
            border-radius: 0.375rem;
            min-height: 38px;
            padding: 2px 5px;
        }

        .select2-container--default .select2-selection--multiple .select2-selection__choice {
            background-color: #007bff;
            border: 1px solid #007bff;
            color: white;
            border-radius: 3px;
            padding: 2px 8px;
            margin: 2px;
        }

        .select2-container--default .select2-selection--multiple .select2-selection__choice__remove {
            color: white;
            margin-right: 5px;
        }

        .select2-container--default .select2-selection--multiple .select2-selection__choice__remove:hover {
            color: #ff6b6b;
        }

        .select2-dropdown {
            border: 1px solid #ced4da;
            border-radius: 0.375rem;
        }

        .select2-container--default .select2-results__option--highlighted[aria-selected] {
            background-color: #007bff;
        }
    </style>
@endpush

@section('content')
    @php
        $offer_id = request('offer_id');
        $country_id = request('country_id');
        $user_id = request('user_id');
        $currentRouteName = \Route::currentRouteName();
    @endphp

    @section('page_title','Click Reports')
    @section('breadcrumb_parent','Reports')
    @section('breadcrumb_active','Click Reports')
    @section('card_title','Click Reports')

    @section('filters_table')
        <form method="get">
            <table class="table table-bordered filter-table">
                <thead>
                    <tr>
                        <th style="width:220px">Filter</th>
                        <th>Value</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td class="label-cell">Data Fields</td>
                        <td>
                            <div class="checkbox-group">
                                <div class="checkbox-group">
                                    <input class="checkbox-normal" name="offer" value="1" type="checkbox" id="offer" {{ request('offer', 1) ? 'checked' : '' }}>
                                    <label for="offer">Offer</label>
                                </div>
                                <div class="checkbox-group">
                                    <input class="checkbox-normal" name="country" value="1" type="checkbox" id="country" {{ request('country', 1) ? 'checked' : '' }}>
                                    <label for="country">Country</label>
                                </div>
                                <div class="checkbox-group">
                                    <input class="checkbox-normal" name="device" value="1" type="checkbox" id="device" {{ request('device') ? 'checked' : '' }}>
                                    <label for="device">Device</label>
                                </div>
                                <div class="checkbox-group">
                                    <input class="checkbox-normal" name="os" value="1" type="checkbox" id="os" {{ request('os') ? 'checked' : '' }}>
                                    <label for="os">OS</label>
                                </div>
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <td class="label-cell">Statistics Fields</td>
                        <td>
                            <div class="checkbox-group">
                                <div class="checkbox-group">
                                    <input class="checkbox-normal" name="click" value="1" type="checkbox" id="click" {{ request('click', 1) ? 'checked' : '' }}>
                                    <label for="click">Click</label>
                                </div>
                                <div class="checkbox-group">
                                    <input class="checkbox-normal" name="unique" value="1" type="checkbox" id="unique" {{ request('unique', 1) ? 'checked' : '' }}>
                                    <label for="unique">Unique</label>
                                </div>
                                <div class="checkbox-group">
                                    <input class="checkbox-normal" name="payout" value="1" type="checkbox" id="payout" {{ request('payout', 1) ? 'checked' : '' }}>
                                    <label for="payout">Payout</label>
                                </div>
                                <div class="checkbox-group">
                                    <input class="checkbox-normal" name="conversions" value="1" type="checkbox" id="conversions" {{ request('conversions') ? 'checked' : '' }}>
                                    <label for="conversions">Conversions</label>
                                </div>
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <td class="label-cell"><label for="date_filter" class="m-0">Date Range</label></td>
                        <td>
                            <input type="text" class="form-control" id="date_filter" name="date_filter" value="{{ request('date_filter') }}" placeholder="Select Date Range">
                        </td>
                    </tr>
                    <tr>
                        <td class="label-cell"><label for="user_id" class="m-0">Affiliates</label></td>
                        <td>
                            <select multiple name="user_id[]" id="user_id" class="form-control select2-users" data-placeholder="Select affiliates...">
                                @foreach ($users ?? [] as $user)
                                    <option @isset($user_id) @foreach ($user_id as $id) {{ $id == $user->id ? 'selected' : '' }} @endforeach @endisset value="{{ $user->id }}">{{ $user->first_name .' '. $user->last_name }}</option>
                                @endforeach
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <td class="label-cell"><label for="offer_id" class="m-0">Offers</label></td>
                        <td>
                            <select multiple name="offer_id[]" id="offer_id" class="form-control select2-offers" data-placeholder="Select offers...">
                                @foreach ($offers ?? [] as $offer)
                                    <option @isset($offer_id) @foreach ($offer_id as $id) {{ $id == $offer->id ? 'selected' : '' }} @endforeach @endisset value="{{ $offer->id }}">{{ $offer->name }}</option>
                                @endforeach
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <td class="label-cell"><label for="country_id" class="m-0">Countries</label></td>
                        <td>
                            <select multiple name="country_id[]" id="country_id" class="form-control select2-countries" data-placeholder="Select countries...">
                                @foreach ($countries ?? [] as $country)
                                    <option @isset($country_id) @foreach ($country_id as $id) {{ $id == $country->id ? 'selected' : '' }} @endforeach @endisset value="{{ $country->id }}">{{ $country->name }}</option>
                                @endforeach
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <td class="label-cell">Actions</td>
                        <td>
                            <div class="filter-actions">
                                <button type="submit" class="btn btn-outline-dark">Generate Report</button>
                                <button type="button" id="resetFilters" class="btn btn-outline-secondary">Reset</button>
                                <button type="button" id="exportCsv" class="btn btn-outline-primary">Export CSV</button>
                            </div>
                        </td>
                    </tr>
                </tbody>
            </table>
        </form>
    @endsection

    @section('data_table')
        @if(isset($clicks) && count($clicks))
            <table id="reportTable" class="table table-bordered text-nowrap border-bottom">
                <thead>
                    <tr>
                        <th class="wd-15p border-bottom-0">Offer</th>
                        <th class="wd-15p border-bottom-0">Affiliate</th>
                        <th class="wd-15p border-bottom-0">Aff Click ID</th>
                        <th class="wd-15p border-bottom-0">Aff Sub 1</th>
                        <th class="wd-15p border-bottom-0">Aff Sub 2</th>
                        <th class="wd-15p border-bottom-0">Aff Sub 3</th>
                        <th class="wd-15p border-bottom-0">Source</th>
                        <th class="wd-15p border-bottom-0">Fraud</th>
                        <th class="wd-15p border-bottom-0">OS Name</th>
                        <th class="wd-15p border-bottom-0">Browser</th>
                        <th class="wd-15p border-bottom-0">Browser Version</th>
                        <th class="wd-15p border-bottom-0">Device Brand</th>
                        <th class="wd-15p border-bottom-0">Device Model</th>
                        <th class="wd-15p border-bottom-0">OS Version</th>
                        <th class="wd-15p border-bottom-0">IP Address</th>
                        <th class="wd-15p border-bottom-0">Country</th>
                        <th class="wd-15p border-bottom-0">City</th>
                        <th class="wd-15p border-bottom-0">Region</th>
                        <th class="wd-15p border-bottom-0">Click Time</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($clicks as $click)
                        <tr>
                            <td style="white-space:nowrap;">
                                <a href="{{ route('manager.offer.show', $click->offer_id) }}" class="text-primary">({{ $click->offer_id }}) {{ $click->offer->name }}</a>
                            </td>
                            <td style="white-space:nowrap;">
                                <a href="{{ route('manager.user.show', $click->user_id) }}" class="text-primary">({{ $click->user_id }}) {{ $click->user->first_name .' '. $click->user->last_name }}</a>
                            </td>
                            <td>{{ $click->aff_click_id }}</td>
                            <td style="white-space:nowrap;">{{ $click->aff_sub_1 }}</td>
                            <td style="white-space:nowrap;">{{ $click->aff_sub_2 }}</td>
                            <td style="white-space:nowrap;">{{ $click->aff_sub_3 }}</td>
                            <td>{{ $click->source }}</td>
                            <td>
                                <span class="badge {{ $click->fraud ? 'bg-danger' : 'bg-success' }}">{{ $click->fraud ? 'Yes' : 'No' }}</span>
                            </td>
                            <td>{{ $click->os_name }}</td>
                            <td style="white-space:nowrap;">{{ $click->browser }}</td>
                            <td style="white-space:nowrap;">{{ $click->browser_version }}</td>
                            <td>{{ $click->device_brand }}</td>
                            <td>{{ $click->device_model }}</td>
                            <td>{{ $click->os_version }}</td>
                            <td>{{ $click->ip_address }}</td>
                            <td style="white-space:nowrap;">{{ $click->country->name ?? 'N/A' }}</td>
                            <td>{{ $click->geo_city }}</td>
                            <td>{{ $click->geo_region }}</td>
                            <td style="white-space:nowrap;">{{ $click->created_at->format('Y-m-d H:i:s') }}</td>
                        </tr>
                    @endforeach
                    @if(isset($total))
                        <tr class="table-info">
                            <td><strong>Total</strong></td>
                            <td>-</td><td>-</td><td>-</td><td>-</td><td>-</td><td>-</td><td>-</td><td>-</td><td>-</td>
                            <td>-</td><td>-</td><td>-</td><td>-</td><td>-</td><td>-</td><td>-</td><td>-</td>
                            <td><strong>({{ $total }})</strong></td>
                        </tr>
                    @endif
                </tbody>
            </table>
            <div class="d-flex justify-content-center mt-3">
                {{ $clicks->withQueryString()->links() }}
            </div>
        @else
            <div class="alert alert-info m-0">No clicks found for the selected filters and date range.</div>
        @endif
    @endsection

    @includeIf('partials.affiliate-report-layout')

@endsection

@push('js')
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
    <script src="{{ asset('backend/date/moment.min.js') }}"></script>
    <script src="{{ asset('backend/date/daterangepicker.js') }}"></script>
    <script src="{{ asset('assets/plugins/datatable/js/jquery.dataTables.min.js') }}"></script>
    <script src="{{ asset('assets/plugins/datatable/js/dataTables.bootstrap5.js') }}"></script>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

    <script>
        $(function() {
            // Date Range Picker
            let dateInterval = getQueryParameter('date_filter');
            let start = moment().startOf('isoWeek');
            let end = moment().endOf('isoWeek');

            if (dateInterval) {
                dateInterval = dateInterval.split(' - ');
                start = dateInterval[0];
                end = dateInterval[1];
            }

            $('#date_filter').daterangepicker({
                showDropdowns: true,
                startDate: start,
                endDate: end,
                locale: {
                    format: 'YYYY-MM-DD',
                    firstDay: 1,
                },
                ranges: {
                    'Today': [moment(), moment()],
                    'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                    'Last 7 Days': [moment().subtract(6, 'days'), moment()],
                    'Last 30 Days': [moment().subtract(29, 'days'), moment()],
                    'This Month': [moment().startOf('month'), moment().endOf('month')],
                    'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
                }
            });

            // Initialize Select2 dropdowns
            $('.select2-users').select2({
                placeholder: 'Select affiliates...',
                allowClear: true,
                width: '100%',
                closeOnSelect: false
            });

            $('.select2-offers').select2({
                placeholder: 'Select offers...',
                allowClear: true,
                width: '100%',
                closeOnSelect: false
            });

            $('.select2-countries').select2({
                placeholder: 'Select countries...',
                allowClear: true,
                width: '100%',
                closeOnSelect: false
            });

            // DataTable
            if ($('#reportTable').length) {
                $('#reportTable').DataTable({
                    responsive: true,
                    pageLength: 25,
                    lengthMenu: [10, 25, 50, 100],
                    order: [],
                    language: {
                        search: "",
                        searchPlaceholder: "Search clicks..."
                    }
                });
            }

            // Reset Filters
            $('#resetFilters').on('click', function() {
                $('#user_id').val(null).trigger('change');
                $('#offer_id').val(null).trigger('change');
                $('#country_id').val(null).trigger('change');
                $('#date_filter').val('');
                $("input[type='checkbox']").prop('checked', false);
                $('#offer, #country, #click, #unique, #payout').prop('checked', true);
            });

            // Export CSV
            $('#exportCsv').on('click', function() {
                const csv = tableToCSV(document.getElementById('reportTable'));
                const blob = new Blob([csv], { type: 'text/csv;charset=utf-8;' });
                const url = URL.createObjectURL(blob);
                const link = document.createElement('a');
                link.setAttribute('href', url);
                link.setAttribute('download', 'click-report-' + moment().format('YYYY-MM-DD') + '.csv');
                document.body.appendChild(link);
                link.click();
                document.body.removeChild(link);
                URL.revokeObjectURL(url);
            });
        });

        function getQueryParameter(name) {
            const url = window.location.href;
            name = name.replace(/[\[\]]/g, "\\$&");
            const regex = new RegExp("[?&]" + name + "(=([^&#]*)|&|#|$)");
            const results = regex.exec(url);
            if (!results) return null;
            if (!results[2]) return '';
            return decodeURIComponent(results[2].replace(/\+/g, " "));
        }

        function tableToCSV(table) {
            const rows = Array.from(table.querySelectorAll('tr'));
            return rows.map(row =>
                Array.from(row.querySelectorAll('th, td'))
                    .map(cell => '"' + (cell.innerText ?? '').replace(/"/g, '""') + '"')
                    .join(',')
            ).join('\n');
        }
    </script>
@endpush