<?php

use App\Http\Controllers\Admin\AffiliateController;
use App\Http\Controllers\Admin\AnnouncementController as AdminAnnouncementController;
use App\Http\Controllers\Admin\InvoiceController;
use App\Http\Controllers\Admin\ManagerController;
use App\Http\Controllers\Admin\ReportController;
use App\Http\Controllers\TrakingController;
use App\Http\Controllers\AnnouncementController;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    myGlobalFunction();
    return redirect('/login');
});

Route::get('/auto/invoice/genarate',[InvoiceController::class, 'autoInvoice']);

Route::get('/reboat', function () {
    Artisan::call('config:clear');
    Artisan::call('view:clear');
    Artisan::call('route:clear');
    Artisan::call('cache:clear');
    
    return response()->json(['message' => 'Cleared successfully.', 'success' => true]);

});


Route::get('/home', 'HomeController@index')->name('home');


Route::get('/install', function () {
    return view('admin.settings.permission');
})->name('install');

Route::get('/storage/path', function () {
    Artisan::call('storage:link');
});



require __DIR__.'/auth.php';

// Route::get('/home', 'HomeController@index')->name('home');
Route::middleware('auth')->get('/dashboard', function () {
    $user = Auth::user();
    
    // Debug: Log user information
    \Log::info('Dashboard redirect - User ID: ' . $user->id . ', Role: ' . ($user->role ?? 'null'));
    
    $role = $user->role;
    
    if ($role === 'admin') {
        return redirect()->route('admin.dashboard');
    } elseif ($role === 'manager') {
        return redirect()->route('manager.dashboard');
    } elseif ($role === 'affiliate') {
        return redirect()->route('affiliate.dashboard');
    } else {
        // Handle users without proper roles
        \Log::error('User ' . $user->id . ' has invalid role: ' . ($role ?? 'null'));
        Auth::logout();
        return redirect()->route('login')->with('error', 'Your account does not have a valid role. Please contact support.');
    }
})->name('dashboard');
 
Route::get('get/report/by/group', [ReportController::class, 'getReportByGroup'])->name('get-report-by-group');

// Debug route to check user authentication
Route::middleware('auth')->get('/debug-user', function () {
    $user = Auth::user();
    return response()->json([
        'user_id' => $user->id,
        'email' => $user->email,
        'role' => $user->role ?? 'null',
        'status' => $user->status ?? 'null',
        'authenticated' => Auth::check()
    ]);
})->name('debug-user');

// User Rollback


Route::get('/rollbackrollback', [AffiliateController::class, 'rollback'])->name('user.rollback');

// Manager Rollback

Route::get('rollback/manager', [ManagerController::class, 'rollback'])->name('manager.rollback');
Route::post('apkeystore', [TrakingController::class, 'updateKey'])->name('apkeystore');
// Manager To User Rollback

Route::get('rollback/user', [App\Http\Controllers\Manager\AffiliateController::class, 'rollback'])->name('user.rollback.manager');

// Tracking endpoints (public)
Route::get('redirect', [TrakingController::class, 'redirect'])->name('redirect');
Route::get('postback', [TrakingController::class, 'postback'])->name('postback');

Route::group(['as' => 'admin.', 'prefix' => 'admin', 'namespace' => 'Admin', 'middleware' => ['auth', 'admin']], function () {
    Route::get('/dashboard', 'DashboardController@index')->name('dashboard');
    Route::get('/fraud-detection', 'FraudController@index')->name('fraud-detected');
    Route::group(['as' => 'announcement.', 'prefix' => 'announcement'], function () {
        Route::get('/', 'AnnouncementController@index')->name('index');
        Route::get('create', 'AnnouncementController@create')->name('create');
        Route::post('store', 'AnnouncementController@store')->name('store');
        Route::get('edit/{id}', 'AnnouncementController@edit')->name('edit');
        Route::post('update/{id}', 'AnnouncementController@update')->name('update');
        Route::delete('delete/{id}', 'AnnouncementController@delete')->name('delete');
    });

    Route::group(['as' => 'affiliate.', 'prefix' => 'affiliate'], function () {
        Route::get('/', 'AffiliateController@index')->name('index');
        Route::get('create', 'AffiliateController@create')->name('create');
        Route::post('store', 'AffiliateController@store')->name('store');
        Route::get('edit/{id}', 'AffiliateController@edit')->name('edit');
        Route::get('show/{id}', 'AffiliateController@show')->name('show');
        Route::put('update/{id}', 'AffiliateController@update')->name('update');
        Route::get('delete/{id}', 'AffiliateController@delete')->name('delete');
        Route::post('offer/blocked/{id}', 'AffiliateController@blocked')->name('offer.blocked');
        Route::get('switch/{id}', 'AffiliateController@switch')->name('switch');
    });
    Route::group(['as' => 'manager.', 'prefix' => 'manager'], function () {
        Route::get('/', 'ManagerController@index')->name('index');
        Route::get('create', 'ManagerController@create')->name('create');
        Route::post('store', 'ManagerController@store')->name('store');
        Route::get('edit/{id}', 'ManagerController@edit')->name('edit');
        Route::put('update/{id}', 'ManagerController@update')->name('update');
        Route::get('delete/{id}', 'ManagerController@delete')->name('delete');
        Route::get('switch/{id}', 'ManagerController@switch')->name('switch');
    });
    Route::resource('category', 'CategoryController');
    Route::resource('verticle', 'VerticleController');
    Route::resource('advertiser', 'AdvertiserController');
    Route::group(['as' => 'offer.', 'prefix' => 'offer'], function () {
        Route::get('/', 'OfferController@index')->name('index');
        Route::get('create', 'OfferController@create')->name('create');
        Route::post('store', 'OfferController@store')->name('store');
        Route::get('show/{id}', 'OfferController@show')->name('show');
        Route::get('edit/{id}', 'OfferController@edit')->name('edit');
        Route::put('update/{id}', 'OfferController@update')->name('update');
        Route::delete('destroy/{id}', 'OfferController@destroy')->name('destroy');
        Route::get('application', 'OfferController@application')->name('application');
        Route::get('application/approved/{id}', 'OfferController@approved')->name('application.approved');
    });
    Route::group(['as' => 'payout.', 'prefix' => 'payout'], function () {
        Route::get('/{id}', 'PayoutController@index')->name('index');
        Route::get('country/{id}', 'PayoutController@countryPayouts')->name('country');
        Route::post('country/{id}', 'PayoutController@countryPayoutsStore')->name('country.store');
        Route::get('country/delete/{id}', 'PayoutController@countryPayoutsDelete')->name('country.delete');
        Route::get('device/{id}', 'PayoutController@devicePayouts')->name('device');
        Route::post('device/{id}', 'PayoutController@devicePayoutsStore')->name('device.store');
        Route::get('device/delete/{id}', 'PayoutController@devicePayoutsDelete')->name('device.delete');
        Route::get('coustomPayouts/{id}', 'PayoutController@coustomPayouts')->name('coustom');
        Route::post('coustomPayouts/{id}', 'PayoutController@coustomPayoutsStore')->name('coustom.store');
        Route::get('coustomPayouts/delete/{id}', 'PayoutController@coustomPayoutsDelete')->name('coustom.delete');
        Route::get('cap/{id}', 'PayoutController@coustomCap')->name('coustom.cap');
        Route::post('cap/{id}', 'PayoutController@coustomCapStore')->name('coustom.cap.store');
        Route::get('cap/delete/{id}', 'PayoutController@coustomCapDelete')->name('coustom.cap.delete');
        Route::get('coustomCountry/{id}', 'PayoutController@coustomCountryPayouts')->name('coustom.country');
        Route::post('coustomCountry/{id}', 'PayoutController@coustomCountryPayoutsStore')->name('coustom.country.store');
        Route::get('coustomCountry/delete/{id}', 'PayoutController@coustomCountryPayoutsDelete')->name('coustom.country.delete');
        Route::get('coustomDevice/{id}', 'PayoutController@coustomDevicePayouts')->name('coustom.device');
        Route::get('fetch/country/data', 'PayoutController@getCountryData')->name('getCountryData');
        Route::post('coustomDevice/{id}', 'PayoutController@coustomDevicePayoutsStore')->name('coustom.device.store');
        Route::get('coustomDevice/delete/{id}', 'PayoutController@coustomDevicePayoutsDelete')->name('coustom.device.delete');
        Route::post('optimize', 'PayoutController@optimizeStore')->name('optimize');
        Route::get('optimizeDelete/{id}', 'PayoutController@optimizeDelete')->name('optimize.delete');
    });
    Route::resource('finance', 'FinanceController');

    Route::group(['as' => 'setting.', 'prefix' => 'settings'], function () {
        Route::get('general', 'SettingController@general')->name('general');
        Route::put('general', 'SettingController@generalUpdate')->name('general.update');
        Route::get('appearance', 'SettingController@appearance')->name('appearance');
        Route::put('appearance', 'SettingController@appearanceUpdate')->name('appearance.update');
        Route::get('logo/{type}', 'SettingController@deleteLogo')->name('logo.delete');
        Route::get('mail', 'SettingController@mail')->name('mail');
        Route::put('mail', 'SettingController@mailUpdate')->name('mail.update');
        Route::get('question', 'SettingController@registerQuestion')->name('question');
        Route::post('question', 'SettingController@registerQuestionStore')->name('question.store');
        Route::get('delete/question/{id}', 'SettingController@questionDelete')->name('question.delete');
    });
    Route::group(['as' => 'report.', 'prefix' => 'report'], function () {
        Route::get('day', 'ReportController@day')->name('day');
        Route::get('offer', 'ReportController@offer')->name('offer');
        Route::get('affiliate', 'ReportController@affiliate')->name('affiliate');
        Route::get('country', 'ReportController@country')->name('country');
        Route::get('aff_sub_1', 'ReportController@aff_sub_1')->name('aff_sub_1');
        Route::get('aff_sub_2', 'ReportController@aff_sub_2')->name('aff_sub_2');
        Route::get('aff_sub_3', 'ReportController@aff_sub_3')->name('aff_sub_3');
        Route::get('clicks', 'ReportController@click')->name('click');
        Route::get('convert/{id}', 'ReportController@convert')->name('convert');
        Route::get('conversion', 'ReportController@conversion')->name('conversion');
        Route::get('reject/{id}', 'ReportController@reject')->name('reject');
        Route::get('rejected', 'ReportController@rejected')->name('rejected');
        Route::get('pending', 'ReportController@pending')->name('pending');
        Route::get('postback-log', 'ReportController@postback_log')->name('postback.log');
    });
    Route::group(['as' => 'invoice.', 'prefix' => 'invoice'], function () {
        Route::get('/', 'InvoiceController@index')->name('index');
        Route::get('generate', 'InvoiceController@generate')->name('generate');
        Route::get('get-wallet', 'InvoiceController@getWallet')->name('get-wallet');
        Route::get('get-report', 'InvoiceController@getReport')->name('get-report');
        Route::post('store', 'InvoiceController@store')->name('store');
        Route::get('paid/{id}', 'InvoiceController@paid')->name('paid');
        Route::get('manager-invoice', 'InvoiceController@managerInvoice')->name('manager-invoice');
    });
    Route::group(['as' => 'account.', 'prefix' => 'account'], function () {
        Route::get('/', 'AccountController@index')->name('index');
        Route::put('update', 'AccountController@update')->name('update');
        Route::post('paymentUpdate', 'AccountController@paymentUpdate')->name('paymentUpdate');
        Route::post('postback', 'AccountController@postback')->name('postback');
    });
    
    // Admin Chat Routes
    Route::group(['as' => 'chat.', 'prefix' => 'chat'], function () {
        Route::get('/', [App\Http\Controllers\ChatController::class, 'index'])->name('index');
        Route::get('/data', [App\Http\Controllers\ChatController::class, 'getChatData'])->name('data');
        Route::post('/get-or-create', [App\Http\Controllers\ChatController::class, 'getOrCreateChat'])->name('get-or-create');
        Route::post('/send-message', [App\Http\Controllers\ChatController::class, 'sendMessage'])->name('send-message');
        Route::get('/messages/{chatId}', [App\Http\Controllers\ChatController::class, 'getMessages'])->name('messages');
        Route::get('/chat/{chatId}', [App\Http\Controllers\ChatController::class, 'getChat'])->name('get-chat');
        Route::post('/mark-read/{chatId}', [App\Http\Controllers\ChatController::class, 'markAsRead'])->name('mark-read');
        Route::post('/pusher/auth', [App\Http\Controllers\ChatController::class, 'pusherAuth'])->name('pusher-auth');
    });
});



// Affiliate Routes
Route::group(['as' => 'affiliate.', 'prefix' => 'affiliate', 'namespace' => 'Affiliate', 'middleware' => ['auth', 'affiliate']], function () {
    Route::get('/dashboard', 'DashboardController@index')->name('dashboard');
    
    Route::get('announcement', [AdminAnnouncementController::class, 'allshow'])->name('announcement');
    Route::get('announcement/{id}', [AdminAnnouncementController::class, 'show'])->name('announcement.show');

    Route::group(['as' => 'offer.', 'prefix' => 'offer'], function () {
        Route::get('/', 'OfferController@index')->name('index');
        Route::get('show/{id}', 'OfferController@show')->name('show');
        Route::get('/offer-view', 'OfferController@viewSwitch')->name('viewSwitch');
        Route::get('show/api/{id}', 'OfferController@api')->name('show.api');
        Route::post('application/{id}', 'OfferController@application')->name('application');
    });
    Route::get('/smart-link', 'OfferController@smartlink')->name('offer.smartlink');
    Route::group(['as' => 'report.', 'prefix' => 'report'], function () {
        Route::get('performance', 'ReportController@day')->name('day');
        Route::get('offer', 'ReportController@offer')->name('offer');
        Route::get('country', 'ReportController@country')->name('country');
        Route::get('aff_sub_1', 'ReportController@aff_sub_1')->name('aff_sub_1');
        Route::get('aff_sub_2', 'ReportController@aff_sub_2')->name('aff_sub_2');
        Route::get('aff_sub_3', 'ReportController@aff_sub_3')->name('aff_sub_3');
        Route::get('clicks', 'ReportController@click')->name('click');
        Route::get('conversion', 'ReportController@conversion')->name('conversion');
    });
    Route::group(['as' => 'account.', 'prefix' => 'account'], function () {
        Route::get('/', 'AccountController@index')->name('index');
        Route::get('/global-postback', 'AccountController@postbackurl')->name('postbackurl');
        Route::put('update', 'AccountController@update')->name('update');
        Route::post('paymentUpdate', 'AccountController@paymentUpdate')->name('paymentUpdate');
        Route::post('postback', 'AccountController@postback')->name('postback');
    });
    
    
    Route::resource('invoice', 'InvoiceController');
});


Route::group(['as' => 'manager.', 'prefix' => 'manager', 'namespace' => 'Manager', 'middleware' => ['auth', 'manager']], function () {
    Route::get('/dashboard', 'DashboardController@index')->name('dashboard');
    Route::group(['as' => 'affiliate.', 'prefix' => 'affiliate'], function () {
        Route::get('/', 'AffiliateController@index')->name('index');
        Route::get('create', 'AffiliateController@create')->name('create');
        Route::post('store', 'AffiliateController@store')->name('store');
        Route::get('edit/{id}', 'AffiliateController@edit')->name('edit');
        Route::get('show/{id}', 'AffiliateController@show')->name('show');
        Route::put('update/{id}', 'AffiliateController@update')->name('update');
        Route::get('delete/{id}', 'AffiliateController@delete')->name('delete');
        Route::post('offer/blocked/{id}', 'AffiliateController@blocked')->name('offer.blocked');
        Route::get('switch/{id}', 'AffiliateController@switch')->name('switch');
    });
    Route::group(['as' => 'offer.', 'prefix' => 'offer'], function () {
        Route::get('/', 'OfferController@index')->name('index');
        Route::get('show/{id}', 'OfferController@show')->name('show');
        Route::get('application', 'OfferController@application')->name('application');
        Route::get('application/approved/{id}', 'OfferController@approved')->name('application.approved');
    });
    Route::group(['as' => 'report.', 'prefix' => 'report'], function () {
        Route::get('day', 'ReportController@day')->name('day');
        Route::get('offer', 'ReportController@offer')->name('offer');
        Route::get('country', 'ReportController@country')->name('country');
        Route::get('aff_sub_1', 'ReportController@aff_sub_1')->name('aff_sub_1');
        Route::get('aff_sub_2', 'ReportController@aff_sub_2')->name('aff_sub_2');
        Route::get('aff_sub_3', 'ReportController@aff_sub_3')->name('aff_sub_3');
        Route::get('clicks', 'ReportController@click')->name('click');
        Route::get('conversion', 'ReportController@conversion')->name('conversion');
    });
    Route::group(['as' => 'account.', 'prefix' => 'account'], function () {
        Route::get('/', 'AccountController@index')->name('index');
        Route::put('update', 'AccountController@update')->name('update');
        Route::post('paymentUpdate', 'AccountController@paymentUpdate')->name('paymentUpdate');
        Route::post('postback', 'AccountController@postback')->name('postback');
    });
    
    // Manager Chat Routes
    Route::group(['as' => 'chat.', 'prefix' => 'chat'], function () {
        Route::get('/', [App\Http\Controllers\ChatController::class, 'index'])->name('index');
        Route::get('/data', [App\Http\Controllers\ChatController::class, 'getChatData'])->name('data');
        Route::post('/get-or-create', [App\Http\Controllers\ChatController::class, 'getOrCreateChat'])->name('get-or-create');
        Route::post('/send-message', [App\Http\Controllers\ChatController::class, 'sendMessage'])->name('send-message');
        Route::get('/messages/{chatId}', [App\Http\Controllers\ChatController::class, 'getMessages'])->name('messages');
        Route::get('/chat/{chatId}', [App\Http\Controllers\ChatController::class, 'getChat'])->name('get-chat');
        Route::post('/mark-read/{chatId}', [App\Http\Controllers\ChatController::class, 'markAsRead'])->name('mark-read');
        Route::post('/pusher/auth', [App\Http\Controllers\ChatController::class, 'pusherAuth'])->name('pusher-auth');
    });
});

// Dev-only preview route for report layout (visible only when APP_DEBUG=true)
if (env('APP_DEBUG', false)) {
    Route::get('/dev/report-preview', function () {
        return view('dev.report-preview');
    });
    
    // Database connection test
    Route::get('/dev/db-test', function () {
        try {
            // Test database connection
            \DB::connection()->getPdo();
            $connection = 'Connected to database: ' . \DB::connection()->getDatabaseName();
            
            // Check if reports table exists
            $tables = \DB::select('SHOW TABLES');
            $tables = array_map('current', (array) $tables);
            $reportsTableExists = in_array('reports', $tables) || in_array('reports', array_map('strtolower', $tables));
            
            // Get table structure if exists
            $tableStructure = null;
            if ($reportsTableExists) {
                $tableStructure = \DB::select('DESCRIBE reports');
                $rowCount = \DB::table('reports')->count();
            }
            
            return [
                'database_connection' => $connection,
                'reports_table_exists' => $reportsTableExists,
                'reports_table_structure' => $tableStructure,
                'reports_count' => $rowCount ?? 0,
                'all_tables' => $tables
            ];
            
        } catch (\Exception $e) {
            return [
                'error' => $e->getMessage(),
                'file' => $e->getFile(),
                'line' => $e->getLine()
            ];
        }
    });
}

Route::get('/test-simple', function () {
    return 'Simple test - no auth required';
});

// Chat Routes
Route::group(['as' => 'chat.', 'prefix' => 'chat', 'middleware' => 'auth'], function () {
    Route::get('/', [App\Http\Controllers\ChatController::class, 'index'])->name('index');
    Route::get('/data', [App\Http\Controllers\ChatController::class, 'getChatData'])->name('data');
    Route::post('/get-or-create', [App\Http\Controllers\ChatController::class, 'getOrCreateChat'])->name('get-or-create');
    Route::post('/send-message', [App\Http\Controllers\ChatController::class, 'sendMessage'])->name('send-message');
    Route::get('/messages/{chatId}', [App\Http\Controllers\ChatController::class, 'getMessages'])->name('messages');
    Route::get('/chat/{chatId}', [App\Http\Controllers\ChatController::class, 'getChat'])->name('get-chat');
    Route::post('/mark-read/{chatId}', [App\Http\Controllers\ChatController::class, 'markAsRead'])->name('mark-read');
    Route::post('/pusher/auth', [App\Http\Controllers\ChatController::class, 'pusherAuth'])->name('pusher-auth');
});
