﻿

<?php $__env->startSection('title', 'Edit Profile'); ?>

<?php $__env->startPush('css'); ?>
    <link href="https://cdn.jsdelivr.net/npm/tom-select@2.0.1/dist/css/tom-select.bootstrap5.min.css" rel="stylesheet">
    
    <link href="<?php echo e(asset('css/app.css')); ?>" rel="stylesheet">
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>

    <div class="page-header d-print-none">
        <div class="row align-items-center">
            <div class="col">
                <h2 class="page-title">
                    <i class="fa fa-user-circle me-2"></i> Affiliate Profile Settings
                </h2>
            </div>
        </div>
    </div>

    <div class="page-body">
        <div class="row">
            
            <div class="col-lg-3 col-md-4">
                <div class="list-group list-group-transparent mb-3" role="tablist">
                    <a class="list-group-item list-group-item-action d-flex align-items-center active"
                        id="personal-preference-tab" data-bs-toggle="list" href="#personal-preference" role="tab"
                        aria-controls="personal-preference" aria-selected="true">
                        <i class="fa fa-cog me-2"></i> Personal Preferences
                    </a>
                    <a class="list-group-item list-group-item-action d-flex align-items-center" id="payment-info-tab"
                        data-bs-toggle="list" href="#payment-info" role="tab" aria-controls="payment-info"
                        aria-selected="false">
                        <i class="fa fa-credit-card me-2"></i> Payment Info
                    </a>

                    <?php if(!empty($finances) && $finances->contains('name', 'Bank')): ?>
                        <a class="list-group-item list-group-item-action d-flex align-items-center" id="bank-info-tab"
                            data-bs-toggle="list" href="#bank-info" role="tab" aria-controls="bank-info"
                            aria-selected="false">
                            <i class="fa fa-university me-2"></i> Bank Info
                        </a>
                    <?php endif; ?>

                    <a class="list-group-item list-group-item-action d-flex align-items-center" id="referral-log-tab"
                        data-bs-toggle="list" href="#referral-log" role="tab" aria-controls="referral-log"
                        aria-selected="false">
                        <i class="fa fa-users me-2"></i> Referral Log
                    </a>
                </div>
            </div>

            
            <div class="col-lg-9 col-md-8">
                <div class="tab-content">

                    
                    <div class="tab-pane fade show active" id="personal-preference" role="tabpanel"
                        aria-labelledby="personal-preference-tab">
                        <form action="<?php echo e(route('affiliate.account.update')); ?>" method="post" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('PUT'); ?>

                            <div class="card">
                                <div class="card-header">
                                    <h3 class="card-title">Update Personal Information & Password</h3>
                                </div>
                                <div class="card-body">
                                    
                                    <?php echo $__env->make('layouts.backend.partials.flash-message', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                                    <?php if($errors->any()): ?>
                                        <div class="alert alert-danger">
                                            <ul class="mb-0">
                                                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <li><?php echo e($error); ?></li>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </ul>
                                        </div>
                                    <?php endif; ?>
                                    
                                    
                                    <div class="mb-3 d-flex align-items-end">
                                        <div class="avatar avatar-xl me-3"
                                            style="background-image: url('<?php echo e(Auth::user()->getAvatarUrl() ?: asset('images/default-avatar.png')); ?>')">
                                        </div>
                                        <div>
                                            <label for="avatarInput" class="form-label">Change Avatar</label>
                                            <input type="file" name="avatar" class="form-control" id="avatarInput">
                                        </div>
                                    </div>

                                    <h4 class="mb-3 text-primary">Personal Details</h4>

                                    
                                    <div class="row mb-3">
                                        <div class="col-md-6">
                                            <label for="firstNameInput" class="form-label">First Name</label>
                                            <input type="text" class="form-control" name="first_name" id="firstNameInput"
                                                value="<?php echo e(Auth::user()->first_name ?? old('first_name')); ?>">
                                            <?php $__errorArgs = ['first_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <small class="text-danger"><?php echo e($message); ?></small> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                        <div class="col-md-6">
                                            <label for="lastNameInput" class="form-label">Last Name</label>
                                            <input type="text" class="form-control" name="last_name" id="lastNameInput"
                                                value="<?php echo e(Auth::user()->last_name ?? old('last_name')); ?>">
                                            <?php $__errorArgs = ['last_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <small class="text-danger"><?php echo e($message); ?></small> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                    </div>

                                    
                                    <div class="row mb-3">
                                        <div class="col-md-6">
                                            <label for="emailInput" class="form-label">Email</label>
                                            <input type="email" class="form-control" name="email" id="emailInput"
                                                value="<?php echo e(Auth::user()->email ?? old('email')); ?>" readonly disabled>
                                            <small class="form-text text-muted">Email cannot be changed.</small>
                                            <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <small class="text-danger"><?php echo e($message); ?></small> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>

                                        <div class="col-md-6">
                                            <label for="skypeInput" class="form-label">Skype (Optional)</label>
                                            <input type="text" class="form-control" name="skype" id="skypeInput"
                                                value="<?php echo e(Auth::user()->skype ?? old('skype')); ?>">
                                        </div>
                                    </div>

                                    
                                    <div class="mb-4">
                                        <label for="country_id" class="form-label">Country</label>
                                        <select name="country_id" class="form-select" id="country_id">
                                            <option value="" disabled>Select Country</option>
                                            <?php $__currentLoopData = $countries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option <?php echo e(Auth::user()->country_id == $country->id ? 'selected' : ''); ?>

                                                    value="<?php echo e($country->id); ?>"><?php echo e($country->name); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>

                                    <h4 class="mb-3 text-primary">Change Password</h4>

                                    
                                    <div class="mb-3">
                                        <label for="currentPasswordInput" class="form-label">Current Password</label>
                                        <input type="password" name="old_password" class="form-control" id="currentPasswordInput">
                                    </div>

                                    <div class="row mb-3">
                                        <div class="col-md-6">
                                            <label for="newPasswordInput" class="form-label">New Password</label>
                                            <input type="password" name="password" class="form-control" id="newPasswordInput">
                                            <small class="form-text text-muted">
                                                Your password must be 6-20 characters long.
                                            </small>
                                        </div>
                                        <div class="col-md-6">
                                            <label for="confirmPasswordInput" class="form-label">Confirm New Password</label>
                                            <input type="password" name="password_confirmation" class="form-control"
                                                id="confirmPasswordInput">
                                        </div>
                                    </div>
                                </div>
                                <div class="card-footer text-end">
                                    <button type="submit" class="btn btn-primary mybtnMain submit">Update Profile</button>
                                </div>
                            </div>
                        </form>
                    </div>

                    
                    <div class="tab-pane fade" id="payment-info" role="tabpanel" aria-labelledby="payment-info-tab">
                        <div class="card">
                            <div class="card-header">
                                <h3 class="card-title">Update General Payment Wallet</h3>
                            </div>
                            <div class="card-body">
                                <?php if($message = Session::get('payment_info_success')): ?>
                                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                                        <strong><?php echo e($message); ?></strong>
                                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                                    </div>
                                <?php endif; ?>
                                <?php if($errors->any()): ?>
                                    <div class="alert alert-danger">
                                        <ul class="mb-0">
                                            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <li><?php echo e($error); ?></li>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </ul>
                                    </div>
                                <?php endif; ?>

                                <form action="<?php echo e(route('affiliate.account.paymentUpdate')); ?>" method="POST">
                                    <?php echo csrf_field(); ?>

                                    
                                    <div class="mb-3">
                                        <label class="form-label">Payment Method</label>
                                        <select name="finance_id" class="form-select" id="finance_id"
                                            placeholder="Select a Payment Method...">
                                            <?php $__currentLoopData = $finances; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $finance): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php if($finance->name != 'Bank'): ?>
                                                    <option
                                                        <?php if(isset(Auth::user()->paymentMethod)): ?> <?php echo e(Auth::user()->paymentMethod->finance_id == $finance->id ? 'selected' : ''); ?> <?php endif; ?>
                                                        value="<?php echo e($finance->id); ?>"><?php echo e($finance->name); ?></option>
                                                <?php endif; ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>

                                    
                                    <div class="mb-3" id="wallet-field">
                                        <label class="form-label">Wallet/Account Details (e.g., PayPal email, Crypto address)</label>
                                        <?php
                                            $isBank = isset(Auth::user()->paymentMethod) && Auth::user()->paymentMethod->finance && Auth::user()->paymentMethod->finance->name === 'Bank';
                                            $wallet_value = !$isBank ? (Auth::user()->paymentMethod->wallet ?? old('wallet')) : '';
                                        ?>
                                        <textarea name="wallet" id="wallet" class="form-control" rows="3"><?php echo e($wallet_value); ?></textarea>
                                        <small class="form-text text-muted">Enter your payment account details for the selected method.</small>
                                    </div>

                                    <div class="form-footer text-end">
                                        <button type="submit" class="btn btn-primary mybtnMain">Update Payment Info</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>

                    
                    <?php if(!empty($finances) && $finances->contains('name', 'Bank')): ?>
                        <?php
                            $bankFinance = $finances->firstWhere('name', 'Bank');
                            $wallet_data = [];
                            if (Auth::user()->paymentMethod && Auth::user()->paymentMethod->finance_id == $bankFinance->id && Auth::user()->paymentMethod->wallet) {
                                $wallet_data = json_decode(Auth::user()->paymentMethod->wallet, true);
                            }
                        ?>
                        <div class="tab-pane fade" id="bank-info" role="tabpanel" aria-labelledby="bank-info-tab">
                            <div class="card">
                                <div class="card-header">
                                    <h3 class="card-title">Bank Transfer Information</h3>
                                </div>
                                <div class="card-body">

                                    <?php if($message = Session::get('payment_info_success')): ?>
                                        <div class="alert alert-success alert-dismissible fade show" role="alert">
                                            <strong><?php echo e($message); ?></strong>
                                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                                        </div>
                                    <?php endif; ?>

                                    <?php if($errors->any()): ?>
                                        <div class="alert alert-danger">
                                            <ul class="mb-0">
                                                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <li><?php echo e($error); ?></li>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </ul>
                                        </div>
                                    <?php endif; ?>

                                    <form action="<?php echo e(route('affiliate.account.paymentUpdate')); ?>" method="POST">
                                        <?php echo csrf_field(); ?>

                                        <div class="row">
                                            
                                            <div class="col-md-6 mb-3">
                                                <label class="form-label">Bank Name</label>
                                                <input type="text" name="bank_name" class="form-control"
                                                    value="<?php echo e($wallet_data['bank_name'] ?? old('bank_name')); ?>">
                                            </div>

                                            
                                            <div class="col-md-6 mb-3">
                                                <label class="form-label">Account Number / IBAN</label>
                                                <input type="text" name="account_number" class="form-control"
                                                    value="<?php echo e($wallet_data['account_number'] ?? old('account_number')); ?>">
                                            </div>
                                        </div>

                                        <div class="row">
                                            
                                            <div class="col-md-4 mb-3">
                                                <label class="form-label">Routing Number (ABA)</label>
                                                <input type="text" name="routing_number" class="form-control"
                                                    value="<?php echo e($wallet_data['routing_number'] ?? old('routing_number')); ?>">
                                            </div>

                                            
                                            <div class="col-md-4 mb-3">
                                                <label class="form-label">SWIFT / BIC Code</label>
                                                <input type="text" name="swift_code" class="form-control"
                                                    value="<?php echo e($wallet_data['swift_code'] ?? old('swift_code')); ?>">
                                            </div>
                                             
                                            <div class="col-md-4 mb-3">
                                                <label class="form-label">Beneficiary Name</label>
                                                <input type="text" name="beneficiary_name" class="form-control"
                                                    value="<?php echo e($wallet_data['beneficiary_name'] ?? old('beneficiary_name')); ?>">
                                            </div>
                                        </div>


                                        
                                        <input type="hidden" name="finance_id_bank_update" value="<?php echo e($bankFinance->id); ?>">
                                        <div class="mb-3 form-check">
                                            <input type="checkbox" class="form-check-input" name="use_bank_method"
                                                id="bankFinanceCheck" value="1"
                                                <?php if(isset(Auth::user()->paymentMethod) && Auth::user()->paymentMethod->finance_id == $bankFinance->id): ?> checked <?php endif; ?>>
                                            <label class="form-check-label" for="bankFinanceCheck">
                                                Set Bank as your **Preferred Payment Method**
                                            </label>
                                        </div>

                                        <div class="form-footer text-end">
                                            <button type="submit" class="btn btn-primary mybtnMain">Update Bank Info</button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>


                    
                    <div class="tab-pane fade" id="referral-log" role="tabpanel" aria-labelledby="referral-log-tab">
                        <div class="card">
                            <div class="card-header">
                                <h3 class="card-title">Referral Log and Link</h3>
                            </div>
                            <div class="card-body">
                                <div class="mb-4">
                                    <label class="form-label">Your Unique Referral Link</label>
                                    <div class="input-group">
                                        <input type="text" id="referralLink" class="form-control"
                                            value="<?php echo e(route('register')); ?>?refer_id=<?php echo e(Auth::user()->id); ?>"
                                            aria-label="Referral Link" readonly>
                                        <button class="btn btn-primary" type="button" id="copyButton">
                                            <i class="fa fa-clipboard me-2"></i> Copy Link
                                        </button>
                                    </div>
                                </div>

                                <h4>Your Referred Users</h4>
                                <div class="table-responsive">
                                    <table class="table table-hover table-vcenter">
                                        <thead>
                                            <tr>
                                                <th>Name</th>
                                                <th>Email</th>
                                                <th class="text-end">Total Earned</th>
                                                <th class="text-end">Your Commission</th>
                                                <th>Join Date</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php $__empty_1 = true; $__currentLoopData = $refer_list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $r): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                                <tr>
                                                    <td><?php echo e($r->first_name); ?></td>
                                                    <td><?php echo e($r->email); ?></td>
                                                    <td class="text-end"><?php echo e($r->balance); ?></td>
                                                    <td class="text-end"><?php echo e(referedCommission(Auth::user()->id, $r->id)); ?></td>
                                                    <td><?php echo e($r->created_at->format('d M Y')); ?></td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                                <tr>
                                                    <td colspan="5" class="text-center text-muted">No referrals found yet. Start sharing your link!</td>
                                                </tr>
                                            <?php endif; ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
    <script src="https://cdn.jsdelivr.net/npm/tom-select@2.0.1/dist/js/tom-select.complete.min.js"></script>
    <script>
        // Initialize TomSelect for select fields
        new TomSelect('#country_id', {
            plugins: ['input_autogrow'],
        });
        new TomSelect('#finance_id', {
            plugins: ['input_autogrow'],
        });

        // Copy button functionality
        document.getElementById("copyButton").addEventListener("click", function() {
            var referralLinkInput = document.getElementById("referralLink");
            // Select the text field
            referralLinkInput.select();
            referralLinkInput.setSelectionRange(0, 99999); // For mobile devices

            // Copy the text inside the text field
            navigator.clipboard.writeText(referralLinkInput.value).then(() => {
                // Change button text temporarily on successful copy
                this.innerHTML = '<i class="fa fa-check me-2"></i> Copied!';
                setTimeout(() => {
                    this.innerHTML = '<i class="fa fa-clipboard me-2"></i> Copy Link';
                }, 2000);
            }).catch(err => {
                console.error('Could not copy text: ', err);
                alert("Failed to copy link. Please copy it manually.");
            });
        });
    </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.backend.affiliate_sash', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\resources\views/affiliate/account/index.blade.php ENDPATH**/ ?>