<?php $__env->startSection('title','Manage Offers'); ?>

<?php $__env->startPush('css'); ?>
    <link href="https://cdn.jsdelivr.net/npm/tom-select@2.0.1/dist/css/tom-select.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/tom-select@2.0.1/dist/css/tom-select.bootstrap5.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.css" rel="stylesheet">
    <link href="<?php echo e(asset('backend/dist/css/tabler-flags.min.css')); ?>" rel="stylesheet"/>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <?php
        $id = request()->get('id');
        $status = request()->get('status');
        $name = request()->get('name');
        $category_id = request()->get('category_id');
        $device_id = request()->get('device_id');
        $country_id = request()->get('country_id');
        $type = request()->get('type');
    ?>
    <div class="container-xl">
        <!-- Page title -->
        <div class="page-header d-print-none">
            <div class="row align-items-center">
                <div class="col">
                    <!-- Page pre-title -->
                    <div class="page-pretitle">
                        Overview
                    </div>
                    <h2 class="page-title">
                        <?php echo $__env->yieldContent(('title')); ?>
                    </h2>
                </div>
                <!-- Page title actions -->
                <div class="col-auto ms-auto d-print-none">
                    <div class="btn-list">
                        <a href="<?php echo e(route('admin.offer.create')); ?>" class="btn btn-primary d-none d-sm-inline-block">
                            <!-- Download SVG icon from http://tabler-icons.io/i/plus -->
                            <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"></path><line x1="12" y1="5" x2="12" y2="19"></line><line x1="5" y1="12" x2="19" y2="12"></line></svg>
                            Create Offers
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="page-body">
        <div class="container-xl">
            <div class="col-md-12">
                <form action="">
                    <input type="hidden" name="filter" value="filter">
                    <div class="card">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-4">
                                    <h3 class="form-group">Name/ID</h3>
                                    <div class="input-icon">
                                        <input name="name" type="text"  class="form-control" placeholder="Name…" value="<?php echo e($name ?? old('name')); ?>">
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <h3 class="form-group">Category</h3>
                                    <select  name="category_id" class="form-select" id="category_id" placeholder="  Select a category...">
                                        <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option <?php if(isset($category_id)): ?> <?php echo e($category_id == $category->id ? 'selected' : ''); ?><?php endif; ?> value="<?php echo e($category->id); ?>"><?php echo e($category->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                                <div class="col-md-4">
                                    <h3 class="form-group">Country</h3>
                                    <select multiple name="country_id[]" class="form-select" id="country_id" placeholder="  Select a country...">
                                        <?php $__currentLoopData = $countries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option
                                                <?php if(isset($country_id)): ?>
                                                <?php $__currentLoopData = $country_id; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $id): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php echo e($id == $country->id ? 'selected' : ''); ?>

                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <?php endif; ?>
                                                value="<?php echo e($country->id); ?>"><?php echo e($country->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </div>
                            <br>
                            <div class="row">
                                <div class="col-md-4">
                                    <h3 class="form-group">Device</h3>
                                    <select multiple name="device_id[]" class="form-select" id="device_id" placeholder="  Select a devices...">
                                        <?php $__currentLoopData = $devices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $device): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option
                                                <?php if(isset($device_id)): ?>
                                                <?php $__currentLoopData = $device_id; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $id): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php echo e($id == $device->id ? 'selected' : ''); ?>

                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <?php endif; ?>
                                                value="<?php echo e($device->id); ?>"><?php echo e($device->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                                <div class="col-md-4">
                                    <h3 class="form-group">Type</h3>
                                    <select  name="type" class="form-select" id="type" placeholder="  Select a type...">
                                        <option value="" >All</option>
                                        <option <?php if(isset($type)): ?> <?php echo e($type == "offer" ? 'selected' : ''); ?> <?php endif; ?> value="offer">Offer</option>
                                        <option <?php if(isset($type)): ?> <?php echo e($type == "smartlink" ? 'selected' : ''); ?> <?php endif; ?> value="smartlink">Smartlink</option>
                                    </select>
                                </div>
                                <div class="col-md-4">
                                    <h3 class="form-group">Status</h3>
                                    <div class="input-icon">
                                        <select  name="status" id="status" class="form-select"  placeholder="  Select a status...">
                                            <option value="" >All</option>
                                            <option <?php if(isset($status)): ?> <?php echo e($status == "pending" ? 'selected' : ''); ?> <?php endif; ?> value="active">Pending</option>
                                            <option <?php if(isset($status)): ?> <?php echo e($status == "active" ? 'selected' : ''); ?> <?php endif; ?> value="pending">Active</option>
                                            <option <?php if(isset($status)): ?> <?php echo e($status == "requestApproved" ? 'selected' : ''); ?> <?php endif; ?> value="requestApproved">ReqestApproved</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card-footer">
                            <div class="row align-items-center">
                                <div  class="col">Affiliate Filter</div>
                                <div class="col-auto">
                                    <button  class="btn btn-primary">
                                        Filter
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
            <br>
            <div class="col-12">
                <div class="card">
                    <div class="table-responsive">
                        <table class="table table-vcenter table-mobile-md card-table">
                            <thead>
                            <tr>
                                <th>Name</th>
                                <th>Advertiser</th>
                                <th>Country</th>
                                <th>Device</th>
                                <th>Type</th>
                                <th>Revenue</th>
                                <th>Payout</th>
                                <th>Conversion Status</th>
                                <th>Daily Cap</th>
                                <th>Expiration Date</th>
                                <th>Category</th>
                                <th>Verticle</th>
                                <th>Action</th>
                            </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $offers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $offer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                
                                    <tr>
                                        <td data-label="Basic Info">
                                            <div class="d-flex py-1 align-items-center">
                                               <span class="avatar me-2" style="background-image: url(<?php echo e($offer->getFirstMediaUrl('avater') ? $offer->getFirstMediaUrl('avater')  : ''); ?>)"></span>
                                                <div class="flex-fill">
                                                    <div class="font-weight-medium"><a href="<?php echo e(route('admin.offer.show',$offer->id)); ?>">(<?php echo e($offer->id); ?>)<?php echo e($offer->name); ?></a></div>
                                                    <div class="text-muted">
                                                        <a href="" class="text-reset">
                                                            <?php if($offer->status == 'active'): ?>
                                                                <span class="badge bg-success">Active</span>
                                                                <?php elseif($offer->status == 'requestApproved'): ?>
                                                                <span class="badge bg-warning">Request Approved</span>
                                                            <?php else: ?>
                                                                <span class="badge bg-danger">Pending</span>
                                                            <?php endif; ?>
                                                        </a>
                                                    </div>
                                                </div>
                                            </div>
                                        </td>
                                        <td data-label="Advertiser">
                                            <div><?php echo e($offer->advertiser->name); ?></div>
                                        </td>
                                        <td data-label="Countries">
                                            <?php if(!$offer->countries->isEmpty()): ?>
                                                <?php $count = 0; ?>
                                                <?php $__currentLoopData = $offer->countries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <?php if($count < 5): ?>
                                                        <span class="flag flag-country-<?php echo e(Str::lower($country->code)); ?>"></span>
                                                        <?php $count++; ?>
                                                    <?php else: ?>
                                                        <?php break; ?>
                                                    <?php endif; ?>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <?php if($offer->countries->count() > 5): ?>
                                                    <span class="badge bg-secondary">+<?php echo e($offer->countries->count() - 5); ?> more</span>
                                                <?php endif; ?>
                                            <?php else: ?>
                                                <span class="badge bg-success">Global</span>
                                            <?php endif; ?>
                                        </td>

                                        <td data-label="Devices">
                                            <?php if(!$offer->devices->isEmpty()): ?>
                                                <?php $__currentLoopData = $offer->devices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $device): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <i  class="fa fa-<?php echo e(Str::lower($device->name)); ?>"></i>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <?php else: ?>
                                                <?php $__currentLoopData = $devices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $device): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <i  class="fa fa-<?php echo e(Str::lower($device->name)); ?>"></i>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <?php endif; ?>
                                        </td>
                                        <td data-label="Type">
                                            <?php if($offer->type == "offer"): ?>
                                                <div class="text-muted"><span class="badge bg-success">Offer</span></div>
                                            <?php else: ?>
                                                <div class="text-muted"><span class="badge bg-cyan">Revinue Share</span></div>
                                            <?php endif; ?>
                                        </td>
                                        <td data-label="Revenue">
                                            <?php if($offer->type == "offer"): ?>
                                                <div class="text-muted"><span class="badge bg-success">$<?php echo e($offer->revenue); ?></span></div>
                                            <?php else: ?>
                                                <div class="text-muted"><span class="badge bg-cyan">%<?php echo e($offer->revenue); ?></span></div>
                                            <?php endif; ?>
                                        </td>
                                        <td data-label="Payout">
                                            <?php if($offer->type == "offer"): ?>
                                                <div class="text-muted"><span class="badge bg-success">$<?php echo e($offer->payout); ?></span></div>
                                            <?php else: ?>
                                                <div class="text-muted"><span class="badge bg-cyan">%<?php echo e($offer->payout); ?></span></div>
                                            <?php endif; ?>
                                        </td>
                                        <td data-label="Conversion Status">
                                            <?php if($offer->conversion_status == false): ?>
                                                <div class="text-muted"><span class="badge bg-danger">Pending</span></div>
                                            <?php else: ?>
                                                <div class="text-muted"><span class="badge bg-success">Approved</span></div>
                                            <?php endif; ?>
                                        </td>
                                        <td data-label="Daily Cap">
                                            <div class="text-muted"><span class="badge bg-success"><?php echo e($offer->daily_cap); ?></span></div>
                                        </td>
                                        <td data-label="Expiration Date">
                                            <div class="text-muted"><span class="badge bg-success"><?php echo e($offer->expiration_date); ?></span></div>
                                        </td>
                                        <td data-label="Category">
                                            <div class="text-muted"><span class="badge bg-success"><?php echo e($offer->category->name); ?></span></div>
                                        </td>
                                         <td data-label="Verticle">
                                            <div class="text-muted"><span class="badge bg-success"><?php echo e(optional($offer->verticle)->name); ?></span></div>
                                        </td>
                                        <td>
                                            <a href="<?php echo e(route('admin.offer.edit',$offer->id)); ?>" class="btn btn-success btn-sm">
                                                <i class="fa fa-pencil"></i>
                                            </a>
                                            <a href="<?php echo e(route('admin.offer.show',$offer->id)); ?>" class="btn btn-primary btn-sm">
                                                <i class="fa fa-eye"></i>
                                            </a>
                                            <form action="<?php echo e(route('admin.offer.destroy', $offer->id)); ?>" method="POST" onclick="return confirm('are u sure to delete?')">
                                                <?php echo method_field('DELETE'); ?>
                                                <?php echo csrf_field(); ?>
                                                <button class="btn btn-danger btn-sm">
                                                    <i class="fa fa-trash"></i>
                                                </button>
                                            </form>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                       <div style="margin: 0 auto;float: right">
                           <?php echo e($offers->withQueryString()->links()); ?>

                       </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
    <script src="https://cdn.jsdelivr.net/npm/tom-select@2.0.1/dist/js/tom-select.complete.min.js"></script>
    <script>
        new TomSelect('#category_id',{
            plugins: ['input_autogrow'],
        });
        new TomSelect('#country_id',{
            plugins: ['input_autogrow'],
        });
        new TomSelect('#type',{
            plugins: ['input_autogrow'],
        });
        new TomSelect('#status',{
            plugins: ['input_autogrow'],
        });
        new TomSelect('#device_id',{
            plugins: ['input_autogrow'],
        });


    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.backend.admin_sash', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\resources\views/admin/offer/index.blade.php ENDPATH**/ ?>